﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public enum UGCEnvironment {
    CitySmall,
    CityMedium,
    CityLarge,
    CityLargeWithDriveThru,
    BeachSmall,
    BeachLarge,
    AirstripSmall,
    AirstripLarge,
    Airport,
    AirportWithTakeout,
    Skyscraper,
    SkyscraperWithTakeout,
    Concert,
    Park
}

public class UGCLevel : ScriptableObject {

    [Tooltip("The name that will be displayed on the UI for this level.")]
    public string friendlyName;

    [Tooltip("The number of dishes the player needs to deliver in order to win.")]
    public int numberOfDishes = 20;
    [Tooltip("The list of Internal Names of dishes that can be ordered by customers.")]
    public List<string> requiredDishes;
    [Tooltip("The list of Internal Names of dishes that can be ordered by customers as a side order.")]
    public List<string> sideDishes;

    [Tooltip("The maximum budget the player has to buy the machines for this level.")]
    public int fundsLimitation = 50000;
    [Tooltip("The maximum total energy the player can use in watt-hours.")]
    public float powerLimitation = 10000;
    [Tooltip("The maximum total power the player can use in watts. Exceeding that limit will cause a blackout.")]
    public float powerUsageLimitation;
    [Tooltip("The maximum number of ingredients the player is allowed to use.")]
    public int ingredientsCountLimitation = 100;

    [Tooltip("The minimum number of seconds between orders being placed.")]
    public float minTimeBetweenOrders = 5.0f;
    [Tooltip("The maximum number of seconds between orders being placed.")]
    public float maxTimeBetweenOrders = 10.0f;
    [Tooltip("The probability that customers will order a side dish along with their main order. Between 0 and 1.")]
    public float sideDishProbability = 0.5f;
    [Tooltip("The environment for this level.")]
    public UGCEnvironment environment;
    [Tooltip("A list of special events (rush hours, crazes, food critic visits) for this level.")]
    public List<UGCSpecialEvent> specialEvents;
    [Tooltip("The time of the day at which this level starts. Only relevant when setting special events.")]
    public float startingTime = 10.0f;

    [Tooltip("The list of internal names of machines that are available to players on this level.")]
    public List<string> availableMachines = new List<string>() {
        "AdvancedAssembler",
        "AdvancedComputer",
        "AdvancedOrderReader",
        "Assembler",
        "Belt",
        "BeltBridge",
        "Computer",
        "ConvectionFryer",
        "ConveyorGrill",
        "Counter",
        "Dispenser",
        "DumbRobotArm",
        "ExtinguisherArm",
        "Fryer",
        "Gate",
        "Grill",
        "HighSpeedBelt",
        "HighSpeedDispenser",
        "LargeStorageTank",
        "LargeStorageUnit",
        "LiquidMixer",
        "LongRobotArm",
        "MechanicMechanic",
        "OrderReader",
        "PackagingMachine",
        "Processor",
        "Pump",
        "Repeater",
        "RobotArm",
        "SmartSplitter",
        "Splitter",
        "Sprinkler",
        "StackingRobotArm",
        "StorageTank",
        "StorageUnit",
        "Teleporter",
        "XTerminator"
    };

    [Tooltip("Can fires occur in this level?")]
    public bool hasFireDisaster;
    [Tooltip("Can infestations occur in this level?")]
    public bool hasInsectsDisaster;
    [Tooltip("Can breakdowns occur in this level?")]
    public bool hasBreakdowns;
}