﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public enum UGCManufacturingTechnique {
    Assembling,
    Packaging,
    Dispensing,
    Mixing,
    Other,
    StorageTank
}

[RequireComponent(typeof(BoxCollider))]
public class UGCIngredient : MonoBehaviour {

    [Tooltip("The Internal Name for this ingredient. This is the one used when setting up the recipes players have to prepare in a level and when specifying ingredients for a recipe. MUST BE UNIQUE!")]
    public string internalName;
    [Tooltip("The name that will be displayed for this ingredient on the UI.")]
    public string friendlyName;

    [Tooltip("A square icon for this ingredient.")]
    public Texture2D icon;

    [Tooltip("Where does this ingredient or dish come from?")]
    public UGCManufacturingTechnique technique;

    [Tooltip("The Internal Name of the product that results from grilling this ingredient.")]
    public string resultGrill = "AshPile";
    [Tooltip("The Internal Name of the product that results from putting this ingredient through the food processor.")]
    public string resultProcess = "AshPile";
    [Tooltip("The Internal Name of the product that results from frying this ingredient.")]
    public string resultFry = "AshPile";
    [Tooltip("The Internal Name of the product that results from getting this ingredient wet.")]
    public string resultWet = "WetGoop";

    [Tooltip("The list of ingredients to make this ingredient. Only used if the manufacturing technique is assembling, packaging or mixing!")]
    public List<string> recipe; // only used if technique is assembling or mixing
    [Tooltip("The list of liquid ingredients to make this ingredient. Only used if the manufacturing technique is assembling or mixing!")]
    public List<string> recipeLiquidIngredients; // only used if technique is assembling or mixing
    [Tooltip("The quantities in milliliters of liquid ingredients to make this ingredient. Must have the same number of elements as the recipeLiquidIngredients property. Only used if the manufacturing technique is assembling or mixing!")]
    public List<int> liquidIngredientsQuantities; // only used if technique is assembling or mixing
    [Tooltip("The number of seconds it takes to make this ingredient. Only used if the manufacturing technique is assembling!")]
    public float timeToBeAssembled = 0.0f; // only used if technique is assembling or mixing

}