﻿using System.Collections.Generic;
using UnityEditor;
using UnityEngine;

public class ShowInternalNamesMachines : EditorWindow {

    Vector2 scrollPos;
    static List<string> machines;

    [MenuItem("Automachef SDK/Show Built-in Internal Names for Machines")]
    static void Init() {
        machines = InternalNames.GetMachines();
        ShowInternalNamesMachines window = (ShowInternalNamesMachines) EditorWindow.GetWindow(typeof(ShowInternalNamesMachines));
        window.Show();
    }

    void OnGUI() {
        EditorGUILayout.BeginVertical();
        scrollPos = EditorGUILayout.BeginScrollView(scrollPos, false, true);
        GUILayout.Label("Internal names of built-in machines:", EditorStyles.largeLabel);
        GUILayout.Label(string.Join("\n", machines), EditorStyles.label);
        EditorGUILayout.EndScrollView();
        EditorGUILayout.EndVertical();
    }
}