﻿using System.Collections.Generic;
using UnityEditor;
using UnityEngine;

public class ShowInternalNames : EditorWindow {

    Vector2 scrollPos;
    static List<string> ingredients;
    static List<string> dishes;
    static List<string> liquidIngredients;

    [MenuItem("Automachef SDK/Show Built-in Internal Names for Ingredients")]
    static void Init() {
        ingredients = InternalNames.GetIngredients();
        dishes = InternalNames.GetDishes();
        liquidIngredients = InternalNames.GetLiquidIngredients();

        ShowInternalNames window = (ShowInternalNames) EditorWindow.GetWindow(typeof(ShowInternalNames));
        window.Show();
    }

    void OnGUI() {
        EditorGUILayout.BeginVertical();
        scrollPos = EditorGUILayout.BeginScrollView(scrollPos, false, true);
        GUILayout.Label("Internal names of built-in ingredients and dishes:", EditorStyles.largeLabel);
        GUILayout.Label("Ingredients", EditorStyles.boldLabel);
        GUILayout.Label(string.Join("\n", ingredients), EditorStyles.label);
        GUILayout.Label("Dishes", EditorStyles.boldLabel);
        GUILayout.Label(string.Join("\n", dishes), EditorStyles.label);
        GUILayout.Label("Liquid Ingredients", EditorStyles.boldLabel);
        GUILayout.Label(string.Join("\n", liquidIngredients), EditorStyles.label);
        EditorGUILayout.EndScrollView();
        EditorGUILayout.EndVertical();
    }
}