﻿using System.Collections;
using UnityEditor;
using UnityEngine;

public class CreateSpecialEvent {
    [MenuItem("Automachef SDK/Create Special Event")]
    public static void CreateNewSpecialEvent() {
        UGCSpecialEvent asset = ScriptableObject.CreateInstance<UGCSpecialEvent>();

        int levelNumber = 1;
        while (AssetDatabase.FindAssets("SpecialEvent" + levelNumber.ToString() + " t:UGCSpecialEvent").Length > 0) {
            levelNumber++;
        }
        AssetDatabase.CreateAsset(asset, "Assets/Data/SpecialEvent" + levelNumber.ToString() + ".asset");
        AssetDatabase.SaveAssets();

        EditorUtility.FocusProjectWindow();
        Selection.activeObject = asset;
    }
}