﻿using System.Collections;
using UnityEditor;
using UnityEngine;

public class CreateLevel {
    [MenuItem("Automachef SDK/Create New Level")]
    public static void CreateNewLevel() {
        UGCLevel asset = ScriptableObject.CreateInstance<UGCLevel>();

        int levelNumber = 1;
        while (AssetDatabase.FindAssets("Level" + levelNumber.ToString() + " t:UGCLevel").Length > 0) {
            levelNumber++;
        }
        AssetDatabase.CreateAsset(asset, "Assets/Data/Level" + levelNumber.ToString() + ".asset");
        AssetDatabase.SaveAssets();

        EditorUtility.FocusProjectWindow();
        Selection.activeObject = asset;
    }
}