﻿using System.IO;
using UnityEditor;
using UnityEngine;

public class CreateAssetBundles {
    [MenuItem("Automachef SDK/Build Mod")]
    static void BuildAllAssetBundles() {
        string warningMessage =
            "Before proceeding please make sure that you have gone through this checklist:\n\n" +
            "- Run the validation tool in the Automachef menu to see if there are any problems with the structure of your mod.\n" +
            "- Check that all of your materials, models, textures, levels, special events, ingredients and dishes are set to use the Asset Bundle called \"mod\".\n" +
            "- Double check the internal names of all ingredients and dishes to ensure there are no duplicates.\n" +
            "- Make sure that all ingredients and dishes have a Friendly Name and an icon set. Also verify that the results of different processes such as frying and grilling point to existing Internal Names.\n" +
            "- Remember that all mods should contain at least one level in order to be playable.\n" +
            "- Verify that all references to dishes in levels and to ingredients in recipes point to Internal Names that actually exist, either within your mod or in the base game.";
        bool ok = EditorUtility.DisplayDialog("Warning", warningMessage, "Okay", "Cancel");

        if (ok) {
            string path = EditorUtility.SaveFilePanel("Select a file name for your exported mod", "", "mod", "automachefmod");
            BuildPipeline.BuildAssetBundles("Assets/ExportedAssetBundles", BuildAssetBundleOptions.None, BuildTarget.StandaloneWindows64);
            string sourceFileName = Application.dataPath + "/ExportedAssetBundles/mod";
            File.Copy(sourceFileName, path);
        }
    }
}