/**
 * 初始化Session对象

 var session = new IFlyIseSession({
    'url': 'http://webapi.openspeech.cn/',
    'reconnection': true,
    'reconnectionDelay': 30000,
    'compress': 'speex',
    'speex_path': 'js/speex.js', //speex.js本地路径 
    'vad_path': 'js/vad.js', //vad.js本地路径
    'recorder_path': 'js/recorderWorker.js' //recordWorker.js本地路径
});
 */

/**
 * 开启录音并获取识别结果
 */
var byteArray = [];
var result = "";
var i = 0;
var arry = {};
topics_.topicIndex = -1;


function ClearS(str) {
  while (true) {
    if (str.indexOf("(") > 0 && str.indexOf(")") > 0) {
      var a1 = str.substring(0, str.indexOf("("));
      var a2 = str.substring(str.indexOf(")") + 1, str.length);
      str = a1 + a2;
    } else {
      break;
    }
  }
  return str;
}


function speechStart(text, type, userId) {
  text = text.replace(/,/gm, ", ");
  text = text.replace(/,  /gm, ", ");
  text = text.replace(/\?/gm, "? ");
  text = text.replace(/\?  /gm, "? ");
  text = text.replace(/!/gm, "! ");
  text = text.replace(/!  /gm, "! ");
  text = text.replace(/;/gm, "; ");
  text = text.replace(/;  /gm, "; ");
  text = text.replace(/;  /gm, "; ");
  text = text.replace(/【/gm, "");
  text = text.replace(/】/gm, "");
  text = text.replace(/_+/gm, "");
  text = ClearS(text);
  text = text.replace(/\)/gm, "");
  text = text.replace(/\(/gm, "");
  if (type == "短语") {//句子
    aiPanel.setData({
      audioUrl: "",
      duration: 50000,
      serverParams: {
        coreType: "en.sent.score",
        attachAudioUrl: 1,//加上这个属性返回结果中会有音频url
        refText: text,
        rank: 100,
        userId: userId
      }
    });
  } else if (type == "课文") {//段子
    aiPanel.setData({
      audioUrl: "",
      duration: 110000,
      serverParams: {
        coreType: "en.pred.exam",
        attachAudioUrl: 1,
        precision: 0.5,//评分精度目前支持0.5和1.0
        refText: {
          lm: text
        },
        rank: 100,
        userId: userId
      }
    });
  } else {//单词
    aiPanel.setData({
      audioUrl: "",
      duration: 50000,
      serverParams: {
        coreType: "en.word.score",
        attachAudioUrl: 1,
        refText: text,
        rank: 100,
        userId: userId
      }
    });
  }
  topics_.startSpeech = true;//当连上服务器真正开始录音时设置为true
  $("#record").click();
  $("#start-voice").text('正在录音');
}

function speechStop() {
  topics_.topicIndex++;
  $("#record").click();
}
