﻿(function () {
    "use strict";
    var mathml_css_path = getMathmlCSSPath();
    function getCurrentFolderPath() {
        var scripts = document.getElementsByTagName('script');
        for (var i = 0; i < scripts.length; i++) {
            var script_path = scripts[i].src;
            if (/($|[^\w]+)mfrac\.js$/.test(script_path)) { // search for 'mfrac.js'
                return script_path.substr(0, script_path.lastIndexOf('/') + 1);
            }
        }
        return '';
    }

    function getMathmlCSSPath() {
        return getCurrentFolderPath() + "mathml.css";
    }
    if (document.readyState !== 'complete') {
        addEventListener("load", tryLoadCSS);
    } else
        tryLoadCSS();

    function tryLoadCSS() {
        var mfrac_html_str = "<div style='position:absolute;display:inline-block'><math xmlns='http://www.w3.org/1998/Math/MathML'><mfrac><mi>xx</mi><mi>yy</mi></mfrac></math></div>";
        document.body.insertAdjacentHTML("afterbegin", mfrac_html_str);
        var div = document.body.firstChild;
        if (div.offsetHeight < div.offsetWidth) {
            var link = document.createElement("link");
            link.href = mathml_css_path;
            link.rel = "stylesheet";
            document.head.appendChild(link);
        }
        document.body.removeChild(div);
    };
}());