// 解决桌面浏览器上click和鼠标拖拽操作二义性的问题：限制能产生 click 的 mousedown/mouseup 的时间和空间间隔。
(function() {
  var mouseMoveThreshold = 2;
  var upDownTimeThreshold = 300;
  var upClickTimeThreshold = 60;
  var xDown = -1/0, yDown = -1/0, tDown = -1/0, tUp = -1/0;

  function onMouseDown(ev) {
    xDown = ev.clientX;
    yDown = ev.clientY;
    tDown = Date.now();
  }

  function onMouseUp(ev) {
    tUp = Date.now();
  }

  function onClick(ev) {
    var dTUpDown = tUp - tDown;
    var dTClickUp = Date.now() - tUp;
    var dX = xDown - ev.clientX, dY = yDown - ev.clientY;
    //console.log('trueclick: parems: ', dTUpDown, dTClickUp, dX, dY);
    if (!(
      dTClickUp > upClickTimeThreshold || // 用来判别是否为合成的click事件或其他输入设备（如键盘）产生的click事件
      dTUpDown >= 0 && dTUpDown < upDownTimeThreshold &&
      Math.abs(dX) < mouseMoveThreshold &&
      Math.abs(dY) < mouseMoveThreshold
    )) {
      ev.stopImmediatePropagation();
      ev.preventDefault();
      //console.log('trueclick: canceled: ', ev);
    }
    xDown = yDown = tDown = tUp = -1/0; // 这是必要的。如果一个 click 事件中合成了另一个 click 事件，则后一个不应被取消。
  }

  window.addEventListener('mousedown', onMouseDown, true);
  window.addEventListener('mouseup', onMouseUp, true);
  window.addEventListener('click', onClick, true);
})();