(function (mainbo_voicescore) {
  function init(el) {
    setEditing(el);
  }
  mainbo_voicescore.init = init;

  const toolsName = [
    'zhuyin', 'zhushi',
    'fanyi', 'tingdun',
    'tongjiazi', 'xuci',
    'yidong', 'gujin',
    'huoyong', 'duoyi',
    'jushi', 'tjushi',
    'zuozhe', 'shangxi',
    'shangxiarticle'];
  const descType = {
    '17': '注音',
    '11': '注释', // '词语解释'
    '201': '翻译',
    '202': '朗读停顿', // '停顿'
    '20': '通假字',
    '12': '虚词用法',
    '19': '意动用法',
    '13': '古今异义', 
    '14': '词类活用', 
    '15': '一词多义', 
    '16': '文言句式', // '句式讲解'
    '21': '特殊句式',
    '203': '作者简介', // 18
    '204': '赏析评点', // '赏析'
    '205': '整篇赏析', // '赏析'
  };

  function setEditing(el) {
  	el.addEventListener('click', stopPropagation);
    if(!el.querySelectorAll('article').length) return;
    var scores = el.querySelectorAll('article');
    scores = Array.prototype.slice.call(scores, 0);
    if(isChinese(el)) {
      addTools(el, false);
      clearGuwen(el);
      if(!el.classList.contains('mainbo-zuowen')) {
        scores.forEach(function(score) {setGuwen(el, score)});
      } else {
        scores.forEach(function(score) {setZuowen(el, score)});
      }
      
      el.querySelector('.zhuyin').addEventListener('click', clickzhuyin);
      el.querySelector('.zhushi').addEventListener('click', clickzhushi);
      el.querySelector('.fanyi').addEventListener('click', clickfanyi);
      el.querySelector('.tingdun').addEventListener('click', clicktingdun);
      el.querySelector('.xuci').addEventListener('click', clickxuci);
      el.querySelector('.gujin').addEventListener('click', clickgujin);
      el.querySelector('.huoyong').addEventListener('click', clickhuoyong);
      el.querySelector('.duoyi').addEventListener('click', clickduoyi);
      el.querySelector('.jushi').addEventListener('click', clickjushi);
      el.querySelector('.yidong').addEventListener('click', clickyidong);
      el.querySelector('.tongjiazi').addEventListener('click', clicktongjiazi);
      el.querySelector('.tjushi').addEventListener('click', clicktjushi);
      el.querySelector('.zuozhe').addEventListener('click', clickzuozhe);
      el.querySelector('.shangxi').addEventListener('click', clickshangxi);
      el.querySelector('.shangxiarticle').addEventListener('click', clickshangxiarticle);
    } else {
      scores.forEach(function(score, index) {
        var playbtnh = score.querySelector('h2 > button');
        var allAudios = score.querySelectorAll('audio');
        allAudios = Array.prototype.slice.call(allAudios, 0);
        var removeLabel = score.querySelectorAll('label');
        Array.prototype.slice.call(removeLabel, 0).forEach(function(label) {label.parentNode.removeChild(label)});
        var paragraph = score.querySelectorAll('div.voice-textContent');
        paragraph = Array.prototype.slice.call(paragraph, 0);
        paragraph.forEach(function(para) {
          var playbtn = para.querySelector('button');
          var audios = para.querySelectorAll('audio');
          if (playbtn) playbtn.isloop = playbtn.words = false;
          if (playbtnh) playbtnh.isloop = playbtnh.words = false;
          if (playbtn) {
            playbtn.addEventListener('click', clickContentBtn);
          }
          allAudios.forEach(function(audio) {
            audio.removeAttribute('controls');
            audio.readword = 0;
            var wordthis = audio.nextElementSibling.localName === 'button' ? audio.nextElementSibling.nextElementSibling : audio.nextElementSibling;
            wordthis.addEventListener('click', function(ev) {
              ev.stopPropagation();
              pauseAndRemoveColor(allAudios);
              if (playbtn && playbtn.isloop) {
                playbtn.firstElementChild.classList.remove('mbe-icon-pause');
              }
              if (playbtnh && playbtnh.isloop) {
                playbtnh.firstElementChild.classList.remove('mbe-icon-pause');
              }
              if (playbtn) { playbtn.isloop = false; playbtn.words = true;}// 停止段落连续播放
              if (playbtnh) { playbtnh.isloop = false; playbtnh.words = true; }// 停止文章连续播放
              setTimeout(function() { // 延时，确保所有文本未描红
                audioPlay(audio);
                changeTextColor(audio, wordthis, audio.readword);
              }, 1000);
            });
          });
        });
        if (playbtnh) playbtnh.addEventListener('click', clickHeaderBtn);
      });
    }
  }
  
  mainbo_voicescore.setEditing = setEditing;
  function stopPropagation(ev) {
  	ev.stopPropagation();
  }
  function clickContentBtnOfGuwen(ev) {
    ev.stopImmediatePropagation();
    var this_el = getAncestors(ev.target, function(el) {return el.hasAttribute('data-control')}).pop();
    var guwenPlay = getAncestors(ev.target, function(el) {return el.localName == 'button'}).pop();
    var guwenPlayAll = getAncestors(ev.target, function(el) {return el.localName == 'article'}).pop().querySelector('h2 > button');
    var allAudios = this_el.querySelectorAll('audio');
    var audios = guwenPlay.parentElement.querySelectorAll('audio');
    if (guwenPlayAll) { // 停止文章连续播放
      guwenPlayAll.isloop = false;
      guwenPlayAll.setAttribute('title', '播放');
      //guwenPlayAll.removeEventListener('click',clickHeaderBtnOfGuwen);
    }
    var elPause = this_el.querySelector('.mbe-icon-pause');
    if (elPause) {
      if (elPause && guwenPlay === elPause.parentElement) { // 播放按钮为自身时，暂停音频，否则停止音频并播放新的
        elPause.classList.remove('mbe-icon-pause');
        elPause.parentElement.setAttribute('title', '播放');
        guwenPlay.ispause = true;
        guwenPlayAll.ispause = false;
        forEach(allAudios, function(audio) { audio.isplay = false; audio.pause(); });
        return;
      }
      elPause && elPause.classList.remove('mbe-icon-pause');
      clickPlayAudioOfGuwen(audios, guwenPlay, true);
      return;
    }
    clickPlayAudioOfGuwen(audios, guwenPlay);
  }
  function clickHeaderBtnOfGuwen(ev) {
    ev.stopImmediatePropagation();
    var this_el = getAncestors(ev.target, function(el) {return el.hasAttribute('data-control')}).pop();
    var guwenPlays = getAncestors(ev.target, function(el) {return el.localName == 'article'}).pop().querySelector('.textContent').querySelectorAll('button');
    var guwenPlayAll = getAncestors(ev.target, function(el) {return el.localName == 'button'}).pop();
    var allAudios = getAncestors(ev.target, function(el) {return el.localName == 'article'}).pop().querySelectorAll('audio');
    var elPause = this_el.querySelector('.mbe-icon-pause');
    if (elPause) {
      if (elPause && guwenPlayAll === elPause.parentElement) { // 播放按钮为自身时，暂停音频，否则停止音频并播放新的
        forEach(allAudios, function(audio) { audio.isplay = false; audio.pause(); });
        elPause.classList.remove('mbe-icon-pause');
        elPause.parentElement.setAttribute('title', '播放');
        guwenPlayAll.ispause = true;
        forEach(guwenPlays, function(guwenPlay) {
          guwenPlay.ispause = false;
        });
        return;
      }
      elPause.classList.remove('mbe-icon-pause');
      clickPlayAudioOfGuwen(allAudios, guwenPlayAll, true);
      if (elPause) {// 停止段落联系播放
        elPause.parentElement.isloop = false;
        elPause.parentElement.setAttribute('title', '播放');
      }
      return;
    }
    clickPlayAudioOfGuwen(allAudios, guwenPlayAll);
  }
  
  function clickContentBtn(ev) {
    ev.stopImmediatePropagation();
    var this_el = getAncestors(ev.target, function(el) {return el.hasAttribute('data-control')}).pop();
    var playbtn = getAncestors(ev.target, function(el) {return el.localName == 'button'}).pop();
    var playbtnh = getAncestors(ev.target, function(el) {return el.localName == 'article'}).pop().querySelector('h2 > button');
    var allAudios = this_el.querySelectorAll('audio');
    var audios = playbtn.parentElement.querySelectorAll('audio');
    if (playbtnh) { // 停止文章连续播放
      playbtnh.isloop = playbtnh.words =  false;
      playbtnh.setAttribute('title', '播放');
      // playbtnh.removeEventListener('click', clickHeaderBtn);
    }
    if (this_el.querySelector('.mbe-icon-pause') || playbtn.words) {
      var elPause = this_el.querySelector('.mbe-icon-pause');
      if (elPause && playbtn === elPause.parentElement) { // 播放按钮为自身时，暂停音频，否则停止音频并播放新的
        elPause.classList.remove('mbe-icon-pause');
        playbtn.setAttribute('title', '播放');
        playbtn.ispause = true;
        playbtnh && (playbtnh.ispause = false);
        forEach(allAudios, function(audio) { 
          audio.isplay = false; 
          audio.pause(); 
        });
        return;
      }
      elPause && elPause.classList.remove('mbe-icon-pause');
      clickPlayAudio(audios, playbtn, true);
      playbtn.words = false;
      return;
    }
    clickPlayAudio(audios, playbtn);
  }
  
  function clickHeaderBtn(ev) {
    ev.stopImmediatePropagation();
    var this_el = getAncestors(ev.target, function(el) {return el.hasAttribute('data-control')}).pop();
    var playbtnh = getAncestors(ev.target, function(el) {return el.localName == 'button'}).pop();
    var playbtns = getAncestors(ev.target, function(el) {return el.localName == 'article'}).pop().querySelectorAll('.voice-textContent');
    var allAudios = getAncestors(ev.target, function(el) {return el.localName == 'article'}).pop().querySelectorAll('audio');
    if (this_el.querySelector('.mbe-icon-pause') || playbtnh.words) {
      var elPause = this_el.querySelector('.mbe-icon-pause');
      if (elPause && playbtnh === elPause.parentElement) { // 播放按钮为自身时，暂停音频，否则停止音频并播放新的
        forEach(allAudios, function(audio) { audio.isplay = false; audio.pause(); });
        elPause.classList.remove('mbe-icon-pause');
        if(playbtnh) {
          playbtnh.setAttribute('title', '播放');
          playbtnh.ispause = true;
        }
        forEach(playbtns, function(playbtn) {
          playbtn.querySelector('button').ispause = false;
        });
        return;
      }
      elPause && elPause.classList.remove('mbe-icon-pause');
      clickPlayAudio(allAudios, playbtnh, true);
      if (elPause) {// 停止段落联系播放
        elPause.parentElement.words = elPause.parentElement.isloop = false;
        elPause.parentElement.setAttribute('title', '播放');
      }
      playbtnh.words = false;
      return;
    }
    clickPlayAudio(allAudios, playbtnh);
  }
  
  function clickzhuyin(ev){ clickToolsKid(ev.target, 'word-zhuyin', 17); }
  function clickzhushi(ev){ clickToolsKid(ev.target, 'word-zhushi', 11); }
  function clickfanyi(ev){ clickToolsKid(ev.target, 'word-fanyi', 201); }
  function clicktingdun(ev){ clickToolsKid(ev.target, 'word-tingdun', 202); }
  function clickxuci(ev){ clickToolsKid(ev.target, 'word-xuci', 12); }
  function clickgujin(ev){ clickToolsKid(ev.target, 'word-gujin', 13); }
  function clickhuoyong(ev){ clickToolsKid(ev.target, 'word-huoyong', 14); }
  function clickduoyi(ev){ clickToolsKid(ev.target, 'word-duoyi', 15); }
  function clickjushi(ev) { clickToolsKid(ev.target, 'word-jushi', 16); }
  function clickyidong(ev) { clickToolsKid(ev.target, 'word-yidong', 19); }
  function clicktongjiazi(ev) { clickToolsKid(ev.target, 'word-tongjiazi', 20); }
  function clicktjushi(ev) { clickToolsKid(ev.target, 'word-tjushi', 21); }
  function clickzuozhe(ev){ clickToolsKid(ev.target, 'word-zuozhe', 203); } // 18
  function clickshangxi(ev) { clickToolsKid(ev.target, 'word-shangxi', 204); }
  function clickshangxiarticle(ev) { clickToolsKid(ev.target, 'word-shangxiarticle', 205); }
  
  function clickToolsKid(target, type, desc_type) {
    var this_el = getAncestors(target, function(el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_guwen';}).pop();
    clearGuwen(this_el);
    var articles = this_el.getElementsByTagName('article');
    forEach(articles, function(article) {
      var getGuwenDate = JSON.parse(article.getAttribute('data-guwenjson'));
      var textCont = article.querySelector('.textContent');
      if(desc_type == 201) { // 译文
        var explainsCont = document.createElement('div');
        var explainsBtnCont = document.createElement('div');
        var btnMode = document.createElement('button');
        explainsCont.classList.add('guwen-explains');
        explainsCont.innerHTML = '<b>译：</b>';
        explainsCont.style.color = '#257e17';
        explainsBtnCont.classList.add('explains-mode');
        btnMode.textContent = target.classList.contains('fanyi-mode') ? '全部翻译>>' : '每段翻译>>';
        explainsBtnCont.appendChild(btnMode);
        btnMode.addEventListener('click', function(ev) {
          if(btnMode.textContent == '每段翻译>>') {
            target.classList.add('fanyi-mode');
            btnMode.textContent = '全部翻译>>';
            clickToolsKid(target, 'word-fanyi', 201);
          } else {
            target.classList.remove('fanyi-mode');
            btnMode.textContent = '每段翻译>>';
            textCont.style.marginBottom = '';
            clickToolsKid(target, 'word-fanyi', 201);
          }
        });
        forEach(textCont.querySelectorAll('.voice-textContent'), function(child) {
          if(!child.getAttribute('data-explains')) return;
          if(target.classList.contains('fanyi-mode')) { // 每段译文
            var cloneCont = explainsCont.cloneNode(true);
            cloneCont.innerHTML += '<b>' + child.getAttribute('data-explains') + '</b><br />';
            child.parentElement.insertBefore(cloneCont, child.nextElementSibling);
          } else { // 全部译文
            explainsCont.innerHTML += '<p>' + child.getAttribute('data-explains') + '</p>';
          }
        });
        if(!target.classList.contains('fanyi-mode')) { 
          article.insertBefore(explainsCont, null);
          if(article.scrollHeight - article.getBoundingClientRect().height > 100) {
            article.scrollTop = textCont.getBoundingClientRect().height -100;
          }
        }
        // 添加译文模式按钮
        if(!article.querySelector('.explains-mode')) article.appendChild(explainsBtnCont);
        article.querySelector('.explains-mode').previousElementSibling.style.marginBottom = '50px';
        article.style.height = 'calc(100% - 64px)';
      } else if(desc_type == 202) { // 停顿
        forEach(textCont.children, function(section) {
          forEach(section.children, function(sentence) {
            if(!sentence.getAttribute('data-contentpause')) return;
            sentence.setAttribute('data-oldhtml', sentence.innerHTML);
            sentence.innerHTML = sentence.getAttribute('data-contentpause');
          });
        });
      } else if(desc_type == 203) { // 作者
        makeLink(article.parentElement, '<div style="text-indent: 2em;">' + getGuwenDate.guwen.authorDesc + '</div>', 0, 0, 'detail-link')
      } else if(desc_type == 204) { // 赏析评点
        forEach(textCont.children, function(section, i) {
          forEach(section.children, function(sentence, j) {
            if(sentence.getAttribute('data-comment') == '无') return;
            forEach(sentence.children, function(word) {
              word.classList.add('word-shangxi');
              word.classList.add('word-shangxi-' + i + j);
              word.setAttribute('title', '点击查看赏析');
              word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, sentence.getAttribute('data-comment'))});
            });
          });
        });
      } else if(desc_type == 205) { // 整篇赏析
        makeLink(this_el, '<div style="text-indent: 2em;">' + getGuwenDate.guwen.analysisDesc.split(/\n/).map((text) => { return '<p>' + text + '</p>'}).join('') + '</div>', 0, 0, 'detail-link');
      } else {
        forEach(getGuwenDate.words, function(word) {
          if(word.desc_type == desc_type) {
            parseWords(article, word.idx_s, word.idx_e, type, word.description);
          }
        });
      }
    });
    if(desc_type != 203 && desc_type != 205) {
      addResetBut(this_el);
    }
  }
  
  function setDetailOfToolsKid(stc, type, desc_type, idx_first, idx_last) {
    var article = getAncestors(stc, function(el) { return el.localName == 'article'}).pop();
    var words = article.querySelectorAll('span');
    var getGuwenDate = JSON.parse(article.getAttribute('data-guwenjson'));
    forEach(getGuwenDate.words, function(word) {
      if(word.idx_s > idx_last || word.idx_e < idx_first) return;
      if(word.desc_type == desc_type) {
        setDetailLinkContent(article, word.idx_s, word.idx_e, type, word.description);
        if(desc_type == 17) return; // 拼音常态显示
        if(!stc.linkjson[descType[desc_type]]) {
          stc.linkjson[descType[desc_type]] = [getTextOf(Array.prototype.slice.call(words, 0), word.idx_s, word.idx_e) + '：' + word.description];
        } else {
          stc.linkjson[descType[desc_type]].push(getTextOf(Array.prototype.slice.call(words, 0), word.idx_s, word.idx_e) + '：' + word.description)
        }
      }
    });
  }

  function clickSentence(ev) {
    var stc = getAncestors(ev.target, function(el) {return el.localName == 'p'}).pop();
    var this_el = getAncestors(stc, function(el) {return el.hasAttribute('data-control')}).pop();
    var article = getAncestors(stc, function(el) {return el.localName == 'article'}).pop();
    var allSpan = article.getElementsByTagName('span');
    allSpan = Array.prototype.slice.call(allSpan, 0);
    stc.linkjson = {};
    var idx_first = allSpan.indexOf(stc.firstChild) + 1;
    var idx_last = allSpan.indexOf(stc.lastChild) + 1;
    setDetailOfToolsKid(stc, 'word-zhuyin', 17, idx_first, idx_last);
    setDetailOfToolsKid(stc, 'word-zhushi', 11, idx_first, idx_last);
    setDetailOfToolsKid(stc, 'word-xuci', 12, idx_first, idx_last);
    setDetailOfToolsKid(stc, 'word-gujin', 13, idx_first, idx_last);
    setDetailOfToolsKid(stc, 'word-huoyong', 14, idx_first, idx_last);
    setDetailOfToolsKid(stc, 'word-duoyi', 15, idx_first, idx_last);
    setDetailOfToolsKid(stc, 'word-jushi', 16, idx_first, idx_last);
    setDetailOfToolsKid(stc, 'word-yidong', 19, idx_first, idx_last);
    setDetailOfToolsKid(stc, 'word-tongjiazi', 20, idx_first, idx_last);
    setDetailOfToolsKid(stc, 'word-tjushi', 21, idx_first, idx_last);
    stc.setAttribute('data-linkjson', JSON.stringify(stc.linkjson));
    if(JSON.stringify(stc.linkjson).length < 3 && stc.getAttribute('data-explains') == '无' && stc.previousElementSibling.error) return;
    makeLink(this_el, makeLinkDetail(stc).innerHTML, 0, 0, 'detail-link');
    var detailLink = this_el.querySelector('.detail-link');
    var detailShow = detailLink.querySelector('.link-showOrHide');
    detailShow.addEventListener('click', function() {
      var linkUnderWords = detailLink.querySelector('.link-underwords');
      detailShow.classList.toggle('showDetail');
      if(detailShow.classList.contains('showDetail')) {
        detailLink.querySelector('.link-detailLists').classList.add('show');
        linkUnderWords.classList.add('show');
        linkUnderWords.querySelector('span').innerHTML = stc.getAttribute('data-explains');
      } else {
        detailLink.querySelector('.link-detailLists').classList.remove('show');
        linkUnderWords.classList.remove('show');
      }
    });
    removeResetBut(this_el);
  }  
  
  /**
   * 添加作文数据
  */
  function setZuowen(el, article) {
    var content = article.querySelector('.textContent');
    if(!content && article.getAttribute('data-zuowenjson')) {
      var guwenJSON = JSON.parse(article.getAttribute('data-zuowenjson'));
      var art = parseArticleZuoWen(guwenJSON.content.trim().replace(/(\r)?(\n)?\s+/g, '\n'));
      var title = article.querySelector('h2');
      var author = article.querySelector('h4');
      article.appendChild(art);
      el.classList.add('mainbo-zuowen');
      addCommentsBtn(article);
      // etb_book.setTextEditable(art, true);
      title.innerHTML = guwenJSON.title;
      author.hidden = true;
    }
    var btnAll = article.querySelector('.comments > button');
    btnAll.addEventListener('click', () => {
      if(article.querySelector('.comments-content')) {
        article.removeChild(article.querySelector('.comments-content'));
        btnAll.classList.remove('action');
      } else {
        article.appendChild(addComments(article));
        intoView(article);
        btnAll.classList.add('action');
      }
    });
  }
  
  /**
   * 古文控件添加数据
  */
  function setGuwen(el, article) {
    var scoreContent = article.querySelector('.textContent');
    if(!scoreContent && article.getAttribute('data-guwenjson')) {
      var guwenJSON = JSON.parse(article.getAttribute('data-guwenjson'));
      var art = parseArticle(guwenJSON.guwen.content);
      var sections = Array.prototype.sort.call(guwenJSON.sections, function(a, b) { return a.idx_s - b.idx_s; });
      var sentences = Array.prototype.sort.call(guwenJSON.sentences, function(a, b) { return a.idx_s - b.idx_s; });
      var title = article.querySelector('h2');
      var author = article.querySelector('h4');
      forEach(sections, function(section) {
        parseSections(art, section.idx_s, section.idx_e, section.explains, section.voice_path);
      });
      forEach(sentences, function(sentence) {
        parseSentences(art, sentence.idx_s, sentence.idx_e, sentence.explains, sentence.content_pause, sentence.comment, guwenJSON.relative_path_ali + sentence.voice_path);
      });   
      article.appendChild(art);
      if(title) { // 添加文章标题和音频播放按钮
        title.innerHTML = '';
        forEach(art.firstElementChild.querySelectorAll('p'), function(sentences, i) {
          if(art.firstElementChild.querySelectorAll('p').length < 2) {
            forEach(sentences.querySelectorAll('span'), function(isSpan, j) {
              if(sentences.querySelectorAll('span').length == 1 && isSpan.textContent == '无') {
                title.style.display = 'none';
              }
            });
          }
          if(sentences.previousElementSibling && sentences.previousElementSibling.localName == 'audio') {
            title.appendChild(sentences.previousElementSibling.cloneNode(true)); 
          }
          title.appendChild(sentences.cloneNode(true)); 
        });
        art.removeChild(art.firstElementChild);
      }
      if(author) {
        author.innerHTML = '';
        forEach(art.firstElementChild.querySelectorAll('p'), function(sentences, i) {
          if(art.firstElementChild.querySelectorAll('p').length < 2) {
            forEach(sentences.querySelectorAll('span'), function(isSpan, j) {
              if(sentences.querySelectorAll('span').length == 1 && isSpan.textContent == '无') {
                author.style.display = 'none';
              }
            });
          }
          if(sentences.previousElementSibling && sentences.previousElementSibling.localName == 'audio') {
            author.appendChild(sentences.previousElementSibling.cloneNode(true)); 
          }
          author.appendChild(sentences.cloneNode(true)); 
        });
        art.removeChild(art.firstElementChild);
      }
    }
    var getAllAudios = article.querySelectorAll('audio');
    if(title && !title.querySelector('button')) {
      title.insertBefore(appendPlayButton(el), title.firstChild);
      if(!getAllAudios.length) { // 无音频可播放时，隐藏播放按钮
        title.querySelector('button').style.visibility = 'hidden';
      }
    }
    var guwenPlayAll = article.querySelector('h2 > button');
    var allAudios = article.querySelectorAll('audio');
    var textContents = article.querySelectorAll('.voice-textContent');
    forEach(textContents, function(content) {
      var audios = content.querySelectorAll('audio');
      if(!content.querySelector('button')) {
        content.insertBefore(appendPlayButton(el), content.firstChild);
        if(!audios.length) { // 无音频可播放时，隐藏播放按钮
          content.querySelector('button').style.visibility = 'hidden';
        }
      }
      var guwenPlay = content.querySelector('button');
      if (guwenPlay) guwenPlay.isloop = false;
      if (guwenPlayAll) guwenPlayAll.isloop = false;
      if (guwenPlay) guwenPlay.addEventListener('click', clickContentBtnOfGuwen);
    });
    if (guwenPlayAll) guwenPlayAll.addEventListener('click', clickHeaderBtnOfGuwen);
    var getSentences = article.getElementsByTagName('p');
    var allSpan = article.getElementsByTagName('span');
    allSpan = Array.prototype.slice.call(allSpan, 0);
    forEach(getSentences, function(stc) {
      stc.addEventListener('pointerdown', clickSentence);
    });
    localAudiosSrc(article);
  }

  /**
   * 添加作文评论按钮 
  */
  function addCommentsBtn(article) {
    var comments = document.createElement('div');
    var btnAll = document.createElement('button');
    comments.className = 'comments';
    btnAll.textContent = '全文评论';
    comments.appendChild(btnAll);
    article.appendChild(comments);
  }

  function addComments(el) {
    var comments = document.createElement('div');
    comments.className = 'comments-content';
    comments.setAttribute('id', 'mbe-id-zuowen-comments');
    // etb_book.setTextEditable(comments, true);
    var zuowen = el.getAttribute('data-zuowenjson');
    if(zuowen) {
      comments.appendChild(parseArticleZuoWen(('<b>评论：</b>' + (JSON.parse(zuowen).comments || '暂无评论')).trim().replace(/&nbsp;/g, '').replace(/(\r)?(\n)?\s+/g, '\n')));
    }
    return comments;
  }

  function intoView(el) {
    // el.scrollIntoView();
    var textCont = el.querySelector('.textContent');
    if(el.scrollHeight - el.getBoundingClientRect().height > 100) {
      el.scrollTop = textCont.getBoundingClientRect().height -100;
    }
  }
  
  /**
   * 添加重置古文内容的按钮
  */
  function addResetBut(el) {
    var back = document.createElement('div');
    back.className = 'backOldHTML';
    back.title = '返回';
    el.appendChild(back);
    back.addEventListener('click', function() {
      clearGuwen(el);
      addTools(el, false);
    });
  }
  
  /**
   * 删除重置古文内容的按钮
  */
  function removeResetBut(el) {
    if(!el.querySelector('.backOldHTML')) return;
    el.removeChild(el.querySelector('.backOldHTML'));
  }
  
  /**
   * 重置古文内容
   * 功能切换或返回或关闭详情框时调用
  */
  function clearGuwen(el) {
    var toolsLi = el.querySelectorAll('.guwen-tools>li');
    if (!toolsLi.length) return;
    removeResetBut(el);
    el.querySelector('.guwen-link').innerHTML = '';
    el.querySelector('.guwen-link').style.display = 'none';
    var articles = el.getElementsByTagName('article');
    forEach(articles, function(article) {
      var title = document.createElement('h2');
      var author = document.createElement('h4');
      saveAudios(article);
      article.innerHTML = '';
      article.appendChild(title);
      article.appendChild(author);
      setGuwen(el, article);
      // 翻译修改了内容容器的位置和高度，需要清理恢复
      article.scrollTop = 0;
      article.style.height = '';
    });
  }

  function saveAudios(article) {
    var oldAudiosSrc = getMap(article.querySelectorAll('audio'), function(audio) { return audio.getAttribute('src') } );
    article.setAttribute('data-oldsrc', oldAudiosSrc.join());
  }

  function localAudiosSrc(article) {
    if(!article.getAttribute('data-oldsrc')) return;
    var oldAudiosSrc = article.getAttribute('data-oldsrc').split(',');
    forEach(article.querySelectorAll('audio'),function(audio, i) {
      audio.setAttribute('src', oldAudiosSrc[i]);
    });
    article.removeAttribute('data-oldsrc');
  }
  
  /**
   * 获取内容
  */
  function getTextOf(spans, idx_s, idx_e) {
    var text = '';
    for(var i = idx_s; i <= idx_e; i++) {
      text += spans[i - 1].getAttribute('data-oldhtml') || spans[i - 1].textContent;
    }
    return text;
  }

  function matchPinyin(text) {
    if(!/[a-z]{1,6}\-\d\d/g.test(text)) return text;
    forEach(text.match(/[a-z]{1,6}\-\d\d/g), function(pinyin) {
      text = text.replace(pinyin, parsePinyin(pinyin));
    });
    return text;
  }
  /**
   * 置换拼音音标
   * zhang-31 -> zhāng
  */
  function parsePinyin(pinyin) {
    var soundmark = {
      'a': ['a', 'ā', 'á', 'ǎ', 'à'],
      'e': ['e', 'ē', 'é', 'ě', 'è'],
      'i': ['i', 'ī', 'í', 'ǐ', 'ì'],
      'o': ['o', 'ō', 'ó', 'ǒ', 'ò'],
      'u': ['u', 'ū', 'ú', 'ǔ', 'ù'],
      'v': ['ü', 'ǖ', 'ǘ', 'ǚ', 'ǜ'],
    };
    var sound = pinyin.split('-')[0];
    var mark = pinyin.split('-')[1];
    if(!sound || !mark || mark.length < 2) return pinyin;
    var sm = soundmark[sound.charAt(parseFloat(mark.split('')[0]) - 1)][parseFloat(mark.split('')[1])];
    if(!sm) return pinyin;
    return sound.replace(sound.charAt(parseFloat(mark.split('')[0]) - 1), sm);
  }
  
  /**
   * 预处理弹出框里的内容
  */
  function setDetailLinkContent(article, sIndex, eIndex, type, description) {
    var words = article.querySelectorAll('span');
    for(var i = sIndex; i <= eIndex; i++) {
      var word = words[i - 1];
      switch (type) {
        case 'word-zhuyin':
          if(word.hasAttribute('data-oldhtml')) return;
          word.setAttribute('data-oldhtml', word.innerHTML);
          word.innerHTML = word.innerHTML + '(' + matchPinyin(description) + ')';
          break;
        case 'word-zhushi':
        case 'word-xuci':
        case 'word-gujin':
        case 'word-huoyong':
        case 'word-duoyi':
        case 'word-jushi':
        case 'word-yidong':
        case 'word-tongjiazi':
        case 'word-tjushi':
        case 'word-zuozhe':
          type && word.classList.add(type);
          word.setAttribute('data-word-description', description);
          break;
        case 'word-fanyi': // 查看全部时显示
        case 'word-tingdun': // 不显示
        case 'word-shangxi': // 不显示
        default:
          break;
      }
    }
  }
  
  function showLinkPanel(ev, article, description) {
    ev.stopImmediatePropagation();
    var rect = article.parentElement.getBoundingClientRect();
    var dx = ev.clientX - rect.left + 5;
    var dy = ev.clientY - rect.top + 5;
    
    makeLink(article.parentElement, description, dx, dy);
  }
  /**
   * 整理文字
  */
  function parseWords(article, sIndex, eIndex, type, description) {
    var words = article.querySelectorAll('span');
    for(var i = sIndex; i <= eIndex; i++) {
      var word = words[i - 1];
      if(!word) continue;
      type && word.classList.add(type);
      switch(type) {
        case 'word-zhuyin':
          if(word.hasAttribute('data-oldhtml')) return;
          word.setAttribute('data-oldhtml', word.innerHTML);
          word.innerHTML = word.innerHTML + '(' + matchPinyin(description) + ')';
          break;
        case 'word-zhushi':
          word.classList.add('word-zhushi-' + sIndex + eIndex);
          word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, description)});
          break;
        case 'word-xuci':
          word.classList.add('word-xuci-' + sIndex + eIndex);
          word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, description)});
          break;
        case 'word-gujin':
          word.classList.add('word-gujin-' + sIndex + eIndex);
          word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, description)});
          break;
        case 'word-huoyong':
          word.classList.add('word-huoyong-' + sIndex + eIndex);
          word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, description)});
          break;
        case 'word-duoyi':
          word.classList.add('word-duoyi-' + sIndex + eIndex);
          word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, description)});
          break;
        case 'word-jushi':
          word.classList.add('word-jushi-' + sIndex + eIndex);
          word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, description)});
          break;
        case 'word-yidong':
          word.classList.add('word-yidong-' + sIndex + eIndex);
          word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, description)});
          break;
        case 'word-tongjiazi':
          word.classList.add('word-tongjiazi-' + sIndex + eIndex);
          word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, description)});
          break;
        case 'word-tjushi':
          word.classList.add('word-tjushi-' + sIndex + eIndex);
          word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, description)});
          break;
        case 'word-zuozhe':
          word.classList.add('word-zuozhe-' + sIndex + eIndex);
          word.addEventListener('pointerdown', function(ev) {showLinkPanel(ev, article, description)});
          break;
        case 'word-fanyi': // 特殊处理
        case 'word-tingdun': // 特殊处理
        case 'word-shangxi': // 特殊处理
        default:
          break;
      }
    }
  }
  
  /**
   * 整理句子
   * *音频不确定是放在段落还是句子，所以置为可选项*
  */
  function parseSentences(article, sIndex, eIndex, explains, contentPause, comment, audio_path) {
    var p = document.createElement('p');
    var queryAllSpan = article.querySelectorAll('span');
    var oldParent = article.querySelectorAll('span')[sIndex -1].parentElement;
    
    for(var i = sIndex; i <= eIndex; i++) {
      if(!queryAllSpan[i - 1]) continue;
      p.appendChild(queryAllSpan[i - 1]);
    }
    p.setAttribute('data-contentpause', contentPause);
    p.setAttribute('data-explains', explains);
    p.setAttribute('data-comment', comment);
    p.setAttribute('title', '点击查看详情');
    var nextSpan = article.querySelectorAll('span')[sIndex - 1];
    if(audio_path) { // 添加音频
      var audio = document.createElement('audio');
      audio.setAttribute('src', audio_path);
      if(nextSpan && (nextSpan.parentElement == oldParent)) {
        oldParent.insertBefore(audio, nextSpan);
      } else {
        oldParent.insertBefore(audio, null);
      }
    }
    if(nextSpan && (nextSpan.parentElement == oldParent)) {
      oldParent.insertBefore(p, nextSpan);
    } else {
      oldParent.insertBefore(p, null);
    }
  }
  /**
   * 整理段落
   * *音频不确定是放在段落还是句子，所以置为可选项*
  */
  function parseSections(article, sIndex, eIndex, explains, audio_path) {
    var textContent = document.createElement('div');
    textContent.className = 'voice-textContent';
    textContent.setAttribute('data-explains', explains);
    var articleChildSpan = getFilter(article.children, function(kid) {
      return kid.localName == 'span';
    });
    for(var i = 0; i <= (eIndex - sIndex); i++) {
      if(!articleChildSpan[i]) continue;
      textContent.appendChild(articleChildSpan[i]);
    }
    if(audio_path) { // 添加音频
      var audio = document.createElement('audio');
      audio.setAttribute('src', iOUtils.toAbsoluteUrl(audio_path));
      textContent.insertBefore(audio, textContent.firstChild);
    }
    article.insertBefore(textContent, article.querySelectorAll('span')[sIndex - 1]);
    return article;
  }
  /**
   * 整理文章
  */
  function parseArticle(article, sIndex, eIndex) {
    sIndex = sIndex || 0;
    eIndex = eIndex || article.length;
    var container = document.createElement('div');
    container.className = 'textContent';
    for(var i = sIndex; i < eIndex; i++) {
      container.appendChild(createSpanAppend(article.charAt(i)));
    }
    return container;
  }  

  /**
   * 整理文章(作文)
  */
  function parseArticleZuoWen(article) {
    var articleSplit = article.trim().split(/\n|<\/br>/);
    var container = document.createElement('div');
    container.className = 'textContent';
    for(var i = 0; i < articleSplit.length; i++) {
      var p = document.createElement('p');
      p.innerHTML = articleSplit[i];
      container.appendChild(p);
    }
    return container;
  }  
  
  /**
   * 创建一个添加文字的span
   * 文字包括古文中的所有字符
  */
  function createSpanAppend(word, classNames) {
    var span = document.createElement('span');
    span.textContent = word;
    span.className = classNames || '';
    return span;
  }
  
  /**
   * 设置文言解析句子详情内容
  */
  function makeLinkDetail(sentence) {
    var explain = sentence.getAttribute('data-explains');
    var linkJson = JSON.parse(sentence.getAttribute('data-linkjson')) || {};
    // 创建项
    var detail = document.createElement('div');
    var sentHTML = document.createElement('p');
    var underOfSent = document.createElement('div');
    var detailLists = document.createElement('div');
    var showOrHide = document.createElement('div');
    var showOrHideText = document.createElement('span');
    var showOrHideIcon = document.createElement('button');
    sentHTML.classList.add('link-oldhtml');
    underOfSent.classList.add('link-underwords');
    detailLists.classList.add('link-detailLists');
    showOrHide.classList.add('link-showOrHide');
    // 添加内容
    explain && sentHTML.setAttribute('data-explains', explain);
    var cloneIcon = showOrHideIcon.cloneNode();
    cloneIcon.classList.add('explains');
    cloneIcon.setAttribute('title', '译文');
    sentHTML.appendChild(cloneIcon);
    forEach(sentence.children, function(kid) {
      sentHTML.appendChild(kid.cloneNode(true));
    });
    if(sentence.previousElementSibling && sentence.previousElementSibling.localName == 'audio' && !sentence.previousElementSibling.error) {
      sentHTML.insertBefore(sentence.previousElementSibling.cloneNode(true), cloneIcon);
    }
    var descCon = document.createElement('span');
    underOfSent.appendChild(descCon);
    for(var name in linkJson) {
      var descList = document.createElement('dl');
      var descName = document.createElement('dt');
      var descContent = document.createElement('dd');
      var detaiDescCon = descCon.cloneNode();
      var descCons = getMap(linkJson[name], function(descCon) { return matchPinyin(descCon); }).join('<br />');
     
      descName.innerHTML = name;
      detaiDescCon.innerHTML = descCons;
      descContent.appendChild(detaiDescCon);
      descList.appendChild(descName);
      descList.appendChild(descContent);
      detailLists.appendChild(descList);
    }
    showOrHide.appendChild(showOrHideText);
    showOrHide.appendChild(showOrHideIcon);
    // 添加项
    detail.appendChild(sentHTML);
    detail.appendChild(underOfSent);
    detail.appendChild(detailLists);
    detail.appendChild(showOrHide);
    return detail;
  }
  
  /**
   * 修改弹出项内容,并添加功能
  */
  function makeLink(el, insertText, dx, dy, className) {
    var gLink = el.querySelector('.guwen-link');
    var linkContent = document.createElement('div');
    var fontSize = getCSSNumber(gLink, 'font-size') || 24;
    gLink.innerHTML = '';
    gLink.className = 'guwen-link';
    linkContent.classList.add('linkContent');
    !className && (insertText = matchPinyin(insertText));
    linkContent.innerHTML = insertText;
    gLink.setAttribute('style', 'display: block; left: ' + dx + 'px; top: ' + dy + 'px;');
    if(className) {
      forEach(className.split(' '), function(cName) {
        gLink.classList.add(cName);
      });
    }
    var closeLink = document.createElement('div');
    closeLink.className = 'link-close';
    closeLink.setAttribute('title', '关闭');
    gLink.appendChild(linkContent);
    gLink.appendChild(closeLink);
    gLink.querySelector('.link-close').addEventListener('click', function() {
      gLink.style.display = 'none';
      if(className) {
        gLink.className = 'guwen-link';
        clearGuwen(el);
        addTools(el, false);
      }
    });
    if(!className) {
      var gLinkRect = gLink.getBoundingClientRect();
      if(gLinkRect.height > gLinkRect.width) {
        gLink.style.width = gLinkRect.height + 'px';
        gLink.style.height = gLinkRect.width + 'px';
      }
      gLinkRect = gLink.getBoundingClientRect();
      var gLinkParentRect = gLink.parentElement.getBoundingClientRect();
      if(gLinkRect.right > gLinkParentRect.right) {
      gLink.style.left = '';
      gLink.style.right = '0px';
      }
      if(gLinkRect.bottom > gLinkParentRect.bottom) {
        gLink.style.top = '';
        gLink.style.bottom = gLinkParentRect.bottom - gLinkRect.top + fontSize + 'px';
      }
      // 防止超出上边界
      gLinkRect = gLink.getBoundingClientRect();
      if(gLinkRect.top <= gLinkParentRect.top) {
        gLink.style.top = 4 + 'px';
        gLink.style.height = gLinkRect.height - fontSize * 2 + 'px';
      }
    }
    var oldhtml = gLink.querySelector('.link-oldhtml');
    if(oldhtml) {
      // 显示注释，一词多义等
      forEach(gLink.querySelectorAll('span'), function(span) {
        if(!span.hasAttribute('data-word-description')) return;
        span.addEventListener('pointerdown', ev => {
          ev.stopPropagation();
          var underWordContent = gLink.querySelector('.link-underwords');
          underWordContent.classList.add('show');
          underWordContent.classList.add('showDescription');
          underWordContent.querySelector('span').innerHTML = matchPinyin(span.getAttribute('data-word-description'));
        });
      });
      // 显示翻译
      oldhtml.querySelector('button').addEventListener('pointerdown', function(ev) {
        ev.stopPropagation();
        var underWordContent = gLink.querySelector('.link-underwords');
        underWordContent.classList.add('show');
        underWordContent.querySelector('span').innerHTML = oldhtml.getAttribute('data-explains');
      });
      // 句子音频播放按钮
      var sentenceAudios = oldhtml.querySelectorAll('audio');
      if(sentenceAudios.length) {
        sentenceAudios[0].parentElement.insertBefore(appendPlayButton(el), sentenceAudios[0]);
        sentenceAudios[0].previousElementSibling.addEventListener('pointerdown', ev => {
          clickPlayAudioOfGuwen(sentenceAudios, sentenceAudios[0].previousElementSibling)
        });
      }
    }
  }
  
  /**
   * 功能项添加事件
  */
  function addTools(el, editing){
    var gTools = el.querySelector('.guwen-tools');
    forEach(gTools.children, function(tool, i) {
      if(!editing) {
        forEach(gTools.children, function(li, j) {
          li.classList.remove('current');
          li.classList.remove('fanyi-mode');
        });
      }
      tool.addEventListener('click', function() {
        forEach(gTools.children, function(li, j) {
          li.classList.remove('current');
        });
        tool.classList.add('current');
      });
    });
  }
  
  function isChinese(el){
    switch(el.getAttribute('data-control')){
      case 'mainbo_guwen':
      case 'mainbo_zuowen':
        return true;
      default:
        return false;
    }
  }
  /**
   * 古文 音频按钮 被点击时
  */
  function clickPlayAudioOfGuwen(audios, playbtn, cutOther) {
    playbtn.setAttribute('title', '播放');
    if (!playbtn.firstElementChild.classList.contains('mbe-icon-pause')) {
      playbtn.firstElementChild.classList.add('mbe-icon-pause');
      playbtn.setAttribute('title', '暂停');
    }
    if (cutOther || !playbtn.ispause) {
      var allAudios = getAncestors(playbtn, function(el) { return el.localName === 'article' || el.classList.contains('guwen-link') })[0].querySelectorAll('audio');
      forEach(allAudios, function(audio) { // 停止所有播放的音频
        audio.isplay = false;
        audio.pause();
        audio.currentTime = 0;
      });
    }
    playbtn.audioIndex = 0;
    forEach(audios, function(audio, i) { // 找回暂停的音频
      if (cutOther) return;
      if(!audio.ended && audio.currentTime != 0) {
        playbtn.audioIndex = i;
      }
    });
    setTimeout(function() {
      var audio = audios[playbtn.audioIndex];
      playbtn.isloop = true;
      if(audio.error) {
        playbtn.audioIndex += 1;
        loopPlayAudio(audios, playbtn.audioIndex, playbtn);
      } else {
        audioPlay(audio);
        audio.addEventListener('ended', function() {
          loopPlayAudio(audios, playbtn.audioIndex, playbtn);
        });
      }
    }, 1000);
  }
  /**
  * 音频按钮 被点击时
  */
  function clickPlayAudio(audios, playbtn, cutOther) {
    cutOther = cutOther || false;
    if (!playbtn.firstElementChild.classList.contains('mbe-icon-pause')) {
      playbtn.firstElementChild.classList.add('mbe-icon-pause');
      playbtn.setAttribute('title', '暂停');
    }
    if (cutOther || !playbtn.ispause) {
      var allAudios = getAncestors(playbtn, function(el){ return el.localName === 'article'})[0].getElementsByTagName('audio');
      allAudios = Array.prototype.slice.call(allAudios, 0);
      pauseAndRemoveColor(allAudios);
    }
    playbtn.audioIndex = 0;
    for (var i = 0; i < audios.length; i++) { // 找回暂停时已经有描红的文本
      if (cutOther) { continue; }
      var audio = audios[i];
      var wordthis = audio.nextElementSibling.localName === 'button' ? audio.nextElementSibling.nextElementSibling : audio.nextElementSibling;
      if (wordthis.querySelector('span').style.color === 'red') playbtn.audioIndex = i;
    }
    setTimeout(function() { // 等待描红文字重置
      var audio = audios[playbtn.audioIndex];
      if(audio.error) {
        playbtn.audioIndex += 1;
        loopPlayAudio(audios, playbtn.audioIndex, playbtn);
      } else {
        var wordthis = audio.nextElementSibling.localName === 'button' ? audio.nextElementSibling.nextElementSibling : audio.nextElementSibling;
        audio.readword = getFilter(wordthis.children, function(child) { return child.style.color === 'red' }).length || 0;
        playbtn.isloop = true;
        audioPlay(audio);
        changeTextColor(audio, wordthis, audio.readword);
        audio.addEventListener('ended',function() {
          loopPlayAudio(audios, playbtn.audioIndex, playbtn);
        });
      }
    }, 1000);
  }

  /**
  * 循环播放录音
  */
  function loopPlayAudio(audios, index, playbtn) {
    if (!playbtn.isloop) return;
    index += 1;
    var audio = audios[index];
    if(audio && (audio.classList.contains('mainbo-load-failed') || audio.classList.contains('mainbo-loading'))) { // 音频加载失败时，则跳过
      index += 1;
      audio = audios[index];
    }
    if(!playbtn.classList.contains('mbe-icon-pause')) {
      playbtn.isloop = true;
      playbtn.setAttribute('title', '播放');
    }
    if (!audio || index > audios.length) {
      playbtn.isloop = false;
      if (playbtn.querySelector('.mbe-icon-pause')) {
        playbtn.querySelector('i').classList.remove('mbe-icon-pause');
      }
      return;
    }
    audio.readword = 0;
    audioPlay(audio);
    var this_el = getAncestors(audio, function(el) { return el.hasAttribute('data-control') }).pop();
    if(!isChinese(this_el)) {
      var wordthis = audio.nextElementSibling.localName === 'button' ? audio.nextElementSibling.nextElementSibling : audio.nextElementSibling;
      changeTextColor(audio, wordthis, audio.readword);
    }
    audio.addEventListener('ended',function() {
      loopPlayAudio(audios, index, playbtn)
    });
  }

  /**
  * 文本随音频匀速描红
  * 文本有.voice-splitword类时，按字母数确定文字描红时间
  */
  function changeTextColor(audio, wordthis, readword) {
    if (!audio.isplay)
      return;
    var spans = wordthis.querySelectorAll('span');
    var article = getAncestors(audio, function(el){ return el.localName == 'article'}).pop();
    if ((readword < wordthis.childElementCount) && spans[readword]) {
      spans[readword].style.color = 'red';
      readword += 1;
    }
    var timeout = parseFloat(getimeout(wordthis, audio, readword).toFixed(2));
    var timer = setInterval(function() {
      if (!audio.isplay || !article.querySelector('.mbe-icon-pause')) {
        clearInterval(timer);
        if(audio.isplay && !article.querySelector('.mbe-icon-pause')) {
          colorchange(wordthis);
          audio.readword = 0;
        }
      } else {
        if (readword >= spans.length) {
          clearInterval(timer);
          audio.readword = 0;
          setTimeout(function() { // 文本样式重置
            colorchange(wordthis);
          }, 400);
          return;
        }
        spans[readword].style.color = 'red';
        readword += 1;
        timeout = parseFloat(getimeout(wordthis, audio, readword).toFixed(2));
      }
    }, timeout * 1000);
  }

  /**
  * 获取单词变色时间
  */
  function getimeout(wordthis, audio, readword) {
    if (wordthis.classList.contains('voice-splitword')) {
      return wordTakeTime(wordthis, audio.duration, readword);
    }
    return audio.duration / wordthis.childElementCount;
  }

  /**
  * 对话中的人名，特殊处理
  */
  function appendNameToB(wordthis) {
    if (wordthis.querySelector('b')) return wordthis;
    if (wordthis.textContent.indexOf(':') < 0 || wordthis.textContent.indexOf(':') > 10 || !/(\w+:)/.test(wordthis.textContent)) return wordthis;
    var splitName = wordthis.textContent.split(':');
    splitName = Array.prototype.slice.call(splitName, 0);
    wordthis.innerHTML = '';
    forEach(splitName, function(word, i) {
      if (i < splitName.length - 1) word += ':';
      if (i < 1) {
        wordthis.innerHTML = '<b style="color: black;">' + word + '</b>';
      } else {
        wordthis.innerHTML += word;
      }
    });
    return wordthis;
  }

  /**
  * 将段落文本按单词改写成span节点
  */
  function appendTextSplit(wordthis, _doc, editing) {
    if (!editing) return;
    wordthis = appendNameToB(wordthis);
    var talkManName = _doc.createElement('div');
    if (wordthis.firstElementChild) {
      if (wordthis.querySelector('span')) return;
      if (wordthis.firstElementChild.localName === 'b') {
        talkManName.appendChild(wordthis.firstElementChild);
      }
    }
    var textSplit = wordthis.textContent.replace(/^\s+|\s+$/, '').split(/\s+/g);
    textSplit = Array.prototype.slice.call(textSplit, 0);
    wordthis.innerHTML = '';
    if (talkManName.firstElementChild)
      wordthis.appendChild(talkManName.firstElementChild);
    forEach(textSplit, function(word) {
      var wordspan = _doc.createElement('span');
      wordspan.textContent = word + ' ';
      wordthis.appendChild(wordspan);
    });
  }

  /**
  * 按字母数量，计算单词变色所用的时间
  */
  function wordTakeTime(wordthis, duration, index) {
    if (!(wordthis.firstElementChild && wordthis.firstElementChild.localName === 'span')) return;
    var wordthisLength = 0;
    for (var i = 0; i < wordthis.children.length; i++) {
      wordthisLength += wordthis.children[i].textContent.length;
    }
    return duration * wordthis.children[index].textContent.length / wordthisLength;
  }

  function colorchange(wordthis) {
    Array.prototype.slice.call(wordthis.children, 0).forEach(function(span) {
      if (span.localName !== 'span') return;
      span.style.color = '';
    });
  }
  /**
  * 音频播放或暂停
  */
  function audioPlay(audio) {
    if (audio.ended) audio.isplay = false;
    if (!audio.isplay || audio.currentTime < 0.1) {
      audio.play();
      audio.isplay = true;
    }
    else {
      audio.pause();
      audio.isplay = false;
    }
    return audio.isplay;
  }
  
  function pauseAndRemoveColor(audios) {
    forEach(audios, function(audio) {// 音频播放或暂停
      audio.isplay = false;
      audio.pause();
      audio.currentTime = 0;
      var wordthis = audio.nextElementSibling.localName === 'button' ? audio.nextElementSibling.nextElementSibling : audio.nextElementSibling;
      colorchange(wordthis);
    });
  }
  
  /**
  * 添加播放按钮
  */
  function appendPlayButton(el) {
    var button = el.ownerDocument.createElement('button');
    var i = el.ownerDocument.createElement('i');
    i.classList.add('mbe-icon-play');
    isChinese(el) && button.setAttribute('title', '播放');
    button.appendChild(i);
    return button;
  }
  
  /**
   * （尽可能）读取当前CSS计算值，并转为数值。参见 getCssValue()。
   */
  function getCSSNumber(el, propName) {
    return parseFloat(getCSSValue(el, propName));
  }
  /**
   * 读取当前CSS计算值。
   * *详见mbe_core.CSSUtils.getCSSValue
   */
  function getCSSValue(el, propName) {
    var cv = el.ownerDocument.defaultView &&
      el.ownerDocument.defaultView.getComputedStyle(el).getPropertyValue(propName);
    return cv || (el.style && el.style.getPropertyValue(propName)) || '';
  }

  function getAncestors(node, filter){
    var ret = [];
    var docType = Node.DOCUMENT_NODE;
    for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
      try {
        if (filter && filter(cur))
          ret.push(cur);
      } catch (e) {
        console.warn(e.stack || e);
      }
    }
    return ret;
  }
  
  function forEach(nodes, foreach) {
    Array.prototype.slice.call(nodes, 0).forEach(foreach);
  }

  function getMap(nodes, map){
    var ret = [];
    for (var i = 0; i < nodes.length; i++){
      try{
        if (map && map(nodes[i])) {
          ret.push(map(nodes[i]))
        }
      } catch (e) {
        console.warn(e.stack || e)
      }
    }
    return ret;
  }
  function getFilter(nodes, filter) {
    var ret = [];
    for (var i = 0; i < nodes.length; i++){
      try{
        if (filter && filter(nodes[i])) {
          ret.push(nodes[i])
        }
      } catch (e) {
        console.warn(e.stack || e)
      }
    }
    return ret;
  }

})(etb_controls.mainbo_voicescore || (etb_controls.mainbo_voicescore = {}));

(function(etb_controls){
  etb_controls.mainbo_voicescore = etb_controls.mainbo_voicescore;
  etb_controls.mainbo_guwen = etb_controls.mainbo_voicescore;
  etb_controls.mainbo_zuowen = etb_controls.mainbo_voicescore;
})(etb_controls || (etb_controls = {}));