(function(mainbo_virtualtool) {
  mainbo_virtualtool.init = init;

  function init(el) {
    setEditing(el);
  }

  function setEditing(el) {
    if (!el.mainbo_virtualtool) el.mainbo_virtualtool = {
      moveObj: null,
      pointerdownFlag: false,
      toDelete: null
    }
    el.addEventListener('click', stopPropagation);
    el.querySelector(".basket1").addEventListener("pointerdown", toggle)
    el.querySelector(".basket1").addEventListener("touchstart", dragstart)
    el.querySelector(".rallying").addEventListener("touchstart", dragstart)
    Array.prototype.forEach.call(el.querySelectorAll(".imggroup img"), function(item) {
      item.addEventListener("touchstart", dragstart);
    });
    el.addEventListener("pointerdown", pointerdown);
    el.addEventListener("pointermove", pointermove);
    el.addEventListener("pointerup", pointerup);
    Array.prototype.forEach.call(
      el.querySelectorAll(".imggroup img"),
      function(item) {
        item.addEventListener("dragstart", dragstart);
      }
    );
    // 为篮子中的图片注册事件
    Array.prototype.forEach.call(
      el.querySelectorAll(".item"),
      function(item) {
        item.addEventListener("dragstart", dragstart);
        item.addEventListener("click", insert)
      }
    );
    // 清除
    el.querySelector(".clear").addEventListener("click", clear);
  }

  function stopPropagation(ev) {
    ev.stopPropagation();
  }

  function pointerdown(ev) {
    var ctr = getAncestors(ev.target,
      function(el) {
        return el.classList.contains("virtualtool")
      })[0];
    var temp = ev.target;
    // 禁止整个控件的移动
    if (temp.classList.contains("virtualtool") || temp.classList.contains('virtualtool-sub')) return false;
    if (temp.classList.contains("basket1")) {
      temp = getAncestors(ev.target,
        function(el) {
          return el.classList.contains("basket")
        })[0];
    }
    ctr.mainbo_virtualtool.moveObj = temp;
    ctr.mainbo_virtualtool.pointerdownFlag = true
    var moveObjRect = ctr.mainbo_virtualtool.moveObj.getBoundingClientRect();
    var _x = ev.clientX - moveObjRect.left;
    var _y = ev.clientY - moveObjRect.top;
    ctr.mainbo_virtualtool.moveObj.dataset['x'] = _x;
    ctr.mainbo_virtualtool.moveObj.dataset['y'] = _y;
    if (temp.nodeName.toLocaleLowerCase() == "img" && temp.parentElement.classList.contains("imggroup")) {
      handlerDelIcon(ctr, 1);
    } else {
      handlerDelIcon(ctr, 0);
    }
    var delIcon = getAncestors(ev.target, function(el) {
      return el.classList.contains("delIconContainer")
    }).pop();
    if (delIcon) delItem(ctr);
  }

  function pointerup(ev) {
    var ctr = getAncestors(ev.target,
      function(el) {
        return el.classList.contains("virtualtool")
      })[0];
    ctr.mainbo_virtualtool.moveObj = null;
    ctr.mainbo_virtualtool.pointerdownFlag = false;
  }


  function toggle(ev) {
    var el = getAncestors(
      ev.target,
      function(el) {
        return el.hasAttribute("data-control") && el.getAttribute("data-control") == "mainbo_virtualtool"
      }
    ).pop();
    var basket = el.querySelector(".basket1");
    if (basket.dataset['rallying'] === "true") {
      basket.dataset['rallying'] = "false";
      basket.setAttribute("title", "点击显示工具");
      basket.classList.add("basket0");
      hide(el);
    } else {
      basket.dataset['rallying'] = "true";
      basket.setAttribute("title", "点击隐藏工具");
      basket.classList.remove("basket0");
      show(el);
    }
  }

  function hide(el) {
    var items = el.querySelector(".items");
    var rallying = el.querySelector(".rallying");
    if (items && rallying) {
      items.style.display = "none";
      rallying.style.display = "none";
    }
  }

  function show(el) {
    var items = el.querySelector(".items");
    var rallying = el.querySelector(".rallying");
    if (items && rallying) {
      items.style.display = "block";
      rallying.style.display = "block";
    }
  }

  function insert(ev) {
    var button = getAncestors(ev.target, function(el) {
      return el.classList.contains("item")
    }).pop();
    var ancestor = getAncestors(
      ev.target,
      function(el) {
        return el.hasAttribute("data-control") && el.getAttribute("data-control") == "mainbo_virtualtool"
      }
    ).pop();
    var index = button.dataset["category"];
    var img = ancestor.querySelector(".items").querySelectorAll("img")[index].cloneNode(true);
    var rallying = ancestor.querySelector(".rallying");
    if (img) {
      img.style.top = (parseFloat(rallying.style.top) || 0) + "px";
      img.style.left = (parseFloat(rallying.style.left) || 0) + "px";
      ancestor.querySelector(".imggroup").appendChild(img);
      next(ev, img.getBoundingClientRect().width, img.getBoundingClientRect().height);
      img.addEventListener("dragstart", dragstart);
      img.addEventListener("touchstart", dragstart);
    }
  }

  function next(ev, imgW, imgH, resetRallying) {
    var etbPage = getAncestors(ev.target,
      function(el) {
        return el.classList.contains("etb-page")
      })[0];
    var ancestor = getAncestors(
      ev.target,
      function(el) {
        return el.hasAttribute("data-control") && el.getAttribute("data-control") == "mainbo_virtualtool"
      }
    ).pop();
    var ancestorRect = ancestor.getBoundingClientRect();
    var rallying = ancestor.querySelector(".rallying");
    var rallyingRect = rallying.getBoundingClientRect();
    if (resetRallying === true) {
      rallying.style.top = "0";
      rallying.style.left = "0";
      return;
    }
    if (rallyingRect.right > (ancestorRect.right - rallyingRect.width)) {
      rallying.style.top = ((parseFloat(rallying.style.top) || 0) + (imgH + 4)) + "px";
      rallying.style.left = "0";
      if (imgH > (ancestorRect.bottom - rallyingRect.bottom)) {
        rallying.style.top = "0";
        rallying.style.left = "0";
      }
    } else {
      rallying.style.left = ((parseFloat(rallying.style.left) || 0) + (imgW + 4)) + "px";
    }
  }

  function clear(ev) {
    var ancestor = getAncestors(
      ev.target,
      function(el) {
        return el.hasAttribute("data-control") && el.getAttribute("data-control") == "mainbo_virtualtool"
      }
    ).pop();
    var imggroup = ancestor.querySelector(".imggroup");
    imggroup.innerHTML = '';
    next(ev, 0, 0, true);
  }

  function delItem(el) {
    if (el.mainbo_virtualtool.toDelete) {
      el.mainbo_virtualtool.toDelete.parentNode.removeChild(el.mainbo_virtualtool.toDelete);
    }
  }

  //el-virtualtool type 1-显示 0-隐藏
  function handlerDelIcon(el, type) {
    var virtualtool = el,
      delIconContainer = virtualtool.querySelector(".delIconContainer"),
      moveObj = virtualtool.mainbo_virtualtool.moveObj;
    if (!delIconContainer) return false;
    switch (type) {
      case 0:
        delIconContainer.style.display = "none";
        break;
      case 1:
        virtualtool.mainbo_virtualtool.toDelete = moveObj;
        delIconContainer.style.top = parseFloat(moveObj.style.top) - 16 + "px";
        delIconContainer.style.left = parseFloat(moveObj.style.left) + 70 + "px";
        delIconContainer.style.display = "block";
        break;
      default:
        break;
    }
  }

  function dragstart(ev) {
    ev.preventDefault();
  }

  var moveObj = null;

  function pointermove(event) {
    var virtualtool = getAncestors(event.target,
      function(el) {
        return el.classList.contains("virtualtool")
      })[0];
    if (!virtualtool.mainbo_virtualtool.moveObj && !virtualtool.mainbo_virtualtool.pointerdownFlag) return false;
    if (virtualtool.mainbo_virtualtool.moveObj.classList.contains("basket")) {
      basketmove(event);
      return;
    }

    var etbPage = getAncestors(event.target,
      function(el) {
        return el.classList.contains("etb-page")
      })[0];
    if (!etbPage) return;
    var etbPageRect = etbPage.getBoundingClientRect();
    if (!virtualtool) return;
    var virtualtoolRect = virtualtool.getBoundingClientRect();
    var moveObj = virtualtool.mainbo_virtualtool.moveObj,
      moveObjRect = virtualtool.mainbo_virtualtool.moveObj.getBoundingClientRect();
    if (moveObj.nodeName.toLocaleLowerCase() == "img" && moveObj.parentElement.classList.contains("imggroup")) {
      handlerDelIcon(virtualtool, 1);
    } else {
      handlerDelIcon(virtualtool, 0);
    }
    var _x = virtualtool.mainbo_virtualtool.moveObj.dataset['x'];
    var _y = virtualtool.mainbo_virtualtool.moveObj.dataset['y'];
    if ((event.clientX - virtualtoolRect.left - _x) <= (etbPageRect.left - virtualtoolRect.left)) {
      // 左边界
      virtualtool.mainbo_virtualtool.moveObj.style.left = (etbPageRect.left - virtualtoolRect.left) + "px";
    } else if ((event.clientX - virtualtoolRect.left - _x) >= (etbPageRect.right - virtualtoolRect.left - moveObjRect.width)) {
      // 右边界
      virtualtool.mainbo_virtualtool.moveObj.style.left = (etbPageRect.right - virtualtoolRect.left - moveObjRect.width) + "px";
    } else {
      virtualtool.mainbo_virtualtool.moveObj.style.left = ((event.clientX - virtualtoolRect.left - _x)) + "px";
    }
    if ((event.clientY - virtualtoolRect.top - _y) <= (etbPageRect.top - virtualtoolRect.top)) {
      // 上边界
      virtualtool.mainbo_virtualtool.moveObj.style.top = (etbPageRect.top - virtualtoolRect.top) + "px";
    } else if ((event.clientY - virtualtoolRect.top - _y) >= (etbPageRect.bottom - virtualtoolRect.top - moveObjRect.height)) {
      // 下边界
      virtualtool.mainbo_virtualtool.moveObj.style.top = (etbPageRect.bottom - virtualtoolRect.top - moveObjRect.height) + "px";
    } else {
      virtualtool.mainbo_virtualtool.moveObj.style.top = ((event.clientY - virtualtoolRect.top - _y)) + "px";
    }
  }

  function basketmove(event) {
    var virtualtool = getAncestors(event.target,
      function(el) {
        return el.classList.contains("virtualtool")
      })[0];
    if (!virtualtool.mainbo_virtualtool.moveObj) return;
    var etbPage = getAncestors(event.target,
      function(el) {
        return el.classList.contains("etb-page")
      })[0];
    if (!etbPage) return;
    var etbPageRect = etbPage.getBoundingClientRect();
    if (!virtualtool) return;
    var virtualtoolRect = virtualtool.getBoundingClientRect();
    var moveObjRect = virtualtool.mainbo_virtualtool.moveObj.getBoundingClientRect();
    var _x = virtualtool.mainbo_virtualtool.moveObj.dataset['x'];
    var _y = virtualtool.mainbo_virtualtool.moveObj.dataset['y'];
    if ((event.clientX - virtualtoolRect.left - +_x) <= (etbPageRect.left - virtualtoolRect.left)) {
      // 左边界
      virtualtool.mainbo_virtualtool.moveObj.style.right =
        (virtualtoolRect.width - moveObjRect.width - etbPageRect.left + virtualtoolRect.left) + "px";
    } else if ((event.clientX - virtualtoolRect.left - +_x) >= (etbPageRect.right - virtualtoolRect.left - moveObjRect.width)) {
      // 右边界
      virtualtool.mainbo_virtualtool.moveObj.style.right =
        (virtualtoolRect.width - moveObjRect.width - etbPageRect.right + virtualtoolRect.left + moveObjRect.width) + "px";
    } else {
      virtualtool.mainbo_virtualtool.moveObj.style.right =
        ((virtualtoolRect.width - moveObjRect.width - event.clientX + virtualtoolRect.left + +_x)) + "px";
    }
    if ((event.clientY - virtualtoolRect.top - +_y) <= (etbPageRect.top - virtualtoolRect.top)) {
      // 上边界
      virtualtool.mainbo_virtualtool.moveObj.style.bottom =
        (virtualtoolRect.height - moveObjRect.height - etbPageRect.top + virtualtoolRect.top) + "px";
    } else if ((event.clientY - virtualtoolRect.top - +_y) >= (etbPageRect.bottom - virtualtoolRect.top - moveObjRect.height)) {
      // 下边界
      virtualtool.mainbo_virtualtool.moveObj.style.bottom =
        (virtualtoolRect.height - moveObjRect.height - etbPageRect.bottom + virtualtoolRect.top + moveObjRect.height) + "px";
    } else {
      virtualtool.mainbo_virtualtool.moveObj.style.bottom =
        ((virtualtoolRect.height - moveObjRect.height - event.clientY + virtualtoolRect.top + +_y)) + "px";
    }
  }

  function getAncestors(node, filter) {
    var ret = [];
    var docType = Node.DOCUMENT_NODE;
    for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
      try {
        if (filter && filter(cur))
          ret.push(cur);
      } catch (e) {
        console.warn(e.stack || e);
      }
    }
    return ret;
  }

})(mainbo_virtualtool = etb_controls.mainbo_virtualtool || (etb_controls.mainbo_virtualtool = {}))