(function (mainbo_timecalendar) {
    function init(el) {
        setEditing(el, true);
    }
    mainbo_timecalendar.init = init;
    function setEditing(el, editing) {
        el.addEventListener('click', stopPropagation);
        el.addEventListener('pointerup', pointerUpEl);
        var yeaript = el.querySelector('.mbe-timecalendr-year-ipt');
        yeaript.value = el.getAttribute('data-fullyear');
        yeaript.addEventListener('change', canlendarYearChange);
        yeaript.addEventListener('click', showYearSelectTab);
        var preva = el.querySelector('.mbe-timecalendar-yearpreva');
        preva.addEventListener('click', clickPrevYear);
        var nexta = el.querySelector('.mbe-timecalendar-yearnexta');
        nexta.addEventListener('click', clickNextYear);
        var yearspreva = el.querySelectorAll('.mbe-timecalendar-yearselecttab a')[0];
        var yearsnexta = el.querySelectorAll('.mbe-timecalendar-yearselecttab a')[1];
        yearspreva.addEventListener('click', clickPrevYears);
        yearsnexta.addEventListener('click', clickNextYears);
        var lis = el.querySelectorAll('.mbe-timecalendar-yearselecttab ul li');
        [].forEach.call(lis, function (item, index) {
            item.addEventListener('click', clickSelectLi)
        });
        if (el.querySelector('.mbe-timecalendar-monthtab')) {
            el.querySelector('.mbe-timecalendar-monthtab .mbe-timecalendar-c2titback').addEventListener('click', createMonthTableHidden);
            el.querySelector('.mbe-timecalendar-monthtab .mbe-timecalendar-monthprev').addEventListener('click', clickMonthPrev);
            el.querySelector('.mbe-timecalendar-monthtab .mbe-timecalendar-monthnext').addEventListener('click', clickMonthNext);
            [].forEach.call(el.querySelectorAll('.mbe-timecalendar-c2body .mbe-timecalendar-days2 a'), function (item, index) {
                item.addEventListener('click', addClassSelectDay);
            });
        }
        [].forEach.call(el.querySelectorAll('.mbe-timecalendar-month'), function (item, index) {
            item.addEventListener('click', function (ev) {
                ev.stopPropagation();
                yeaript = el.querySelector('.mbe-timecalendr-year-ipt');
                clickMonth(ev, index, parseInt(yeaript.value));
            });
        });
    }
    function contructTimeCalendar(el) {
        // 创建基础的文档
        create1(el);
        // 创建当年的日历表
        if (!el.querySelector('.mbe-timecalendar-days a')) {
            create1Days(el);
        }
    }
    function pointerUpEl(ev) {
        ev.stopPropagation();
        var this_el = getAncestors((ev.target), function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var seltab1 = getAncestors((ev.target), function (el) { return el.classList.contains('mbe-timecalendar-yearselecttab'); }).pop();
        var seltab2 = this_el.querySelector('.mbe-timecalendar-yearselecttab');
        seltab1 != seltab2 && (this_el.querySelector('.mbe-timecalendar-yearselecttab').style.removeProperty('display'));
    }
    function stopPropagation(ev) {
        ev.stopPropagation();
    }
    /**
	* tab 1 start
	* @param el
	*/
    function create1Days(el, year) {
        var nowdate = new Date();
        //if (year + ''.length < 4) {
        //  var ysl = (4 - year + ''.length);
        //}
        [].forEach.call(el.querySelectorAll('.mbe-timecalendar-month .mbe-timecalendar-days'), function (item, index) {
            item.innerHTML = '';
            dayList(item, nowdate, index, year);
        });
    }
    function clickNextYear(ev) {
        ev.stopPropagation();
        var this_el = getAncestors((ev.target), function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var target = getAncestors((ev.target), function (el) { return el.classList.contains('mbe-timecalendar-yearpreva'); }).pop();
        var year = this_el.getAttribute('data-fullyear');
        if(parseFloat(year) >=9999) return false;
        this_el.setAttribute('data-fullyear', (parseFloat(year) + 1) + '');
        create1Days(this_el, parseFloat(year) + 1);
        this_el.querySelector('.mbe-timecalendr-year-ipt').value = (parseFloat(year) + 1) + '';
    }
    function clickPrevYear(ev) {
        ev.stopPropagation();
        var this_el = getAncestors((ev.target), function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var target = getAncestors((ev.target), function (el) { return el.classList.contains('mbe-timecalendar-yearpreva'); }).pop();
        var year = this_el.getAttribute('data-fullyear');
        if(parseFloat(year) <= 0) return false;
        this_el.setAttribute('data-fullyear', (parseFloat(year) - 1) + '');
        create1Days(this_el, parseFloat(year) - 1);
        this_el.querySelector('.mbe-timecalendr-year-ipt').value = (parseFloat(year) - 1) + '';
    }
    function clickNextYears(ev) {
        ev.stopPropagation();
        ev.preventDefault();
        var this_el = getAncestors((ev.target), function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var seltab = this_el.querySelector('.mbe-timecalendar-yearselecttab');
        var lis = seltab.querySelectorAll('li');
        var lastyear = parseFloat(lis[lis.length - 1].textContent);
        seltab.querySelector('.mbe-timecalendar-yearselectul').innerHTML = '';
        for (var i = lastyear + 1; i < lastyear + 11; i++) {
            var yli = this_el.ownerDocument.createElement('li');
            yli.textContent = i + '';
            seltab.querySelector('.mbe-timecalendar-yearselectul').appendChild(yli);
            yli.addEventListener('click', clickSelectLi);
        }
    }
    function clickPrevYears(ev) {
        ev.stopPropagation();
        ev.preventDefault();
        var this_el = getAncestors((ev.target), function (el) { return el.hasAttribute('data-control'); }).pop();
        var seltab = this_el.querySelector('.mbe-timecalendar-yearselecttab');
        var lastyear = parseFloat(seltab.querySelector('li').textContent);
        seltab.querySelector('.mbe-timecalendar-yearselectul').innerHTML = '';
        for (var i = lastyear - 10; i < lastyear; i++) {
            var yli = this_el.ownerDocument.createElement('li');
            yli.textContent = i + '';
            seltab.querySelector('.mbe-timecalendar-yearselectul').appendChild(yli);
            yli.addEventListener('click', clickSelectLi);
        }
    }
    function showYearSelectTab(ev) {
        ev.stopPropagation();
        var this_el = getAncestors((ev.target), function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var seltab = this_el.querySelector('.mbe-timecalendar-yearselecttab');
        seltab.style.display = 'flex';
    }
    function hiddenYearSelectTab(ev) {
        var this_el = getAncestors((ev.target), function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var seltab = this_el.querySelector('.mbe-timecalendar-yearselecttab');
        seltab.style.removeProperty('display');
    }
    /**
	 * 功能函数
	 */
    function canlendarYearChange(ev) {
        var this_el = getAncestors((ev.target), function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var yearv = this_el.querySelector('.mbe-timecalendr-year-ipt');
        var reg = /^\d{0,4}$/;
        if (!reg.test(yearv.value)) {
            yearv.value = this_el.getAttribute('data-fullyear');
            return false;
        }
        if (parseFloat(yearv.value) >= 0 && parseFloat(yearv.value) < 10000) {
            this_el.setAttribute('data-fullyear', yearv.value);
        }
        else {
            if (parseFloat(yearv.value) < 0) {
                yearv.value = '0';
                this_el.setAttribute('data-fullyear', parseFloat(yearv.value) + '');
            }
            else {
                yearv.value = 9999 + ''; //如果 number的值超过9999 则将值为最大值9999
                this_el.setAttribute('data-fullyear', parseFloat(yearv.value) + '');
            }
        }
        create1Days(this_el, parseInt(yearv.value));
    }
    function dayList(el, date, index, year) {
        // 补全空白日期 星期显示 i=0是为方案一 i=1为方案二
        for (var i = 0, j = daysIndex(date, index, year) ; i < j; i++) {
            var atag = el.ownerDocument.createElement('a');
            el.appendChild(atag);
        }
        // 循环天数
        for (var i = 1, j = daysCount(date, index, year), k = daysToday(date) ; i <= j; i++) {
            var curcalss = '';
            if (i == k) {
                curcalss += ' mbe-today';
            }
            var atag = el.ownerDocument.createElement('a');
            atag.className = "mbe-day" + curcalss;
            //atag.setAttribute('href', 'javascript:;');
            atag.textContent = i + ''; //< 10 ? '0' + i : i + '';
            el.appendChild(atag);
        }
    }
    /**
	 * @param date    默认为当前时间
	 * @param month   0-11
	 * @param year    4位年
	 */
    function daysIndex(date, month, year) {
        var newdate = new Date();
        if (year && year > 0) {
            newdate.setFullYear(year);
        }
        else {
            newdate.setFullYear(date.getFullYear());
        }
        newdate.setMonth(month);
        newdate.setDate(1);
        //星期显示方案一
        return newdate.getDay();
        //星期显示方案二
        //return newdate.getDay() + 1;
    }
    function daysCount(date, month, year) {
        var newmonth;
        if (year && year > 0) {
            newmonth = month + 1;
        }
        else {
            date.setMonth(month);
            newmonth = date.getMonth() + 1;
        }
        if (/^(1|3|5|7|8|10|12)$/.test(newmonth + '')) {
            return 31;
        }
        if (/^(4|6|9|11)$/.test(newmonth + '')) {
            return 30;
        }
        //二月
        if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0) {
            return 29;
        }
        else {
            return 28;
        }
    }
    ;
    function daysToday(date) {
        var newdate = new Date();
        if (newdate.getMonth() == date.getMonth() && newdate.getFullYear() == date.getFullYear()) {
            return newdate.getDate();
        }
        else {
            return 0;
        }
    }
    function clickSelectLi(ev) {
        ev.stopPropagation();
        var this_el = getAncestors((ev.target), function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var tab = getAncestors((ev.target), function (el) { return el.classList.contains('mbe-timecalendar-yearselecttab'); }).pop();
        this_el.querySelector('.mbe-timecalendr-year-ipt').value = ev.target.textContent;
        this_el.setAttribute('data-fullyear', ev.target.textContent);
        tab.style.removeProperty('display');
        var yearv = this_el.querySelector('.mbe-timecalendr-year-ipt');
        if (parseFloat(yearv.value) >= 0 && parseFloat(yearv.value) < 10000) {
            this_el.setAttribute('data-fullyear', yearv.value);
        }
        else {
            if (parseFloat(yearv.value) < 0) {
                yearv.value = '0';
                this_el.setAttribute('data-fullyear', parseFloat(yearv.value) + '');
            }
            else {
                yearv.value = 9999 + ''; //如果 number的值超过9999 则将值为最大值9999
                this_el.setAttribute('data-fullyear', parseFloat(yearv.value) + '');
            }
        }
        create1Days(this_el, parseInt(yearv.value));
    }
    /**
	 * tab 1 end
	 */
    /*
	 * tab 2 start
	 */
    function clickMonth(ev, index, year) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var mbetclist = this_el.querySelectorAll('.mbe-timecalendar-content');
        create2MonthTab(mbetclist[1], index);
        mbetclist[0].classList.add('mbe-timecalendar-hidden');
        mbetclist[1].classList.remove('mbe-timecalendar-hidden');
    }
    function create2MonthTab(el, month) {
        el.innerHTML = '';
        var monthcon = el.ownerDocument.createElement('div');
        monthcon.classList.add('mbe-timecalendar-monthtab');
        el.appendChild(monthcon);
        create2Monthtitle(monthcon, month);
        create2Monthbody(monthcon, month);
    }
    function create2Monthtitle(el, month) {
        var title = el.ownerDocument.createElement('div');
        title.classList.add('mbe-timecalendar-c2tit');
        el.appendChild(title);
        create2MonthtitleContent(title, month);
    }
    function create2MonthtitleContent(el, month) {
        var this_el = getAncestors(el, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var back = el.ownerDocument.createElement('div');
        back.classList.add('mbe-timecalendar-c2titback');
        back.addEventListener('click', createMonthTableHidden);
        el.appendChild(back);
        var bar = el.ownerDocument.createElement('div');
        bar.classList.add('mbe-timecalendar-c2titbar');
        el.appendChild(bar);

        var slidegroup = el.ownerDocument.createElement('div');
        slidegroup.classList.add('mbe-timecalendar-monthselectgroup');

        var prev = el.ownerDocument.createElement('div');
        prev.addEventListener('click', clickMonthPrev);
        prev.classList.add('mbe-timecalendar-monthprev')
        var prevatag = el.ownerDocument.createElement('city');
        prev.appendChild(prevatag);

        var next = el.ownerDocument.createElement('div');
        next.addEventListener('click', clickMonthNext);
        next.classList.add('mbe-timecalendar-monthnext');
        var nextatag = el.ownerDocument.createElement('city');
        next.appendChild(nextatag);

        slidegroup.appendChild(prev);
        slidegroup.appendChild(next);

        var year = el.ownerDocument.createElement('div');
        year.classList.add('mbe-timecalendar-monthyear')
        year.textContent = this_el.getAttribute('data-fullyear') + '年';

        var monthslide = el.ownerDocument.createElement('div');
        monthslide.classList.add('mbe-timecalendar-monthslide');
        monthslide.textContent = (month + 1) + '月';

        bar.appendChild(year);
        bar.appendChild(monthslide);
        bar.appendChild(slidegroup);

        var compareMonth = el.ownerDocument.createElement('div');
        compareMonth.addEventListener('click', clickCompareMonth);
        compareMonth.classList.add('mbe-timecalendar-compmonth');
        el.appendChild(compareMonth);
    }
    function clickMonthPrev(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var monthtab = getAncestors(ev.target, function (el) { return el.classList.contains('mbe-timecalendar-monthtab'); }).pop();
        var month = monthtab.querySelector('.mbe-timecalendar-back2').textContent;
        if (month == '1') {
            month = '12';
            monthtab.querySelector('.mbe-timecalendar-back2').textContent = month + '';
            this_el.querySelector('.mbe-timecalendar-c2titbar .mbe-timecalendar-monthslide').textContent = parseFloat(month) + '月';
            this_el.setAttribute('data-fullyear', parseFloat(this_el.getAttribute('data-fullyear')) - 1 + '');
        }
        else {
            this_el.querySelector('.mbe-timecalendar-c2titbar .mbe-timecalendar-monthslide').textContent = (parseFloat(month) - 1) + '月';
            monthtab.querySelector('.mbe-timecalendar-back2').textContent = (parseFloat(month) - 1) + '';
        }
        monthtab.querySelector('.mbe-timecalendar-days2').innerHTML = '';
        create2Days(monthtab.querySelector('.mbe-timecalendar-days2'), parseFloat(month) - 2);
        this_el.querySelector('.mbe-timecalendar-c2titbar .mbe-timecalendar-monthyear').textContent = this_el.getAttribute('data-fullyear') + '年';
    }
    function clickMonthNext(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var monthtab = getAncestors(ev.target, function (el) { return el.classList.contains('mbe-timecalendar-monthtab'); }).pop();
        var month = monthtab.querySelector('.mbe-timecalendar-back2').textContent;
        if (parseFloat(month) == 12) {
            month = 0 + '';
            this_el.setAttribute('data-fullyear', parseFloat(this_el.getAttribute('data-fullyear')) + 1 + '');
        }
        monthtab.querySelector('.mbe-timecalendar-back2').textContent = (parseFloat(month) + 1) + '';
        monthtab.querySelector('.mbe-timecalendar-days2').innerHTML = '';
        create2Days(monthtab.querySelector('.mbe-timecalendar-days2'), parseFloat(month));
        this_el.querySelector('.mbe-timecalendar-c2titbar .mbe-timecalendar-monthslide').textContent = (parseFloat(month) + 1) + '月';
        this_el.querySelector('.mbe-timecalendar-c2titbar .mbe-timecalendar-monthyear').textContent = this_el.getAttribute('data-fullyear') + '年';
    }
    function clickCompareMonth(ev) {
        console.log('compareMonth');
    }
    function createMonthTableHidden(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        var mbetclist = this_el.querySelectorAll('.mbe-timecalendar-content');
        mbetclist[1].classList.add('mbe-timecalendar-hidden');
        mbetclist[0].classList.remove('mbe-timecalendar-hidden');
        this_el.setAttribute('data-fullyear', mbetclist[0].querySelector('.mbe-timecalendr-year-ipt').value + '');
    }
    function create2Monthbody(el, month) {
        var body = el.ownerDocument.createElement('div');
        body.classList.add('mbe-timecalendar-c2body');
        el.appendChild(body);
        create2MonthBodyContent(body, month);
        create2Week(el.querySelector('.mbe-timecalendar-week2'));
        create2Days(el.querySelector('.mbe-timecalendar-days2'), month);
    }
    function create2MonthBodyContent(el, month) {
        var back = el.ownerDocument.createElement('div');
        back.classList.add('mbe-timecalendar-back2');
        back.textContent = month + 1 + '';
        var week = el.ownerDocument.createElement('div');
        week.classList.add('mbe-timecalendar-week2');
        var days = el.ownerDocument.createElement('div');
        days.classList.add('mbe-timecalendar-days2');
        el.appendChild(back);
        el.appendChild(week);
        el.appendChild(days);
    }
    function create2Week(el) {
        // 星期显示方案一
        ['日', '一', '二', '三', '四', '五', '六'].forEach(function (item) {
            var span = el.ownerDocument.createElement('span');
            span.textContent = item;
            el.appendChild(span);
        });
        // 星期显示方案二
        //['一', '二', '三', '四', '五', '六', '日'].forEach((item: any) => {
        //  var span = week.ownerDocument.createElement('span');
        //  span.textContent = item;
        //  week.appendChild(span);
        //});
    }
    function create2Days(el, month) {
        var control = getAncestors(el, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        day2List(el, month, parseFloat(control.getAttribute('data-fullyear')));
    }
    function day2List(el, index, year) {
        // 补全空白日期 星期显示 i=0是为方案一 i=1为方案二
        for (var i = 0, j = days2Index(index, year) ; i < j; i++) {
            var span = el.ownerDocument.createElement('span');
            var atag = el.ownerDocument.createElement('a');
            span.appendChild(atag);
            el.appendChild(span);
        }
        // 循环天数
        for (var i = 1, j = days2Count(index, year), k = days2Today(new Date()) ; i <= j; i++) {
            var curcalss = '';
            if (i == k) {
                curcalss += ' mbe-today';
            }
            var span = el.ownerDocument.createElement('span');
            var atag = el.ownerDocument.createElement('a');
            atag.addEventListener('click', addClassSelectDay);
            span.appendChild(atag);
            atag.className = "mbe-day" + curcalss;
            //atag.setAttribute('href', 'javascript:;');
            atag.textContent = i + ''; //< 10 ? '0' + i : i + '';
            el.appendChild(span);
        }
    }
    function addClassSelectDay(ev) {
        ev.stopPropagation();
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_timecalendar' })[0];
        //[].forEach.call(this_el.querySelectorAll('.mbe-timecalendar-days2 a'), function (item, index) {
        //	if (item.classList.contains('mbe-timecalendar-dayshadow')) {
        //		item.classList.remove('mbe-timecalendar-dayshadow');
        //	}
        //});
        var target = ev.target;
        if (target.classList.contains('mbe-timecalendar-dayshadow')) {
            target.classList.remove('mbe-timecalendar-dayshadow')
        } else {
            target.classList.add('mbe-timecalendar-dayshadow')
        }
        //ev.target.classList.add('mbe-timecalendar-dayshadow');
    }
    function days2Count(month, year) {
        var date = new Date();
        date.setFullYear(year);
        date.setMonth(month);
        var newmonth = date.getMonth() + 1;
        if (/^(1|3|5|7|8|10|12)$/.test(newmonth + '')) {
            return 31;
        }
        if (/^(4|6|9|11)$/.test(newmonth + '')) {
            return 30;
        }
        //二月
        if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0) {
            return 29;
        }
        else {
            return 28;
        }
    }
    function days2Index(month, year) {
        var newdate = new Date();
        newdate.setFullYear(year);
        newdate.setMonth(month);
        newdate.setDate(1);
        //星期显示方案一
        return newdate.getDay();
        //星期显示方案二
        //return newdate.getDay() + 1;
    }
    function days2Today(date) {
        var newdate = new Date();
        return newdate.getDate();
    }
    /*
	 * tab 2 end
	 */
    function getAncestors(node, filter) {
        var ret = [];
        var docType = Node.DOCUMENT_NODE;
        for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
            try {
                if (filter && filter(cur))
                    ret.push(cur);
            }
            catch (e) {
                console.warn(e.stack || e);
            }
        }
        return ret;
    }
})(mainbo_timecalendar = etb_controls.mainbo_timecalendar || (etb_controls.mainbo_timecalendar = {}));
