﻿(function (mainbo_slide) {
  function init(el) {
    // el.addEventListener("click", onClick); // 幻灯片内加入视频后，视频的全屏功能与幻灯片翻页功能冲突
    onClickThumb(el, 0);
    gotoPage(el, 0);
  }
  mainbo_slide.init = init;
  
  function getFullscreenElement(doc) {
    return doc.fullscreenElement || doc.mozFullScreenElement || doc.webkitFullscreenElement;
  }
  
  function isChildFullscreened(el) {
    var fe = getFullscreenElement(el.ownerDocument);
    return (!!fe) && el.contains(fe);
  }

  function onClick(ev) {
    ev.stopPropagation();
    var el = ev.currentTarget;
    var x = ev.clientX;
    var y = ev.clientY;
    var box = el.getBoundingClientRect();
    var sensibleLength = Math.min(80, 0.3 * box.width);
    var toLeft = el.classList.contains('slideThumbnail') ? box.width * 0.26 : 0;
    if(y > box.bottom - 50) return;
    if ((x - box.left - toLeft) < sensibleLength && (x - box.left - toLeft) > 0)
      backward(el);
    else if ((box.right - x) < sensibleLength)
      forward(el);
  }

  function onClickThumb(el, n) {
    var li = el.querySelector('.slide-thumbnail > ol').children;
    for (var i = 0; i < li.length; i++) {
      li[i].removeAttribute('class');
      li[i].index = i;
      li[i].addEventListener('click', function () {
        for(var j = 0; j < li.length; j++){
          li[j].removeAttribute('class');
        };
        this.setAttribute('class', 'thumbnailCurrent');
        gotoPage(el, this.index);
      });
    }
    li[n].setAttribute('class', 'thumbnailCurrent');
  }

  function gotoPage(el, n) {
    var page = el.querySelector('.slide-pages').children[n];
    if (!page)
      return false;
    var prev = page.previousElementSibling,
      next = page.nextElementSibling;
    if (!page)
      return false;
    for (var prev = page.previousElementSibling; prev; prev = prev.previousElementSibling) {
      setPosition(prev, 'previous');
    }
    for (var next = page.nextElementSibling; next; next = next.nextElementSibling) {
      setPosition(next, 'next');
    }
    setPosition(page, 'current');
    return true;
  }

  function forward(el) {
    if (isChildFullscreened(el))
      return false;
    var curr = getCurrentPage(el);
    if (!curr)
      return false;
    var next = curr.nextElementSibling;
    if (!next)
      return false;
    setPosition(curr, 'previous');
    setPosition(next, 'current');
    var currPage = el.querySelector('.slide-pages').children;
    for (var i = 0; i < currPage.length; i++) {
      if (currPage[i].className == 'slide-page current') onClickThumb(el, i);
    }
    return true;
  }
  mainbo_slide.forward = forward;

  function backward(el) {
    if (isChildFullscreened(el))
      return false;
    var curr = getCurrentPage(el);
    if (!curr)
      return false;
    var prev = curr.previousElementSibling;
    if (!prev)
      return false;
    setPosition(curr, 'next');
    setPosition(prev, 'current');
    var currPage = el.querySelector('.slide-pages').children;
    for (var i = 0; i < currPage.length; i++) {
      if (currPage[i].className == 'slide-page current') onClickThumb(el, i);
    }
    return true;
  }
  mainbo_slide.backward = backward;

  function getCurrentPage(el) {
    return Array.prototype.filter.call(
      el.querySelector('.slide-pages').children,
      function (page) {
        return page.classList.contains('current');
      }).pop();
  }

  function setPosition(page, posClass) {
    page.setAttribute('class', 'slide-page ' + posClass);
  }
})(etb_controls.mainbo_slide || (etb_controls.mainbo_slide = {}));
