(function (mainbo_wordteaching) {
  function init(el) {
    setEditing(el);
  }
  mainbo_wordteaching.init = init;
  var last_audio = '';
  var time_audio = '';
  function setEditing(el) {
    el.addEventListener('click', stopPropagation);
    if (!el._wordteachingproperty) {
      el._wordteachingproperty = {};
    }
    if (el._wordteachingproperty.setintervaldrawlinecontinue) {
      clearInterval(el._wordteachingproperty.setintervaldrawlinecontinue);
      el._wordteachingproperty.setintervaldrawlinecontinue = 0;
      el.querySelectorAll('.countfloat div')[0].removeAttribute('style');
      el.querySelectorAll('.countfloat div')[1].removeAttribute('style');
    }
    if (el.querySelectorAll('.countfloat')) {
      Array.prototype.slice.call(el.querySelectorAll('.countfloat div'), 0).forEach(function (item, index) {
        if (index == 0) {
          item.addEventListener('click', clickStrokeContinue);
        }
        if (index == 1) {
            item.addEventListener('click', clickStrokeStep);
        }
      });
    }
    if (el.querySelector('.audiopro')) {
      el.querySelector('.audiopro').style.display = 'none';
      Array.prototype.slice.call(el.querySelectorAll('.audiopro div'), 0).forEach(function (item, index) {
        if (item.querySelector('audio')) {
          item.addEventListener('click', audioPlay);
        }
      });
    }
    el.querySelector('.content-example .hanzi-font').value = el.querySelector('.pword').innerHTML;

    el.addEventListener('dragstart', preventDefault);
    el.querySelector('.operate-pronunciation').addEventListener('click', clickPronuciation);
    el.querySelector('.operate-radicals') && el.querySelector('.operate-radicals').addEventListener('click', clickRadicals);
    el.querySelector('.operate-linecount').addEventListener('click', clickStrokeCount);
    el.querySelector('.operate-struct').addEventListener('click', clickStruct);
    el.querySelector('.operate-literalmeaning').addEventListener('click', clickLiteralmeaning);
    el.querySelector('.operate-draw').addEventListener('click', clickDraw);
    el.querySelector('.operate-example').addEventListener('click', clickExample);
    el.querySelector('.word-svg-eraser').addEventListener('click', clearWordDraw);
    Array.prototype.slice.call(el.querySelectorAll('.content-example .hanzi-edit p'), 0).forEach(function (item, index) {
      item.removeAttribute('contenteditable');
    });
  }
  function preventDefault(ev) {
    ev.preventDefault();
  }
  function clickPronuciation(ev) {
    //获取控件元素
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
    var etbpage_scale = !etbpage.etbScale ? 1 : etbpage.etbScale;
    //删除笔画
    if (this_el.querySelector('.countfloat')) {
      this_el.querySelector('.countfloat').style.display = 'none';
    }
    Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
      if (item.style.display == 'block' || item.style.display == 'flex') {
        item.removeAttribute('style');
      }
    });
    Array.prototype.slice.call(this_el.querySelectorAll('.operate-item'), 0).forEach(function (item, index) {
      if (item.classList.contains('item-current')) {
        item.classList.remove('item-current');
      }
    });
    this_el.querySelector('.operate-pronunciation').classList.add('item-current');
    this_el.querySelector('.content-pronunciation').style.display = 'block';
    if (this_el.querySelector('.audiopro')) {
      this_el.querySelector('.audiopro').style.display = 'flex';
      var div = this_el.querySelector('.audiopro');
      var show_area_op = this_el.querySelector('.show-area-operate');
      var linecouana = this_el.querySelector('.operate-pronunciation');
      var clientR = this_el.querySelector('.operate-pronunciation a').getBoundingClientRect();
      var show_rect = show_area_op.getBoundingClientRect();
      div.style.left = (clientR.left - show_rect.left) / etbpage_scale - 10 + 'px';
      div.style.bottom = (show_rect.bottom - clientR.top) / etbpage_scale + 'px';
    }
  }
  function clickRadicals(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    if (this_el.querySelector('.countfloat')) {
      this_el.querySelector('.countfloat').style.display = 'none';
    }
    if (this_el.querySelector('.audiopro')) {
      this_el.querySelector('.audiopro').style.display = 'none';
    }
    Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
      if (item.style.display == 'block') {
        item.removeAttribute('style');
      }
    });
    Array.prototype.slice.call(this_el.querySelectorAll('.operate-item'), 0).forEach(function (item, index) {
      if (item.classList.contains('item-current')) {
        item.classList.remove('item-current');
      }
    });
    this_el.querySelector('.operate-radicals').classList.add('item-current');
    this_el.querySelector('.content-radicals').style.display = 'block';
    pauseLastAudio();
    last_audio = this_el.querySelector('.audioRadicals audio');
    this_el.querySelector('.audioRadicals audio') && this_el.querySelector('.audioRadicals audio').play();
  }
  
  //点击当前播放 停止之前的播放
  function  pauseLastAudio() {
    if(last_audio != ''){
      last_audio.pause();
    }
    clearInterval(time_audio);
    time_audio.setintervaldrawlinecontinue = 0;
  }
  
  
  function clickStrokeCount(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
    var etbpage_scale = !etbpage.etbScale ? 1 : etbpage.etbScale;
    //初始分布
    this_el._wordteachingproperty.countstep = 0;
    //初始连续
    if (this_el._wordteachingproperty.setintervaldrawlinecontinue) {
      clearInterval(this_el._wordteachingproperty.setintervaldrawlinecontinue);
      this_el._wordteachingproperty.setintervaldrawlinecontinue = 0;
      this_el.querySelectorAll('.countfloat div')[0].removeAttribute('style');
      this_el.querySelectorAll('.countfloat div')[1].removeAttribute('style');
    }
    var el_linecount = this_el.querySelector('.content-linecount');
    Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
      if (item.style.display == 'block' && item != el_linecount) {
        item.removeAttribute('style');
      }
    });
    el_linecount.style.display = 'block';
    if (this_el.querySelector('.countfloat')) {
      this_el.querySelector('.countfloat').style.display = 'flex';
      var div = this_el.querySelector('.countfloat');
      var show_area_op = this_el.querySelector('.show-area-operate');
      var linecouana = this_el.querySelector('.operate-linecount');
      var clientR = this_el.querySelector('.operate-linecount a').getBoundingClientRect();
      var show_rect = show_area_op.getBoundingClientRect();
      div.style.left = (clientR.left - show_rect.left) / etbpage_scale - 10 + 'px';
      div.style.bottom = (show_rect.bottom - clientR.top) / etbpage_scale + 'px';
    }
    if (this_el.querySelector('.audiopro')) {
      this_el.querySelector('.audiopro').style.display = 'none';
    }
    Array.prototype.slice.call(this_el.querySelectorAll('.operate-item'), 0).forEach(function (item, index) {
      if (item.classList.contains('item-current')) {
        item.classList.remove('item-current');
      }
    });
    this_el.querySelector('.operate-linecount').classList.add('item-current');
    var svg = this_el.querySelector('.content-linecount .hanzi-font-single-content .hanzi-font-single svg');
    if (svg.children.length > 1) {
      svg.children[1].setAttribute('d', '');
      this_el.querySelectorAll('.countfloat div')[0].innerHTML = '连续';
      this_el.querySelectorAll('.countfloat div')[1].innerHTML = '分步';
      this_el.querySelectorAll('.countfloat div')[0].removeAttribute('style');
      this_el.querySelectorAll('.countfloat div')[1].removeAttribute('style');
    }
    clearInterval(this_el['setintervaldrawlinecontinue']);
  }
  function clickStruct(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    if (this_el.querySelector('.countfloat')) {
      this_el.querySelector('.countfloat').style.display = 'none';
    }
    if (this_el.querySelector('.audiopro')) {
      this_el.querySelector('.audiopro').style.display = 'none';
    }
    Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
      if (item.style.display == 'block') {
        item.removeAttribute('style');
      }
    });
    Array.prototype.slice.call(this_el.querySelectorAll('.operate-item'), 0).forEach(function (item, index) {
      if (item.classList.contains('item-current')) {
        item.classList.remove('item-current');
      }
    });
    this_el.querySelector('.operate-struct').classList.add('item-current');
    this_el.querySelector('.content-struct').style.display = 'block';
    pauseLastAudio();
    last_audio = this_el.querySelector('.audioStrutre audio');
    this_el.querySelector('.audioStrutre audio').play();
  }
  function clickDraw(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
    var etbpage_scale = !etbpage.etbScale ? 1 : etbpage.etbScale;
    var el_draw = this_el.querySelector('.content-draw');
    Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
      if (item.style.display == 'block' && item != el_draw) {
        item.removeAttribute('style');
      }
    });
    el_draw.style.display = 'block';
    if (this_el.querySelector('.countfloat')) {
      this_el.querySelector('.countfloat').style.display = 'none';
    }
    if (this_el.querySelector('.audiopro')) {
      this_el.querySelector('.audiopro').style.display = 'none';
    }
    Array.prototype.slice.call(this_el.querySelectorAll('.operate-item'), 0).forEach(function (item, index) {
      if (item.classList.contains('item-current')) {
        item.classList.remove('item-current');
      }
    });
    this_el.querySelector('.operate-draw').classList.add('item-current');

    if (!this_el._wordteachingproperty.isDrawing) {
      //this_el.querySelector('.word-svg-pen').classList.add('word-pen-down');
      var hfsc = this_el.ownerDocument.querySelector('.content-draw .hanzi-font-single-content');
      var hfschfs = this_el.ownerDocument.querySelector('.content-draw .hanzi-font-single-content .hanzi-font-single');
      var hfscrect = hfsc.getBoundingClientRect();
      var hfschfsrect = hfschfs.getBoundingClientRect();
      if (!this_el._wordteachingproperty.overlay) {
        var ol;
        ol = this_el._wordteachingproperty.overlay = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
        ol.setAttribute('class', 'wordoverlay');
        //ol.setAttribute('style', 'position:absolute; width:272px;height:279px;left:' + (hfschfsrect.left - hfscrect.left) / etbpage_scale + 'px;top:' + (hfschfsrect.top - hfscrect.top) / etbpage_scale + 'px;overflow:hidden;');
        ol.setAttribute('style', 'position:absolute; width:272px;height:279px;left:0px;top:0px;overflow:hidden;');
        this_el.querySelector('.content-draw .hanzi-font-single').appendChild(ol);
        ol.addEventListener('pointerdown', wordSvgStart);
        ol.addEventListener('pointermove', wordSvgMove);
        ol.addEventListener('pointerup', wordSvgUp);
        ol.addEventListener('touchstart', function (ev) { ev.preventDefault(); });
      }
      else {
        if (this_el.querySelector('.content-draw .wordoverlay')) {
          var wordsvgoverlay = this_el.querySelector('.content-draw .wordoverlay');
          wordsvgoverlay.addEventListener('pointerdown', wordSvgStart);
          wordsvgoverlay.addEventListener('pointermove', wordSvgMove);
          wordsvgoverlay.addEventListener('pointerup', wordSvgUp);
          wordsvgoverlay.addEventListener('touchstart', function (ev) { ev.preventDefault(); });
        }
      }
      this_el._wordteachingproperty.isDrawing = true;
    }
    else {
      this_el._wordteachingproperty.isDrawing = false;
    }


  }
  function clickLiteralmeaning(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    if (this_el.querySelector('.countfloat')) {
      this_el.querySelector('.countfloat').style.display = 'none';
    }
    if (this_el.querySelector('.audiopro')) {
      this_el.querySelector('.audiopro').style.display = 'none';
    }
    Array.prototype.slice.call(this_el.querySelectorAll('.content-item')).forEach(function (item, index) {
      if (item.style.display == 'block' || item.style.display == 'flex') {
        item.removeAttribute('style');
      }
    });
    Array.prototype.slice.call(this_el.querySelectorAll('.operate-item')).forEach(function (item, index) {
      if (item.classList.contains('item-current')) {
        item.classList.remove('item-current');
      }
    });
    this_el.querySelector('.operate-literalmeaning').classList.add('item-current');
    this_el.querySelector('.content-literalmeaning').style.display = 'block';
  }
  function clickExample(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    if (this_el.querySelector('.countfloat')) {
      this_el.querySelector('.countfloat').style.display = 'none';
    }
    if (this_el.querySelector('.audiopro')) {
      this_el.querySelector('.audiopro').style.display = 'none';
    }
    Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
      if (item.style.display == 'block' || item.style.display == 'flex') {
        item.removeAttribute('style');
      }
    });
    Array.prototype.slice.call(this_el.querySelectorAll('.operate-item'), 0).forEach(function (item, index) {
      if (item.classList.contains('item-current')) {
        item.classList.remove('item-current');
      }
    });
    this_el.querySelector('.operate-example').classList.add('item-current');
    this_el.querySelector('.content-example').style.display = 'block';
  }
  function clickStrokeContinue(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    this_el._wordteachingproperty.countstep = 0;
    var audioStrokeOrderText = this_el.querySelectorAll('.audioStrokeOrderText audio');
    this_el.querySelectorAll('.countfloat div')[0].style.pointerEvents = 'none';
    this_el.querySelectorAll('.countfloat div')[1].style.pointerEvents = 'none';
    var svg = this_el.querySelector('.content-linecount .hanzi-font-single-content .hanzi-font-single svg');
    if (svg && svg.children.length > 1 && svg.children[0].localName == 'path') {
      svg.removeChild(svg.firstChild.nextSibling);
    }
    var secondpath = this_el.ownerDocument.createElementNS('http://www.w3.org/2000/svg', 'path');
    secondpath.setAttribute('d', '');
    secondpath.setAttribute('fill', 'red');
    svg.appendChild(secondpath);
    var orpath = svg.firstChild;
    var orpathd = orpath.getAttribute('d');
    var pathlines = orpathd.split('Z');
    var count = 0;
    pauseLastAudio();
    function drawlinecontinue() {
      if (count > pathlines.length - 2) {
        clearInterval(this_el._wordteachingproperty.setintervaldrawlinecontinue);
        this_el._wordteachingproperty.setintervaldrawlinecontinue = 0;
        this_el.querySelectorAll('.countfloat div')[0].removeAttribute('style');
        this_el.querySelectorAll('.countfloat div')[1].removeAttribute('style');
        secondpath.setAttribute('d', '');
        count = 0;
        return;
      }
      var secondpathd = secondpath.getAttribute('d');
      secondpath.setAttribute('d', secondpathd + pathlines[count] + 'Z');
      secondpath.style.cssText = '-moz-transform:rotateX(180deg) translate(0px,-221px);-webkit-transform:rotateX(180deg) translate(0px,-221px);transform:rotateX(180deg) translate(0px,-221px);';
      //var orctm = orpath.getCTM();
      //var sectm = secondpath.getCTM();
      //var movex = (orctm.e - sectm.e);
      //var movey = (orctm.f - sectm.f);
      //secondpath.style.cssText = '-moz-transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);-webkit-transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);';
      audioStrokeOrderText[count].play();
      count++;
    }
    this_el._wordteachingproperty.setintervaldrawlinecontinue = setInterval(drawlinecontinue, 1000);
    time_audio = this_el._wordteachingproperty.setintervaldrawlinecontinue;
  }
  function clickStrokeStep(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    this_el.querySelectorAll('.countfloat div')[0].style.pointerEvents = 'none';
    var audioStrokeOrderText = this_el.querySelectorAll('.audioStrokeOrderText audio');
    var svg = this_el.querySelector('.content-linecount .hanzi-font-single-content .hanzi-font-single svg');
    var orpath = svg.firstChild;
    var orpathd = orpath.getAttribute('d');
    var pathlines = orpathd.split('Z');
    if (svg.children.length < 2) {
      //第一次分步 创建第二条路径
      var secondpath = this_el.ownerDocument.createElementNS('http://www.w3.org/2000/svg', 'path');
      secondpath.setAttribute('fill', 'red');
      var secondpathd = secondpath.getAttribute('d');
      secondpath.setAttribute('d', pathlines[this_el._wordteachingproperty.countstep] + 'Z');
      secondpath.style.cssText = '-moz-transform:rotateX(180deg) translate(0px,-221px);-webkit-transform:rotateX(180deg) translate(0px,-221px);transform:rotateX(180deg) translate(0px,-221px);';
      svg.appendChild(secondpath);
      //var orctm = orpath.getCTM();
      //var sectm = secondpath.getCTM();
      //var movex = (orctm.e - sectm.e);
      //var movey = (orctm.f - sectm.f);
      ev.target.innerHTML = '下一步';
      audioStrokeOrderText[this_el._wordteachingproperty.countstep].play();
      this_el._wordteachingproperty.countstep++;
    }
    else {
      if (!svg.children[1].getAttribute('d')) {
        svg.children[1].setAttribute('d', pathlines[this_el._wordteachingproperty.countstep] + 'Z');
        ev.target.innerHTML = '下一步';
        audioStrokeOrderText[this_el._wordteachingproperty.countstep].play();
        this_el._wordteachingproperty.countstep++;
      }
      else {
        if (!svg.children[1].getAttribute('d')) {
          svg.children[1].setAttribute('d', pathlines[this_el._wordteachingproperty.countstep] + 'Z');
          svg.children[1].style.cssText = '-moz-transform:rotateX(180deg) translate(0px,-221px);-webkit-transform:rotateX(180deg) translate(0px,-221px);transform:rotateX(180deg) translate(0px,-221px);';
          ev.target.innerHTML = '下一步';
          audioStrokeOrderText[this_el._wordteachingproperty.countstep].play();
          this_el._wordteachingproperty.countstep++;
        } else {
          if (this_el._wordteachingproperty.countstep > pathlines.length - 2) {
            this_el._wordteachingproperty.countstep = 0;
            svg.children[1].setAttribute('d', '');
            ev.target.innerHTML = '分步';
            this_el.querySelectorAll('.countfloat div')[0].removeAttribute('style');
          }
          else {
            var secondpathd = svg.children[1].getAttribute('d');
            svg.children[1].setAttribute('d', secondpathd + pathlines[this_el._wordteachingproperty.countstep] + 'Z');
            svg.children[1].style.cssText = '-moz-transform:rotateX(180deg) translate(0px,-221px);-webkit-transform:rotateX(180deg) translate(0px,-221px);transform:rotateX(180deg) translate(0px,-221px);';
            //var orctm = orpath.getCTM();
            //var sectm = svg.children[1].getCTM();
            //var movex = (orctm.e - sectm.e);
            //var movey = (orctm.f - sectm.f);
            //secondpath.style.cssText = '-moz-transform-origin:50% 50%;-webkit-transform-origin:50% 50%;transform-origin:50% 50%;-moz-transform:translate(' + movex + 'px,' + movey + 'px) rotateX(180deg);-webkit-transform:translate(' + movex + 'px,' + movey + 'px) rotateX(180deg);transform:translate(' + movex + 'px,' + movey + 'px) rotateX(180deg)';
            //secondpath.style.transform = '-moz-transform:rotateX(180deg) translateY(' + movey + 'px);-webkit-transform:rotateX(180deg) translateY(' + movey + 'px);transform:rotateX(180deg) translateY(' + movey + 'px)';
            //svg.children[1].style.cssText = '-moz-transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);-webkit-transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);';
            if (this_el._wordteachingproperty.countstep < pathlines.length - 1) {
              audioStrokeOrderText[this_el._wordteachingproperty.countstep].play();
            }
            ev.target.innerHTML = this_el._wordteachingproperty.countstep === pathlines.length - 2 ? '清除' : '下一步';
            this_el._wordteachingproperty.countstep++;
          }
        }
      }
    }
  }
  function audioPlay(ev) {
    if (ev.target.querySelector('audio')) {
      var audiop = ev.target.querySelector('audio');
      if (audiop.src) {
        audiop.play();
      }
    }
  }
  function clearWordDraw(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    var wordclear = this_el.querySelector('.wordoverlay');
    if (wordclear) {
      for (var i = wordclear.children.length - 1; i >= 0; i--) {
        wordclear.removeChild(wordclear.children[i]);
      }
    }
  }
  function wordSvgStart(ev) {
    var x = ev.clientX, y = ev.clientY;
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
    if (!this_el._wordteachingproperty.pointerId || this_el._wordteachingproperty.pointerId < 0) {
      this_el._wordteachingproperty.pointerId = 1;
      this_el._wordteachingproperty.path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
      this_el._wordteachingproperty.path.style.stroke = 'red';
      this_el._wordteachingproperty.path.style.strokeWidth = '5';
      this_el._wordteachingproperty.path.style.fill = 'none';
      //if (this._itm) {
      //  // svg 元素的css transform 和 transform 属性在 getBoundingClientRect 时的结果不同,
      //  // 前者得到变换前的结果，后者得到变换后的结果；html 元素是变换后的结果。TODO 这是 bug 还是规范？
      //  p.setAttribute('transform', SVGUtils.matToCSS(this._tm));
      //  var v = SVGUtils.newPoint(x, y).matrixTransform(this._itm);
      //  x = v.x;
      //  y = v.y;
      //}      
      var wordsvgoverlay = this_el.querySelector('.wordoverlay')
      var svgbox = etb_book.offSetRect(wordsvgoverlay);
      var dx, dy;
      if (etbpage.etbScale && etbpage.etbScale != 1) {
        //解决方案 通过当前坐标获取对应原始页面坐标，处理margin 比列  svg层原始高/整个原始页面高 * scale -> 得到缩放后的高度 / 整个页面高 * 页面偏移量
        var w = parseInt(getComputedStyle(etbpage, null).width), h = parseInt(getComputedStyle(etbpage, null).height);
        var w1 = parseInt(getComputedStyle(this_el, null).width), h1 = parseInt(getComputedStyle(this_el, null).height);
        dx = (x - wordsvgoverlay.getBoundingClientRect().left) / etbpage.etbScale - (w1 / w) * etbpage.etbScale / innerWidth * (w / 2);
        dy = (y - wordsvgoverlay.getBoundingClientRect().top) / etbpage.etbScale - (h1 / h) * etbpage.etbScale / innerHeight * (h / 2);
      } else {
        dx = x - svgbox.left;
        dy = y - svgbox.top;
      }
      this_el._wordteachingproperty.path.pathSegList.appendItem(this_el._wordteachingproperty.path.createSVGPathSegMovetoAbs(dx, dy));
      if (this_el._wordteachingproperty.overlay) {
        this_el._wordteachingproperty.overlay.appendChild(this_el._wordteachingproperty.path);
      }
    }
    this_el._wordteachingproperty.lastx = x;
    this_el._wordteachingproperty.lasty = y;

  }
  function wordSvgMove(ev) {
    var x = ev.clientX, y = ev.clientY;
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
    if (this_el._wordteachingproperty.path) {
      var p = this_el._wordteachingproperty.path;
      if (this_el._wordteachingproperty.pointerId === 1) {
        if (etbpage.etbScale) {
          var dx = (x - this_el._wordteachingproperty.lastx) / etbpage.etbScale,
          dy = (y - this_el._wordteachingproperty.lasty) / etbpage.etbScale;
        } else {
          var dx = x - this_el._wordteachingproperty.lastx,
            dy = y - this_el._wordteachingproperty.lasty;
        }
        p.pathSegList.appendItem(p.createSVGPathSegLinetoRel(dx, dy));
      }
    }
    this_el._wordteachingproperty.lastx = x;
    this_el._wordteachingproperty.lasty = y;
  }
  function wordSvgUp(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_wordteaching' }).pop();
    if (this_el._wordteachingproperty.path) {
      this_el.querySelector('.wordoverlay').appendChild(this_el._wordteachingproperty.path);
    }
    this_el._wordteachingproperty.pointerId = -1;
    this_el._wordteachingproperty.path = null;
    this_el._wordteachingproperty.lastx = 0;
    this_el._wordteachingproperty.lasty = 0;
  }
  function stopPropagation(ev) {
    ev.stopPropagation()
  }
  function getAncestors(node, filter) {
    var ret = [];
    var docType = Node.DOCUMENT_NODE;
    for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
      try {
        if (filter && filter(cur))
          ret.push(cur);
      }
      catch (e) {
        console.warn(e.stack || e);
      }
    }
    return ret;
  }
})(mainbo_wordteaching = etb_controls.mainbo_wordteaching || (etb_controls.mainbo_wordteaching = {}));
