(function (mainbo_imatch) {
    function init(el) {
        setEditing(el);
    }
    mainbo_imatch.init = init;
    function setEditing(el) {
        el.addEventListener('touchstart', preventDefault);
        el.addEventListener('click', stopPropagation);
        if (!el._imatch) {
            el._imatch = {};
        }
        //bool arr
        if (el._imatch.check_bool_arr && el._imatch.check_bool_arr.length > 0) {
            el._imatch.check_bool_arr.length = 0;
        } else {
            el._imatch.check_bool_arr = [];
        }
        Array.prototype
       .slice
       .call(el.querySelectorAll('.answer'), 0)
       .forEach(function (item) {
           item.addEventListener('dragstart', ondragstart)
           item.addEventListener('pointerdown', onpointerdown);
           item.addEventListener('pointermove', onpointermove);
           item.addEventListener('pointerup', onpointerup);
       });

        Array.prototype
       .slice
       .call(el.querySelectorAll('.answer > .all_p'), 0)
       .forEach(function (item) {
           item.style.display = 'flex';
           item.style.cursor = 'move';
       });
        el._imatch.ClientRectquest = el.querySelector('.answer').getBoundingClientRect();

        Array.prototype
       .slice
       .call(el.querySelectorAll('p'))
       .forEach(function (item) {
           item.removeAttribute('contenteditable');
       });

        Array.prototype
       .slice
       .call(el.querySelectorAll('.item'))
       .forEach(function (item) {
           if (item.getAttribute('value') == 'check') {
               item.addEventListener('click', check);
           } else if (item.getAttribute('value') == 'show') {
               item.addEventListener('click', show)
           } else if (item.getAttribute('value') == 'repeat') {
               item.addEventListener('click', repeat);
           }
       });

        var qh = parseInt(el.dataset['qheight']);
        var el_width_height = { width: parseFloat(el.style.width), height: parseFloat(el.style.height) };
        var el_imatch_bor = el.querySelectorAll('.imatch_bor');
        for (var i = 0, len = el_imatch_bor.length; i < len; i++) {
            var imatch_bor = el_imatch_bor[i];
            //questioncount <= answercount
            if (parseInt(el.dataset['questioncount']) <= parseInt(el.dataset['answercount'])) {
                var el_imatch_bor_width = el_width_height.width / parseInt(el.dataset['answercount']) * 0.8;
            } else {
                var el_imatch_bor_width = el_width_height.width / parseInt(el.dataset['questioncount']) * 0.8;
            }
            imatch_bor.style.width = el_imatch_bor_width + 'px';
            imatch_bor.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
            var el_imatch_bor_width_all = el_imatch_bor_width * parseInt(el.dataset['questioncount']);
            var shdintence = (el_width_height.width - el_imatch_bor_width_all) / (parseInt(el.dataset['questioncount']) + 1);
            imatch_bor.style.left = (shdintence * (i + 1) + el_imatch_bor_width * i) + 'px';
            imatch_bor.style.top = el_width_height.height * 0.8 * 0.28 * (qh / (qh + 200)) / 3 + 'px';
            imatch_bor.style.display = 'block';
        }
        //set .answer p
        var el_answer_p = el.querySelectorAll('.answer > .all_p');
        //随机数序列 
        if (el._imatch.srandom && el._imatch.srandom.length > 0) {
            el._imatch.srandom.length = 0;
        } else {
            el._imatch.srandom = [];
            el._imatch.length = 0;
        }

        for (var i = 0, len = el_answer_p.length; i < len; i++) {
            el._imatch.srandom.push(i);
        }
        shuffle(el._imatch.srandom);

        for (var i = 0, len = el_answer_p.length; i < len; i++) {
            var el_answerp = el_answer_p[i];
            if (parseFloat(el.dataset['questioncount']) <= parseFloat(el.dataset['answercount'])) {
                var el_answerp_width = el_width_height.width / parseFloat(el.dataset['answercount']) * 0.8;
            } else {
                var el_answerp_width = el_width_height.width / parseFloat(el.dataset['questioncount']) * 0.8;
            }
            el_answerp.style.width = el_answerp_width + 'px';
            el_answerp.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
            var el_answerp_width_all = el_answerp_width * parseFloat(el.dataset['answercount']);
            var shdintence = (el_width_height.width - el_answerp_width_all) / (parseFloat(el.dataset['answercount']) + 1);
            if (el._imatch.srandom) {
                el_answerp.style.left = (shdintence * (el._imatch.srandom[i] + 1) + el_answerp_width * el._imatch.srandom[i]) + 'px';
            }
            el_answerp.style.top = el_width_height.height * 0.8 * 0.28 * (1 - qh / (qh + 200)) / 3 * 2 + el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
            //el_answerp.style.display = 'block';
        }
    }


    //check answer
    function check(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_imatch' }).pop();
        Array.prototype.slice.call(this_el.querySelectorAll('.item'), 0).forEach(function (item) {
            if (item.getAttribute('value') == 'check') {
                item.setAttribute('hidden', 'hidden')
            }
            if (item.getAttribute('value') == 'show') {
                item.removeAttribute('hidden');
            }
        });
        var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
        var el_answer_p = this_el.querySelectorAll('.answer > .all_p');
        var c_imatch_bor = [];
        var c_answer = [];
        for (var i = 0, len = el_imatch_bor.length; i < len; i++) {
            c_imatch_bor.push(el_imatch_bor[i].getBoundingClientRect());
        }
        for (var i = 0, len = el_answer_p.length; i < len; i++) {
            c_answer.push(el_answer_p[i].getBoundingClientRect());
        }
        if (this_el._imatch.check_bool_arr.length > 0) {
            this_el._imatch.check_bool_arr.length = 0;
        }
        if (this_el.dataset['_type'] == 'result') {
            var questioncount = parseFloat(this_el.dataset['questioncount']);
            var answercount = parseFloat(this_el.dataset['answercount']);
            if (questioncount <= answercount) {
                for (var i = 0; i < answercount; i++) {
                    if (i > questioncount - 1) {
                        for (var j = 0; j < questioncount; j++) {
                            if (_detectCollision(c_answer[i], c_imatch_bor[j])) {
                                this_el._imatch.check_bool_arr.push(false);
                            }
                        }
                    }
                    else {
                        if (_detectCollision(c_answer[i], c_imatch_bor[i])) {
                            this_el._imatch.check_bool_arr.push(true);
                        }
                        else {
                            this_el._imatch.check_bool_arr.push(false);
                        }
                    }
                }
            }
            else {
                for (var i = 0; i < questioncount; i++) {
                    if (i > answercount - 1) {
                        //for (var j = 0; j < c_answer.length; j++) {
                        //if (_detectCollision(c_answer[j], c_imatch_bor[i])) {
                        this_el._imatch.check_bool_arr.push(false);
                        //}
                        //}
                    }
                    else {
                        if (_detectCollision(c_answer[i], c_imatch_bor[i])) {
                            this_el._imatch.check_bool_arr.push(true);
                        }
                        else {
                            this_el._imatch.check_bool_arr.push(false);
                        }
                    }
                }
            }
        }
        else {
            var questioncount = parseFloat(this_el.dataset['questioncount']);
            var answercount = parseFloat(this_el.dataset['answercount']);
            if (questioncount <= answercount) {
                for (var i = 0, len = questioncount; i < len; i++) {
                    if (_detectCollision(c_answer[i], c_imatch_bor[i])) {
                        this_el._imatch.check_bool_arr.push(true);
                    } else {
                        this_el._imatch.check_bool_arr.push(false);
                    }
                }
            } else {
                for (var i = 0, len = answercount; i < len; i++) {
                    if (_detectCollision(c_answer[i], c_imatch_bor[i])) {
                        this_el._imatch.check_bool_arr.push(true);
                    } else {
                        this_el._imatch.check_bool_arr.push(false);
                    }
                }
            }
        }
        for (var i = 0; i < this_el._imatch.check_bool_arr.length; i++) {
            if (i < c_imatch_bor.length) {
                var ibobox = el_imatch_bor[i].getBoundingClientRect();
                var ibopbox = el_imatch_bor[i].parentElement.getBoundingClientRect();
                var ibo_mask = this_el.ownerDocument.createElement('div');
                ibo_mask.setAttribute('class', 'mainbo_imatch_ibrmask');
                ibo_mask.style.left = el_imatch_bor[i].style.left;
                ibo_mask.style.top = el_imatch_bor[i].style.top;
                ibo_mask.style.width = el_imatch_bor[i].style.width
                ibo_mask.style.height = el_imatch_bor[i].style.height
                el_imatch_bor[i].parentElement.appendChild(ibo_mask);
                var ibo_mask_mark = this_el.ownerDocument.createElement('div');
                if (this_el._imatch.check_bool_arr[i] == true) {
                    ibo_mask_mark.appendChild(createCorrectMark(this_el));
                }
                else {
                    ibo_mask_mark.appendChild(createErrorMark(this_el));
                }
                ibo_mask_mark.style.bottom = 0 + 'px';
                ibo_mask_mark.style.right = 0 + 'px';
                ibo_mask_mark.style.position = 'absolute';
                ibo_mask_mark.style.width = 40 + 'px';
                ibo_mask_mark.style.height = 40 + 'px';
                ibo_mask.appendChild(ibo_mask_mark);
            }
        }
    }
    //show answer
    function show(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_imatch' }).pop();
        var check_ibr = this_el.querySelectorAll('.mainbo_imatch_ibrmask')
        for (var i = 0; i < check_ibr.length; i++) {
            check_ibr[i].parentNode.removeChild(check_ibr[i]);
        }
        var el_width_height = { width: parseFloat(this_el.style.width), height: parseFloat(this_el.style.height) };
        var qh = parseInt(this_el.dataset['qheight']);
        var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
        var el_answer_p = this_el.querySelectorAll('.answer > .all_p');
        var el_imatch_bor_width;
        if (parseInt(this_el.dataset['questioncount']) <= parseInt(this_el.dataset['answercount'])) {
            for (var i = 0, len = el_answer_p.length; i < len; i++) {
                var el_answerp = el_answer_p[i];
                if (i > parseFloat(this_el.dataset['questioncount']) - 1) {
                    el_answerp.style.display = 'flex';
                    if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {
                        el_imatch_bor_width = el_width_height.width / parseFloat(this_el.dataset['answercount']) * 0.8;
                    } else {
                        el_imatch_bor_width = el_width_height.width / parseFloat(this_el.dataset['questioncount']) * 0.8;
                    }
                    var el_answerp_width_all = el_imatch_bor_width * parseFloat(this_el.dataset['answercount']);
                    var shdintence = (el_width_height.width - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                    if (this_el._imatch.srandom) {
                        el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_imatch_bor_width * this_el._imatch.srandom[i]) + 'px';
                    }
                    el_answerp.style.top = el_width_height.height * 0.8 * 0.28 * (1 - qh / (qh + 200)) / 3 * 2 + el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
                }
                else {
                    //el_answerp.style.display = 'block';
                    el_imatch_bor_width = el_width_height.width / parseInt(this_el.dataset['answercount']) * 0.8;
                    el_answerp.style.width = el_imatch_bor_width + 'px';
                    el_answerp.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
                    var el_imatch_bor_width_all = el_imatch_bor_width * parseInt(this_el.dataset['questioncount']);
                    var shdintence = (el_width_height.width - el_imatch_bor_width_all) / (parseInt(this_el.dataset['questioncount']) + 1);
                    el_answerp.style.left = (shdintence * (i + 1) + el_imatch_bor_width * i) + 'px';
                    el_answerp.style.top = el_width_height.height * 0.8 * 0.28 * (qh / (qh + 200)) / 3 + 'px';
                }
            }
        } else {
            for (var i = 0, len = el_answer_p.length; i < len; i++) {
                var el_answerp = el_answer_p[i];
                el_answerp.style.display = 'flex';
                el_imatch_bor_width = el_width_height.width / parseFloat(this_el.dataset['questioncount']) * 0.8;
                el_answerp.style.width = el_imatch_bor_width + 'px';
                el_answerp.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
                var el_imatch_bor_width_all = el_imatch_bor_width * parseFloat(this_el.dataset['questioncount']);
                var shdintence = (el_width_height.width - el_imatch_bor_width_all) / (parseFloat(this_el.dataset['questioncount']) + 1);
                el_answerp.style.left = (shdintence * (i + 1) + el_imatch_bor_width * i) + 'px';
                el_answerp.style.top = el_width_height.height * 0.8 * 0.28 * (qh / (qh + 200)) / 3 + 'px';
            }
        }
    }
    //repeat again 
    function repeat(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_imatch' }).pop();
        var el_width_height = { width: parseFloat(this_el.style.width), height: parseFloat(this_el.style.height) };
        var qh = parseInt(this_el.dataset['qheight']);
        this_el._imatch.this_check_bool = false;
        var check_ibr = this_el.querySelectorAll('.mainbo_imatch_ibrmask')
        if (check_ibr) {
            for (var i = 0; i < check_ibr.length; i++) {
                check_ibr[i].parentNode.removeChild(check_ibr[i]);
            }
        }

        if (this_el.dataset['_type'] == 'process') {
            Array.prototype.slice(this_el.querySelectorAll('.item'), 0).forEach(function (item) {
                if (item.getAttribute('value') == 'check') {
                    item.setAttribute('hidden', 'hidden');
                } else if (item.getAttribute('value') == 'show') {
                    if (item.getAttribute('hidden')) {
                        item.removeAttribute('hidden');
                    }
                } else {

                }
            });
        } else {
            Array.prototype.slice.call(this_el.querySelectorAll('.item'), 0).forEach(function (item) {
                if (item.getAttribute('value') == 'check') {
                    item.removeAttribute('hidden');
                } else if (item.getAttribute('value') == 'show') {
                    item.setAttribute('hidden', 'hidden');
                } else {

                }
            });
        }

        var el_answer = this_el.querySelector('.answer').getBoundingClientRect();
        var el_answerW = parseFloat(this_el.style.width);
        var el_answerH = parseFloat(this_el.style.height) * 0.8 * 0.7;
        var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
        for (var i = 0, len = el_imatch_bor.length; i < len; i++) {
            var imatch_bor = el_imatch_bor[i];
            if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {
                var el_imatch_bor_width = el_answerW / parseFloat(this_el.dataset['answercount']) * 0.8;
                imatch_bor.style.width = el_imatch_bor_width + 'px';
                imatch_bor.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
                var el_imatch_bor_width_all = el_imatch_bor_width * parseFloat(this_el.dataset['questioncount']);
                var shdintence = (el_answerW - el_imatch_bor_width_all) / (parseFloat(this_el.dataset['questioncount']) + 1);
                imatch_bor.style.left = (shdintence * (i + 1) + el_imatch_bor_width * i) + 'px';
                imatch_bor.style.top = el_width_height.height * 0.8 * 0.28 * (qh / (qh + 200)) / 3 + 'px';
            } else {

            }
            imatch_bor.style.display = 'block';
        }

        var el_answer_p = this_el.querySelectorAll('.answer > .all_p');
        for (var i = 0, len = el_answer_p.length; i < len; i++) {
            var el_answerp = el_answer_p[i];
            if (parseInt(this_el.dataset['questioncount']) <= parseInt(this_el.dataset['answercount'])) {
                var el_answerp_width = el_answerW / parseFloat(this_el.dataset['answercount']) * 0.8;
            } else {
                var el_answerp_width = el_answerW / parseFloat(this_el.dataset['questioncount']) * 0.8;
            }
            el_answerp.style.width = el_answerp_width + 'px';
            el_answerp.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
            var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
            var shdintence = (el_answerW - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
            el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';
            el_answerp.style.top = el_width_height.height * 0.8 * 0.28 * (1 - qh / (qh + 200)) / 3 * 2 + el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
            el_answerp.style.display = 'flex';
        }
    }
    //mainbo_imatch_mask 
    function checkmask(ev) {
        if (ev.target.classList.contains('mainbo_imatch_mask')) {
            ev.target.style.display = 'none';
            ev.target.children.forEach(function (item) {
                item.style.display = 'none';
            });
        }
    }
    //retangle
    function _detectCollision(Bs1, Bs2) {
        return (Math.max(Bs1.right - Bs2.left, Bs2.right - Bs1.left) < Bs1.width + Bs2.width) && (Math.max(Bs1.bottom - Bs2.top, Bs2.bottom - Bs1.top) < Bs1.height + Bs2.height);
    }
    //retangle area
    function _detectArea(Bs1, Bs2) {
        var area = Bs1.width * Bs1.height;

        var minright = Math.min(Bs1.right, Bs2.right);
        var maxleft = Math.max(Bs1.left, Bs2.left);

        var minbottom = Math.min(Bs1.bottom, Bs2.bottom);
        var maxtop = Math.max(Bs1.top, Bs2.top);

        var deheight = minbottom - maxtop > 0 ? minbottom - maxtop : 0;
        var dewidth = minright - maxleft > 0 ? minright - maxleft : 0;

        var inarea = deheight * dewidth;
        return inarea <= area && inarea > area / 2;

    }
    //contains Bs1为被包含(小) Bs2为包含(大)
    function _containCollision(Bs1, Bs2) {
        return Bs1.top > Bs2.top && Bs1.right < Bs2.right && Bs1.bottom < Bs2.bottom && Bs1.left > Bs2.left;
    }
    //get Ancestors
    function getAncestors(node, filter) {
        var ret = [];
        var docType = Node.DOCUMENT_NODE;
        for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
            try {
                if (filter && filter(cur))
                    ret.push(cur);
            }
            catch (e) {
                console.warn(e.stack || e);
            }
        }
        return ret;
    }
    function ondragstart(ev) {
        ev.preventDefault();
    }
    //pointdown event
    function onpointerdown(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_imatch' }).pop();
        var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
        if (ev.button == 0) {
            var allp = null;
            if (ev.target.classList.contains('all_p')) {
                allp = ev.target;
            } else {
                allp = getAncestors(ev.target, function (el) {
                    if (el.classList.contains('all_p')) {
                        return true;
                    }
                }).pop();
            }
            this_el._imatch.dragt = allp;
            if (allp) {
                Array.prototype.slice.call(this_el.querySelectorAll('.imatch_bor'), 0).forEach(function (item) {
                    item.style.borderColor = 'rgba(255,145,74,1)';
                });
                this_el._imatch.dragt.style.zIndex = '1';
                this_el._imatch.pos = {
                    x: !etbpage.etbScale ? ev.clientX : ev.clientX / etbpage.etbScale,
                    y: !etbpage.etbScale ? ev.clientY : ev.clientY / etbpage.etbScale,
                    l: parseFloat(allp.style.left),
                    t: parseFloat(allp.style.top),
                };
            }
        }
        else {
            return;
        }
    }
    //pointmove event
    function onpointermove(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_imatch' }).pop();
        var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
        if (ev.target.classList.contains('all_p')) {
            allp = ev.target;
        } else {
            allp = getAncestors(ev.target, function (el) {
                if (el.classList.contains('all_p')) {
                    return true;
                }
            }).pop();
        }
        this_el._imatch.temp = {
            x: !etbpage.etbScale ? ev.clientX : ev.clientX / etbpage.etbScale,
            y: !etbpage.etbScale ? ev.clientY : ev.clientY / etbpage.etbScale
        };
        var el_width_height = { width: parseFloat(this_el.style.width), height: parseFloat(this_el.style.height) };
        this_el._imatch.ClientRectquest = this_el.querySelector('.answer').getBoundingClientRect();
        var el_answer_p = this_el.querySelectorAll('.answer > .all_p');
        var qh = parseInt(this_el.dataset['qheight']);
        if (this_el._imatch.dragt) {
            var xfa = Math.min(Math.max(this_el._imatch.temp['x'] - this_el._imatch.pos['x'] + this_el._imatch.pos['l'], 0), this_el._imatch.ClientRectquest['right'] - this_el._imatch.ClientRectquest['left'] - parseFloat((this_el._imatch.dragt).style.width));
            var yfa = Math.min(Math.max(this_el._imatch.temp['y'] - this_el._imatch.pos['y'] + this_el._imatch.pos['t'], 0), this_el._imatch.ClientRectquest['bottom'] - this_el._imatch.ClientRectquest['top'] - parseFloat((this_el._imatch.dragt).style.height));
            this_el._imatch.dragt.style.left = xfa + 'px';
            this_el._imatch.dragt.style.top = yfa + 'px';
            if (this_el._imatch.dragt == allp) {
                Array.prototype.slice.call(this_el.querySelectorAll('.imatch_bor'), 0).forEach(function (item) {
                    var itembox = item.getBoundingClientRect();
                    var allpbox = allp.getBoundingClientRect();
                    if (_detectCollision(allpbox, itembox) && _detectArea(allpbox, itembox)) {
                        item.style.transform = 'scale(1.1,1.1)';
                    } else {
                        item.style.removeProperty('transform');
                    }
                });
            }
            //if (this_el._imatch.temp['x'] < this_el._imatch.ClientRectquest['left'] || this_el._imatch.temp['y'] < this_el._imatch.ClientRectquest['top'] || this_el._imatch.temp['x'] > this_el._imatch.ClientRectquest['right'] || this_el._imatch.temp['y'] > this_el._imatch.ClientRectquest['bottom']) {
            //  setTimeout(function () {
            //    if (this_el._imatch.dragt.style.zIndex) {
            //      this_el._imatch.dragt.style.removeProperty('z-index');
            //    }
            //    for (var i = 0; i < el_answer_p.length; i++) {
            //      var el_answerp = el_answer_p[i];
            //      if (this_el._imatch.dragt === el_answerp) {
            //        if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {
            //          var el_answerp_width = el_width_height.width / parseFloat(this_el.dataset['answercount']) * 0.8;
            //        } else {
            //          var el_answerp_width = el_width_height.width / parseFloat(this_el.dataset['questioncount']) * 0.8;
            //        }
            //        el_answerp.style.width = el_answerp_width + 'px';
            //        el_answerp.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
            //        var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
            //        var shdintence = (el_width_height.width - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
            //        if (this_el._imatch.srandom) {
            //          el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';
            //        }
            //        el_answerp.style.top = el_width_height.height * 0.8 * 0.28 * (1 - qh / (qh + 200)) / 3 * 2 + el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';

            //      } else {

            //      }
            //    }
            //    this_el._imatch.dragt = null;
            //  }, 0);
            //}
        }
        else {
            this_el._imatch.dragt = null;
        }
    }
    //pointup event
    function onpointerup(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_imatch' }).pop();
        Array.prototype.slice.call(this_el.querySelectorAll('.imatch_bor'), 0).forEach(function (item) {
            item.style.removeProperty('border-color');
            item.style.removeProperty('transform');
        });
        this_el._imatch.temp = {
            x: ev.clientX,
            y: ev.clientY
        };
        if (this_el._imatch.dragt) {
            var qh = parseInt(this_el.dataset['qheight']);
            var el_width_height = { width: parseFloat(this_el.style.width), height: parseFloat(this_el.style.height) };
            var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
            Array.prototype.slice.call(el_imatch_bor, 0).forEach(function (item) {
                item.style.removeProperty('transform');
            });
            var el_answer_p = this_el.querySelectorAll('.answer > .all_p');
            var dragclient = this_el._imatch.dragt.getBoundingClientRect();
            var dragtimatchs = [];
            dragtimatchs.length = 0;
            if (this_el.dataset['_type'] == 'process') {
                for (var j = 0; j < el_imatch_bor.length; j++) {
                    var el_imatchbor = el_imatch_bor[j];
                    var c_el_imatchbor = el_imatchbor.getBoundingClientRect();
                    var el_imatchbor_centerpoint = { x: c_el_imatchbor.left + (c_el_imatchbor.right - c_el_imatchbor.left) / 2, y: c_el_imatchbor.top + (c_el_imatchbor.bottom - c_el_imatchbor.top) };
                    var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
                    var dragtgetrect = this_el._imatch.dragt.getBoundingClientRect();
                    var imatch_bor_rect = el_imatch_bor[j].getBoundingClientRect();
                    if (_detectCollision(dragtgetrect, imatch_bor_rect)) {
                        var dragtimatch = [];
                        dragtimatch.push(this_el._imatch.dragt);
                        dragtimatch.push(el_imatch_bor[j]);
                        dragtimatchs.push(dragtimatch);
                    }
                }
                //判断当前拖动元素与匹配区域的数量
                if (dragtimatchs.length == 1) {
                    var imatchb = dragtimatchs[0][1];
                    if (parseInt(this_el._imatch.dragt.getAttribute('data-imatch')) == parseInt(imatchb.getAttribute('data-ibor'))) {
                        //相交并且匹配成功,将答案放入选项区
                        this_el._imatch.dragt.style.top = imatchb.style.top;
                        this_el._imatch.dragt.style.right = imatchb.style.right;
                        this_el._imatch.dragt.style.bottom = imatchb.style.bottom;
                        this_el._imatch.dragt.style.left = imatchb.style.left;
                    } else {
                        //相交但匹配不成功,归位
                        for (var i = 0; i < el_answer_p.length; i++) {
                            var el_answerp = el_answer_p[i];
                            if (this_el._imatch.dragt === el_answerp) {
                                if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {
                                    var el_answerp_width = el_width_height.width / parseFloat(this_el.dataset['answercount']) * 0.8;
                                } else {
                                    var el_answerp_width = el_width_height.width / parseFloat(this_el.dataset['questioncount']) * 0.8;
                                }
                                el_answerp.style.width = el_answerp_width + 'px';
                                el_answerp.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
                                var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                                var shdintence = (el_width_height.width - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                                if (this_el._imatch.srandom) {
                                    el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';
                                }
                                el_answerp.style.top = el_width_height.height * 0.8 * 0.28 * (1 - qh / (qh + 200)) / 3 * 2 + el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
                                break;
                            } else {

                            }
                        }
                    }
                } else {
                    //归位
                    for (var i = 0; i < el_answer_p.length; i++) {
                        var el_answerp = el_answer_p[i];
                        if (this_el._imatch.dragt === el_answerp) {
                            if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {
                                var el_answerp_width = el_width_height.width / parseFloat(this_el.dataset['answercount']) * 0.8;
                            } else {
                                var el_answerp_width = el_width_height.width / parseFloat(this_el.dataset['questioncount']) * 0.8;
                            }
                            el_answerp.style.width = el_answerp_width + 'px';
                            el_answerp.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
                            var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                            var shdintence = (el_width_height.width - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                            if (this_el._imatch.srandom) {
                                el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';
                            }
                            el_answerp.style.top = el_width_height.height * 0.8 * 0.28 * (1 - qh / (qh + 200)) / 3 * 2 + el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
                            break;
                        } else {
                        }
                    }
                }

                if (this_el._imatch.dragt && this_el._imatch.dragt.style.zIndex) {
                    this_el._imatch.dragt.style.removeProperty('z-index');
                }
                this_el._imatch.dragt = null;
            } else {//结果判断
                var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
                var react_bool = [];
                react_bool.length = 0;
                //循环选项区
                for (var i = 0, len = el_imatch_bor.length; i < len; i++) {
                    var dragtp = this_el._imatch.dragt;
                    var imatt_bor_d = (el_imatch_bor[i]);
                    var dragtgetrect = this_el._imatch.dragt.getBoundingClientRect();
                    var imatch_bor_rect = (el_imatch_bor[i]).getBoundingClientRect();
                    if (_detectCollision(dragtgetrect, imatch_bor_rect) && _detectArea(dragtgetrect, imatch_bor_rect)) {
                        for (var j = 0; j < el_answer_p.length; j++) {
                            var el_answerp_un = el_answer_p[j];
                            //替换已经相交的元素(已经相交的元素归位)
                            if (this_el._imatch.dragt !== el_answerp_un && _detectCollision(el_answerp_un.getBoundingClientRect(), imatch_bor_rect)) {
                                if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {
                                    var el_answerp_width = el_width_height.width / parseFloat(this_el.dataset['answercount']) * 0.8;
                                } else {
                                    var el_answerp_width = el_width_height.width / parseFloat(this_el.dataset['questioncount']) * 0.8;
                                }
                                el_answerp_un.style.width = el_answerp_width + 'px';
                                el_answerp_un.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
                                var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                                var shdintence = (el_width_height.width - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                                if (this_el._imatch.srandom) {
                                    el_answerp_un.style.left = (shdintence * (this_el._imatch.srandom[j] + 1) + el_answerp_width * this_el._imatch.srandom[j]) + 'px';
                                }
                                el_answerp_un.style.top = el_width_height.height * 0.8 * 0.28 * (1 - qh / (qh + 200)) / 3 * 2 + el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';

                            } else {

                            }
                        }
                        this_el._imatch.dragt.style.top = (imatt_bor_d).style.top;
                        this_el._imatch.dragt.style.right = (imatt_bor_d).style.right;
                        this_el._imatch.dragt.style.bottom = (imatt_bor_d).style.bottom;
                        this_el._imatch.dragt.style.left = (imatt_bor_d).style.left;
                        react_bool.push(i);
                    } else {

                    }
                }

                if (react_bool.length == 0) {
                    for (var i = 0; i < el_answer_p.length; i++) {
                        var el_answerp = el_answer_p[i];
                        if (this_el._imatch.dragt === el_answerp) {
                            if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {
                                var el_answerp_width = el_width_height.width / parseFloat(this_el.dataset['answercount']) * 0.8;
                            } else {
                                var el_answerp_width = el_width_height.width / parseFloat(this_el.dataset['questioncount']) * 0.8;
                            }
                            el_answerp.style.width = el_answerp_width + 'px';
                            el_answerp.style.height = el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';
                            var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                            var shdintence = (el_width_height.width - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                            if (this_el._imatch.srandom) {
                                el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';
                            }
                            el_answerp.style.top = el_width_height.height * 0.8 * 0.28 * (1 - qh / (qh + 200)) / 3 * 2 + el_width_height.height * 0.8 * 0.72 * (1 - qh / (qh + 200)) / 2 + 'px';

                        } else {

                        }
                    }
                }
                if (this_el._imatch.dragt && this_el._imatch.dragt.style.zIndex) {
                    this_el._imatch.dragt.style.removeProperty('z-index');
                }
                this_el._imatch.dragt = null;
            }
        }
    }
    //right mark
    function createCorrectMark(el) {
        var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'), path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
        svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
        svg.style.width = 40 + 'px';
        svg.style.height = 40 + 'px';
        //svg.setAttribute('class', 'svgmask imatch_svgright');
        //svg.style.transform = 'scale(0.3) translate(-100%,-100%)';
        //path.setAttribute('stroke', 'green');
        path.setAttribute('fill', 'rgb(49, 159, 27)');
        path.setAttribute('d', 'M20,40C8.955,40,0,31.045,0,20C0,8.954,8.955,0,20,0s20,8.954,20,20C40,31.045,31.046,40,20,40z   M20.002,2.66c-9.576,0-17.338,7.762-17.338,17.338c0,9.575,7.762,17.337,17.338,17.337c9.575,0,17.337-7.762,17.337-17.337  C37.339,10.422,29.576,2.66,20.002,2.66L20.002,2.66z M10.872,25.437v2.655c0,0,4.627,2.678,9.4,2.678  c4.73,0,9.061-2.678,9.061-2.678v-2.655c0,0-4.366,2.677-9.061,2.677C15.464,28.113,10.872,25.437,10.872,25.437z M25.558,19.241  c-1.507,0-2.73-2.031-2.73-4.537c0-2.506,1.223-4.539,2.73-4.539s2.73,2.032,2.73,4.539C28.288,17.209,27.066,19.241,25.558,19.241z   M14.725,19.241c-1.507,0-2.73-2.031-2.73-4.537c0-2.506,1.223-4.539,2.73-4.539c1.508,0,2.73,2.032,2.73,4.539  C17.455,17.209,16.233,19.241,14.725,19.241z');
        svg.appendChild(path);
        return svg;
    }
    //false mark
    function createErrorMark(el) {
        var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'), path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
        svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
        svg.style.width = 40 + 'px';
        svg.style.height = 40 + 'px';
        //svg.setAttribute('class', 'svgmask imatch_svgmistake');
        //svg.style.transform = 'scale(0.3) translate(-100%,-100%)';
        //path.setAttribute('stroke', 'red');
        path.setAttribute('fill', 'rgb(224, 108, 85)');
        path.setAttribute('d', 'M37.289,31.691h0.003v-0.018L37.289,31.691z M34.148,5.852c-7.801-7.802-20.495-7.802-28.296,0  c-7.803,7.801-7.803,20.496,0,28.296c7.801,7.803,20.495,7.803,28.296,0C41.951,26.347,41.951,13.653,34.148,5.852 M32.118,32.119  c-6.682,6.682-17.555,6.681-24.236,0c-6.683-6.683-6.683-17.554,0-24.237c6.681-6.681,17.554-6.682,24.236,0  C38.8,14.563,38.8,25.437,32.118,32.119 M13.758,17.893c1.188,0,2.154-0.966,2.154-2.155c0-1.189-0.966-2.157-2.154-2.157  c-1.19,0-2.157,0.968-2.157,2.157C11.601,16.926,12.568,17.893,13.758,17.893 M26.166,17.896c1.189,0,2.157-0.969,2.157-2.157  c0-1.189-0.968-2.156-2.157-2.156c-1.188,0-2.154,0.967-2.154,2.156C24.011,16.927,24.978,17.896,26.166,17.896 M26.241,29.021  l-0.117-0.038c-1.932-0.875-4.004-1.32-6.153-1.32c-2.221,0-4.321,0.449-6.244,1.332l-0.116,0.036  c-0.072,0.02-0.17,0.048-0.292,0.048c-0.707,0-1.281-0.574-1.281-1.278c0-0.334,0.157-0.67,0.417-0.923L12.439,26.8l0.327-0.147  c2.296-1.039,4.793-1.586,7.22-1.586c2.473,0,4.896,0.533,7.234,1.599c0.411,0.226,0.667,0.657,0.667,1.127  C27.887,28.618,27.141,29.297,26.241,29.021');
        svg.appendChild(path);
        return svg;
    }
    function stopPropagation(ev) {
        ev.stopPropagation();
    }

    function shuffle(arr) {
      var k = 0;
      var temp = 0;
      for (var i = 0; i < arr.length; i++) {
        k = Math.floor(Math.random() * (arr.length - i));
        temp = arr[i];
        arr[i] = arr[k];
        arr[k] = temp;
      }
    }

    function preventDefault(ev) {
      touchstart.preventDefault();
      //会阻止滚动和合成的click事件，所以对button不能用
        //if (ev.target.localName !== 'button') {
        //    ev.preventDefault();
        //}
    }
})(etb_controls.mainbo_imatch || (etb_controls.mainbo_imatch = {}));

