﻿(function (mainbo_gridboard) {
  function init(el) {
    setEditing(el, false);
  }
  function setEditing(el) {
    el.addEventListener('click', stopPropagation);
    if (!el._gridboardproperty) {
      el._gridboardproperty = {
        _curshape: null,
        _pointerdown: false,
        _dragStart: false,
        _moved: false,
        _dragResizeStartFrom: null,
        _lastMouseX: 0,
        _lastMouseY: 0,
        _dragStartX: 0,
        _dragStartY: 0,
        _isInsert: false,
        _shape: null,
        _lastBorderColor: null,
        _lastBorderWidth: null,
        _lastFillColor: null,
        _lastShape: null
      };
    }
    el.querySelector('.mbe-grid-board').addEventListener('pointerup', gridPointerUp);
    el.querySelector('.mbe-grid-board').addEventListener('pointermove', gridPointerMove);
    el.querySelector('.mbe-grid-board').addEventListener('pointerdown', gridPointerDown);
    el.querySelector('.mbe-grid-shapes').addEventListener('pointerdown', shapePointerDown);
    el.addEventListener('dragstart', onDragstart);
    Array.prototype.slice.call(el.querySelectorAll('.mbe-grid-colors-radius')).forEach(function (item, index) {
      if (item.classList.contains('current-color')) {
        el._gridboardproperty._lastFillColor = item.style.backgroundColor;
      }
      item.addEventListener('click', setCurFillColor);
    });
    if (!el.querySelector('.mbe-grid-board-svgBackGround')) {
      var mgbBackGround = createGridBack(el);
      if (mgbBackGround) {
        createGridLine(mgbBackGround);
      }
    }
  };

  function stopPropagation(ev) {
    ev.stopPropagation();
  }
  function shapePointerDown(ev) {
    var target = ev.target;
    var ctr = getAncestors(target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_gridboard' }).pop();
    var isInsert = getAncestors(target, function (el) { return el.classList.contains('mbe-grid-shapes') }).length > 0 ? true : false;
    ctr._gridboardproperty._isInsert = isInsert;
    if (isInsert) {
      var shape = getAncestors(target, function (el) { return el.hasAttribute('data-shape') }).pop();
      if (shape) {
        Array.prototype.forEach.call(ctr.querySelectorAll('.mbe-grid-shapes [data-shape]'), (item, index) => {
            item.firstElementChild.firstElementChild.style.fill = 'rgba(255,255,255,1)';
        });
        ctr._gridboardproperty._shape = shape;
        createInsertGroup(ctr, shape);
        shape.classList.add('current-shape')
        shape.firstElementChild.firstElementChild.style.fill = ctr._gridboardproperty._lastFillColor;
      } else {
          var ig = ctr.querySelector('.mbe-grid-insert-Group');
          if (ig) {
              ig.parentElement.removeChild(ig);
              [].forEach.call(ctr.querySelectorAll('.current-shape'),(item, index) => {
                  item.classList.remove('current-shape');
              });
              ctr._gridboardproperty._lastFillColor = ctr.querySelector('.current-color').style.backgroundColor;
          }
      }
    }
  }
  function gridPointerDown(ev) {
    var target = ev.target;
    var ctr = getAncestors(target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_gridboard' }).pop();
    var shape = getAncestors(target, function (el) { return el.hasAttribute('data-shape') }).pop();
    var insertGroup = ctr.querySelector('.mbe-grid-insert-Group');
    if (!insertGroup && shape) {
      if (ev.button !== 0 || ev.buttons !== 1) {
        return;
      }
      Array.prototype.forEach.call(ctr.querySelectorAll('[data-shape]'), function (item, index) {
        if (item && item.classList.contains('current-active')) {
          item.classList.remove('current-active');
        }
      });
      var x = ev.clientX, y = ev.clientY;
      var hRE = new RegExp('mbe-gridboard-dragresize-([trbl]{2})', '');
      var cur = ctr._gridboardproperty._curshape = shape
      if (cur) {
        cur.classList.add('current-active');
        if (!cur.querySelector('.mbe-gridboard-dragresize-tl')) {
          createDragResizeEl(cur);
          removeDragResizeEl(cur);
        }
        ctr._gridboardproperty._pointerdown = true;
        var drH;
        if (typeof (target).className !== 'string') {
          drH = "";
        }
        else {
          drH = (target).className.match(hRE);
        }
        //点击事件发生在dragsize节点上
        if (drH && drH.length) {
          ctr._gridboardproperty._dragResizeStartFrom = drH[1];
          //console.log(dragResizeStartFrom);
        } else {
          ctr._gridboardproperty._dragStart = true;
          //eventInSelectionBox(x, y, cur);
        }
        ctr._gridboardproperty._dragStartX = x;
        ctr._gridboardproperty._dragStartY = y;
        ctr._gridboardproperty._lastMouseX = x;
        ctr._gridboardproperty._lastMouseY = y;
      }
      else {
        Array.prototype.forEach.call(ctr[0].querySelectorAll('[data-shape]'), function (item, index) {
          if (item && item.children.length) {
            var svgnode;
            Array.prototype.forEach.call(item.children, function (node, index1) {
              if (node.localName == 'svg') {
                svgnode = node;
              }
            });
            item.innerHTML = ''
            if (svgnode) {
              item.appendChild(svgnode);
            }
          }
        });
      }
    } else {
      if (!shape) {
        Array.prototype.forEach.call(ctr.querySelectorAll('[data-shape]'), function (item, index) {
          if (item && item.classList.contains('current-active')) {
            var itemsvg = item.firstElementChild;
            item.innerHTML = '';
            item.appendChild(itemsvg);
            item.classList.remove('current-active');
          }
        });
      }
    }
  }
  function gridPointerMove(ev) {
    var target = ev.target;
    var ctr = getAncestors(target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_gridboard' }).pop();
    var insertGroup = ctr.querySelector('.mbe-grid-insert-Group');
    var gridboard = ctr.querySelector('.mbe-grid-board');
    var gridbox = ctr.querySelector('.mbe-grid-board').getBoundingClientRect();
    if (insertGroup && ctr._gridboardproperty._isInsert && ctr._gridboardproperty._shape) {
      var newshape = gridboard.querySelector('.mbe-grid-shape-creating')
      if (newshape) {
        newshape.style.left = (ev.clientX - gridbox.left) + 'px';
        newshape.style.top = (ev.clientY - gridbox.top) + 'px';
        newshape.style.display = 'block';
      } else {
        newshape = insertGroup.children[0].cloneNode(true)
        newshape.style.position = 'absolute';
        newshape.style.left = (ev.clientX - gridbox.left) + 'px';
        newshape.style.top = (ev.clientX - gridbox.left) + 'px';
        var svg = newshape.children[0];
        var svgshape = svg.children[0];
        newshape.style.width = 60 + 'px';
        newshape.style.height = 60 + 'px';
        newshape.style.minWidth = 60 + 'px';
        newshape.style.minHeight = 60 + 'px';
        newshape.style.maxWidth = 480 + 'px';
        newshape.style.maxHeight = 480 + 'px';
        newshape.style.borderColor = 'rgba(0,0,0,1)';
        newshape.style.boxSizing = 'border-box';
        newshape.classList.add('mbe-grid-shape-creating');
        svg.style.width = 60 + 'px';
        svg.style.height = 60 + 'px';
        svg.style.minWidth = 60 + 'px';
        svg.style.minHeight = 60 + 'px';
        svgshape.setAttribute('data-stroke-width', '0');
        svgshape.setAttribute('data-stroke-color', 'rgba(135,176,255,1)');
        svgshape.setAttribute('data-fill-color', ctr && ctr._gridboardproperty._lastFillColor ? ctr._gridboardproperty._lastFillColor : 'none');
        svgshape.style.stroke = ctr && ctr._gridboardproperty._lastBorderColor ? ctr._gridboardproperty._lastBorderColor : 'rgba(0,0,0,1)';
        svgshape.style.strokeWidth = '0px';
        svgshape.style.fill = ctr && ctr._gridboardproperty._lastFillColor ? ctr._gridboardproperty._lastFillColor : 'rgba(255,0,0,1)';
        gridboard.appendChild(newshape);
      }
      childrenResize(newshape.children[0], false);
      var c_shape = ctr.querySelector('.current-shape')
      c_shape && (c_shape.firstElementChild.firstElementChild.style.fill = 'rgba(255,255,255,1)');
      c_shape && (c_shape.classList.remove('current-shape'));
      //insertGroup.style.position = 'absolute';
      //insertGroup.style.left = (ev.clientX - gridbox.left) + 'px';
      //insertGroup.style.top = (ev.clientY - gridbox.top) + 'px';
    } else {
      var x = ev.clientX, y = ev.clientY, dx = 0, dy = 0;
      dx = x - ctr._gridboardproperty._lastMouseX;
      dy = y - ctr._gridboardproperty._lastMouseY;
      var curshape = ctr._gridboardproperty._curshape || ctr.querySelector('.current-active');
      if (!dx && !dy) {
        return;
      }
      if (!ctr._gridboardproperty._moved && ctr._gridboardproperty._pointerdown) {
        ctr._gridboardproperty._moved = true;
      }
      if (ctr._gridboardproperty._dragResizeStartFrom && ctr._gridboardproperty._curshape) {
        //dealcurentElEdge(mainbo_gridboard._curshape);
        //先将除矩形以外的形状禁止缩放
        var curshape = ctr._gridboardproperty._curshape;
        var curshapeP = curshape.parentElement;
        var curleft = getCSSNumber(curshape, 'left');
        var curtop = getCSSNumber(curshape, 'top');
        var curwidth = getCSSNumber(curshape, 'width');
        var curwidth = getCSSNumber(curshape, 'height');
        var pwidth = getCSSNumber(curshapeP, 'width');
        var pheight = getCSSNumber(curshapeP, 'width');
        if (/^(hexagon)$/.test(ctr._gridboardproperty._curshape.getAttribute('data-shape'))) {
          if (curleft + curwidth > pwidth) {
            handleResize(x, y, 0, 0, true, ctr)
          } else {
            handleResize(x, y, dx, dy, true, ctr);
          }
        }
        else {
          if (curleft + curwidth > pwidth) {
            handleResize(x, y, 0, 0, false, ctr)
          } else {
            handleResize(x, y, dx, dy, false, ctr);
          }
        }
        ctr._gridboardproperty._lastMouseX = x;
        ctr._gridboardproperty._lastMouseY = y;
      } else if (ctr._gridboardproperty._dragStart && ctr._gridboardproperty._pointerdown && ctr._gridboardproperty._curshape && ctr.getAttribute('data-graphicalposition') == 'notfixed') {
        ev.preventDefault();
        moveSelectionby(ctr._gridboardproperty._curshape, dx, dy);
        ctr._gridboardproperty._lastMouseX = x;
        ctr._gridboardproperty._lastMouseY = y;
      }
    }
  }
  function gridPointerUp(ev) {
    var target = ev.target;
    var ctr = getAncestors(target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_gridboard' }).pop();
    //判断时插入还是移动拖拽
    var insertGroup = ctr.querySelector('.mbe-grid-insert-Group');
    var shapecreating = ctr.querySelector('.mbe-grid-shape-creating');

    if (insertGroup) {
      var boxSize = 60;
      //设置正在创建图形的位置
      var left = (Math.floor(parseFloat(shapecreating.style.left) / boxSize)) * boxSize;
      var top = (Math.floor(parseFloat(shapecreating.style.top) / boxSize)) * boxSize;
      if (isNaN(left)) {
        var gridbox = ctr.querySelector('.mbe-grid-board').getBoundingClientRect();
        left = Math.floor((ev.clientX - gridbox.left) / boxSize) * boxSize;
        top = Math.floor((ev.clientY - gridbox.top) / boxSize) * boxSize;
      }
      shapecreating.style.left = left + 'px';
      shapecreating.style.top = top + 'px';
      Array.prototype.forEach.call(ctr.querySelectorAll('[data-shape]'), function (item, index) {
        if (item && item.classList.contains('current-active')) {
          item.classList.remove('current-active');
        }
      });
      shapecreating.classList.add('current-active')
      createDragResizeEl(shapecreating);
      removeDragResizeEl(shapecreating)
    } else {
      var boxSize = 60;
      if (ctr._gridboardproperty._curshape) {
        var left =
          parseFloat(ctr._gridboardproperty._curshape.style.left) % boxSize > boxSize / 2 ?
            (Math.floor(parseFloat(ctr._gridboardproperty._curshape.style.left) / boxSize) + 1) * boxSize :
            (Math.floor(parseFloat(ctr._gridboardproperty._curshape.style.left) / boxSize)) * boxSize
        ;
        var top =
          parseFloat(ctr._gridboardproperty._curshape.style.top) % boxSize > boxSize / 2 ?
            (Math.floor(parseFloat(ctr._gridboardproperty._curshape.style.top) / boxSize) + 1) * boxSize :
            (Math.floor(parseFloat(ctr._gridboardproperty._curshape.style.top) / boxSize)) * boxSize;

        var width =
          parseFloat(ctr._gridboardproperty._curshape.style.left) % boxSize > boxSize / 2 ?
            Math.floor(getCSSNumber(ctr._gridboardproperty._curshape, 'width' || 0) / boxSize) * boxSize :
            Math.ceil(getCSSNumber(ctr._gridboardproperty._curshape, 'width' || 0) / boxSize) * boxSize;
        var height =
          parseFloat(ctr._gridboardproperty._curshape.style.top) % boxSize > 15 ?
            Math.floor(getCSSNumber(ctr._gridboardproperty._curshape, 'height' || 0) / boxSize) * boxSize :
            Math.ceil(getCSSNumber(ctr._gridboardproperty._curshape, 'height' || 0) / boxSize) * boxSize;
        if (left >= parseFloat(ctr._gridboardproperty._curshape.parentElement.style.width) - boxSize) {
          ctr._gridboardproperty._curshape.style.left = parseFloat(ctr._gridboardproperty._curshape.parentElement.style.width) - boxSize + 'px';
        } else {
          ctr._gridboardproperty._curshape.style.left = left < 0 ? 0 : left + 'px';
        }
        if (top >= parseFloat(ctr._gridboardproperty._curshape.parentElement.style.height) - boxSize) {
          ctr._gridboardproperty._curshape.style.top = parseFloat(ctr._gridboardproperty._curshape.parentElement.style.height) - boxSize + 'px';
        } else {
          ctr._gridboardproperty._curshape.style.top = top < 0 ? 0 : top + 'px';
        }
        if (width < boxSize) {
          ctr._gridboardproperty._curshape.style.width = boxSize + 'px';
          ctr._gridboardproperty._curshape.style.height = boxSize + 'px';
        } else {
          if (/^(hexagon)$/.test(ctr._gridboardproperty._curshape.getAttribute('data-shape'))) {
            ctr._gridboardproperty._curshape.style.width = (width > height ? height : width) + 'px';
            ctr._gridboardproperty._curshape.style.height = (width > height ? height : width) + 'px';
          } else {
            ctr._gridboardproperty._curshape.style.width = width + 'px';
            ctr._gridboardproperty._curshape.style.height = height + 'px'
          }
        }
        childrenResize(ctr._gridboardproperty._curshape.children[0], false);
      }
    }


    if (shapecreating) {
      shapecreating.classList.remove('mbe-grid-shape-creating');
    }
    insertGroup && insertGroup.parentElement && insertGroup.parentElement.removeChild(insertGroup);
    ctr._gridboardproperty._isInsert = false;
    ctr._gridboardproperty._pointerdown = false;
    ctr._gridboardproperty._dragStart = false;
    ctr._gridboardproperty._dragResizeStartFrom = '';
    ctr._gridboardproperty._dragStartX = 0;
    ctr._gridboardproperty._dragStartY = 0;
    ctr._gridboardproperty._moved = false;
    ctr._gridboardproperty._shape = null;
    ctr._gridboardproperty._curshape = null;
  }
  function setCurFillColor(ev) {
    var el = getAncestors(ev.target, function (el) {
      return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_gridboard';
    }).pop();
    var cur = el.querySelector('.current-active');
    if (cur) {
      cur.children[0].children[0].setAttribute('data-fill-color', ev.target.style.backgroundColor);
      cur.children[0].children[0].style.fill = ev.target.style.backgroundColor;
    }
    [].forEach.call(el.querySelectorAll('.mbe-grid-colors-radius'), function (item, index) {
      if (item.classList.contains('current-color')) {
        item.classList.remove('current-color')
      }
      item.style.removeProperty('box-shadow');
      item.style.removeProperty('border')
    });
    el._gridboardproperty._lastFillColor = ev.target.style.backgroundColor;
    if (el.querySelector('.mbe-grid-colors-group-wrap')) {
      ev.target.style.border = '4px solid rgba(239,143,19,1)';
      ev.target.classList.add('current-color');
    } else {
      ev.target.style.boxShadow = '0px 0px 0px 2px rgba(239,143,19,1)';
      ev.target.style.border = '2px solid rgba(239,143,19,1)';
    }
  }
  function moveSelectionby(el, dx, dy) {
    var hel = el;
    if (dx) {
      if (parseFloat(el.style.left) <= 0) {
        el.style.left = 0 + dx + 'px';
      } else {
        if (parseFloat(el.style.left) + parseFloat(el.style.width) > getCSSNumber(el.parentElement, 'width')) {
          el.style.left = getCSSNumber(el.parentElement, 'width') - parseFloat(el.style.width) + 'px';
        } else {
          el.style.left = parseFloat(el.style.left) + dx + 'px'
        }
      }
    }
    if (dy) {
      if (parseFloat(el.style.top) < 0) {
        el.style.top = 0 + 'px';
      } else {
        if (parseFloat(el.style.top) + parseFloat(el.style.height) > getCSSNumber(el.parentElement, 'height')) {
          el.style.top = getCSSNumber(el.parentElement, 'height') - parseFloat(el.style.height) + 'px';
        } else {
          el.style.top = parseFloat(el.style.top) + dy + 'px'
        }
      }
    }
  }
  function handleResize(x, y, dx, dy, equalProportion, sel) {
    var dRSF = sel._gridboardproperty._dragResizeStartFrom;
    var el = sel._gridboardproperty._curshape;
    //var selP = mainbo_gridboard._curshape.parentElement;
    //var selRect = sel.getBoundingClientRect();
    if (equalProportion === true) {
      var imgProp = sel.getBoundingClientRect();
      var tmp = Math.abs(dx) > Math.abs(dy) ? dx : dy;
      if (dRSF.indexOf("tl") > -1 || dRSF.indexOf("br") > -1) {
        dx = tmp;
        dy = tmp;
      }
      if (dRSF.indexOf("tr") > -1 || dRSF.indexOf("bl") > -1) {
        tmp = Math.abs(tmp);
        if (dx >= 0 && dy <= 0) {
          dx = tmp;
          dy = -tmp;
        } else if (dx <= 0 && dy >= 0) {
          dx = -tmp;
          dy = tmp;
        } else if (dx <= 0 && dy <= 0) {
          dx = -tmp;
          dy = tmp;
        } else if (dx >= 0 && dy >= 0) {
          dx = -tmp;
          dy = tmp;
        }
      }
    }
    if (dRSF.indexOf('t') > -1) {
      resizeStep(el, 0, dy, 0, -dy, sel);
    }
    if (dRSF.indexOf('l') > -1) {
      resizeStep(el, dx, 0, -dx, 0, sel);
    }
    if (dRSF.indexOf('r') > -1) {
      resizeStep(el, 0, 0, dx, 0, sel);
    }
    if (dRSF.indexOf('b') > -1) {
      resizeStep(el, 0, 0, 0, dy, sel);
    }
  }
  function resizeStep(el, dx, dy, dw, dh, sel) {
    if (sel.getAttribute('data-graphicalsize') == 'notfixed') {
      moveStep(el, dx, dy);
      el.style.width = getCSSNumber(el, 'width' || 0) + dw + 'px';
      el.style.height = getCSSNumber(el, 'height' || 0) + dh + 'px';
      //默认情况 第一个元素应该为svg元素
      if (el.children[0].localName == 'svg') {
        childrenResize(el.children[0], true);
      }
    }
  }
  function moveStep(el, dx, dy) {
    var hel = el;
    dx && (hel.style.left = getCSSNumber(hel, 'left') + dx + 'px');
    dy && (hel.style.top = getCSSNumber(hel, 'top') + dy + 'px');
  }
  function getCSSNumber(el, propName) {
    return parseFloat(getCSSValue(el, propName));
  }
  function getCSSValue(el, propName) {
    var cv = el.ownerDocument.defaultView &&
    el.ownerDocument.defaultView.getComputedStyle(el).getPropertyValue(propName);
    return cv || (el.style && el.style.getPropertyValue(propName)) || '';
  }
  function childrenResize(el, move) {
    var shape_type = el.parentElement.getAttribute('data-shape');
    switch (shape_type) {
      case 'rect':
        changeRectSvg(el, move);
      case 'ellipse':
        changeEllipseSvg(el, move);
        break;
      case 'diamond':
        changeDiamondSvg(el, move);
        break;
      case 'hexagon':
        changeHexagonSvg(el, move);
        break;
      case 'uitriangle':
        changeUitriangleSvg(el, move);
        break;
      case 'ditriangle':
        changeDitriangleSvg(el, move);
        break;
      case 'litriangle':
        changeLitriangleSvg(el, move);
        break
      case 'ritriangle':
        changeRitriangleSvg(el, move);
        break;
      case 'urrighttriangle':
        changeURRighttriangleSvg(el, move);
        break;
      case 'drrighttriangle':
        changeDRRighttriangleSvg(el, move);
        break;
      case 'dlrighttriangle':
        changeDLRighttriangleSvg(el, move);
        break;
      case 'ulrighttriangle':
        changeULRighttriangleSvg(el, move);
        break;
      case 'parallelogram':
        changeParallelogramSvg(el, move);
        break;
      case 'trapezoid':
        changeTrapezoidSvg(el, move);
        break;
      default:
        break;
    }

  }
  // 动态创建临时存储区域
  function createInsertGroup(ctr, shape) {
    var insertGroup = ctr.querySelector('.mbe-grid-insert-Group');
    if (insertGroup) {
      insertGroup.innerHTML = '';
      var newshape = shape.cloneNode(true)
      insertGroup.appendChild(newshape);
      ctr._gridboardproperty._curshape = newshape;
    } else {
      var insertEl = '<div class="mbe-grid-insert-Group"></div>';
      ctr.insertAdjacentHTML('beforeEnd', insertEl);
      insertGroup = ctr.querySelector('.mbe-grid-insert-Group');
      var newshape = shape.cloneNode(true)
      insertGroup.appendChild(newshape);
      ctr._gridboardproperty._lastFillColor = ctr.querySelector('.current-color').style.backgroundColor;
      ctr._gridboardproperty._curshape = newshape;
    }
  }

  /**
   * left top Edge
   */
  function isMinLeft(sel) {
    return getCSSNumber(sel, 'left') == 0;
  }
  function isMinTop(sel) {
    return getCSSNumber(sel, 'top') == 0;
  }
  function isMaxleft(sel) {
    var selParent = sel.parentElement;
    return getCSSNumber(sel, 'left') == 0;
  }
  function isMaxTop(sel) {
    var selParent = sel.parentElement;
    return getCSSNumber(sel, 'top') == 0;
  }
  /**
   * min max Width Height
   */
  function isMinWidth(sel) {
    return getCSSNumber(sel, 'min-width') == getCSSNumber(sel, 'width');
  }
  function isMinHeight(sel) {
    return getCSSNumber(sel, 'min-height') == getCSSNumber(sel, 'height');
  }
  function isMaxWidth(sel) {
    var left = getCSSNumber(sel, 'left');
    var borderleft = Math.round(getCSSNumber(sel, 'border-left'));
    var borderright = Math.round(getCSSNumber(sel, 'border-right'));
    var selwidth = getCSSNumber(sel, 'width');
    var pwidth = getCSSNumber(sel.parentElement, 'width');
    return (left + borderleft + borderright + selwidth) >= pwidth;
  }
  function isMaxHeight(sel) {
    var left = getCSSNumber(sel, 'top');
    var bordertop = Math.round(getCSSNumber(sel, 'border-top'));
    var borderbottom = Math.round(getCSSNumber(sel, 'border-bottom'));
    var selheight = getCSSNumber(sel, 'height');
    var pheight = getCSSNumber(sel.parentElement, 'height');
    return (left + bordertop + borderbottom + selheight) >= pheight;
  }

  function getAncestors(node, filter) {
    var ret = [];
    var docType = Node.DOCUMENT_NODE;
    for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
      try {
        if (filter && filter(cur))
          ret.push(cur);
      }
      catch (e) {
        console.warn(e.stack || e);
      }
    }
    return ret;
  }
  function createDragResizeEl(cur) {
    var tl = cur.ownerDocument.createElement('div');
    tl.classList.add('mbe-gridboard-dragresize-tl');
    var tr = cur.ownerDocument.createElement('div');
    tr.classList.add('mbe-gridboard-dragresize-tr');
    var bl = cur.ownerDocument.createElement('div');
    bl.classList.add('mbe-gridboard-dragresize-bl');
    var br = cur.ownerDocument.createElement('div');
    br.classList.add('mbe-gridboard-dragresize-br');
    var de = cur.ownerDocument.createElement('div');
    de.classList.add('mbe-gridboard-delete');

    var topline = cur.ownerDocument.createElement('div');
    topline.classList.add('mbe-gridboard-topline');
    var rightline = cur.ownerDocument.createElement('div');
    rightline.classList.add('mbe-gridboard-rightline');
    var bottomline = cur.ownerDocument.createElement('div');
    bottomline.classList.add('mbe-gridboard-bottomline');
    var leftline = cur.ownerDocument.createElement('div');
    leftline.classList.add('mbe-gridboard-leftline');

    de.addEventListener('click', deleteOnClick)
    cur.appendChild(tl);
    cur.appendChild(tr);
    cur.appendChild(bl);
    cur.appendChild(br);
    cur.appendChild(topline);
    cur.appendChild(rightline);
    cur.appendChild(bottomline);
    cur.appendChild(leftline);
    cur.appendChild(de);
  }
  function removeDragResizeEl(cur) {
    Array.prototype.forEach.call(cur.parentElement.querySelectorAll('[data-shape]'), function (item, index) {
      if (!item.classList.contains('current-active')) {
        if (item.children.length) {
          var svgnode;
          Array.prototype.forEach.call(item.children, function (node, index1) {
            if (node.localName == 'svg') {
              svgnode = node;
            }
          });
          item.innerHTML = ''
          if (svgnode) {
            item.appendChild(svgnode);
          }
        }
      }
    });
  }
  function deleteOnClick(ev) {
    var target = ev.target;
    var ctr = getAncestors(target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_gridboard' }).pop();
    var cur = ctr.querySelector('.current-active');
    cur.parentElement.removeChild(cur);
  }

  function eventInSelectionBox(x, y, ctl) {
    var cb = mainbo_gridboard._curshape.getBoundingClientRect();
    var scale = 1;
    // 选中线框内外的吸附宽度（鼠标在此区域内仍可拖动）
    var snapOut = 4 / scale, snapIn = 6 / scale;
    var oRect = { left: cb.left - snapOut, top: cb.top - snapOut, width: cb.width + 2 * snapOut, height: cb.height + 2 * snapOut };
    var iRect = { left: cb.left + snapIn, top: cb.top + snapIn, width: cb.width - 2 * snapIn, height: cb.height - 2 * snapIn };
    var inORect = isInRect(x, y, oRect);
    var inIRect = isInRect(x, y, iRect);
    if (inORect && !inIRect)
      return true;
    if (ctl)
      return false;
    return inORect;
  }
  function isInRect(x, y, rect) {
    return x >= rect.left && y >= rect.top && x < rect.width + rect.left && y < rect.height + rect.top;
  }
  function onDragstart(ev) {
    ev.preventDefault();
  }

  //拉伸变换过程
  function changeRectSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = parseFloat(selPN.style.width);
    var pH = parseFloat(selPN.style.height);
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = strokeW / 2 + ' ' + strokeW / 2 + ' ';
    var point2 = (pW - strokeW / 2) + ' ' + strokeW / 2 + ' ';
    var point3 = (pW - strokeW / 2) + ' ' + (pH - strokeW / 2) + ' ';
    var point4 = strokeW / 2 + ' ' + (pH - strokeW / 2) + ' ';
    var pointAll = point1 + point2 + point3 + point4;
    elChild.setAttribute('points', pointAll);
  }
  function changeEllipseSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var el_child_ellipse = el.children[0];
    var pW = parseFloat(selPN.style.width);
    var pH = parseFloat(selPN.style.height);
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(el_child_ellipse.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    el_child_ellipse.setAttribute('cx', pW / 2 > 30 ? pW / 2 : 30);
    el_child_ellipse.setAttribute('cy', pH / 2 > 30 ? pH / 2 : 30);
    el_child_ellipse.setAttribute('rx', (pW / 2 - strokeW / 2) > 30 ? (pW / 2 - strokeW / 2) : 29);
    el_child_ellipse.setAttribute('ry', (pH / 2 - strokeW / 2) > 30 ? (pH / 2 - strokeW / 2) : 29);

  }
  function changeDiamondSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var el_child_diamond = el.children[0];
    var pW = getCSSNumber(selPN, 'width');
    var pH = getCSSNumber(selPN, 'height');
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(el_child_diamond.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = pW / 2 + ' ' + strokeW / 2 + ' ';
    var point2 = strokeW / 2 + ' ' + pH / 2 + ' ';
    var point3 = pW / 2 + ' ' + (pH - strokeW / 2) + ' ';
    var point4 = (pW - strokeW / 2) + ' ' + (pH / 2);
    var pointAll = point1 + point2 + point3 + point4;
    el_child_diamond.setAttribute('points', pointAll);
  }
  function changeHexagonSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = getCSSNumber(selPN, 'width');
    var pH = getCSSNumber(selPN, 'height');
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var x = pW / (2 + Math.sqrt(2));
    var y = pH * Math.sqrt(2) / (2 + Math.sqrt(2));
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = x + ' ' + strokeW / 2 + ' ';
    var point2 = (x + y) + ' ' + strokeW / 2 + ' ';
    var point3 = (pW - strokeW / 2) + ' ' + pH / 2 + ' ';
    var point4 = (x + y) + ' ' + (pH - strokeW / 2) + ' ';
    var point5 = x + ' ' + (pH - strokeW / 2) + ' ';
    var point6 = strokeW / 2 + ' ' + pH / 2;
    var pointAll = point1 + point2 + point3 + point4 + point5 + point6;
    elChild.setAttribute('points', pointAll);
  }
  function changeUitriangleSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = getCSSNumber(selPN, 'width');
    var pH = getCSSNumber(selPN, 'height');
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = pW / 2 + ' ' + strokeW / 2 + ' ';
    var point2 = (pW - strokeW / 2) + ' ' + (pH - strokeW / 2) + ' ';
    var point3 = strokeW / 2 + ' ' + (pH - strokeW / 2) + ' ';
    var pointAll = point1 + point2 + point3;
    elChild.setAttribute('points', pointAll);
  }
  function changeDitriangleSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = getCSSNumber(selPN, 'width');
    var pH = getCSSNumber(selPN, 'height');
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = pW / 2 + ' ' + (pH - strokeW / 2) + ' ';
    var point2 = strokeW / 2 + ' ' + strokeW / 2 + ' ';
    var point3 = (pW - strokeW / 2) + ' ' + strokeW / 2 + ' ';
    var pointAll = point1 + point2 + point3;
    elChild.setAttribute('points', pointAll);
  }
  function changeLitriangleSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = getCSSNumber(selPN, 'width');
    var pH = getCSSNumber(selPN, 'height');
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = strokeW / 2 + ' ' + pH / 2 + ' ';
    var point2 = (pW - strokeW / 2) + ' ' + strokeW / 2 + ' ';
    var point3 = (pW - strokeW / 2) + ' ' + (pH - strokeW / 2) + ' ';
    var pointAll = point1 + point2 + point3;
    elChild.setAttribute('points', pointAll);
  }
  function changeRitriangleSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = getCSSNumber(selPN, 'width');
    var pH = getCSSNumber(selPN, 'height');
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = (pW - strokeW / 2) + ' ' + pH / 2 + ' ';
    var point2 = strokeW / 2 + ' ' + strokeW / 2 + ' ';
    var point3 = strokeW / 2 + ' ' + (pH - strokeW / 2) + ' ';
    var pointAll = point1 + point2 + point3;
    elChild.setAttribute('points', pointAll);
  }
  function changeURRighttriangleSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = getCSSNumber(selPN, 'width');
    var pH = getCSSNumber(selPN, 'height');
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = (strokeW / 2) + ' ' + (strokeW / 2) + ' ';
    var point2 = (strokeW / 2) + ' ' + (pH - strokeW / 2) + ' ';
    var point3 = (pW - strokeW / 2) + ' ' + (pH - strokeW / 2) + ' ';
    var pointAll = point1 + point2 + point3;
    elChild.setAttribute('points', pointAll);
  }
  function changeDRRighttriangleSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = getCSSNumber(selPN, 'width');
    var pH = getCSSNumber(selPN, 'height');
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = (strokeW / 2) + ' ' + (strokeW / 2) + ' ';
    var point2 = (strokeW / 2) + ' ' + (pH - strokeW / 2) + ' ';
    var point3 = (pW - strokeW / 2) + ' ' + (strokeW / 2) + ' ';
    var pointAll = point1 + point2 + point3;
    elChild.setAttribute('points', pointAll);
  }
  function changeDLRighttriangleSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = getCSSNumber(selPN, 'width');
    var pH = getCSSNumber(selPN, 'height');
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = (strokeW / 2) + ' ' + (strokeW / 2) + ' ';
    var point2 = (pW - strokeW / 2) + ' ' + (pH - strokeW / 2) + ' ';
    var point3 = (pW - strokeW / 2) + ' ' + (strokeW / 2) + ' ';
    var pointAll = point1 + point2 + point3;
    elChild.setAttribute('points', pointAll);
  }
  function changeULRighttriangleSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = getCSSNumber(selPN, 'width');
    var pH = getCSSNumber(selPN, 'height');
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = (strokeW / 2) + ' ' + (pH - strokeW / 2) + ' ';
    var point2 = (pW - strokeW / 2) + ' ' + (pH - strokeW / 2) + ' ';
    var point3 = (pW - strokeW / 2) + ' ' + (strokeW / 2) + ' ';
    var pointAll = point1 + point2 + point3;
    elChild.setAttribute('points', pointAll);
  }
  function changeParallelogramSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = parseFloat(selPN.style.width);
    var pH = parseFloat(selPN.style.height);
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = pW / 4 + ' ' + strokeW / 2 + ' ';
    var point2 = (pW - strokeW / 2) + ' ' + strokeW / 2 + ' ';
    var point3 = pW / 4 * 3 + ' ' + (pH - strokeW / 2) + ' ';
    var point4 = strokeW / 2 + ' ' + (pH - strokeW / 2) + ' ';
    var pointAll = point1 + point2 + point3 + point4;
    elChild.setAttribute('points', pointAll);
  }
  function changeTrapezoidSvg(el, move) {
    var boxSize = 60;
    var selPN = el.parentElement;
    var sel = el;
    var elChild = el.children[0];
    var pW = parseFloat(selPN.style.width);
    var pH = parseFloat(selPN.style.height);
    if (pW < boxSize) {
      pW = boxSize;
    }
    if (pH < boxSize) {
      pH = boxSize;
    }
    var strokeW = parseFloat(elChild.getAttribute('data-stroke-width'));
    sel.style.width = pW + 'px';
    sel.style.height = pH + 'px';
    var point1 = pW / 4 + ' ' + strokeW / 2 + ' ';
    var point2 = pW / 4 * 3 + ' ' + strokeW / 2 + ' ';
    var point3 = (pW - strokeW / 2) + ' ' + (pH - strokeW / 2) + ' ';
    var point4 = strokeW / 2 + ' ' + (pH - strokeW / 2) + ' ';
    var pointAll = point1 + point2 + point3 + point4;
    elChild.setAttribute('points', pointAll);
  }
  mainbo_gridboard.init = init;
})(etb_controls.mainbo_gridboard || (etb_controls.mainbo_gridboard = {}));
