(function(mainbo_fun_math) {
  mainbo_fun_math.init = init;

  function init(el) {
    setEditing(el);
  }

  function setEditing(el) {
    if (!el.mainbo_fun_math) el.mainbo_fun_math = {
      moveObj: null,
      pointerdownFlag: false,
      toDelete: null,
      delIconContainerWidth: 16,
      delIconContainerHeight: 16,
      delIconContainerVeriialGap: 4,
      imgGroupPaddingLeft: 5,
      imgHorizontalGap: 5,
      imgVerticalGap: 8
    }
    el.addEventListener('dragstart', dragstart);
    el.querySelector(".rallying").addEventListener("touchstart", dragstart)
    Array.prototype.forEach.call(el.querySelectorAll(".imggroup img"),
      function(item) {
        item.addEventListener("touchstart", dragstart);
      });
    el.addEventListener("pointerdown", pointerdown);
    el.addEventListener("pointermove", pointermove);
    el.addEventListener("pointerup", pointerup);
    Array.prototype.forEach.call(
      el.querySelectorAll(".itme-container"),
      function(item) {
        item.addEventListener("click", insert)
      }
    );
    // 清除
    el.querySelector(".clear").addEventListener("click", clear);
  }

  function stopPropagation(ev) {
    ev.stopPropagation();
  }

  function dragstart(ev) {
    ev.preventDefault();
  }

  function insert(ev) {
    var itemContainer = getAncestors(ev.target, function(el) {
      return el.classList.contains("itme-container")
    }).pop();
    var fun_math = getAncestors(
      ev.target,
      function(el) {
        return el.hasAttribute("data-control") && el.getAttribute("data-control") == "mainbo_fun_math"
      }
    ).pop();
    var img = itemContainer.querySelector("img").cloneNode(true);
    var rallying = fun_math.querySelector(".rallying");
    if (img) {
      var top = rallying.style.top == "0px" ? 0 : parseFloat(rallying.style.top) ||
        (fun_math.mainbo_fun_math.delIconContainerHeight + fun_math.mainbo_fun_math.delIconContainerVeriialGap),
        left = rallying.style.left == "0px" ? 0 : parseFloat(rallying.style.left) || +fun_math.mainbo_fun_math.imgGroupPaddingLeft;
      img.classList.add("imgmove");
      img.style.top = top + "px";
      img.style.left = left + "px";
      img.a
      fun_math.querySelector(".imggroup").appendChild(img);
      next(ev, img.getBoundingClientRect().width, img.getBoundingClientRect().height);
    }
  }

  function next(ev, imgW, imgH, resetRallying) {
    var etbPage = getAncestors(ev.target,
      function(el) {
        return el.classList.contains("etb-page")
      })[0];
    var fun_math = getAncestors(
      ev.target,
      function(el) {
        return el.hasAttribute("data-control") && el.getAttribute("data-control") == "mainbo_fun_math"
      }
    ).pop();
    var imggroupRect = fun_math.querySelector(".imggroup").getBoundingClientRect();
    var rallying = fun_math.querySelector(".rallying");
    var rallyingRect = rallying.getBoundingClientRect();
    if (resetRallying === true) {
      rallying.style.top = fun_math.mainbo_fun_math.delIconContainerHeight +
        fun_math.mainbo_fun_math.delIconContainerVeriialGap + "px";
      rallying.style.left = "5px";
      return;
    }
    if (rallyingRect.right > (imggroupRect.right - rallyingRect.width)) {
      rallying.style.top = ((parseFloat(rallying.style.top) || 0) + (imgH + fun_math.mainbo_fun_math.imgVerticalGap)) + "px";
      rallying.style.left = "5px";
      if (imgH > (imggroupRect.bottom - rallyingRect.bottom)) {
        rallying.style.top = fun_math.mainbo_fun_math.delIconContainerHeight +
          fun_math.mainbo_fun_math.delIconContainerVeriialGap + "px";
        rallying.style.left = "5px";
      }
    } else {
      rallying.style.left = ((parseFloat(rallying.style.left) || 0) + (imgW + fun_math.mainbo_fun_math.imgHorizontalGap)) + "px";
    }
  }

  function clear(ev) {
    var fun_math = getAncestors(ev.target,
      function(el) {
        return el.hasAttribute("data-control") && el.getAttribute("data-control") == "mainbo_fun_math"
      }
    ).pop();
    var imggroup = fun_math.querySelector(".imggroup");
    imggroup.innerHTML = '';
    next(ev, 0, 0, true);
  }

  function delItem(el) {
    if (el.mainbo_fun_math.toDelete) {
      el.mainbo_fun_math.toDelete.parentNode.removeChild(el.mainbo_fun_math.toDelete);
    }
  }

  //el-fun_math type 1-显示 0-隐藏
  function handlerDelIcon(el, type) {
    var fun_math = el,
      delIconContainer = fun_math.querySelector(".delIconContainer"),
      moveObj = fun_math.mainbo_fun_math.moveObj,
      moveObjRect = moveObj.getBoundingClientRect();
    if (!delIconContainer) return false;
    switch (type) {
      case 0:
        delIconContainer.style.display = "none";
        break;
      case 1:
        fun_math.mainbo_fun_math.toDelete = moveObj;
        delIconContainer.style.top = parseFloat(moveObj.style.top) -
          (fun_math.mainbo_fun_math.delIconContainerHeight +
            fun_math.mainbo_fun_math.delIconContainerVeriialGap) + "px";
        delIconContainer.style.left = parseFloat(moveObj.style.left) +
          moveObjRect.width - +fun_math.mainbo_fun_math.delIconContainerWidth + "px";
        delIconContainer.style.display = "block";
        break;
      default:
        break;
    }
  }

  function addClass(ev, type) {
    var fun_math = getAncestors(ev.target,
      function(el) {
        return el.classList.contains("fun_math")
      })[0];
    var imgs = fun_math.querySelectorAll(".imggroup img");
    Array.prototype.forEach.call(imgs, function(img) {
      img.classList.remove("active");
    });
    type && fun_math.mainbo_fun_math.moveObj.classList.add("active");
  }

  function pointerdown(ev) {
    var ctr = getAncestors(ev.target,
      function(el) {
        return el.classList.contains("fun_math")
      })[0];
    var temp = ev.target;
    // 禁止整个控件的移动
    if (temp.classList.contains("fun_math") || temp.classList.contains("imggroup")) return false;
    ctr.mainbo_fun_math.moveObj = temp;
    ctr.mainbo_fun_math.pointerdownFlag = true
    var moveObjRect = ctr.mainbo_fun_math.moveObj.getBoundingClientRect();
    var _x = ev.clientX - moveObjRect.left;
    var _y = ev.clientY - moveObjRect.top;
    ctr.mainbo_fun_math.moveObj.dataset['x'] = _x;
    ctr.mainbo_fun_math.moveObj.dataset['y'] = _y;
    if (temp.nodeName.toLocaleLowerCase() == "img" && temp.parentElement.classList.contains("imggroup")) {
      addClass(ev, 1);
      handlerDelIcon(ctr, 1);
    } else {
      addClass(ev, 0);
      handlerDelIcon(ctr, 0);
    }
    var delIcon = getAncestors(ev.target, function(el) {
      return el.classList.contains("delIconContainer")
    }).pop();
    if (delIcon) delItem(ctr);
  }

  function pointerup(ev) {
    var ctr = getAncestors(ev.target,
      function(el) {
        return el.classList.contains("fun_math")
      })[0];
    ctr.mainbo_fun_math.moveObj = null;
    ctr.mainbo_fun_math.pointerdownFlag = false;
  }

  function pointermove(event) {
    var fun_math = getAncestors(event.target,
      function(el) {
        return el.classList.contains("fun_math")
      })[0];
    if (!fun_math) return;
    var moveObj = fun_math.mainbo_fun_math.moveObj,
      moveObjRect = moveObj.getBoundingClientRect();
    if (!moveObj && !fun_math.mainbo_fun_math.pointerdownFlag) return false;
    var imggroupRect = fun_math.querySelector(".imggroup").getBoundingClientRect();
    var _x = moveObj.dataset['x'];
    var _y = moveObj.dataset['y'];
    if (event.clientX - _x <= imggroupRect.left) {
      // 左边界
      moveObj.style.left = 0 + "px";
    } else if (event.clientX - _x >= (imggroupRect.right - moveObjRect.width)) {
      // 右边界
      moveObj.style.left = (imggroupRect.width - moveObjRect.width) + "px";
    } else {
      moveObj.style.left = (event.clientX - imggroupRect.left - _x) + "px";
    }
    if (event.clientY - _y <= imggroupRect.top) {
      // 上边界
      moveObj.style.top = 0 + "px";
    } else if ((event.clientY - _y) >= (imggroupRect.bottom - moveObjRect.height)) {
      // 下边界
      moveObj.style.top = (imggroupRect.height - moveObjRect.height) + "px";
    } else {
      moveObj.style.top = ((event.clientY - imggroupRect.top - _y)) + "px";
    }
    if (moveObj.nodeName.toLocaleLowerCase() == "img" && moveObj.parentElement.classList.contains("imggroup")) {
      handlerDelIcon(fun_math, 1);
    } else {
      handlerDelIcon(fun_math, 0);
    }
  }

  function getAncestors(node, filter) {
    var ret = [];
    var docType = Node.DOCUMENT_NODE;
    for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
      try {
        if (filter && filter(cur))
          ret.push(cur);
      } catch (e) {
        console.warn(e.stack || e);
      }
    }
    return ret;
  }

})(mainbo_fun_math = etb_controls.mainbo_fun_math || (etb_controls.mainbo_fun_math = {}))