﻿(function (mainbo_freedrag) {
  function init(el) {
    if (!el._freedragproperty) {
      el._freedragproperty = {};
      el._freedragproperty.pointdown = false;
      el._freedragproperty.this_editing = false;
      el._freedragproperty.dragt = null;
      el._freedragproperty.pos = { x: 0, y: 0, l: 0, t: 0 };
      el._freedragproperty.temp = { x: 0, y: 0 }
      el._freedragproperty.percentO = {
        pW: 1,
        pH: 1
      }
    }
    if (el.classList.contains('stop')) {
      el.classList.remove('stop');
    }
    var content = el.querySelector('.mainbo_freedrag_content');
    var answer = el.querySelector('.mainbo_freedrag_content_answer');
    el.addEventListener('touchstart',preventDefault)
    el.addEventListener('click', stopPropagation);
    content.addEventListener('dragstart', ondragstart);
    content.addEventListener('pointerdown', onpointdown);
    content.addEventListener('pointermove', onpointermove);
    content.addEventListener('pointerup', onpointerup);
    for (var i = 0 ; i < el.querySelectorAll('.item').length; i++) {
      var item = el.querySelectorAll('.item')[i];
      if (item.getAttribute('value') == 'check') {
        item.addEventListener('click', check);
      }
      else if (item.getAttribute('value') == 'show') {
        item.addEventListener('click', show);
      }
      else if (item.getAttribute('value') == 'repeat') {
        item.addEventListener('click', repeat);
      }
    };
    content.querySelector('.mainbo_freedrag_svgmask').addEventListener('click', function (ev) {
      content.querySelector('.mainbo_freedrag_svgmask').style.display = 'none';
    })
    for (var i = 0, len = answer.children.length; i < len; i++) {
      var answer_client = etb_book.offSetRect(answer);
      var answer_c_client = etb_book.offSetRect(answer.children[i]);
      var answer_c_el_left = Math.random() * (answer_client.right - answer_client.left - answer_c_client.width);
      var answer_c_el_top = Math.random() * (answer_client.bottom - answer_client.top - answer_c_client.height);
      answer.children[i].style.left = answer_c_el_left + 'px';
      answer.children[i].style.top = answer_c_el_top + 'px';
      answer.children[i].dataset['rposition'] = answer_c_el_left + ',' + answer_c_el_top;
    }
  }
  mainbo_freedrag.init = init;
  function stopPropagation(ev) {
    ev.stopPropagation();
  }
  function preventDefault(ev) {
      ev.preventDefault();
  }
  //drag area content
  function ondragstart(ev) {
    ev.preventDefault();
  }
  function onpointdown(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_freedrag' }).pop();
    var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
    if (ev.button == 0) {
      this_el._freedragproperty.pointdown = true;
      if (this_el.querySelector('.mainbo_freedrag_content_answer').compareDocumentPosition(ev.target) == 20) {
        this_el._freedragproperty.dragt = ev.target;
        this_el._freedragproperty.dragt.style.zIndex = '1';
        //if (this_el._freedragproperty.dragt) {
        this_el._freedragproperty.pos = {
          x: !etbpage.etbScale ? ev.clientX : ev.clientX / etbpage.etbScale,
          y: !etbpage.etbScale ? ev.clientY : ev.clientY / etbpage.etbScale,
          l: parseFloat(ev.target.style.left),
          t: parseFloat(ev.target.style.top)
        };
        //}
      }
    }
    else {
      return;
    }
  }
  function onpointermove(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_freedrag' }).pop();
    var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
    this_el._freedragproperty.temp = {
      x: !etbpage.etbScale ? ev.clientX : ev.clientX / etbpage.etbScale,
      y: !etbpage.etbScale ? ev.clientY : ev.clientY / etbpage.etbScale
    };
    var this_el_scale = !etbpage.etbScale ? 1 : etbpage.etbScale;
    var ClientRectquest = this_el.querySelector('.mainbo_freedrag_content').getBoundingClientRect();
    var ClientA = this_el.querySelector('.mainbo_freedrag_content_answer').getBoundingClientRect();
    if (this_el._freedragproperty.pointdown) {
      if (this_el._freedragproperty.dragt) {
        //var w = parseInt(getComputedStyle(etbpage, null).width), h = parseInt(getComputedStyle(etbpage, null).height);
        //var w1 = parseInt(getComputedStyle(this_el, null).width), h1 = parseInt(getComputedStyle(this_el, null).height);
        var xfa, yfa;
        if (this_el_scale != 1) {
          xfa =
         Math.min(
                 Math.max(
                   (this_el._freedragproperty.temp.x - this_el._freedragproperty.pos.x)
                   /*+ ((w1 / w) * etbpage.etbScale / innerWidth * (w / 2)) */
                  + this_el._freedragproperty.pos.l
                   ,
                   (ClientRectquest.left - ClientA.left) / etbpage.etbScale
                 )
                 ,
                 (ClientRectquest.right - ClientA.left) / etbpage.etbScale - parseFloat(this_el._freedragproperty.dragt.style.width)
         );
          yfa =
         Math.min(
                 Math.max(
                   (this_el._freedragproperty.temp.y - this_el._freedragproperty.pos.y)
                   /*+ ((h1 / h) * etbpage.etbScale / innerWidth * (h / 2)) */
                  + this_el._freedragproperty.pos.t
                   ,
                   (ClientRectquest.top - ClientA.top) / etbpage.etbScale
                 )
                 ,
                 (ClientRectquest.bottom - ClientA.top) / etbpage.etbScale - parseFloat(this_el._freedragproperty.dragt.style.height)
          );
        } else {
          xfa = Math.min(Math.max((this_el._freedragproperty.temp.x - this_el._freedragproperty.pos.x + this_el._freedragproperty.pos.l), ClientRectquest.left - ClientA.left), ClientRectquest.right - ClientA.left - parseFloat((this_el._freedragproperty.dragt).style.width));
          yfa = Math.min(Math.max((this_el._freedragproperty.temp.y - this_el._freedragproperty.pos.y + this_el._freedragproperty.pos.t), ClientRectquest.top - ClientA.top), ClientRectquest.bottom - ClientA.top - parseFloat((this_el._freedragproperty.dragt).style.height));
        }
        this_el._freedragproperty.dragt.style.left = xfa + 'px';
        this_el._freedragproperty.dragt.style.top = yfa + 'px';
      }
      //if (this_el._freedragproperty.temp.x < ClientRectquest.left || this_el._freedragproperty.temp.y < ClientRectquest.top || this_el._freedragproperty.temp.x > ClientRectquest.right || this_el._freedragproperty.temp.y > ClientRectquest.bottom) {
      //  if (this_el._freedragproperty.dragt) {
      //    if (this_el._freedragproperty.dragt.style.zIndex) {
      //      this_el._freedragproperty.dragt.style.removeProperty('z-index');
      //    }
      //    this_el._freedragproperty.dragt = null;
      //  }
      //}
    }
    else {
      this_el._freedragproperty.dragt = null;
    }
  }
  function onpointerup(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_freedrag' }).pop();
    var this_el_answer = this_el.querySelector('.mainbo_freedrag_content_answer');
    if (this_el._freedragproperty.dragt) {
      for (var i = 0; i < this_el_answer.children.length; i++) {
        if (this_el._freedragproperty.dragt === this_el_answer.children[i]) {
          var this_c_el = this_el.querySelector('.mainbo_freedrag_content');
          //若为编辑状态则赋值 否则做判断
          var dragt_relationp = _relativep(etb_book.offSetRect(this_el._freedragproperty.dragt), etb_book.offSetRect(this_c_el));
          var dragt_datap = {
            top: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[0]),
            right: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[1]),
            bottom: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[2]),
            left: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[3]),
            width: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[4]),
            height: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[5]),
          }
          var this_clientRect_a_resize = _resize(dragt_datap, true);
          if (_containrelationp(dragt_relationp, this_clientRect_a_resize)) {
          }
          else {
            //过程判断
            if (this_el.dataset['_type'] != 'result') {
              this_el_answer.children[i].style.left = this_el_answer.children[i].dataset['rposition'].split(',')[0] + 'px';
              this_el_answer.children[i].style.top = this_el_answer.children[i].dataset['rposition'].split(',')[1] + 'px';
            }

          }
        }
      }
      if (this_el._freedragproperty.dragt && this_el._freedragproperty.dragt.style.zIndex) {
        this_el._freedragproperty.dragt.style.removeProperty('z-index');
      }
      this_el._freedragproperty.pointdown = false;
      this_el._freedragproperty.dragt = null;
    }
  }
  function checkmask(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_freedrag' }).pop();
    this_el.querySelector('.mainbo_freedrag_svgmask').style.display = 'none';
  }
  //get the percent of the img
  function getPercentImg(el) {
    var question = el.querySelector('.mainbo_freedrag_content_question');
    var questionR = etb_book.offSetRect(question);
    //if exist the backgroundImage return the percent  else return the 100% origin 
    if (question.children.length != 0) {
      image = question.childNodes[0];
      var percentW = questionR.width / image.naturalWidth;
      var percentH = questionR.height / image.naturalHeight;
      return {
        pW: percentW,
        pH: percentH
      };
    }
    else {
      return {
        pW: 1,
        pH: 1
      };
    }
  }
  //check
  function check(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_freedrag' }).pop();
    Array.prototype.slice.call(this_el.querySelectorAll('.item'), 0).forEach(function (item) {
      if (item.getAttribute('value') == 'check') {
        item.setAttribute('hidden', 'hidden')
      }
      if (item.getAttribute('value') == 'show') {
        item.removeAttribute('hidden');
      }
    });
    var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
    if (etbpage.etbScale) {
      this_el_etbScale = etbpage.etbScale != 1 ? etbpage.etbScale : 1;
    } else {
      this_el_etbScale = 1;
    }
    //var w = parseInt(getComputedStyle(etbpage, null).width), h = parseInt(getComputedStyle(etbpage, null).height);
    //var w1 = parseInt(getComputedStyle(this_el, null).width), h1 = parseInt(getComputedStyle(this_el, null).height);
    var f = false;
    var check_bool_arr = [];
    check.length = 0;
    var this_c_el = this_el.querySelector('.mainbo_freedrag_content');
    var question = this_el.querySelector('.mainbo_freedrag_content_question');
    var answer = this_el.querySelector('.mainbo_freedrag_content_answer');
    //if (this_el_etbScale == 1) {
    //  var questionrelationp = _relativep(etb_book.offSetRect(question), etb_book.offSetRect(this_c_el));
    //} else {
    //  var questionrelationp = _relativep(question.getBoundingClientRect(), this_c_el.getBoundingClientRect());
    //}
    if (answer.children.length == 0) {
      return false;
    }
    var answerfilter = [];
    //过滤正确答案,是否在左边区域
    /* 包含关系
    for (var i = 0; i < answer.children.length; i++) {
      var acr = { top: 0, right: 0, bottom: 0, left: 0, width: 0, height: 0 };
      var acrd = answer.children[i].dataset['relativeposition'];
      if (this_el_etbScale == 1) {
        acr.top = parseFloat(acrd.split(',')[0]);
        acr.right = parseFloat(acrd.split(',')[1]);
        acr.bottom = parseFloat(acrd.split(',')[2]);
        acr.left = parseFloat(acrd.split(',')[3]);
        acr.width = parseFloat(acrd.split(',')[4]);
        acr.height = parseFloat(acrd.split(',')[5]);
        if (_containrelationp(acr, questionrelationp)) {
          answerfilter.push(answer.children[i]);
        } else {

        }
      } else {
        //原始对象的盒子
        acr.top = parseFloat(acrd.split(',')[0]);
        acr.right = parseFloat(acrd.split(',')[1]);
        acr.bottom = parseFloat(acrd.split(',')[2]);
        acr.left = parseFloat(acrd.split(',')[3]);
        acr.width = parseFloat(acrd.split(',')[4]);
        acr.height = parseFloat(acrd.split(',')[5]);
        //当前盒子需要除以放大或缩小系数与 原始盒子对比
        questionrelationp.left = questionrelationp.left / this_el_etbScale;
        questionrelationp.top = questionrelationp.top / this_el_etbScale;
        questionrelationp.right = questionrelationp.right / this_el_etbScale;
        questionrelationp.bottom = questionrelationp.bottom / this_el_etbScale;
        questionrelationp.width = questionrelationp.width / this_el_etbScale;
        questionrelationp.height = questionrelationp.height / this_el_etbScale;
        if (_containrelationp(acr, questionrelationp)) {
          answerfilter.push(answer.children[i]);
        } else {

        }
      }
    }
    */
    //TODO 是否需要相交过滤 ? 
    for (var i = 0; i < answer.children.length; i++) {
      var questionRect = etb_book.offSetRect(question);
      var answerRect = etb_book.offSetRect(answer.children[i]);
      if (_detectCollision(questionRect, answerRect)) {
        answerfilter.push(answer.children[i]);
      }
    }
    //TODO 是否需要对过滤的正确答案做相应
    //if (answerfilter.length == 0) {
    //  return false;
    //}
    for (var i = 0; i < answerfilter.length; i++) {
      var an_o_rect = answerfilter[i].getBoundingClientRect();
      var this_cel_o_rect = this_c_el.getBoundingClientRect();
      //etb_book.offSetRect(this_c_el);
      var answer_child_relationp = _relativep(an_o_rect, this_cel_o_rect);
      var acr = { top: 0, right: 0, bottom: 0, left: 0, width: 0, height: 0 };
      var acrd = answerfilter[i].dataset['relativeposition'];
      if (this_el_etbScale > 1 || this_el_etbScale == 1) {
        acr.top = parseFloat(acrd.split(',')[0]) / this_el_etbScale;
        acr.right = parseFloat(acrd.split(',')[1]) / this_el_etbScale;
        acr.bottom = parseFloat(acrd.split(',')[2]) / this_el_etbScale;
        acr.left = parseFloat(acrd.split(',')[3]) / this_el_etbScale;
        acr.width = parseFloat(acrd.split(',')[4]) / this_el_etbScale;
        acr.height = parseFloat(acrd.split(',')[5]) / this_el_etbScale;
      } else {
        acr.top = parseFloat(acrd.split(',')[0]) * this_el_etbScale;
        acr.right = parseFloat(acrd.split(',')[1]) * this_el_etbScale;
        acr.bottom = parseFloat(acrd.split(',')[2]) * this_el_etbScale;
        acr.left = parseFloat(acrd.split(',')[3]) * this_el_etbScale;
        acr.width = parseFloat(acrd.split(',')[4]) * this_el_etbScale;
        acr.height = parseFloat(acrd.split(',')[5]) * this_el_etbScale;
      }
      var this_clientRect_a_resize = _resize(acr, true);
      if (this_el.dataset['_type'] == 'result') {
        if (_containrelationp(answer_child_relationp, this_clientRect_a_resize)) {
          check_bool_arr.push(true);
        }
        else {
          check_bool_arr.push(false);
        }
      } else {
        return;
      }

      f = check_bool_arr.every(function (item) {
        return item === true;
      })
      var mask = this_el.querySelector('.mainbo_freedrag_svgmask');
      if (f && check_bool_arr.length > 0 && check_bool_arr.length === this_el.dataset['rightanswer'].length) {
        mask.innerHTML = '';
        mask.style.display = 'flex';
        mask.appendChild(createCorrectMark(this_el))
      }
      else {
        mask.innerHTML = '';
        mask.style.display = 'flex';
        mask.appendChild(createErrorMark(this_el))
      }
    }
  }
  //show
  function show(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_freedrag' }).pop();
    this_el.querySelector('.mainbo_freedrag_svgmask').style.display = 'none';
    var answer = this_el.querySelector('.mainbo_freedrag_content_answer');
    for (var i = 0, len = answer.children.length; i < len; i++) {
      var orleft = answer.children[i].dataset['lefttop'].split(',')[0];
      var ortop = answer.children[i].dataset['lefttop'].split(',')[1];
      answer.children[i].style.left = orleft + 'px';
      answer.children[i].style.top = ortop + 'px';
    }
  }
  //repeat
  function repeat(ev) {
    var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_freedrag' }).pop();
    var etbpage = getAncestors(this_el, function (el) { return el.classList.contains('etb-page') }).pop();
    if (etbpage.etbScale) {
      this_el_etbScale = etbpage.etbScale != 1 ? etbpage.etbScale : 1;
    } else {
      this_el_etbScale = 1;
    }
    this_el.querySelector('.mainbo_freedrag_svgmask').style.display = 'none';
    this_el.querySelector('.mainbo_freedrag_svgmask').style.display = 'none';
    if (this_el.dataset['_type'] == 'process') {
      Array.prototype.slice.call(this_el.querySelectorAll('.item'), 0).forEach(function (item) {
        if (item.getAttribute('value') == 'check') {
          item.setAttribute('hidden', 'hidden');
        } else if (item.getAttribute('value') == 'show') {
          if (item.getAttribute('hidden')) {
            item.removeAttribute('hidden');
          }
        } else {

        }
      });
    } else {
      Array.prototype.slice.call(this_el.querySelectorAll('.item'), 0).forEach(function (item) {
        if (item.getAttribute('value') == 'check') {
          item.removeAttribute('hidden');
        } else if (item.getAttribute('value') == 'show') {
          item.setAttribute('hidden', 'hidden');
        } else {

        }
      });
    }
    //重做一次的 第一种 方式 恢复到最初的形式
    //var answer = this_el.querySelector('.mainbo_freedrag_content_answer');
    //for (var i = 0; i < answer.children.length; i++) {
    //    answer.children[i].style.left = answer.children[i].dataset['rposition'].split(',')[0] + 'px';
    //    answer.children[i].style.top = answer.children[i].dataset['rposition'].split(',')[1] + 'px';
    //}
    //重做一次的 第二种形式 重新随机排列
    var answer = this_el.querySelector('.mainbo_freedrag_content_answer');
    for (var i = 0, len = answer.children.length; i < len; i++) {
      var answer_client = etb_book.offSetRect(answer);
      var answer_c_client = etb_book.offSetRect(answer.children[i]);
      var answer_c_el_left = Math.random() * (answer_client.right - answer_client.left - answer_c_client.width);
      var answer_c_el_top = Math.random() * (answer_client.bottom - answer_client.top - answer_c_client.height);
      answer.children[i].dataset['rposition'] = answer_c_el_left + ',' + answer_c_el_top;
      answer.children[i].style.left = answer_c_el_left / this_el_etbScale + 'px';
      answer.children[i].style.top = answer_c_el_top / this_el_etbScale + 'px';
    }
  }
  //right mark
  function createCorrectMark(el) {
    var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'), path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
    svg.setAttribute('class', 'svgmask imatch_svgright');
    path.setAttribute('stroke', 'green');
    path.setAttribute('fill', 'green');
    path.setAttribute('d', 'M 3 68 c 0 0 10 -11 22 -12 c 0 0 7 11 15 10 C 40 64 52 5 98 0 c 0 0 -38 22 -42 82 c -0.8 1.6 -19 12 -21 12 C 32 93 12 65 3 68z');
    svg.appendChild(path);
    return svg;
  }
  //false mark
  function createErrorMark(el) {
    var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'), path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
    svg.setAttribute('class', 'svgmask imatch_svgmistake');
    path.setAttribute('stroke', 'red');
    path.setAttribute('fill', 'red');
    path.setAttribute('d', 'M 89 0 L 51 38 L 13 0 C 8 4 4 8 0 13 l 38 38 L 0 90 c 4 5 8 9 13 13 L 50 65 L 90 100 c 5 -4 9 -8 13 -13 L 65 50 L 100 13 C 98 8 94 4 90 0z');
    svg.appendChild(path);
    return svg;
  }
  //retangle
  function _detectCollision(Bs1, Bs2) {
    return (Math.max(Bs1.right - Bs2.left, Bs2.right - Bs1.left) < Bs1.width + Bs2.width) && (Math.max(Bs1.bottom - Bs2.top, Bs2.bottom - Bs1.top) < Bs1.height + Bs2.height);
  }
  //reSize  bool为true 表示范围扩大   false 表示范围缩小
  function _resize(Bs1, bool) {
    if (bool) {
      return {
        left: Bs1.left - Bs1.width * 0.2,
        right: Bs1.right - Bs1.width * 0.2,
        top: Bs1.top - Bs1.height * 0.2,
        bottom: Bs1.bottom - Bs1.height * 0.2,
        width: Bs1.width,
        height: Bs1.height
      };
    }
    else {
      return {
        left: Bs1.left + Bs1.width * 0.2,
        right: Bs1.right + Bs1.width * 0.2,
        top: Bs1.top + Bs1.height * 0.2,
        bottom: Bs1.bottom + Bs1.height * 0.2,
        width: Bs1.width,
        height: Bs1.height
      };
    }
  }
  //Bs1为小  Bs2为大
  function _containrelationp(Bs1, Bs2) {
    return Bs1.left > Bs2.left && Bs1.right > Bs2.right && Bs1.top > Bs2.top && Bs1.bottom > Bs2.bottom;
  }
  //contains Bs1为被包含(小) Bs2为包含(大) 误差为20% Bs2扩大20%
  function _containCollision(Bs1, Bs2) {
    return Bs1.top > Bs2.top && Bs1.right < Bs2.right && Bs1.bottom < Bs2.bottom && Bs1.left > Bs2.left;
  }
  //Bs1为被包含(小) Bs2为包含(大)  均为正值
  function _relativep(Bs1, Bs2) {
    var relative_position = {
      left: Bs1.left - Bs2.left,
      right: Bs2.right - Bs1.right,
      bottom: Bs2.bottom - Bs1.bottom,
      top: Bs1.top - Bs2.top,
      width: Bs1.width,
      height: Bs1.height
    };
    return relative_position;
  }
  //get Ancestors
  function getAncestors(node, filter) {
    var ret = [];
    var docType = Node.DOCUMENT_NODE;
    for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
      try {
        if (filter && filter(cur))
          ret.push(cur);
      }
      catch (e) {
        console.warn(e.stack || e);
      }
    }
    return ret;
  }
})(etb_controls.mainbo_freedrag || (etb_controls.mainbo_freedrag = {}))