﻿(function (mainbo_comparemonthcalendar) {
    function init(el) {
        setEditing(el, true);
    }
    mainbo_comparemonthcalendar.init = init;
    var config = {
        defaultyear: 2016,
        defaultmonth: 2
    };
    function setEditing(el, editing) {
        if (!el._comparemonthcalendarproperty) {
            el._comparemonthcalendarproperty = {};
        }
        el.addEventListener('click', clickControl);
        var prev = el.querySelector('.mbe-cmcalendar-body .mbe-cmcalendar-bodyyearprev');
        var next = el.querySelector('.mbe-cmcalendar-body .mbe-cmcalendar-bodyyearnext');
        prev.addEventListener('click', clickBodyYearPrev);
        next.addEventListener('click', clickBodyYearNext);
        var sy = el.querySelectorAll('.mbe-cmcalendar-title .mbe-cmcalendar-tityear span')[1];
        var sm = el.querySelectorAll('.mbe-cmcalendar-title .mbe-cmcalendar-titmonth span')[1];
        sy.addEventListener('click', showSelectYearTab);
        sm.addEventListener('click', showMonthTab);
        var monthlist = el.querySelectorAll('.mbe-cmcalendar-monthtab > div');
        [].forEach.call(monthlist, function (item) {
            item.addEventListener('click', clickSelectMonth);
        });
        var mt = el.querySelector('.mbe-cmcalendar-monthtab');
        if (mt.style.display != 'none') {
            mt.style.display = 'none';
        }

        var bodytabs = el.querySelectorAll('.mbe-cmcalendar-bodytabs .mbe-cmcalendar-bodytabmonth');
        [].forEach.call(bodytabs, function (item) {
            item.addEventListener('click', clickBodyTabMonth);
        });

        var back = el.querySelector('.mbe-cmcalendar-content .mbe-cmcalendar-monthtab1 .mbe-cmcalendar-c2titback');
        back && back.addEventListener('click', createMonthTableHidden);

        var prev = el.querySelector('.mbe-cmcalendar-monthselectgroup .mbe-cmcalendar-monthprev');
        prev && prev.addEventListener('click', clickMonthPrev);

        var next = el.querySelector('.mbe-cmcalendar-monthselectgroup .mbe-cmcalendar-monthnext');
        next && next.addEventListener('click', clickMonthNext);

        [].forEach.call(el.querySelectorAll('.mbe-cmcalendar-c2body .mbe-cmcalendar-days2 a'), function (item, index) {
            item && item.addEventListener('click', addClassSelectDay);
        });
        var mcyp = el.querySelector('.mbe-cmcalendar-yeartabs .mbe-cmcalendar-yeartabprev');
        var mcyn = el.querySelector('.mbe-cmcalendar-yeartabs .mbe-cmcalendar-yeartabnext');
        var mcyc = el.querySelector('.mbe-cmcalendar-yeartabs .mbe-cmcalendar-confirm');
        if (mcyc) {
            mcyp.addEventListener('click', clickYearTabPrev);
            mcyn.addEventListener('click', clickYearTabNext);
            mcyc.addEventListener('click', clickYearConfirm);
        }
    }
    function contructCMCalendar(el) {
        var content = el.ownerDocument.createElement('div');
        content.classList.add('mbe-cmcalendar-content');
        el.appendChild(content);
        createTitle(el);
        createBody(el);
        createMonthTab(el);
        createTitleContent(el);
        //createBodyContent(el);
    }
    function createTitle(el) {
        var titleContent = el.ownerDocument.createElement('div');
        titleContent.classList.add('mbe-cmcalendar-title');
        var p = el.querySelector('.mbe-cmcalendar-content');
        p.appendChild(titleContent);
    }
    function createBody(el) {
        var bodyContent = el.ownerDocument.createElement('div');
        bodyContent.classList.add('mbe-cmcalendar-body');
        var bodyYearPrev = el.ownerDocument.createElement('div');
        bodyYearPrev.classList.add('mbe-cmcalendar-bodyyearprev');
        bodyYearPrev.addEventListener('click', clickBodyYearPrev);
        bodyContent.appendChild(bodyYearPrev);
        var bodyYearNext = el.ownerDocument.createElement('div');
        bodyYearNext.classList.add('mbe-cmcalendar-bodyyearnext');
        bodyYearNext.addEventListener('click', clickBodyYearNext);
        bodyContent.appendChild(bodyYearNext);
        var bodyTabs = el.ownerDocument.createElement('div');
        bodyTabs.classList.add('mbe-cmcalendar-bodytabs');
        bodyContent.appendChild(bodyTabs);
        var p = el.querySelector('.mbe-cmcalendar-content');
        p.appendChild(bodyContent);
    }
    function createTitleContent(el) {
        var titmidlayer = el.ownerDocument.createElement('div');
        titmidlayer.classList.add('mbe-cmcalendar-titlemid');
        var p = el.querySelector('.mbe-cmcalendar-title');
        p.appendChild(titmidlayer);
        var yeararea = el.ownerDocument.createElement('div');
        yeararea.classList.add('mbe-cmcalendar-tityear');
        var y = el.ownerDocument.createElement('span');
        y.textContent = '年';
        var sy = el.ownerDocument.createElement('span');
        sy.addEventListener('click', showSelectYearTab);
        var sybtn = el.ownerDocument.createElement('city');
        sy.appendChild(sybtn);
        yeararea.appendChild(y);
        yeararea.appendChild(sy);
        var montharea = el.ownerDocument.createElement('div');
        montharea.classList.add('mbe-cmcalendar-titmonth');
        var m = el.ownerDocument.createElement('span');
        m.textContent = '月';
        var sm = el.ownerDocument.createElement('span');
        sm.addEventListener('click', showMonthTab);
        var smbtn = el.ownerDocument.createElement('city');
        sm.appendChild(smbtn);
        montharea.appendChild(m);
        montharea.appendChild(sm);
        titmidlayer.appendChild(yeararea);
        titmidlayer.appendChild(montharea);
    }
    function showSelectYearTab(ev) {
        stopPropagation(ev);
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        if (!this_el.querySelector('.mbe-cmcalendar-yeartabs')) {
            createYearTabs(this_el);
            createYear(this_el);
            var mt = this_el.querySelector('.mbe-cmcalendar-monthtab');
            if (mt.style.display != 'none') {
                mt.style.display = 'none';
            }
        }
        else {
            var tab = this_el.querySelector('.mbe-cmcalendar-yeartabs');
            tab && tab.parentElement.removeChild(tab);
        }
    }
    function showMonthTab(ev) {
        stopPropagation(ev);
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var monthtab = this_el.querySelector('.mbe-cmcalendar-content .mbe-cmcalendar-monthtab');
        if (monthtab.style.display == 'none') {
            monthtab.style.removeProperty('display');
        }
        else {
            monthtab.style.display = 'none';
        }
        var yt = this_el.querySelector('.mbe-cmcalendar-yeartabs');
        if (yt) {
            yt.parentElement.removeChild(yt);
        }
    }
    function createYearTabs(el) {
        var yeartabs = el.ownerDocument.createElement('div');
        yeartabs.classList.add('mbe-cmcalendar-yeartabs');
        var p = el.querySelector('.mbe-cmcalendar-content');
        p.appendChild(yeartabs);
        var yearsprev = el.ownerDocument.createElement('div');
        yearsprev.classList.add('mbe-cmcalendar-yeartabprev');
        yearsprev.addEventListener('click', clickYearTabPrev);
        var yearsnext = el.ownerDocument.createElement('div');
        yearsnext.classList.add('mbe-cmcalendar-yeartabnext');
        yearsnext.addEventListener('click', clickYearTabNext);
        yeartabs.appendChild(yearsprev);
        yeartabs.appendChild(yearsnext);
        var yearsconfirmbtn = el.ownerDocument.createElement('div');
        yearsconfirmbtn.classList.add('mbe-cmcalendar-confirm');
        yearsconfirmbtn.addEventListener('click', clickYearConfirm);
        yearsconfirmbtn.textContent = '确  定';
        yeartabs.appendChild(yearsconfirmbtn);
    }
    function clickControl(ev) {
        stopPropagation(ev);
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var mt = this_el.querySelector('.mbe-cmcalendar-monthtab');
        var yt = this_el.querySelector('.mbe-cmcalendar-yeartabs');
        if (yt) {
            yt.parentElement.removeChild(yt);
        }
        if (mt.style.display != 'none') {
            mt.style.display = 'none';
        }
    }
    function clickBodyYearPrev(ev) {
        stopPropagation(ev);
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var curbodytab = this_el.querySelector('.mbe-cmcalendar-body .mbe-cmcalendar-bodytabs .mbe-cmcalendar-curbodytab');
        var prevtab = curbodytab && curbodytab.previousElementSibling;
        if (prevtab) {
            prevtab.classList.add('mbe-cmcalendar-curbodytab');
            curbodytab.classList.remove('mbe-cmcalendar-curbodytab');
        }
        else {
            return;
        }
    }
    function clickBodyYearNext(ev) {
        stopPropagation(ev);
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var curbodytab = this_el.querySelector('.mbe-cmcalendar-body .mbe-cmcalendar-bodytabs .mbe-cmcalendar-curbodytab');
        var nexttab = curbodytab && curbodytab.nextElementSibling;
        if (nexttab) {
            nexttab.classList.add('mbe-cmcalendar-curbodytab');
            curbodytab.classList.remove('mbe-cmcalendar-curbodytab');
        }
        else {
            return;
        }
    }
    function clickYearTabPrev(ev) {
        stopPropagation(ev);
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var yeartabs = this_el.querySelectorAll('.mbe-cmcalendar-content .mbe-cmcalendar-yeartab');
        var curyeartab = this_el.querySelector('.mbe-cmcalendar-content .mbe-cmcalendar-yeartab.mbe-cmcalendar-curyeartab');
        var yearlist = curyeartab.querySelectorAll('.mbe-cmcalendar-year');
        var minyear = parseFloat(yearlist[0].textContent);
        var maxyear = parseFloat(yearlist[79].textContent);
        if (yeartabs[0] == curyeartab) {
            createYear(this_el, (parseFloat(curyeartab.getAttribute('data-index')) - 1), 'prev', minyear, maxyear);
            curyeartab.classList.remove('mbe-cmcalendar-curyeartab');
        }
        else {
            var prevtab = curyeartab.previousElementSibling;
            prevtab.classList.add('mbe-cmcalendar-curyeartab');
            curyeartab.classList.remove('mbe-cmcalendar-curyeartab');
        }
    }
    function clickYearTabNext(ev) {
        stopPropagation(ev);
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var yeartabs = this_el.querySelectorAll('.mbe-cmcalendar-content .mbe-cmcalendar-yeartab');
        var curyeartab = this_el.querySelector('.mbe-cmcalendar-content .mbe-cmcalendar-yeartab.mbe-cmcalendar-curyeartab');
        var yearlist = curyeartab.querySelectorAll('.mbe-cmcalendar-year');
        var minyear = parseFloat(yearlist[0].textContent);
        var maxyear = parseFloat(yearlist[79].textContent);
        if (yeartabs[yeartabs.length - 1] == curyeartab) {
            createYear(this_el, (parseFloat(curyeartab.getAttribute('data-index')) + 1), 'next', minyear, maxyear);
            curyeartab.classList.remove('mbe-cmcalendar-curyeartab');
        }
        else {
            var nexttab = curyeartab.nextElementSibling;
            nexttab.classList.add('mbe-cmcalendar-curyeartab');
            curyeartab.classList.remove('mbe-cmcalendar-curyeartab');
        }
    }
    function clickYear(ev) {
        stopPropagation(ev);
        var target = ev.target;
        if (target.classList.contains('mbe-cmcalendar-yearselect')) {
            target.classList.remove('mbe-cmcalendar-yearselect');
        }
        else {
            target.classList.add('mbe-cmcalendar-yearselect');
        }
    }
    function clickYearConfirm(ev) {
        stopPropagation(ev);
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var yearlist = this_el.querySelectorAll('.mbe-cmcalendar-yeartabs .mbe-cmcalendar-yeartab .mbe-cmcalendar-yearselect');
        var bodytabs = this_el.querySelector('.mbe-cmcalendar-bodytabs');
        if (yearlist.length > 0) {
            bodytabs.innerHTML = '';
            createBodyContent(this_el, yearlist);
        } else {
            var yt = this_el.querySelector('.mbe-cmcalendar-yeartabs');
            if (yt) {
                yt.parentElement.removeChild(yt);
            }
            return false
        }
    }
    function clickSelectMonth(ev) {
        stopPropagation(ev);
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var month = parseFloat(ev.target.textContent);
        var tm = this_el.querySelectorAll('.mbe-cmcalendar-bodytabmonth');
        var tmlist = [];
        [].forEach.call(tm, function (item) {
            tmlist.push(item);
        });
        createBodyContent(this_el, tmlist, month);
        this_el.querySelector('.mbe-cmcalendar-monthtab').style.display = 'none';
    }
    function clickBodyTabMonth(ev) {
        stopPropagation(ev);
        var this_el = getAncestors(ev.target, (el) => { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var target = getAncestors(ev.target, (el) => { return el.classList.contains('mbe-cmcalendar-bodytabmonth') }).pop();
        var year = target && target.getAttribute('data-year');
        var mbetclist = this_el.querySelectorAll('.mbe-cmcalendar-content');
        if (!!year.trim() && /\d+/g.test(year)) {
            create2MonthTab(mbetclist[1], parseFloat(this_el.getAttribute('data-month')), parseFloat(year));
            mbetclist[0].classList.add('mbe-cmcalendar-hidden');
            mbetclist[1].classList.remove('mbe-cmcalendar-hidden');
        }
    }
    function createMonthTab(el) {
        var monthtab = el.ownerDocument.createElement('div');
        monthtab.classList.add('mbe-cmcalendar-monthtab');
        monthtab.style.display = 'none';
        var p = el.querySelector('.mbe-cmcalendar-content');
        p.appendChild(monthtab);
        for (var i = 0; i < 12; i++) {
            var month = el.ownerDocument.createElement('div');
            month.textContent = (i + 1) + '月';
            month.addEventListener('click', clickSelectMonth);
            monthtab.appendChild(month);
        }
    }
    function createYear(el, index, cmd, minyear, maxyear) {
        var this_el = el;
        var tabs = this_el.querySelector('.mbe-cmcalendar-yeartabs');
        if (tabs)
            if (!tabs.querySelector('.mbe-cmcalendar-yeartab')) {
                var yeartab = el.ownerDocument.createElement('div');
                yeartab.classList.add('mbe-cmcalendar-yeartab');
                yeartab.classList.add('mbe-cmcalendar-curyeartab');
                yeartab.setAttribute('data-index', '0');
                tabs.appendChild(yeartab);
                for (var i = config.defaultyear - 40; i < config.defaultyear + 40; i++) {
                    var year = el.ownerDocument.createElement('div');
                    year.classList.add('mbe-cmcalendar-year');
                    year.textContent = i + '';
                    year.addEventListener('click', clickYear);
                    yeartab.appendChild(year);
                }
            }
            else {
                var yeartab = el.ownerDocument.createElement('div');
                yeartab.classList.add('mbe-cmcalendar-yeartab');
                yeartab.classList.add('mbe-cmcalendar-curyeartab');
                yeartab.setAttribute('data-index', (index ? index : '') + '');
                var curyeartab = this_el.querySelector('.mbe-cmcalendar-content .mbe-cmcalendar-yeartab.mbe-cmcalendar-curyeartab');
                cmd == 'prev' ? curyeartab.parentElement.insertBefore(yeartab, curyeartab) : tabs.appendChild(yeartab);
                var startyear = cmd == 'prev' ? minyear - 80 : maxyear + 1;
                var endyear = cmd == 'prev' ? minyear : maxyear + 81;
                if (startyear < 0) {
                    startyear = 0;
                    endyear = 80;
                }
                if (endyear > 10000) {
                    startyear = 9920;
                    endyear = 10000;
                }
                for (var i = startyear; i < endyear; i++) {
                    var year = el.ownerDocument.createElement('div');
                    year.classList.add('mbe-cmcalendar-year');
                    year.textContent = i + '';
                    year.addEventListener('click', clickYear);
                    yeartab.appendChild(year);
                }
            }
    }
    function createBodyContent(el, yearlist, Month) {
        var this_el = el;
        var bodytabs = this_el.querySelector('.mbe-cmcalendar-bodytabs');
        bodytabs.innerHTML = '';
        var yearselectlist = yearlist;
        var ylist = [];
        var slist = [];
        var tylist = [];
        // 处理选中的数据
        for (var i = 0; i < yearselectlist.length; i++) {
            if (yearselectlist[i].hasAttribute('data-year')) {
                var year = yearselectlist[i].getAttribute('data-year');
            }
            else {
                var year = yearselectlist[i].textContent;
            }
            ylist.push(year);
        }
        if (ylist.length % 6 != 0) {
            var mod = ylist.length % 6;
            for (var j = 0; j < 6 - mod; j++) {
                ylist.push(' ');
            }
        }
        for (var k = 1; k <= ylist.length; k++) {
            slist.push(ylist[k - 1]);
            if (k % 6 == 0) {
                var tmp = [];
                for (var l = 0; l < slist.length; l++) {
                    tmp.push(slist[l]);
                }
                tylist.push(tmp);
                slist.length = 0;
            }
        }
        for (var i = 0; i < tylist.length; i++) {
            var bodytab = el.ownerDocument.createElement('div');
            bodytab.classList.add('mbe-cmcalendar-bodytab');
            if (i == 0) {
                bodytab.classList.add('mbe-cmcalendar-curbodytab');
            }
            bodytabs.appendChild(bodytab);
            for (var j = 0; j < tylist[i].length; j++) {
                var month = this_el.ownerDocument.createElement('div');
                month.classList.add('mbe-cmcalendar-bodytabmonth');
                month.setAttribute('data-year', tylist[i][j]);
                month.addEventListener('click', clickBodyTabMonth);
                createMonthContent(month, parseFloat(tylist[i][j]), Month ? Month : config.defaultmonth);
                bodytab.appendChild(month);
            }
        }
        var tab = this_el.querySelector('.mbe-cmcalendar-yeartabs');
        tab && tab.parentElement.removeChild(tab);
    }
    function createMonthContent(el, year, month) {
        var monthcontent = el.ownerDocument.createElement('div');
        monthcontent.classList.add('mbe-cmcalendar-monthcontent');
        el.appendChild(monthcontent);
        //createMonthBackground(monthcontent, year, month);
        if (year) {
            createMonthTitle(monthcontent, year, month);
            createWeek(monthcontent);
            createDayContent(monthcontent, year, month);
        }
    }
    function createMonthTitle(el, year, month) {
        var tit = el.ownerDocument.createElement('div');
        tit.classList.add('mbe-cmcalendar-mctitle');
        tit.textContent = year + '年' + month + '月';
        el.appendChild(tit);
    }
    function createWeek(el) {
        var week = el.ownerDocument.createElement('div');
        week.classList.add('mbe-cmcalendar-mcweek');
        var weekmid = el.ownerDocument.createElement('div');
        weekmid.classList.add('mbe-cmcalendar-mcweekmid');
        week.appendChild(weekmid);
        el.appendChild(week);
        ['日', '一', '二', '三', '四', '五', '六'].forEach(function (item) {
            var span = el.ownerDocument.createElement('span');
            span.textContent = item;
            weekmid.appendChild(span);
        });
    }
    function createDayContent(el, year, month) {
        var days = el.ownerDocument.createElement('div');
        days.classList.add('mbe-cmcalendar-days');
        var daysmid = el.ownerDocument.createElement('div');
        daysmid.classList.add('mbe-cmcalendar-daysmid');
        days.appendChild(daysmid);
        el.appendChild(days);
        daysList(daysmid, month, year);
    }
    function daysList(el, index, year) {
        for (var i = 0, j = daysIndex(index, year) ; i < j; i++) {
            var atag = el.ownerDocument.createElement('a');
            el.appendChild(atag);
        }
        // 循环天数
        for (var i = 1, j = daysCount(index, year) ; i <= j; i++) {
            var curcalss = '';
            var atag = el.ownerDocument.createElement('a');
            atag.className = "mbe-day" + curcalss;
            //atag.setAttribute('href', 'javascript:;');
            atag.textContent = i + ''; //< 10 ? '0' + i : i + '';
            el.appendChild(atag);
        }
    }
    /**
     * @param date    默认为当前时间
     * @param month   0-11
     * @param year    4位年
     */
    function daysIndex(month, year) {
        var newdate = new Date();
        if (year && year > 0 && year < 10000) {
            newdate.setFullYear(year);
        }
        newdate.setMonth(month);
        newdate.setDate(1);
        //星期显示方案一
        return newdate.getDay();
        //星期显示方案二
        //return newdate.getDay() + 1;
    }
    function daysCount(month, year) {
        var newmonth;
        if (year && year > 0 && year < 10000) {
            newmonth = month;
        }
        if (/^(1|3|5|7|8|10|12)$/.test(newmonth + '')) {
            return 31;
        }
        if (/^(4|6|9|11)$/.test(newmonth + '')) {
            return 30;
        }
        //二月
        if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0) {
            return 29;
        }
        else {
            return 28;
        }
    }
    function daysToday(date) {
        var newdate = new Date();
        if (newdate.getMonth() == date.getMonth() && newdate.getFullYear() == date.getFullYear()) {
            return newdate.getDate();
        }
        else {
            return 0;
        }
    }

    function create2MonthTab(el, month, year) {
        el.innerHTML = '';
        var monthcon = el.ownerDocument.createElement('div');
        monthcon.classList.add('mbe-cmcalendar-monthtab1');
        el.appendChild(monthcon);
        create2Monthtitle(monthcon, month, year);
        create2Monthbody(monthcon, month, year);
    }

    function create2Monthtitle(el, month, year) {
        var title = el.ownerDocument.createElement('div');
        title.classList.add('mbe-cmcalendar-c2tit');
        el.appendChild(title);
        create2MonthtitleContent(title, month, year);
    }
    function create2MonthtitleContent(el, month, fullyear) {
        var this_el = getAncestors(el, function (el1) { return el1.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var back = el.ownerDocument.createElement('div');
        back.classList.add('mbe-cmcalendar-c2titback');
        back.addEventListener('click', createMonthTableHidden)
        el.appendChild(back);
        var bar = el.ownerDocument.createElement('div');
        bar.classList.add('mbe-cmcalendar-c2titbar');
        el.appendChild(bar);

        var slidegroup = el.ownerDocument.createElement('div');
        slidegroup.classList.add('mbe-cmcalendar-monthselectgroup');

        var prev = el.ownerDocument.createElement('div');
        prev.addEventListener('click', clickMonthPrev);
        prev.classList.add('mbe-cmcalendar-monthprev')
        var prevatag = el.ownerDocument.createElement('city');
        prev.appendChild(prevatag);

        var next = el.ownerDocument.createElement('div');
        next.addEventListener('click', clickMonthNext);
        next.classList.add('mbe-cmcalendar-monthnext');
        var nextatag = el.ownerDocument.createElement('city');
        next.appendChild(nextatag);

        slidegroup.appendChild(prev);
        slidegroup.appendChild(next);

        var year = el.ownerDocument.createElement('div');
        year.classList.add('mbe-cmcalendar-monthyear')
        year.textContent = fullyear + '年';

        var monthslide = el.ownerDocument.createElement('div');
        monthslide.classList.add('mbe-cmcalendar-monthslide');
        monthslide.textContent = month + '月';

        bar.appendChild(year);
        bar.appendChild(monthslide);
        bar.appendChild(slidegroup);

        //var compareMonth = el.ownerDocument.createElement('div');
        //compareMonth.addEventListener('click', clickCompareMonth);
        //compareMonth.classList.add('mbe-cmcalendar-compmonth');
        //el.appendChild(compareMonth);
    }
    function create2Monthbody(el, month, year) {
        var body = el.ownerDocument.createElement('div');
        body.classList.add('mbe-cmcalendar-c2body');
        el.appendChild(body);
        create2MonthBodyContent(body, month);
        create2Week(el.querySelector('.mbe-cmcalendar-week2'));
        create2Days(el.querySelector('.mbe-cmcalendar-days2'), month, year);
    }
    function create2MonthBodyContent(el, month) {
        var back = el.ownerDocument.createElement('div');
        back.classList.add('mbe-cmcalendar-back2');
        back.textContent = month + '';
        var week = el.ownerDocument.createElement('div');
        week.classList.add('mbe-cmcalendar-week2');
        var days = el.ownerDocument.createElement('div');
        days.classList.add('mbe-cmcalendar-days2');
        el.appendChild(back);
        el.appendChild(week);
        el.appendChild(days);
    }
    function create2Week(el) {
        // 星期显示方案一
        ['日', '一', '二', '三', '四', '五', '六'].forEach(function (item) {
            var span = el.ownerDocument.createElement('span');
            span.textContent = item;
            el.appendChild(span);
        });
        // 星期显示方案二
        //['一', '二', '三', '四', '五', '六', '日'].forEach((item: any) => {
        //  var span = week.ownerDocument.createElement('span');
        //  span.textContent = item;
        //  week.appendChild(span);
        //});
    }
    function create2Days(el, month, fullyear) {
        var control = getAncestors(el, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        day2List(el, month, fullyear);
    }

    function clickMonthPrev(ev) {
        ev.stopPropagation();
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var monthtab = getAncestors(ev.target, function (el) { return el.classList.contains('mbe-cmcalendar-monthtab1'); }).pop();
        // 获取月份1-12
        var month = monthtab.querySelector('.mbe-cmcalendar-back2').textContent;
        if (month == '1') {
            // 设置月份的index 0-11
            month = 11 + '';
            monthtab.querySelector('.mbe-cmcalendar-back2').textContent = (parseFloat(month) + 1) + '';
            this_el.querySelector('.mbe-cmcalendar-c2titbar .mbe-cmcalendar-monthslide').textContent = (parseFloat(month) + 1) + '月';
            var mt = this_el.querySelector('.mbe-cmcalendar-c2titbar .mbe-cmcalendar-monthyear');
            mt.textContent = parseFloat(mt.textContent) - 1 + '年';
        } else {
            // 月份的index
            month = (parseFloat(month) - 2) + '';
            this_el.querySelector('.mbe-cmcalendar-c2titbar .mbe-cmcalendar-monthslide').textContent = (parseFloat(month) + 1) + '月';
            monthtab.querySelector('.mbe-cmcalendar-back2').textContent = (parseFloat(month) + 1) + '';
        }
        monthtab.querySelector('.mbe-cmcalendar-days2').innerHTML = '';
        var fullyear = parseFloat(monthtab.querySelector('.mbe-cmcalendar-monthyear').textContent);
        create2Days(monthtab.querySelector('.mbe-cmcalendar-days2'), parseFloat(month) + 1, fullyear);
    }
    function clickMonthNext(ev) {
        ev.stopPropagation();
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var monthtab = getAncestors(ev.target, function (el) { return el.classList.contains('mbe-cmcalendar-monthtab1'); }).pop();
        var month = monthtab.querySelector('.mbe-cmcalendar-back2').textContent;
        if (parseFloat(month) == 12) {
            month = 0 + '';
            var mt = this_el.querySelector('.mbe-cmcalendar-c2titbar .mbe-cmcalendar-monthyear');
            mt.textContent = parseFloat(mt.textContent) + 1 + '年';
        }
        monthtab.querySelector('.mbe-cmcalendar-back2').textContent = (parseFloat(month) + 1) + '';
        monthtab.querySelector('.mbe-cmcalendar-days2').innerHTML = '';
        var fullyear = parseFloat(monthtab.querySelector('.mbe-cmcalendar-monthyear').textContent);
        create2Days(monthtab.querySelector('.mbe-cmcalendar-days2'), parseFloat(month) + 1, fullyear);
        this_el.querySelector('.mbe-cmcalendar-c2titbar .mbe-cmcalendar-monthslide').textContent = (parseFloat(month) + 1) + '月';
    }
    //function clickCompareMonth(ev: PointerEvent) {
    //    console.log('compareMonth');
    //}
    function createMonthTableHidden(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        var mbetclist = this_el.querySelectorAll('.mbe-cmcalendar-content');
        mbetclist[1].classList.add('mbe-cmcalendar-hidden');
        mbetclist[0].classList.remove('mbe-cmcalendar-hidden');
    }

    function day2List(el, index, year) {
        // 补全空白日期 星期显示 i=0是为方案一 i=1为方案二
        for (var i = 0, j = days2Index(index - 1, year) ; i < j; i++) {
            var span = el.ownerDocument.createElement('span')
            var atag = el.ownerDocument.createElement('a');
            span.appendChild(atag);
            el.appendChild(span);
        }
        // 循环天数
        for (var i = 1, j = days2Count(index - 1, year), k = days2Today(new Date()) ; i <= j; i++) {
            var curcalss = '';
            if (i == k) {
                curcalss += ' mbe-today';
            }
            var span = el.ownerDocument.createElement('span');
            var atag = el.ownerDocument.createElement('a');
            atag.addEventListener('click', addClassSelectDay);
            span.appendChild(atag);
            atag.className = "mbe-day" + curcalss;
            //atag.setAttribute('href', 'javascript:;');
            atag.textContent = i + '';//< 10 ? '0' + i : i + '';
            el.appendChild(span);
        }
    }
    function addClassSelectDay(ev) {
        ev.stopPropagation();
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_comparemonthcalendar' })[0];
        //this_el.querySelectorAll('.mbe-cmcalendar-days2 a').forEach((item: HTMLElement, index: number) => {
        //  if (item.classList.contains('mbe-cmcalendar-dayshadow')) {
        //    item.classList.remove('mbe-cmcalendar-dayshadow');
        //  }
        //});
        var target = ev.target;
        if (target.classList.contains('mbe-cmcalendar-dayshadow')) {
            target.classList.remove('mbe-cmcalendar-dayshadow')
        } else {
            target.classList.add('mbe-cmcalendar-dayshadow')
        }
        //(<HTMLElement>ev.target).classList.add('mbe-cmcalendar-dayshadow');
    }
    function days2Count(month, year) {
        var date = new Date();
        date.setFullYear(year);
        date.setDate(1);
        date.setMonth(month);
        var newmonth = date.getMonth() + 1;
        if (/^(1|3|5|7|8|10|12)$/.test(newmonth + '')) {
            return 31;
        }
        if (/^(4|6|9|11)$/.test(newmonth + '')) {
            return 30;
        }
        //二月
        if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0) {
            return 29;
        } else {
            return 28;
        }
    }
    function days2Index(month, year) {
        var newdate = new Date();
        newdate.setFullYear(year);
        newdate.setDate(1);
        newdate.setMonth(month);
        //星期显示方案一
        return newdate.getDay();
        //星期显示方案二
        //return newdate.getDay() + 1;
    }
    function days2Today(date) {
        var newdate = new Date();
        return newdate.getDate();
    }

    function stopPropagation(ev) {
        ev.stopPropagation();
    }
    function getAncestors(node, filter) {
        var ret = [];
        var docType = Node.DOCUMENT_NODE;
        for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
            try {
                if (filter && filter(cur))
                    ret.push(cur);
            }
            catch (e) {
                console.warn(e.stack || e);
            }
        }
        return ret;
    }
})(mainbo_comparemonthcalendar = etb_controls.mainbo_comparemonthcalendar || (etb_controls.mainbo_comparemonthcalendar = {}));

