(function (mainbo_clock) {
  function init(el) {
    el.addEventListener('click', stopPropagation);
    el.addEventListener("touchstart", function (ev) {
      ev.preventDefault();
    })
    Array.prototype.forEach.call(el.querySelectorAll(".mainbo-clock-time-ctrl"), function (item) {
      item.addEventListener("pointerup", toggleClockTime);
    });
    Array.prototype.forEach.call(el.querySelectorAll(".mainbo-clock-time-hour"), function (item) {
      item.addEventListener("change", handlerClockTime);
    });
    Array.prototype.forEach.call(el.querySelectorAll(".mainbo-clock-time-minute"), function (item) {
      item.addEventListener("change", handlerClockTime);
    });
    Array.prototype.forEach.call(el.querySelectorAll(".mainbo-clock-time-second"), function (item) {
      item.addEventListener("change", handlerClockTime);
    });
    Array.prototype.forEach.call(el.querySelectorAll(".clock-point-hour .move"), function (item) {
      item.addEventListener("pointerdown", pointerdown);
    });
    Array.prototype.forEach.call(el.querySelectorAll(".clock-point-minute div"), function (item) {
      item.addEventListener("pointerdown", pointerdown);
    });
    Array.prototype.forEach.call(el.querySelectorAll(".clock-point-second div"), function (item) {
      item.addEventListener("pointerdown", pointerdown);
    });
    Array.prototype.forEach.call(el.querySelectorAll(".numbox-btn-plus"), function (item) {
      item.addEventListener("pointerup", numboxPlus);
    });
    Array.prototype.forEach.call(el.querySelectorAll(".numbox-btn-minus"), function (item) {
      item.addEventListener("pointerup", numboxMinus);
    });

    // 移出表盘，不再触发拖动效果
    el.querySelector(".mainbo-clock").addEventListener("pointerleave", pointerleave);
  }
  mainbo_clock.init = init;

  function stopPropagation(ev) {
    ev.stopPropagation();
  }
  // 数字控件，加
  function numboxPlus(ev) {
    var _target = ev.target;
    while (_target.localName != "button") {
      _target = _target.parentNode;
    }
    var _input = _target.parentNode.querySelector("input");
    var _step = _input.dataset['step'] || 1;
    var _max = _input.dataset['max'];
    var _sum = parseInt(_input.value) + parseInt(_step);
    if (_max && _sum > _max) {
      return false;
    }
    _input.value = _sum;
    if (_input.classList.contains("mainbo-clock-time-hour")) {
      changeHourTime(ev, _sum);
    } else if (_input.classList.contains("mainbo-clock-time-minute")) {
      changeMinuteTime(ev, _sum);
    } else if (_input.classList.contains("mainbo-clock-time-second")) {
      changeSecondTime(ev, _sum);
    }
  }

  // 数字控件，减
  function numboxMinus(ev) {
    var _target = ev.target;
    while (_target.localName != "button") {
      _target = _target.parentNode;
    }
    var _input = _target.parentNode.querySelector("input");
    var _step = _input.dataset['step'] || 1;
    var _min = _input.dataset['min'];
    var _sum = parseInt(_input.value) - parseInt(_step);
    if (_min && _sum < _min) {
      return false;
    }
    _input.value = _sum;
    if (_input.classList.contains("mainbo-clock-time-hour")) {
      changeHourTime(ev, _sum);
    } else if (_input.classList.contains("mainbo-clock-time-minute")) {
      changeMinuteTime(ev, _sum);
    } else if (_input.classList.contains("mainbo-clock-time-second")) {
      changeSecondTime(ev, _sum);
    }
  }

  // 鼠标点击事件，移动事件
  var _xNew = 0;
  var _yNew = 0;
  var _angle = 0;
  var circleCenterRect;
  var _circelX;
  var _circleY;
  var _fun = null; // 根据不同指针调用不同函数
  var _oldAngle = 0; // 上一次拖动角度
  var _angleChange = ""; // 拖动角度变大1 变小-1
  var mainboClock;

  function pointerdown(e) {
    mainboClock = getAncestors(e.target, function (el) {
      return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_clock'
    }).pop();
    circleCenterRect = mainboClock.querySelector(".clock-point").getBoundingClientRect();
    _circelX = circleCenterRect.left;
    _circelX = parseInt(_circelX);
    _circleY = circleCenterRect.top;
    _circleY = parseInt(_circleY);
    var tempNode = e.target.parentNode;
    if (tempNode.classList.contains("clock-point-hour")) {
      _fun = handlerTragHour;
    } else if (tempNode.classList.contains("clock-point-minute")) {
      _fun = handlerTragMinute;
    } else if (tempNode.classList.contains("clock-point-second")) {
      _fun = handlerTragSecond;
    }
    if (!mainboClock) {
      return false;
    }
    mainboClock.addEventListener("pointermove", pointermove);
    mainboClock.addEventListener("pointerup", function () {
      mainboClock.removeEventListener("pointermove", pointermove);
    });
  }

  function pointermove(ev) {
    _xNew = ev.clientX;
    _xNew = parseInt(_xNew);
    _yNew = ev.clientY;
    _yNew = parseInt(_yNew);
    _angle = Math.atan2((_circleY + parseInt(circleCenterRect.width / 2) - _yNew), (_xNew - _circelX - parseInt(circleCenterRect.width / 2))); // 相对于时钟原点求拖动点弧度
    _angle = _angle / Math.PI * 180; // 弧度转角度
    if (_angle > _oldAngle) {
      _angleChange = "-1";
    } else {
      _angleChange = "1";
    }
    _oldAngle = _angle;
    _angle = 90 - _angle;
    if (_angle <= 0 && _angle >= -90) {
      // 左上方区域
      _angle = 360 + _angle;
    }
    if (!_fun) {
      return false;
    }
    _fun(_angle, _angleChange);
  }

  // 拖动时针 rotate=forbid 已经是随分针转动，不再转动分针
  function handlerTragHour(angle, angleChange, rotate) {
    var _hour = mainboClock.querySelector(".clock-point-hour");
    _hour.style.transform = "rotate(" + angle + "deg)";
    var _hourVal = mainboClock.querySelector(".mainbo-clock-time-hour");
    var _value = Math.floor(angle / 360 * 12);
    if (_value > 12) {
      _value = 1;
    }
    _hourVal.value = _value || 12;
    if (rotate != "forbid") {
      // 分针随动
      var _angleM = angle * 12;
      handlerTragMinute(_angleM, angleChange, "forbid");
    }
  }

  // 拖动分针 rotate=forbid 已经是随时针转动，不再转动时针
  function handlerTragMinute(angle, angleChange, rotate) {
    angle = angle % 360; // 处理随时针转动时，角度过大问题
    var _minute = mainboClock.querySelector(".clock-point-minute");
    _minute.style.transform = "rotate(" + angle + "deg)";
    var _minuteVal = mainboClock.querySelector(".mainbo-clock-time-minute");
    var _value = Math.floor(angle / 360 * 60);
    var _hourVal = mainboClock.querySelector(".mainbo-clock-time-hour");
    if (_value == 0 && _value != _minuteVal.value) {
      if (angleChange == "1") {
        _hourVal.value = parseInt(_hourVal.value) + 1;
      }
    }
    if (_value == 59 && _value != _minuteVal.value) {
      if (angleChange == "-1") {
        _hourVal.value = parseInt(_hourVal.value) - 1;
      }
    }
    _value = _value < 10 ? '0' + _value : _value;
    _minuteVal.value = _value == 60 ? 0 : _value;
    if (rotate != "forbid") {
      // 时针随动
      var _angleH = parseInt(_hourVal.value) * 30 + angle / 12;
      handlerTragHour(_angleH, angleChange, "forbid");
    }
  }

  // 拖动秒针
  function handlerTragSecond(angle) {
    var _second = mainboClock.querySelector(".clock-point-second");
    _second.style.transform = "rotate(" + angle + "deg)";
    var _secondVal = mainboClock.querySelector(".mainbo-clock-time-second");
    var _value = Math.floor(angle / 360 * 60);
    _value = _value < 10 ? '0' + _value : _value;
    _secondVal.value = _value == 60 ? '00' : _value;
  }


  // 移出时钟，不再触发拖动效果
  function pointerleave() {
    if (mainboClock) {
      mainboClock.removeEventListener("pointermove", pointermove);
    }
  }

  // 时针时间的显示隐藏
  function toggleClockTime(ev) {
    var mainboClock = getAncestors(ev.target, function (el) {
      return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_clock'
    }).pop();
    var mctCtrl = mainboClock.querySelector(".mainbo-clock-time-ctrl");
    var mctView = mainboClock.querySelector(".mainbo-clock-time-view");
    if (mctView.style.display == "none") {
      mctView.style.display = "flex"
      mctCtrl.innerHTML = '<i class="mbe-svg-eye-slash"></i>';
    } else {
      mctView.style.display = "none"
      mctCtrl.innerHTML = '<i class="mbe-svg-eye"></i>';
    }
  }

  // 调整时钟时间
  function handlerClockTime(ev) {
    var temp = ev.target;
    var tempVal = parseInt(temp.value);
    // if (!tempVal) {
    //   temp.value = 0;
    //   return false;
    // }
    temp.setAttribute("value", tempVal + '');
    if (temp.classList.contains("mainbo-clock-time-hour")) {
      changeHourTime(ev, tempVal);
    } else if (temp.classList.contains("mainbo-clock-time-minute")) {
      changeMinuteTime(ev, tempVal);
    } else if (temp.classList.contains("mainbo-clock-time-second")) {
      changeSecondTime(ev, tempVal);
    }
  }

  /**
   * 改变时针值
   */
  function changeHourTime(ev, value) {
    var mainboClock = getAncestors(ev.target, function (el) {
      return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_clock'
    }).pop();
    var _hour = mainboClock.querySelector(".mainbo-clock-time-hour");
    if (value >= 13) {
      value = 1;
    } else if (value <= 0) {
      value = 12;
    }
    _hour.value = value;
    var _minute = mainboClock.querySelector(".mainbo-clock-time-minute");
    var _angleH = parseInt(_hour.value) / 12 * 360 + (parseInt(_minute.value) / 60 * 360 / 12);
    turnHourPoint(ev, _angleH);
  }

  /**
   * 转动时针
   * angle 角度值，不带单位
   */
  function turnHourPoint(ev, angleH) {
    var mainboClock = getAncestors(ev.target, function (el) {
      return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_clock'
    }).pop();
    var _hour = mainboClock.querySelector(".clock-point-hour");
    _hour.style.transform = "rotate(" + angleH + "deg)";
  }

  /**
   * 改变分针值
   */
  function changeMinuteTime(ev, value) {
    var mainboClock = getAncestors(ev.target, function (el) {
      return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_clock'
    }).pop();
    var _minute = mainboClock.querySelector(".mainbo-clock-time-minute");
    var _hour = mainboClock.querySelector(".mainbo-clock-time-hour");
    if (value == 60) {
      value = 0;
      _minute.dataset['circles'] = (parseInt(_minute.dataset['circles']) + 1) + '';
      _hour.value = (parseInt(_hour.value) + 1);
      changeHourTime(ev, _hour.value);
    } else if (value > 60) {
      value = 0;
    } else if (value <= 0) {
      value = 0;
    }
    _minute.value = value < 10 ? '0' + value : value;
    var circles = parseInt(_minute.dataset['circles']); // 转的圈数
    var _angleM = value / 60 * 360 + (circles * 360);
    // 时针转动角度不需要计算分针圈数，时针会计算自己的圈数
    var _angleH = parseInt(_hour.value) / 12 * 360 + (parseInt(_hour.dataset['circles']) * 720) + (value / 60 * 360 / 12);
    turnMinutePoint(ev, _angleM, _angleH);
  }

  /**
   * 转动分针
   * angle 角度值，不带单位
   */
  function turnMinutePoint(ev, angleM, angleH) {
    var mainboClock = getAncestors(ev.target, function (el) {
      return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_clock'
    }).pop();
    var _minute = mainboClock.querySelector(".clock-point-minute");
    _minute.style.transform = "rotate(" + angleM + "deg)";
    if (angleH) {
      turnHourPoint(ev, angleH);
    }
  }

  /**
   * 改变秒针值
   */
  function changeSecondTime(ev, value) {
    var mainboClock = getAncestors(ev.target, function (el) {
      return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_clock'
    }).pop();
    var _second = mainboClock.querySelector(".mainbo-clock-time-second");
    var _minute = mainboClock.querySelector(".mainbo-clock-time-minute");
    if (value == 60) {
      value = 0;
      _second.dataset['circles'] = (parseInt(_second.dataset['circles']) + 1) + '';
      _minute.value = (parseInt(_minute.value) + 1);
      changeMinuteTime(ev, _minute.value);
    } else if (value > 60) {
      value = 0;
    } else if (value <= 0) {
      value = 0;
    }
    _second.value = value < 10 ? '0' + value : value;
    var circles = parseInt(_second.dataset['circles']); // 转的圈数
    var _angleS = value / 60 * 360 + (circles * 360);
    // 分针转动角度不需要计算秒针圈数，分针会计算自己的圈数
    var _angleM = parseInt(_minute.value) / 60 * 360 + (parseInt(_minute.dataset['circles']) * 360) + value / 60 * 360 / 60;
    turnSecondPoint(ev, _angleS, _angleM);
  }

  /**
   * 转动秒针
   * angle 角度值，不带单位
   */
  function turnSecondPoint(ev, angleS, angleM, angleH) {
    var mainboClock = getAncestors(ev.target, function (el) {
      return el.hasAttribute('data-control') && el.getAttribute('data-control') == 'mainbo_clock'
    }).pop();
    var _second = mainboClock.querySelector(".clock-point-second");
    _second.style.transform = "rotate(" + angleS + "deg)";
    if (angleM) {
      turnMinutePoint(ev, angleM);
    }
  }

  function getAncestors(node, filter) {
    var ret = [];
    var docType = Node.DOCUMENT_NODE;
    for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
      try {
        if (filter && filter(cur))
          ret.push(cur);
      } catch (e) {
        console.warn(e.stack || e);
      }
    }
    return ret;
  }


})(mainbo_clock = etb_controls.mainbo_clock || (etb_controls.mainbo_clock = {}));