﻿(function (mainbo_clippath) {
  function init(el) { 
    // resetClipPath(el);
    if(el.querySelector('input')) el.removeChild(el.querySelector('input'));
    if(!el._clipProp) {
      el._clipProp = { };
      el._clipProp.pointArray = [];
      el._clipProp.isMoveSelectPath = false;
      el._clipProp.isReset = false;
      el._clipProp.isMousedown = false;
      el._clipProp.startMouseX = null;
      el._clipProp.startMouseY = null;
      el._clipProp.lastMouseX = null;
      el._clipProp.lastMouseY = null;
      el._clipProp.activeTarg = null;
    }
    forEach(el.querySelectorAll('*'), function(kid) {
      kid.addEventListener('dragstart', ondragstart);
    });
    el.addEventListener('pointerdown', drawClipPathUrl);
    el.addEventListener('pointermove', drawClipPathUrl);
    el.addEventListener('pointerup', drawClipPathUrl);
    removePointLine(el);
    el.querySelector('.selectPath').setAttribute('d', '');
    el.querySelector('.svgMaskContainer').classList.add('hide');
    
    // 设置id，防止clippath-url冲突
    var mask = el.querySelector('.mask');
    var images = el.querySelectorAll('.image');
    var maskPathBorder = el.querySelector('.maskPathBorder');
    el.querySelector('.svgMaskContainer').classList.add('hide');
    if(mask) {
      mask.style['webkitClipPath'] = mask.style.clipPath;
      mask.style['webkitFilter'] = mask.style.filter;
    }
    forEach(images, function(image, i) {
      image.style['webkitClipPath'] = image.style.clipPath;
    });
    // if(!window.opener) {
    //   mask && (mask.style.display = 'none');
    //   maskPathBorder && (forEach(maskPathBorder.children, function(child) {
    //     child.style.fill = '#fff';
    //   }));
    // }
  }
  mainbo_clippath.init = init;

  function drawClipPathUrl(ev) {
    ev.stopPropagation();
    ev.preventDefault();
    var x = ev.clientX, y = ev.clientY, dx = 0, dy = 0;
    var targ = ev.target;
    var this_el = getAncestors(targ, function(el) { return el.getAttribute('data-control') == 'mainbo_clippath' }).pop();
    if(!this_el) return;
    switch(ev.type) {
      case 'pointerdown':
        this_el._clipProp.isMousedown = true;
        if(targ.localName == 'rect') {
          var cur = targ.classList.contains('active');
          if(!cur) {
            forEach(targ.parentElement.querySelectorAll('.active'), function(active) {
              active.classList.remove('active');
            });
            targ.classList.add('active');
            this_el._clipProp.isMousedown = false;
          }
          console.log('>>>> rect targ.localName:', targ.localName);
        } else if(targ.localName == 'img' && targ.classList.contains('image')) {
          // 核对答案后，不允许修改作答
          if(this_el.querySelector('.checkin-tool')) {
            this_el._clipProp.isMousedown = false;
            return;
          }
          var svgroot = this_el.querySelector('.clipSvg');
          var imageClipPath = this_el.querySelectorAll('.imageClipPath');
          var elOffset = this_el && this_el.getBoundingClientRect();
          if(svgroot.checkIntersection) {
            var interImgs = [];
            forEach(targ.parentElement.children, function(el, i) {
              var pointRect = svgroot.createSVGRect();
              pointRect.w = pointRect.width = 1;
              pointRect.h = pointRect.height = 1;
              pointRect.x = x - elOffset.left - (parseFloat(el.style.marginLeft) || 0);
              pointRect.y = y - elOffset.top - (parseFloat(el.style.marginTop) || 0);
              if(intersectOvTile(parseRect(this_el, imageClipPath[i].lastChild), pointRect)) {
                interImgs.push(el);
              }
            });
            if(!!interImgs.length) {
              targ = interImgs.pop();
            } else {
              this_el._clipProp.isMousedown = false;
              return;
            }
          }
          targ.style.zIndex = '2';
          console.log('>>>> img.image targ.localName:', targ.localName);
        } else if(targ.localName == 'path') {
          console.log('>>>> path targ.localName:', targ.localName);
        } else if(targ.localName == 'ellipse') {
          console.log('>>>> circle targ.localName:', targ.localName);
        } else if(targ.classList.contains('renewal-tool')) {
          renewalClipPath(this_el, targ);
        } else if(targ.classList.contains('check-tool')) {
          checkClipPath(this_el, targ);
        } else {
          console.log('>>>> targ.localName:', targ.localName);
        }
        this_el._clipProp.startMouseX = x;
        this_el._clipProp.startMouseY = y;
        this_el._clipProp.activeTarg = targ;
        break;
      case 'pointerup':
        this_el._clipProp.isMousedown = false;
        targ = this_el._clipProp.activeTarg || targ;
        targ.style.zIndex = '';
        if(targ.localName == 'img' && targ.classList.contains('image')) {
          var targT = parseFloat(getCSSValue(targ, 'margin-top'));
          var targL = parseFloat(getCSSValue(targ, 'margin-left'));
          if(this_el.getAttribute('data-_type') == 'process') {
            if(Math.abs(targT) <= 50 && Math.abs(targL) <= 50) { 
              targ.style.margin = '0';
              this_el.querySelector('.selectPath').setAttribute('d', '');
            } else {
              var margins = this_el.querySelector('.renewal-tool').getAttribute('data-renewal').split(',');
              var index = Array.prototype.slice.call(this_el.querySelector('.imageCloneBox').querySelectorAll('.image'), 0).indexOf(targ);
              targ.style.margin = margins[index];
            }
          } else {
            nearRect(targ, targL, targT);
          }
          this_el._clipProp.isReset = true;
        }
        this_el._clipProp.activeTarg = null;
        break;
      case 'pointermove':
        dx = x - this_el._clipProp.startMouseX;
        dy = y - this_el._clipProp.startMouseY;
        if (!dx && !dy) {
          return;
        }
        if(!this_el._clipProp.isMousedown) return;
        targ = this_el._clipProp.activeTarg || targ;
        if(targ.localName == 'rect') {

          console.log('>>>> rect targ.localName:', targ.localName, 'ev.type:', ev.type);
        } else if(targ.localName == 'img' && targ.classList.contains('image')) {
          removePointLine(this_el); // 不需要清理路径，移动图像会重绘
          var ctlTarg = getAncestors(targ, function(el) { return el.localName == 'img' || el.localName == 'path'}).pop();
          changeImageSite(ctlTarg, dx, dy);
          
          console.log('>>>> image.image targ.localName:', targ.localName, 'ev.type:', ev.type);
        } else if(targ.localName == 'path' && this_el._clipProp.isMoveSelectPath) {
          changePoints(this_el, dx, dy);

          console.log('>>>> path targ.localName:', targ.localName, 'ev.type:', ev.type);
        } else if(targ.localName == 'ellipse' && this_el._clipProp.isMoveSelectPath) {
          changePoints(this_el, dx, dy);
          var point = this_el._clipProp.pointArray[0].split(' ');
          targ.setAttribute('cx', point[0]);
          targ.setAttribute('cy', point[1]);

          console.log('>>>> circle targ.localName:', targ.localName, 'ev.type:', ev.type);
        } else {
          console.log('>>>> targ.localName:', targ.localName, 'ev.type:', ev.type);
        }
        this_el._clipProp.startMouseX = x;
        this_el._clipProp.startMouseY = y;
        break;
    }
    console.log('>>>> drawClipPathUrl: ev.type:', ev.type, 'x, y:', x, y);
  }

  /**
   * 移动剪切图
   * 移动对象包括剪贴图、剪裁区和选区
  */
  function changeImageSite(target, dx, dy) {
    if(!target) return;
    var index = 0;
    var this_el = getAncestors(target, function(el) { return el.getAttribute('data-control') == 'mainbo_clippath'}).pop();
    var clipPathEles = this_el.querySelectorAll('.imageClipPath');
    var imageCloneBox = this_el.querySelector('.imageCloneBox');
    var images = imageCloneBox.querySelectorAll('img');
    var svgmask = this_el.querySelector('.svgMaskContainer');
    index = Array.prototype.slice.call(images, 0).indexOf(target);
    var image = images[index];
    var imageClipPath = clipPathEles[index];
    if(!imageClipPath || !image) return;
    image.style.marginTop = parseFloat(getCSSValue(image, 'margin-top')) + dy + 'px';
    image.style.marginLeft = parseFloat(getCSSValue(image, 'margin-left')) + dx + 'px';
    var path = imageClipPath.querySelector('path');
    var circle = imageClipPath.querySelector('ellipse');
    this_el._clipProp.pointArray = path.getAttribute('d').replace(/m|z/gi, '').split(' L');
    changePoints(this_el, 0, 0);
    this_el.querySelector('.selectPath').setAttribute('d', '');
    // if(circle) {
    //   var point = this_el._clipProp.pointArray[0].split(' ');
    //   circle.setAttribute('cx', point[0]);
    //   circle.setAttribute('cy', point[1]);
    //   this_el.querySelector('.selectPath').setAttribute('d', '');
    //   this_el.querySelector('.pointLine').appendChild(circle.cloneNode(true));
    // } else {
    //   path.setAttribute('d', 'M'+ this_el._clipProp.pointArray.join(' L') + ' Z');
    // }
    svgmask.classList.add('hide');
  }

  /**
   * 移动选区位置
  */
  function changePoints(el, dx, dy) {
    console.log('>>>> pointArray old:', el._clipProp.pointArray.join(' L'));
    if(!el) return;
    if(!el._clipProp.pointArray.length) {
      return console.error('error => pointArray.length:', el._clipProp.pointArray.length);
    }
    forEach(el._clipProp.pointArray, function(point, i) {
      var l = parseInt(point.split(' ')[0]) + dx;
      var t = parseInt(point.split(' ')[1]) + dy;
      point = l + ' ' + t;
      el._clipProp.pointArray[i] = point;
    });
    console.log('>>>> pointArray new:', el._clipProp.pointArray.join(' L'));
    var clipPathPoint = 'M'+ el._clipProp.pointArray.join(' L') + ' Z';
    el.querySelector('.selectPath').setAttribute('d', clipPathPoint);
    // imageClipPath && imageClipPath.querySelector('path').setAttribute('d', clipPathPoint);
    // isMoveMask && maskPath.querySelector('path').setAttribute('d', clipPathPoint);
    var rects = el.querySelector('.pointLine').querySelectorAll('rect');
    forEach(rects, function(rect) {
      rect.setAttribute('x', parseInt(rect.getAttribute('x')) + dx + '');
      rect.setAttribute('y', parseInt(rect.getAttribute('y')) + dy + '');
    });
  }

  /**
   * 移除点
  */
  function removePointLine(el) {
    if(!el) return;
    var rects = el.querySelector('.pointLine').querySelectorAll('rect');
    forEach(rects, function(rect) {
      rect.parentNode.removeChild(rect);
    });
    if(el.querySelector('.confirmSelect')) {
      el.removeChild(el.querySelector('.confirmSelect'));
    }
    removeCirclePath(el);
  }

  function removeCirclePath(el) {
    var pointLine = el.querySelector('.pointLine');
    forEach(pointLine.querySelectorAll('ellipse'), function(cir) {
      pointLine.removeChild(cir);
    });
  }

  /**
   * 图片吸附在最近的遮罩区域
   * 图片左上边距距离遮罩都不大于50
  */
  function nearRect(target, left, top) {
    var this_el = getAncestors(target, function(el) { return el.getAttribute('data-control') == 'mainbo_clippath'}).pop();
    var index = Array.prototype.slice.call(this_el.querySelectorAll('.image'), 0).indexOf(target);
    var imageClipPaths = this_el.querySelectorAll('.imageClipPath');
    var rect = getRect(imageClipPaths[index]);
    var compareRect = []; // 存储偏移量
    forEach(imageClipPaths, function(clipPath) {
      var rt = getRect(clipPath);
      var _x = Math.abs(rt.x - left - rect.x);
      var _y = Math.abs(rt.y - top - rect.y);
      compareRect.push(Math.max(_x, _y));
    });
    var nearNum = (function(arr) {
      var nearN = parseFloat(arr[0]);
      forEach(arr, function(el) {
        nearN = Math.min(nearN, parseFloat(el));
      });
      return nearN < 50 ? compareRect.indexOf(nearN) : null;
    })(compareRect);
    if(nearNum !== null) {
      var nearRect = getRect(imageClipPaths[nearNum]);
      target.style.marginLeft = (nearRect.x - rect.x) + 'px';
      target.style.marginTop = (nearRect.y - rect.y) + 'px';
    }
    console.log('>>>> nearRect -> compareRect: ', compareRect, nearNum);

    function getRect(clipPath) {
      if(clipPath.querySelector('ellipse')) {
        return {
          'x': (parseFloat(clipPath.querySelector('ellipse').getAttribute('cx')) - parseFloat(clipPath.querySelector('ellipse').getAttribute('rx'))) * getCSSNumber(this_el, 'width'),
          'y': (parseFloat(clipPath.querySelector('ellipse').getAttribute('cy')) - parseFloat(clipPath.querySelector('ellipse').getAttribute('ry'))) * getCSSNumber(this_el, 'height'),
        }
      } else {
        var path = clipPath.querySelector('path');
        if(!path || !path.getAttribute('d')) return {'x': 0, 'y': 0};
        var points = path.getAttribute('d').substring(1).split(' ');
        return {
          'x': parseFloat(points[0]) * getCSSNumber(this_el, 'width'),
          'y': parseFloat(points[1]) * getCSSNumber(this_el, 'height')
        }
      }
    }
  }

  /**
   * 检查并判断
  */
  function checkClipPath(el, target) {
    var images = el.querySelector('.imageCloneBox').querySelectorAll('.image');
    var svgmask = el.querySelector('.svgMaskContainer');
    if(target.classList.contains('checkin-tool')) {
      forEach(images, function(img) {
        img.style.margin = '0';
      });
      svgmask.classList.add('hide');
      // target.classList.remove('checkin-tool');
    } else {
      var check = false;
      if(!svgmask.classList.contains('hide')) return;
      for(var i = 0; i < images.length; i++) {
        var targT = parseFloat(getCSSValue(images[i], 'margin-top'));
        var targL = parseFloat(getCSSValue(images[i], 'margin-left'));
        if(Math.abs(targT) <= 50 && Math.abs(targL) <= 50) {
          check = true;
          continue;
        }
        check = false;
        break;
      }
      if(check) {
        svgmask.classList.remove('hide');
        svgmask.classList.remove('check_false');
        forEach(images, function(img) {
          img.style.margin = '0';
        });
      } else {
        svgmask.classList.remove('hide');
        svgmask.classList.add('check_false');
      }
      target.classList.add('checkin-tool');
    }
  }

  /**
   * 撤销恢复抠图
  */
  function renewalClipPath(el, target) {
    var margins = target.getAttribute('data-renewal').split(',');
    var images = el.querySelector('.imageCloneBox').querySelectorAll('.image');
    var svgmask = el.querySelector('.svgMaskContainer');
    if(!margins.length || !images.length) return;
    forEach(images, function(img, i) {
      img.style.margin =  margins[i];
    });
    svgmask.classList.add('hide');
    target.nextElementSibling.classList.remove('checkin-tool');
  }

  //right mark
  function createCorrectMark(el) {
    var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'), path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
    svg.setAttribute('class', 'svgmask imatch_svgright');
    path.setAttribute('stroke', 'green');
    path.setAttribute('fill', 'green');
    path.setAttribute('d', 'M 3 68 c 0 0 10 -11 22 -12 c 0 0 7 11 15 10 C 40 64 52 5 98 0 c 0 0 -38 22 -42 82 c -0.8 1.6 -19 12 -21 12 C 32 93 12 65 3 68z');
    svg.appendChild(path);
    return svg;
  }
  //false mark
  function createErrorMark(el) {
    var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'), path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
    svg.setAttribute('class', 'svgmask imatch_svgmistake');
    path.setAttribute('stroke', 'red');
    path.setAttribute('fill', 'red');
    path.setAttribute('d', 'M 89 0 L 51 38 L 13 0 C 8 4 4 8 0 13 l 38 38 L 0 90 c 4 5 8 9 13 13 L 50 65 L 90 100 c 5 -4 9 -8 13 -13 L 65 50 L 100 13 C 98 8 94 4 90 0z');
    svg.appendChild(path);
    return svg;
  }
  /**
   * 重置拼图控件，以适应不同浏览器播放
  */
  function resetClipPath(el) {
    var svg = el.querySelector('svg.clipSvg');
    var backImageBox = el.querySelector('.backImageBox');
    var mask = el.querySelector('.mask');
    var imageCloneBox = el.querySelector('.imageCloneBox');
    var imageClipPaths = svg.querySelectorAll('.imageClipPath');

    var svgBackImageBox = createSvgEle('g');
    var svgBackImage = createSvgEle('image');
    var svgMask = createSvgEle('g');
    // 设置控件大小
    var percentImage = getImagePercent(el);
    var minPer = Math.min(percentImage.pW, percentImage.pH);
    var backImage = el.querySelector('.backImage');
    el.style.height = backImage.naturalHeight * minPer + 'px';
    el.style.width = backImage.naturalWidth * minPer + 'px';
    var elRect = el.getBoundingClientRect();
    var elParetRect = el.parentElement.getBoundingClientRect();
    svg.setAttribute('width', elParetRect.width);
    svg.setAttribute('height', elParetRect.height);
    svg.setAttribute('xmlns:xlink', "http://www.w3.org/1999/xlink");
    // 复制背景图
    svgBackImage.setAttribute('xlink:href', backImageBox.firstElementChild.getAttribute('src'));
    svgBackImage.setAttribute('width', elRect.width);
    svgBackImage.setAttribute('height', elRect.height);
    svgBackImage.setAttribute('x', 0); // elLeft);
    svgBackImage.setAttribute('y', 0); // elTop);
    svgBackImage.classList.add('backImage');
    svgBackImageBox.appendChild(svgBackImage);
    svgBackImageBox.classList.add('backImageBox');
    svgBackImageBox.style.pointerEvents = 'none';
    // 移动遮罩层
    svgMask.classList.add('mask');
    svgMask.appendChild(svgBackImage.cloneNode(true));
    svgMask.setAttribute('style', mask.getAttribute('style'));
    mask.parentElement.removeChild(mask);
    svgMask.style.pointerEvents = 'none';
    // 移动克隆图层
    forEach(imageCloneBox.children, function(img, i) {
      var svgImageEle = createSvgEle('svg');
      var defsImageEle = createSvgEle('defs');
      var svgImageClone = createSvgEle('image');
      var clipPath = createSvgEle('clipPath');
      svgImageClone.setAttribute('style', img.getAttribute('style'));
      svgImageClone.setAttribute('xlink:href', img.getAttribute('src'));
      svgImageClone.setAttribute('class', img.getAttribute('class'));
      svgImageClone.setAttribute('width', elRect.width);
      svgImageClone.setAttribute('height', elRect.height);

      svgImageEle.classList.add('imageSvg');
      svgImageEle.setAttribute('xmlns:xlink', "http://www.w3.org/1999/xlink");
      svgImageEle.setAttribute('width', elRect.width);
      svgImageEle.setAttribute('height', elRect.height);
      svgImageEle.setAttribute('viewBox', '0 0 ' + elRect.width + ' ' + elRect.height);
      svgImageEle.setAttribute('style', img.getAttribute('style'));
      clipPath.innerHTML = imageClipPaths[i].innerHTML;
      clipPath.setAttribute('id', imageClipPaths[i].getAttribute('id'));
      clipPath.setAttribute('class', imageClipPaths[i].getAttribute('class'));
      defsImageEle.appendChild(clipPath); // svg中添加image的clipPath
      svgImageEle.appendChild(defsImageEle);
      svgImageEle.appendChild(svgImageClone); // svg中添加image
      imageCloneBox.insertBefore(svgImageEle, img); // svg加入到imageCloneBox中
      imageCloneBox.removeChild(img); // imageCloneBox删除掉原来的img
      svgImageEle.innerHTML += ''; // 刷新svg
    });
    
    svg.insertBefore(svgMask, svg.firstElementChild);
    svg.insertBefore(svgBackImageBox, svg.firstElementChild);
    forEach(imageClipPaths, function(clipPath) {
      clipPath.setAttribute('data-_id', clipPath.getAttribute('id'));
      clipPath.removeAttribute('id');
      clipPath.classList.remove('imageClipPath');
      // clipPath.parentElement.removeChild(clipPath);
    });
    clipMask(el, 0, 0);
    svg.innerHTML += ''; // 刷新svg
  }

  /**
   * 设置遮罩位置
   * 遮罩的位置应该为剪裁的实际位置，裁剪下来的图片被移动过
  */
  function clipMask(el, dx, dy) {
    if(!el) return;
    var maskPath = el.querySelector('.maskPath');
    maskPath.innerHTML = '';
    var imageClipPaths = el.querySelectorAll('.imageClipPath');
    forEach(imageClipPaths, function(kide) {
      var circle = kide.querySelector('ellipse');
      var path = kide.querySelector('path');
      if(circle) { // 添加circle遮罩
        maskPath.insertBefore(circle.cloneNode(true), null);
        return;
      }
      if(path) { // 添加path遮罩
        if(!maskPath.querySelector('path')) {
          maskPath.insertBefore(path.cloneNode(true), maskPath.firstElementChild);
        } else {
          maskPath.querySelector('path').setAttribute('d', maskPath.querySelector('path').getAttribute('d').replace('Z', path.getAttribute('d')));
          maskPath.querySelector('path').setAttribute('data-_d', maskPath.querySelector('path').getAttribute('data-_d').replace('Z', path.getAttribute('data-_d')));
        }
        return;
      }
    });
    var dataId = el.getAttribute('data-id');
    el.querySelector('.mask').style.clipPath = 'url(#maskPath-' + dataId + ')';
    el.querySelector('.mask').style['webkitClipPath'] = 'url(#maskPath-' + dataId + ')';
    clipMaskBorder(el);
  }

  /**
   * 添加遮罩的边框
  */
  function clipMaskBorder(el) {
    var maskPath = el.querySelector('.maskPath');
    var maskPathBorder = el.querySelector('.maskPathBorder');
    maskPathBorder.innerHTML = '';
    forEach(maskPath.children, function(kide) {
      var cloneEle = kide.cloneNode(true);
      cloneEle.classList.add('maskBorder');
      cloneEle.style.fill = el.dataset['_maskfill'];
      maskPathBorder.appendChild(cloneEle);
    });
  }

  /**
   * 是否包含
   * idtile 是否包含在 objinterRectsvg 内
  */
  function intersectOvTile(objinterRectsvg, tile) {
    var objTile = {
      x: objinterRectsvg.getAttributeNS(null, 'x'),
      y: objinterRectsvg.getAttributeNS(null, 'y'),
      w: objinterRectsvg.getAttributeNS(null, 'width'),
      h: objinterRectsvg.getAttributeNS(null, 'height')
    };
    return intersectrect(objTile, tile);
  }

  function parseRect(el, objintersvg) {
    var rectSvg = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
    var percentImage = getImagePercent(el);
    var minPer = Math.min(percentImage.pW, percentImage.pH);
    if(objintersvg.localName == 'path') {
      var d = objintersvg.getAttribute('data-_d');
      var points = d.replace(/[a-z]/ig, '').replace(/\s+$/, '').split(' ');
      var minX = points[0], maxX = points[0];
      var minY = points[1], maxY = points[1];
      for(var i = 2; i < points.length; i++) {
        if(i % 2 == 0) {
          minX = Math.min(minX, points[i]);
          maxX = Math.max(maxX, points[i]);
        } else {
          minY = Math.min(minY, points[i]);
          maxY = Math.max(maxY, points[i]);
        }
      }
      rectSvg.setAttribute('x', minX * minPer);
      rectSvg.setAttribute('y', minY * minPer);
      rectSvg.setAttribute('width', (maxX - minX) * minPer);
      rectSvg.setAttribute('height', (maxY - minY) * minPer);
    } else if(objintersvg.localName == 'ellipse') {
      var cx = parseFloat(objintersvg.getAttribute('data-_cx')) * minPer;
      var cy = parseFloat(objintersvg.getAttribute('data-_cy')) * minPer;
      var rx = parseFloat(objintersvg.getAttribute('data-_rx')) * minPer;
      var ry = parseFloat(objintersvg.getAttribute('data-_ry')) * minPer;
      rectSvg.setAttribute('x', cx - rx);
      rectSvg.setAttribute('y', cy - ry);
      rectSvg.setAttribute('width', rx * 2);
      rectSvg.setAttribute('height', ry * 2);
    } else {
      rectSvg = objintersvg;
    }
    return rectSvg;
  }

  function intersectrect(rect1, rect2) {
      var A = {x: parseFloat(rect1.x), y: parseFloat(rect1.y)};
      var B = {x: parseFloat(rect1.x) + parseFloat(rect1.w), y: parseFloat(rect1.y)};
      var C = {x: parseFloat(rect1.x) + parseFloat(rect1.w), y: parseFloat(rect1.y) + parseFloat(rect1.h)};
      var D = {x: parseFloat(rect1.x), y: parseFloat(rect1.y) + parseFloat(rect1.h)};

      var E = {x: parseFloat(rect2.x), y: parseFloat(rect2.y)};
      var F = {x: parseFloat(rect2.x) + parseFloat(rect2.w), y: parseFloat(rect2.y)};
      var G = {x: parseFloat(rect2.x) + parseFloat(rect2.w), y: parseFloat(rect2.y) + parseFloat(rect2.h)};
      var H = {x: parseFloat(rect2.x), y: parseFloat(rect2.y) + parseFloat(rect2.h)};

    var intersection = false;
    if (pointinRectangle(rect2, A)) { intersection = true; return intersection; }
    else if (pointinRectangle(rect2, B)) { intersection = true; return intersection; }
    else if (pointinRectangle(rect2, C)) { intersection = true; return intersection; }
    else if (pointinRectangle(rect2, D)) { intersection = true; return intersection; }

    else if (pointinRectangle(rect1, E)) { intersection = true; return intersection; }
    else if (pointinRectangle(rect1, F)) { intersection = true; return intersection; }
    else if (pointinRectangle(rect1, G)) { intersection = true; return intersection; }
    else if (pointinRectangle(rect1, H)) { intersection = true; return intersection; }

    else if (intersect2segment(A, B, E, F)) { intersection = true; return intersection; }
    else if (intersect2segment(A, B, F, G)) { intersection = true; return intersection; }
    else if (intersect2segment(A, B, G, H)) { intersection = true; return intersection; }
    else if (intersect2segment(A, B, H, E)) { intersection = true; return intersection; }
    else if (intersect2segment(B, C, E, F)) { intersection = true; return intersection; }
    else if (intersect2segment(B, C, F, G)) { intersection = true; return intersection; }
    else if (intersect2segment(B, C, G, H)) { intersection = true; return intersection; }
    else if (intersect2segment(B, C, H, E)) { intersection = true; return intersection; }
    else if (intersect2segment(C, D, E, F)) { intersection = true; return intersection; }
    else if (intersect2segment(C, D, F, G)) { intersection = true; return intersection; }
    else if (intersect2segment(C, D, G, H)) { intersection = true; return intersection; }
    else if (intersect2segment(C, D, H, E)) { intersection = true; return intersection; }
    else if (intersect2segment(D, A, E, F)) { intersection = true; return intersection; }
    else if (intersect2segment(D, A, F, G)) { intersection = true; return intersection; }
    else if (intersect2segment(D, A, G, H)) { intersection = true; return intersection; }
    else if (intersect2segment(D, A, H, E)) { intersection = true; return intersection; }

    return intersection;
  }

  function pointinRectangle(rectobj, checkPoint) {
    var A = {x: parseFloat(rectobj.x), y: parseFloat(rectobj.y)};
    var B = {x: parseFloat(rectobj.x) + parseFloat(rectobj.w), y: parseFloat(rectobj.y)};
    var C = {x: parseFloat(rectobj.x) + parseFloat(rectobj.w), y: parseFloat(rectobj.y) + parseFloat(rectobj.h)};
    var D = {x: parseFloat(rectobj.x), y: parseFloat(rectobj.y) + parseFloat(rectobj.h)};

    var tabd = new Array();

    tabd[0] = A.x; tabd[1] = A.y;
    tabd[2] = B.x; tabd[3] = B.y;
    tabd[4] = C.x; tabd[5] = C.y;
    tabd[6] = D.x; tabd[7] = D.y;
    tabd[8] = A.x; tabd[9] = A.y;
    var lentabd = 11;

    var counter = 0;
    for (var i = 0; i < lentabd - 3; i = i + 2) {
      var p1x = parseFloat(tabd[i]);
      var p1y = parseFloat(tabd[i + 1]);
      var p2x = parseFloat(tabd[i + 2]);
      var p2y = parseFloat(tabd[i + 3]);
      if (checkPoint.y > Math.min(p1y, p2y)) {
        if (checkPoint.y <= Math.max(p1y, p2y)) {
          if (checkPoint.x <= Math.max(p1x, p2x)) {
            if (p1y != p2y) {
              var x_inter = (checkPoint.y - p1y) * (p2x - p1x) / (p2y - p1y) + p1x;
              if (p1x == p2x || checkPoint.x <= x_inter) { counter++; }
            }
          }
        }
      }
    }
    return counter % 2 == 1;
  }

  function intersect2segment(point1, point2, point3, point4) {
    var afirst;
    var asec;
    var bfirst;
    var bsec;
    var intersection;
    var vector1vert = false;
    var vector2vert = false;

    if (point2.x != point1.x) {
      afirst = (point2.y - point1.y) / (point2.x - point1.x);
      bfirst = (point1.y) - (afirst * point1.x);
    } else vector1vert = true;

    if (point3.x != point4.x) {
      asec = (point4.y - point3.y) / (point4.x - point3.x);
      bsec = parseFloat(point3.y) - (asec * point3.x);
    } else vector2vert = true;

    intersection = false;
    if (!vector1vert || !vector2vert) {
      if (!vector1vert && !vector2vert) {
        if (afirst != asec) {
          var y_inter = (afirst * (bsec - bfirst) / (afirst - asec)) + parseFloat(bfirst);
          var x_inter = ((bfirst - bsec) / (asec - afirst));
          if ((y_inter >= Math.min(point1.y, point2.y)) && (y_inter <= Math.max(point1.y, point2.y))) {
            if ((y_inter >= Math.min(point3.y, point4.y)) && (y_inter <= Math.max(point3.y, point4.y))) {
              if ((x_inter >= Math.min(point1.x, point2.x)) && (x_inter <= Math.max(point1.x, point2.x))) {
                if ((x_inter >= Math.min(point3.x, point4.x)) && (x_inter <= Math.max(point3.x, point4.x))) {
                  intersection = true;
                }
              }
            }
          }
        } else {
          if (bfirst == bsec) {
            if (Math.min(point3.x, point4.x) <= Math.max(point1.x, point2.x)) {
              if (Math.max(point3.x, point4.x) >= Math.min(point1.x, point2.x)) {
                intersection = true;
              }
            }
          }
        }
      } else {
        if (vector1vert) {
          if ((point1.x >= Math.min(point3.x, point4.x)) && (point1.x <= Math.max(point3.x, point4.x))) {
            y_inter = parseFloat(asec * point3.x + bsec);
            if ((bsec >= Math.min(point1.y, point2.y)) && (bsec <= Math.max(point1.y, point2.y))) {
              intersection = true;
            }
          }
        }
        if (vector2vert) {
          if ((point3.x >= Math.min(point1.x, point2.x)) && (point3.x <= Math.max(point1.x, point2.x))) {
            y_inter = parseFloat(afirst * point1.x + bfirst);
            if ((y_inter >= Math.min(point3.y, point4.y)) && (y_inter <= Math.max(point3.y, point4.y))) {
              intersection = true;
            }
          }
        }
      }
    } else {
      if (point1.x == point3.x) {
        if (Math.min(point3.y, point4.y) <= Math.max(point1.y, point2.y)) {
          if (Math.max(point3.y, point4.y) >= Math.min(point1.y, point2.y)) {
            intersection = true;
          }
        }
      }
    }
    return intersection;
  }

  /**
   * 获取图片的缩放比例
  */
  function getImagePercent(el) {
    var backImage = el.querySelector('div.backImageBox > .backImage');
    if(backImage) {
      // backImage.style.width = '100%';
      // backImage.style.height = '100%';
      var biRect = etb_book.offSetRect(backImage);
      var percentW = biRect.width / backImage.naturalWidth;
      var percentH = biRect.height / backImage.naturalHeight;
      return {
        pW: percentW,
        pH: percentH
      }
    } else {
      return {
        pW: 1,
        pH: 1
      }
    }
  }

  function createElement(str) {
    return document.createElement(str);
  }

  function createSvgEle(str) {
    return document.createElementNS('http://www.w3.org/2000/svg', str);
  }

  function stopPropagation(ev) {
    ev.stopPropagation();
  }
  function preventDefault(ev) {
    ev.preventDefault();
  }
  //drag area content
  function ondragstart(ev) {
    ev.preventDefault();
  }

  //forEach
  function forEach(arr, fn) {
    return Array.prototype.slice.call(arr, 0).forEach(fn);
  }

  //get Ancestors
  function getAncestors(node, filter) {
    var ret = [];
    var docType = Node.DOCUMENT_NODE;
    for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
      try {
        if (filter && filter(cur))
          ret.push(cur);
      }
      catch (e) {
        console.warn(e.stack || e);
      }
    }
    return ret;
  }

  /**
   * （尽可能）读取当前CSS计算值，并转为数值。参见 getCssValue()。
   */
  function getCSSNumber(el, propName) {
    return parseFloat(getCSSValue(el, propName));
  }
  /**
   * 读取当前CSS计算值。
   * *详见mbe_core.CSSUtils.getCSSValue
   */
  function getCSSValue(el, propName) {
    var cv = el.ownerDocument.defaultView &&
      el.ownerDocument.defaultView.getComputedStyle(el).getPropertyValue(propName);
    return cv || (el.style && el.style.getPropertyValue(propName)) || '';
  }
})(etb_controls.mainbo_clippath || (etb_controls.mainbo_clippath = {}))