(function (choice_question) {

  function init(el) {
    setEditing(el, false);
  }

  choice_question.init = init;

  function setEditing(el, editing) {
  	el.addEventListener('click', stopPropagation);
    var options = el.querySelector('ol').querySelectorAll('li > span');
    setOptionsNum(el, options);
    setEvent(el, editing);
    clearAnswer(options, el);
    enableEditor(el, editing);
    removeElementBIn(el, isSingleOrMultiple(el));
    if (editing) {
      clearAnswerMark(el);
      if (el.dataset['answer'])
        setAnswer(el, options, el.dataset['answer'].split(','), 'teacher-answer');
      el.querySelector('footer button').textContent = isFillBlank(el) || isSubjective(el) ? '查看答案' : '核对答案';
      if (el.querySelectorAll('footer button')[0].dataset['continueAnswer']) {
        el.querySelector('footer button').removeAttribute('data-continue-answer');
      }
    }
 }

  choice_question.setEditing = setEditing;
  function stopPropagation(ev) {
  	ev.stopPropagation();
  }
  function setOptionsNum(el, options) {
    if (isBooleanSelection(el)) return;
    for (var i = 0, j = 65, len = options.length; i < len; i++, j++) {
      options[i].textContent = String.fromCharCode(j);
    }
  }
  
  function clearAnswerBlank(options) {
    for (var i = 0, len = options.length; i < len; i++) {
      options[i].innerHTML = ' ';
    }
  }

  function clearAnswer(options, el) {
    for (var i = 0, len = options.length; i < len; i++) {
      options[i].removeAttribute('class');
    }
     if (isBooleanSelection(el)) options[0].classList.add('mbe-icon-checkbox-thin');
  }

  function enableEditor(el, editing) {
    var editP = el.querySelectorAll('ol p'), question = el.querySelector('dt p'), showTeacherAnalysis = el.querySelector('section');
    if (editing) {
      question.setAttribute('contenteditable', 'true');
      showTeacherAnalysis.style.visibility = 'visible';
      for (var i = 0, len = editP.length; i < len; i++) {
        editP[i].setAttribute('contenteditable', 'true');
      }
    }
    else {
      question.removeAttribute('contenteditable');
      showTeacherAnalysis.style.visibility = 'hidden';
      for (var i = 0, len = editP.length; i < len; i++) {
        editP[i].removeAttribute('contenteditable');
      }

      if(isSubjective(el)) el.dataset['answer'] = '0';
      if(isFillBlank(el)){
        if(!el.dataset['answer']) el.dataset['answer'] = '';
        Array.prototype.slice.call(el.querySelectorAll('span.fill-blank'), 0).forEach(function(blank, i) {
          el.dataset['answer'] += blank.innerHTML + ',';
          blank.innerHTML = ' ';
          blank.setAttribute('contenteditable', 'true');
        });
      }
    }
  }

  function getAnswer(options, classname) {
    for (var i = 0, optionsLen = options.length, arr = []; i < optionsLen; i++) {
      if (options[i].className && (options[i].classList.contains(classname)))
        arr.push(i);
    }
    for (var i = 0, arrLen = arr.length; i < arrLen; i++) {
      if (arr.length)
        return arr.join();
    }
    return false;
  }

  function setAnswerBlank(options, answer){
    if(!options.length) return;
    Array.prototype.slice.call(answer, 0).forEach(function(value, i){
      if(!value) return;
      options[i].innerHTML = value;
    });
  }

  function setAnswer(el, options, answer, classname) {
    if (isBooleanSelection(el)) {
      (Number(answer[0]) !== undefined) && options[0].classList.add(classname);
      var val = classname == 'student-answer' ? answer[0] : el.dataset['answer'];
      switch (val) {
        case '0':
          options[0].classList.add('mbe-icon-checkbox-thin-true');
          break;
        case '1':
          options[0].classList.add('mbe-icon-checkbox-thin-false');
          break;
        default:
          options[0].classList.add('mbe-icon-checkbox-thin');
          break;
      }
    } else {
      answer.forEach(function (value, index) {
        !isNaN(Number(value)) && options[value].classList.add(classname);
      });
    }
  }
  
  function clearAnswerMark(el) {
    if (el.querySelector('dd svg'))
      el.querySelector('dd').removeChild(el.querySelector('dd svg'));
  }

  function showTeacherAnalysis(el, displayState) {
    var say = el.querySelector('section'), content = say.querySelector('div p');
    switch (displayState) {
      case true:
        say.style.visibility = 'visible';
        content.setAttribute('contenteditable', 'true');
        break;
      default:
        say.style.visibility = 'hidden';
        content.removeAttribute('contenteditable');
    }
  }

  function createCorrectMark() {
    var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'),
      path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
    svg.setAttribute('class', 'svgmask imatch_svgright');
    svg.style.transform = 'scale(0.3) translate(-100%,-100%)';
    path.setAttribute('stroke', 'green');
    path.setAttribute('fill', 'green');
    path.setAttribute('d', 'M 3 68 c 0 0 10 -11 22 -12 c 0 0 7 11 15 10 C 40 64 52 5 98 0 c 0 0 -38 22 -42 82 c -0.8 1.6 -19 12 -21 12 C 32 93 12 65 3 68z');
    svg.appendChild(path);
    return svg;
  }

  function createErrorMark() {
    var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'),
      path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
    svg.setAttribute('class', 'svgmask imatch_svgmistake')
    svg.style.transform = 'scale(0.3) translate(-100%,-100%)';
    path.setAttribute('stroke', 'red');
    path.setAttribute('fill', 'red');
    path.setAttribute('d', 'M 89 0 L 51 38 L 13 0 C 8 4 4 8 0 13 l 38 38 L 0 90 c 4 5 8 9 13 13 L 50 65 L 90 100 c 5 -4 9 -8 13 -13 L 65 50 L 100 13 C 98 8 94 4 90 0z');
    svg.appendChild(path);
    return svg;
  }

  function arrayEquals(arr1, arr2) {
    if (arr1.length === arr2.length) {
      return arr1.every(function (value, index) {
        return value === arr2[index] ? true : false;
      });
    }
  }

  function isSingleOrMultiple(el) {
    switch (el.dataset['control']) {
      case 'mainbo_single_selection':
        return true;
      case 'mainbo_mutiple_selection':
        return false;
      default:
        return undefined;
    }
  }

  function isBooleanSelection(el) {
    switch (el.dataset['control']) {
      case 'mainbo_boolean_selection':
        return true;
      default:
        return false;
    }
  }

  function isSubjective(el) {
    switch (el.getAttribute('data-control')){
      case 'mainbo_subjective':
        return true;
      default:
        return false;
    }
  }
  
  function isFillBlank(el) {
    switch (el.getAttribute('data-control')){
      case 'mainbo_fill_blank':
        return true;
      default:
        return false;
    }
  }

  function removeElementBIn(el, isSingle) {
    if (isSingle === undefined) return;
    var selectionOl = el.getElementsByTagName('ol')[0];
    var selectionLi = selectionOl.getElementsByTagName('li');
    for(var i = 0; i < selectionLi.length; i++) {
      if (selectionLi[i].getElementsByTagName('b').length) {
        selectionLi[i].removeChild(selectionLi[i].getElementsByTagName('b')[0]);
      }
    }
    selectionOl.parentNode.style.marginLeft = '0.9rem';
  }

  function alertRect(el, str, options) {
    var _document = document.querySelector('iframe').contentDocument;
    var options = options || [];
    var alertWarn = document.createElement('div');
    var alertHeader = document.createElement('header');
    var alertMessage = document.createElement('div');
    var alertButton = document.createElement('button');
    var alertClose = document.createElement('span');
    var imgMessage = document.createElement('span');
    alertMessage.textContent = str;
    alertButton.textContent = '确认';
    alertHeader.innerHTML = '提示信息';
    imgMessage.classList.add('mbe-icon-exclamation');
    alertClose.classList.add('mbe-icon-close-thin');
    if (options.length) {
      alertWarn.classList.add(options[0]);
      alertMessage.classList.add(options[1]);
      alertButton.classList.add(options[2]);
    }
    alertClose.onclick = alertButton.onclick = function (ev) {
      ev.stopPropagation();
      el.parentNode.removeChild(alertWarn);
      el.parentNode.style.pointerEvents = 'auto';
    }
    alertHeader.appendChild(alertClose);
    alertWarn.appendChild(alertHeader);
    alertMessage.appendChild(imgMessage);
    alertWarn.appendChild(alertMessage);
    alertWarn.appendChild(alertButton);
    var scale = parseFloat(getComputedStyle(document.querySelector('iframe'), null).transform.split(/,|\(/)[1]);
    if(scale > 1) {
      alertWarn.style.left = parseInt((0.5 / scale) * 100 + '') + '%';
      alertWarn.style.top = parseInt((0.5 / scale) * 100 + '') + '%';
    }
    el.parentNode.appendChild(alertWarn);
    el.parentNode.style.pointerEvents = 'none';
  }

function setEvent(el, editing) {
  var selectorBox = el.querySelector('dd'),
      options = selectorBox.querySelectorAll('li > span'),
      button = el.querySelector('footer').getElementsByTagName('button'),
      li = el.querySelector('ol').getElementsByTagName('li');
  // el.style.height = 'auto';
  if (editing) {
    for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
      li[i].onclick = null;
      if (li[i].hasAttribute('style')) {
        li[i].removeAttribute('style');
      }
      if (isBooleanSelection(el)) {
        if (!el.dataset['answer']) {
          this.classList.add('mbe-icon-checkbox-thin-true');
          this.classList.add('teacher-answer');
          el.dataset['answer'] = '0';
        } else if (el.dataset['answer'] === '0') {
          this.classList.add('mbe-icon-checkbox-thin-true');
          el.dataset['answer'] = '1';
        } else if (el.dataset['answer'] === '1') {
          clearAnswer(options, el);
          this.classList.add('mbe-icon-checkbox-thin')
          el.removeAttribute('data-answer');
        }
      } else {
        options[i].onclick = function () {
          if (isSingleOrMultiple(el)) {
            if (this.classList.contains('teacher-answer')) {
              this.classList.remove('teacher-answer');
            }else {
               this.classList.add('teacher-answer');
            }
          } else {
            this.classList.toggle('teacher-answer')
          }
          if (getAnswer(options, 'teacher-answer')){
            el.dataset['answer'] = getAnswer(options, 'teacher-answer')
          }else{
            el.removeAttribute('data-answer')
          }
        }
      }
    }
    button[1].onclick = button[0].onclick = null;
  }else {
    var section = el.querySelector('section');
    for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
      if (isBooleanSelection(el)) {
        options[0].onclick = null;
        li[0].style.cursor = 'pointer';
        li[0].onclick = function () {
          if (!el.booleanAnswer) {
            li[0].querySelector('span').classList.add('mbe-icon-checkbox-thin-true');
            li[0].querySelector('span').classList.add('student-answer');
            el.booleanAnswer = ['0'];
          } else if (el.booleanAnswer[0] === '0') {
            li[0].querySelector('span').classList.add('mbe-icon-checkbox-thin-false');
            el.booleanAnswer = ['1'];
          } else if (el.booleanAnswer[0] === '1') {
            clearAnswer(options, el);
            li[0].querySelector('span').classList.add('mbe-icon-checkbox-thin');
            el.booleanAnswer = undefined;
          }
        }
      }
      else {
        options[i].onclick = null;
        li[i].style.cursor = 'pointer';
        li[i].onclick = function () {
          if (isSingleOrMultiple(el)) {
            if (this.querySelector('span').classList.contains('student-answer')){
              this.querySelector('span').classList.remove('student-answer')
            }else {
               clearAnswer(options, el);
               this.querySelector('span').classList.add('student-answer')
            }
            el.singleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined;
          }else {
            this.querySelector('span').classList.toggle('student-answer');
            el.multipleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined;
          }
        }
      }
      
    }
    button[0].onclick = function() {
      showTeacherAnalysis(el, false);
      if (el.dataset['answer']) {
        clearAnswer(options, el)
      }
      for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
        if (isBooleanSelection(el)) {
          li[0].onclick = function () {
            if (!el.booleanAnswer) {
              li[0].querySelector('span').classList.add('mbe-icon-checkbox-thin-true');
              li[0].querySelector('span').classList.add('student-answer');
              el.booleanAnswer = ['0'];
            } else if (el.booleanAnswer[0] === '0') {
              li[0].querySelector('span').classList.add('mbe-icon-checkbox-thin-false');
              el.booleanAnswer = ['1'];
            } else if (el.booleanAnswer[0] === '1') {
              clearAnswer(options, el);
              li[0].querySelector('span').classList.add('mbe-icon-checkbox-thin');
              el.booleanAnswer = undefined;
            }
          }
        }
        else {
          li[i].onclick = function () {
            if (isSingleOrMultiple(el)) {
              if (this.querySelector('span').classList.contains('student-answer'))
                this.querySelector('span').classList.remove('student-answer');
              else {
                clearAnswer(options, el);
                this.querySelector('span').classList.add('student-answer');
              }
              el.singleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined;
            }else {
               this.querySelector('span').classList.toggle('student-answer');
               el.multipleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined
            }
          }
        }
      }
      if(isFillBlank(el) || isSubjective(el)) {
        this.dataset.continueAnswer = true;
      }
      switch (this.dataset.continueAnswer) {
        case undefined:
          if (!el.dataset['answer'])
            return alertRect(el, '未设置答案', ['mbe-alert-selection', 'mbe-alert-selection-message', 'mbe-alert-selection-button']);
          clearAnswer(options, el);
          el.booleanAnswer = el.booleanAnswer || [];
          el.singleAnswer = el.singleAnswer || [];
          el.multipleAnswer = el.multipleAnswer || [];
          setAnswer(el, options, isBooleanSelection(el) ? el.booleanAnswer : isSingleOrMultiple(el) ? el.singleAnswer : el.multipleAnswer, 'student-answer');
          switch (arrayEquals(el.dataset['answer'].split(','), isBooleanSelection(el) ? el.booleanAnswer : isSingleOrMultiple(el) ? el.singleAnswer : el.multipleAnswer)) {
            case true:
              selectorBox.appendChild(createCorrectMark());
              break;
            default:
              selectorBox.appendChild(createErrorMark());
            }
          this.textContent = '查看答案';
          this.dataset.continueAnswer = true;
          for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
            li[i].onclick = null;
          }
          break;
        case 'true':
          clearAnswerMark(el);
          clearAnswer(options, el);
          if (!el.dataset['answer'] && !isFillBlank(el)) {
            if (isBooleanSelection(el)) el.querySelector('ol li span').textContent = '';
            return {Name: 'div', Kids:['未设置答案'], '-position': 'absolute', }
          }
          for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
            li[i].onclick = null;
          }
          if(isFillBlank(el)){
            setAnswerBlank(el.querySelectorAll('span.fill-blank'), el.dataset['answer'].split(','));
          }else{
            setAnswer(el, options, el.dataset['answer'].split(','), 'teacher-answer');
          }
          showTeacherAnalysis(el, true);
          if(isFillBlank(el) || isSubjective(el)){
            button[0].setAttribute('hidden', 'hidden');
            button[1].removeAttribute('hidden');
          }
          el.querySelector('section div p').removeAttribute('contenteditable');
      }
    }
    button[1].onclick = function () {
      clearAnswerMark(el);
      clearAnswer(options, el);
      isBooleanSelection(el) ? (el.booleanAnswer = undefined) : isSingleOrMultiple(el) ? (el.singleAnswer = undefined) : (el.multipleAnswer = undefined);
      showTeacherAnalysis(el, false);
      button[0].dataset.continueAnswer = undefined;
      button[0].textContent = isFillBlank(el) || isSubjective(el) ? '查看答案' : '核对答案';
      button[0].removeAttribute('data-continue-answer');
      if(isFillBlank(el) || isSubjective(el)){
        button[1].setAttribute('hidden', 'hidden');
        button[0].removeAttribute('hidden');
        if(isFillBlank(el)){
          clearAnswerBlank(el.querySelectorAll('span.fill-blank'));
        }
        return;
      }
      for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
        if (isBooleanSelection(el)) {
          clearAnswer(options, el);
          el.booleanAnswer = undefined;
          li[0].onclick = function () {
            if (!el.booleanAnswer) {
              li[0].querySelector('span').classList.add('mbe-icon-checkbox-thin-true');
              li[0].querySelector('span').classList.add('student-answer');
              el.booleanAnswer = ['0'];
            } else if (el.booleanAnswer[0] === '0') {
              li[0].querySelector('span').classList.add('mbe-icon-checkbox-thin-false');
              el.booleanAnswer = ['1'];
            } else if (el.booleanAnswer[0] === '1') {
              clearAnswer(options, el);
              li[0].querySelector('span').classList.add('mbe-icon-checkbox-thin');
              el.booleanAnswer = undefined;
            }
          }
        }
        else {
          li[i].onclick = function () {
            if (isSingleOrMultiple(el)) {
              if (this.querySelector('span').classList.contains('student-answer'))
                this.querySelector('span').classList.remove('student-answer');
              else {
                clearAnswer(options, el);
                this.querySelector('span').classList.add('student-answer');
              }
              el.singleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined;
            } else {
              this.querySelector('span').classList.toggle('student-answer');
              el.multipleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined;
            }
          }
        }
      }
    }
  }
}
})(etb_controls.mainbo_choice_question || (etb_controls.mainbo_choice_question = {}));

(function(etb_controls){
  etb_controls.mainbo_single_selection = etb_controls.mainbo_choice_question;
  etb_controls.mainbo_mutiple_selection = etb_controls.mainbo_choice_question;
  etb_controls.mainbo_boolean_selection = etb_controls.mainbo_choice_question;
  etb_controls.mainbo_subjective = etb_controls.mainbo_choice_question;
  etb_controls.mainbo_fill_blank = etb_controls.mainbo_choice_question;
})(etb_controls || (etb_controls = {}));
