(function (audiopanel) {
  function init(el) {
    var playBtn = el.querySelector('button');
    playBtn.addEventListener('click', playClick.bind(playBtn));
  }
  audiopanel.init = init;

  function playClick() {
    var i = this.querySelector('i');
    if(i.classList.contains('mbe-icon-pause')) {
      i.classList.remove('mbe-icon-pause');
    } else {
      i.classList.add('mbe-icon-pause');
    }
    var audio = this.parentElement.querySelector('audio');
    audioPlay(audio);
    audio.addEventListener('ended', () => {
      i.classList.remove('mbe-icon-pause');
    });
  }
  audiopanel.playClick = playClick;
  
  /**
  * 音频播放或暂停
  */
  function audioPlay(audio) {
    if (audio.ended) audio.isplay = false;
    if (!audio.isplay || audio.currentTime < 0.1) {
      audio.play();
      audio.isplay = true;
    }
    else {
      audio.pause();
      audio.isplay = false;
    }
    return audio.isplay;
  }

})(etb_controls.mainbo_audiopanel || (etb_controls.mainbo_audiopanel = {}));
