﻿(function (mainbo_angle) {
	var SVG_NS = 'http://www.w3.org/2000/svg';
	var pathFillColor = ['rgba(60,176,53,1)', 'rgba(246,153,76, 1)', 'rgba(247,91,75, 1)', 'rgba(126,113,229, 1)', 'rgba(234,76,137, 1)', 'rgba(25,181,255, 1)'];
	function init(el) {
		setEditing(el, true);
	}
	function setEditing(el, editing) {
		el.setAttribute('data-startdeg', '0');
		el.setAttribute('data-count', '0');
		[].forEach.call(el.querySelectorAll('[data-deg]'), function (item, index) {
			item.addEventListener('click', addPathDeg);
		});
		el.querySelector('.mbe-angle-resbtn').addEventListener('click', resetAnglePath);
	}

	function addPathDeg(ev) {
		console.log('sure');
		var this_el = getAncestors(ev.target, function (el) {
			return el.hasAttribute('data-control');
		}).pop();
		var target = (ev.target.hasAttribute('data-deg') && ev.target) || getAncestors(ev.target, function (el) {
			return el.hasAttribute('data-deg');
		}).pop();
		if (target) {
			switch (target.getAttribute('data-deg')) {
				case '20':
					add20deg(target, 20);
					break;
				case '40':
					add20deg(target, 40);
					break;
				case '60':
					add20deg(target, 60);
					break;
				case '90':
					add20deg(target, 90);
					break;
				default: break;
			}
		}
	}

	function add20deg(el, incresedeg) {
		var hel = el;
		var control = getAncestors(hel, function (elem) {
			return elem.hasAttribute('data-control');
		}).pop();
		var startdeg = parseFloat(control.getAttribute('data-startdeg'));
		var dcount = parseFloat(control.getAttribute('data-count'))
		if (parseFloat(startdeg) >= 120) {
			return false;
		}
		var board = control.querySelector('.mbe-angle-content > svg');
		var newpath1 = el.ownerDocument.createElementNS(SVG_NS, 'path');
		var newpath2 = el.ownerDocument.createElementNS(SVG_NS, 'path');
		var r = 100;
		var left = (250 + Math.cos((startdeg) / 180 * Math.PI) * 100);
		var top = (250 - Math.sin((startdeg) / 180 * Math.PI) * 100);

		var leftbig = (250 + Math.cos((startdeg + incresedeg) / 180 * Math.PI) * 200);
		var topbig = (250 - Math.sin((startdeg + incresedeg) / 180 * Math.PI) * 200);

		var left20 = (250 + Math.cos((startdeg + incresedeg) / 180 * Math.PI) * 100);
		var top20 = (250 - Math.sin((startdeg + incresedeg) / 180 * Math.PI) * 100);

		if (startdeg < 90) {
			// 长线
			newpath1.setAttribute('d', 'M250 250L' + leftbig + ' ' + topbig);
			newpath1.style.stroke = 'gray';
			newpath1.style.strokeWidth = '2px';
			board.appendChild(newpath1);
			// 弧度
			newpath2.setAttribute('d', 'M250 250L' + left + ' ' + top + ' A100 100 0 0 0 ' + left20 + ' ' + top20);
			newpath2.style.stroke = pathFillColor[dcount];
			newpath2.style.fill = pathFillColor[dcount];
			newpath2.style.strokeWidth = '2px';
			board.appendChild(newpath2);
		} else {
			// 长线
			newpath1.setAttribute('d', 'M250 250L' + leftbig + ' ' + topbig);
			newpath1.style.stroke = 'gray';
			newpath1.style.strokeWidth = '2px';
			board.appendChild(newpath1);
			// 弧度
			newpath2.setAttribute('d', 'M250 250L' + left + ' ' + top + ' A100 100 0 0 0 ' + left20 + ' ' + top20);
			newpath2.style.stroke = pathFillColor[dcount];
			newpath2.style.fill = pathFillColor[dcount];
			newpath2.style.strokeWidth = '2px';
			board.appendChild(newpath2);
		}
		control.setAttribute('data-startdeg', parseFloat(startdeg) + incresedeg);
		control.setAttribute('data-count', dcount + 1);
	}

	function resetAnglePath(ev) {
		var this_el = getAncestors(ev.target, function (el) {
			return el.hasAttribute('data-control');
		}).pop();
		var board = this_el.querySelector('.mbe-angle-content > svg');
		while (true) {
			if (board.children.length == 1) {
				break;
			}
			board.removeChild(board.lastElementChild);
		}
		this_el.setAttribute('data-startdeg', '0');
		this_el.setAttribute('data-count', '0');
	}

	function getAncestors(node, filter) {
		var ret = [];
		var docType = Node.DOCUMENT_NODE;
		for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
			try {
				if (filter && filter(cur))
					ret.push(cur);
			}
			catch (e) {
				console.warn(e.stack || e);
			}
		}
		return ret;
	}
	mainbo_angle.init = init;
})(mainbo_angle = etb_controls.mainbo_angle || (etb_controls.mainbo_angle = {}));