window.onload = function () {
  // 滑块
  var targetDrag = document.querySelector(".mbe-tailor-box");
  // 滑动区域
  var targetDragParent = targetDrag.parentNode;
  // 遮盖线
  var lineTop = document.querySelector(".lineTop");
  var lineBottom = document.querySelector(".lineBottom");
  // 蒙版区域
  var areaLeft = document.querySelector(".areaLeft");
  var areaRight = document.querySelector(".areaRight");
  var areaTop = document.querySelector(".areaTop");
  var areaBottom = document.querySelector(".areaBottom");
  function mouseDown(e) {
    e.stopPropagation();
    var _offsetParent = targetDragParent.getBoundingClientRect();
    var _offset = targetDrag.getBoundingClientRect();
    var _offsetNow = null;
    var _x = e.clientX;
    var _y = e.clientY;
    var _xNow = 0;
    var _yNow = 0;
    document.onmousemove = function (ev) {
      _offsetNow = targetDrag.getBoundingClientRect();
      _xNow = ev.clientX;
      _yNow = ev.clientY;
      targetDrag.style.left = (_offset.left - _offsetParent.left + _xNow - _x) + "px";
      targetDrag.style.top = (_offset.top - _offsetParent.top + _yNow - _y) + "px";
      if (parseInt(targetDrag.style.left) < 0) {
        targetDrag.style.left = 0;
      }
      if (parseInt(targetDrag.style.left) > (_offsetParent.width - _offset.width)) {
        targetDrag.style.left = (_offsetParent.width - _offset.width) + "px";
      }
      if (parseInt(targetDrag.style.top) < 0) {
        targetDrag.style.top = 0;
      }
      if (parseInt(targetDrag.style.top) > (_offsetParent.height - _offset.height)) {
        targetDrag.style.top = (_offsetParent.height - _offset.height) + "px";
      }
      // 移动蒙版
      lineTop.style.top = (_offsetNow.top - _offsetParent.top - 1) + "Px";
      lineBottom.style.top = (_offsetNow.bottom - _offsetParent.top) + "px";
      
      areaTop.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaTop.style.width = (_offsetNow.width) + "px";
      areaTop.style.height = (_offsetNow.top - _offsetParent.top) + "px";
      areaRight.style.width = (_offsetParent.right - _offsetNow.right) + "px";
      areaBottom.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaBottom.style.width = (_offsetNow.width) + "px";
      areaBottom.style.height = (_offsetParent.bottom - _offsetNow.bottom) + "px";
      areaLeft.style.width = (_offsetNow.left - _offsetParent.left) + "px";
    }
    document.onmouseup = function () {
      document.onmousemove = null;
      document.onmousedown = null;
    }
  }
  
  /**
   * 滑动右边线
   * @param {Object} e
   */
  function mouseDownLineR(e) {
    e.stopPropagation();
    var _offsetParent = targetDragParent.getBoundingClientRect();
    var _offset = targetDrag.getBoundingClientRect();
    var _offsetNow = null;
    var _x = e.clientX;
    var _xNow = 0;
    document.onmousemove = function (ev) {
      _offsetNow = targetDrag.getBoundingClientRect();
      _xNow = ev.clientX;
      // 放大缩小滑块
      targetDrag.style.width = (_xNow - _offsetNow.left) + "px";
      // 判断最大值，超出设置最大值
      if (parseInt(targetDrag.style.width) > (_offsetNow.width + _offsetParent.right - _offsetNow.right)) {
        targetDrag.style.width = (_offsetNow.width + _offsetParent.right - _offsetNow.right) + "px";
      }
      // 移动蒙版
      lineTop.style.top = (_offsetNow.top - _offsetParent.top - 1) + "Px";
      lineBottom.style.top = (_offsetNow.bottom - _offsetParent.top) + "px";
      areaLeft.style.width = (_offsetNow.left - _offsetParent.left) + "px";
      areaRight.style.width = (_offsetParent.right - _offsetNow.right) + "px";
      areaTop.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaTop.style.width = (_offsetNow.width) + "px";
      areaTop.style.height = (_offsetNow.top - _offsetParent.top) + "px";
      areaBottom.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaBottom.style.width = (_offsetNow.width) + "px";
      areaBottom.style.height = (_offsetParent.bottom - _offsetNow.bottom) + "px";
    }
    document.onmouseup = function () {
      document.onmousemove = null;
      document.onmousedown = null;
    }
  }
  
  /**
   * 滑动左边线
   * @param {Object} e
   */
  function mouseDownLineL(e) {
    e.stopPropagation();
    var _offsetParent = targetDragParent.getBoundingClientRect();
    var _offset = targetDrag.getBoundingClientRect();
    var _offsetNow = null;
    var _x = e.clientX;
    var _xNow = 0;
    document.onmousemove = function (ev) {
      _offsetNow = targetDrag.getBoundingClientRect();
      _xNow = ev.clientX;
      // 放大缩小滑块
      targetDrag.style.width = (_offset.width - _xNow + _x) + "px";
      targetDrag.style.left = (_offset.left - _offsetParent.left + (_xNow - _x)) + "px";
      // 判断最大值，超出设置最大值
      if (parseInt(targetDrag.style.width) > (_offset.right - _offsetParent.left)) {
        targetDrag.style.width = (_offset.right - _offsetParent.left) + "px";
        targetDrag.style.left = "0px";
      } else if ((_offset.width - (_xNow - _x)) <= 0) {
        targetDrag.style.width = "0px";
        targetDrag.style.left = (_offset.right - _offsetParent.left) + "px";
      }
      // 移动蒙版
      lineTop.style.top = (_offsetNow.top - _offsetParent.top - 1) + "Px";
      lineBottom.style.top = (_offsetNow.bottom - _offsetParent.top) + "px";
      areaLeft.style.width = (_offsetNow.left - _offsetParent.left) + "px";
      areaRight.style.width = (_offsetParent.right - _offsetNow.right) + "px";
      areaTop.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaTop.style.width = (_offsetNow.width) + "px";
      areaTop.style.height = (_offsetNow.top - _offsetParent.top) + "px";
      areaBottom.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaBottom.style.width = (_offsetNow.width) + "px";
      areaBottom.style.height = (_offsetParent.bottom - _offsetNow.bottom) + "px";
    }
    document.onmouseup = function () {
      document.onmousemove = null;
      document.onmousedown = null;
    }
  }
  
  /**
   * 下边线
   * @param {Object} e
   */
  function mouseDownLineB(e) {
    e.stopPropagation();
    var _offsetParent = targetDragParent.getBoundingClientRect();
    var _offset = targetDrag.getBoundingClientRect();
    var _offsetNow = null;
    var _y = e.clientY;
    var _yNow = 0;
    document.onmousemove = function (ev) {
      _offsetNow = targetDrag.getBoundingClientRect();
      _yNow = ev.clientY
      // 放大缩小滑块
      targetDrag.style.height = (_offset.height + (_yNow - _y)) + "px";
      // 判断最大值，超出设置最大值
      if (parseInt(targetDrag.style.height) > (_offsetParent.bottom - _offset.top)) {
        targetDrag.style.height = (_offsetParent.bottom - _offset.top) + "px";
      }
      // 移动蒙版
      lineTop.style.top = (_offsetNow.top - _offsetParent.top - 1) + "Px";
      lineBottom.style.top = (_offsetNow.bottom - _offsetParent.top) + "px";
      areaBottom.style.height = (_offsetParent.bottom - _offsetNow.bottom) + "px";
    }
    document.onmouseup = function () {
      document.onmousemove = null;
      document.onmousedown = null;
    }
  }
  
  /**
   * 上边线
   * @param {Object} e
   */
  function mouseDownLineT(e) {
    e.stopPropagation();
    var _offsetParent = targetDragParent.getBoundingClientRect();
    var _offset = targetDrag.getBoundingClientRect();
    var _offsetNow = null;
    var _y = e.clientY;
    var _yNow = 0;
    document.onmousemove = function (ev) {
      _offsetNow = targetDrag.getBoundingClientRect();
      _yNow = ev.clientY;
      // 放大缩小滑块
      targetDrag.style.height = (_offset.height - (_yNow - _y)) + "px";
      targetDrag.style.top = (_offset.top - _offsetParent.top + (_yNow - _y)) + "px";
      // 判断最大值，超出设置最大值
      if (parseInt(targetDrag.style.height) > (_offset.bottom - _offsetParent.top)) {
        targetDrag.style.height = (_offset.bottom - _offsetParent.top) + "px";
        targetDrag.style.top = "0px";
      } else if ((_offset.height - (_yNow - _y)) <= 0) {
        targetDrag.style.height = "0px";
        targetDrag.style.top = (_offset.bottom - _offsetParent.top) + "px";
      }
      // 移动蒙版
      lineTop.style.top = (_offsetNow.top - _offsetParent.top - 1) + "Px";
      lineBottom.style.top = (_offsetNow.bottom - _offsetParent.top) + "px";
      areaTop.style.height = (_offsetNow.top - _offsetParent.top) + "px";
    }
    document.onmouseup = function () {
      document.onmousemove = null;
      document.onmousedown = null;
    }
  }
  
  /**
   * 右上角滑块
   * @param {Object} e
   */
  function mouseDownTR(e) {
    e.stopPropagation();
    var _offsetParent = targetDragParent.getBoundingClientRect();
    var _offset = targetDrag.getBoundingClientRect();
    var _offsetNow = null;
    var _x = e.clientX;
    var _y = e.clientY;
    var _xNow = 0;
    var _yNow = 0;
    var _bottom = _offsetParent.bottom - _offset.bottom;
    document.onmousemove = function (ev) {
      _offsetNow = targetDrag.getBoundingClientRect();
      _xNow = ev.clientX;
      _yNow = ev.clientY;
      // 放大缩小滑块
      targetDrag.style.width = (_xNow - _offset.left) + "px";
      // 放大缩小滑块
      targetDrag.style.height = (_offset.height - (_yNow - _y)) + "px";
      targetDrag.style.top = (_offset.top - _offsetParent.top + (_yNow - _y)) + "px";
      // 判断最大值，超出设置最大值
      if (parseInt(targetDrag.style.width) > (_offsetParent.width + _offsetParent.left - _offset.left)) {
        targetDrag.style.width = (_offsetParent.width + _offsetParent.left - _offset.left) + "px";
      }
      if (parseInt(targetDrag.style.height) > (_offsetParent.height - _bottom)) {
        targetDrag.style.height = (_offsetParent.height - _bottom) + "px";
        targetDrag.style.top = "0px";
      } else if ((_offset.height - (_yNow - _y)) <= 0) {
        targetDrag.style.height = "0px";
        targetDrag.style.top = (_offset.height + _offset.top - _offsetParent.top) + "px";
      }
      // 移动蒙版
      lineTop.style.top = (_offsetNow.top - _offsetParent.top - 1) + "Px";
      lineBottom.style.top = (_offsetNow.bottom - _offsetParent.top) + "px";
      areaBottom.style.width = _offsetNow.width + "px";
      areaLeft.style.width = (_offsetNow.left - _offsetParent.left) + "px";
      areaRight.style.width = (_offsetParent.right - _offsetNow.right) + "px";
      areaTop.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaTop.style.width = (_offsetNow.width) + "px";
      areaTop.style.height = (_offsetNow.top - _offsetParent.top) + "px";
      areaBottom.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaBottom.style.width = (_offsetNow.width) + "px";
      areaBottom.style.height = (_offsetParent.bottom - _offsetNow.bottom) + "px";
    }

    document.onmouseup = function () {
      document.onmousemove = null;
      document.onmousedown = null;
    }
  }
  
  /**
   * 右下角滑块
   * @param {Object} e
   */
  function mouseDownBR(e) {
    e.stopPropagation();
    var _offsetParent = targetDragParent.getBoundingClientRect();
    var _offset = targetDrag.getBoundingClientRect();
    var _offsetNow = null;
    var _x = e.clientX;
    var _y = e.clientY;
    var _xNow = 0;
    var _yNow = 0;
    var _bottom = _offsetParent.top + _offsetParent.height - _offset.top - _offset.height;
    document.onmousemove = function (ev) {
      _offsetNow = targetDrag.getBoundingClientRect();
      _xNow = ev.clientX;
      _yNow = ev.clientY;
      // 放大缩小滑块
      targetDrag.style.width = (_xNow - _offset.left) + "px";
      // 放大缩小滑块
      targetDrag.style.height = (_offset.height + (_yNow - _y)) + "px";
      // 判断最大值，超出设置最大值
      if (parseInt(targetDrag.style.width) > (_offsetParent.width + _offsetParent.left - _offset.left)) {
        targetDrag.style.width = (_offsetParent.width + _offsetParent.left - _offset.left) + "px";
      }
      if (parseInt(targetDrag.style.height) > (_offsetParent.height + _offsetParent.top - _offset.top)) {
        targetDrag.style.height = (_offsetParent.height + _offsetParent.top - _offset.top) + "px";
      }
      // 移动蒙版
      lineTop.style.top = (_offsetNow.top - _offsetParent.top - 1) + "Px";
      lineBottom.style.top = (_offsetNow.bottom - _offsetParent.top) + "px";
      areaLeft.style.width = (_offsetNow.left - _offsetParent.left) + "px";
      areaRight.style.width = (_offsetParent.right - _offsetNow.right) + "px";
      areaTop.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaTop.style.width = (_offsetNow.width) + "px";
      areaTop.style.height = (_offsetNow.top - _offsetParent.top) + "px";
      areaBottom.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaBottom.style.width = (_offsetNow.width) + "px";
      areaBottom.style.height = (_offsetParent.bottom - _offsetNow.bottom) + "px";
    }
    document.onmouseup = function () {
      document.onmousemove = null;
      document.onmousedown = null;
    }
  }
  
  /**
   * 左上角滑块
   * @param {Object} e
   */
  function mouseDownTL(e) {
    e.stopPropagation();
    var _offsetParent = targetDragParent.getBoundingClientRect();
    var _offset = targetDrag.getBoundingClientRect();
    var _offsetNow = null;
    var _x = e.clientX;
    var _y = e.clientY;
    var _xNow = 0;
    var _yNow = 0;
    var _top = _offset.top - _offsetParent.top;
    var _bottom = _offsetParent.bottom - _offset.bottom;
    document.onmousemove = function (ev) {
      _offsetNow = targetDrag.getBoundingClientRect();
      _xNow = ev.clientX;
      _yNow = ev.clientY;
      // 放大缩小滑块
      targetDrag.style.height = (_offset.height - (_yNow - _y)) + "px";
      targetDrag.style.top = (_offset.top - _offsetParent.top + (_yNow - _y)) + "px";
      targetDrag.style.width = (_offset.width - (_xNow - _x)) + "px";
      targetDrag.style.left = (_offset.left - _offsetParent.left + (_xNow - _x)) + "px";
      // 判断最大值，超出设置最大值
      if (parseInt(targetDrag.style.width) > (_offsetParent.width - _offsetParent.right + _offset.right)) {
        targetDrag.style.width = (_offsetParent.width - _offsetParent.right + _offset.right) + "px";
        targetDrag.style.left = "0px";
      } else if ((_offset.width - (_xNow - _x)) <= 0) {
        targetDrag.style.width = "0px";
        targetDrag.style.left = (_offsetParent.width - _offsetParent.right + _offset.right) + "px";
      }
      if (parseInt(targetDrag.style.height) > (_offsetNow.height + _offsetNow.top - _offsetParent.top)) {
        targetDrag.style.height = (_offsetNow.height + _offsetNow.top - _offsetParent.top) + "px";
        targetDrag.style.top = "0px";
      } else if (_offset.height - _yNow + _y <= 0) {
        targetDrag.style.height = "0px";
        targetDrag.style.top = (_offsetNow.top - _offsetParent.top) + "px";
      }
      // 移动蒙版
      lineTop.style.top = (_offsetNow.top - _offsetParent.top - 1) + "Px";
      lineBottom.style.top = (_offsetNow.bottom - _offsetParent.top) + "px";
      areaLeft.style.width = (_offsetNow.left - _offsetParent.left) + "px";
      areaTop.style.height = (_offsetNow.top - _offsetParent.top) + "px";
      areaTop.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaTop.style.width = _offsetNow.width + "px";
      areaBottom.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaBottom.style.width = _offsetNow.width + "px";
    }

    document.onmouseup = function () {
      document.onmousemove = null;
      document.onmousedown = null;
    }
  }
  
  /**
   * 左下角滑块
   * @param {Object} e
   */
  function mouseDownBL(e) {
    e.stopPropagation();
    var _offsetParent = targetDragParent.getBoundingClientRect();
    var _offset = targetDrag.getBoundingClientRect();
    var _offsetNow = null;
    var _x = e.clientX;
    var _y = e.clientY;
    var _xNow = 0;
    var _yNow = 0;
    var _top = _offset.top - _offsetParent.top;
    var _bottom = _offsetParent.bottom - _offset.bottom;
    document.onmousemove = function (ev) {
      _offsetNow = targetDrag.getBoundingClientRect();
      _xNow = ev.clientX;
      _yNow = ev.clientY;
      // 放大缩小滑块
      targetDrag.style.height = (_offset.height + (_yNow - _y)) + "px";
      targetDrag.style.width = (_offset.width - (_xNow - _x)) + "px";
      targetDrag.style.left = (_offset.left - _offsetParent.left + (_xNow - _x)) + "px";
      // 判断最大值，超出设置最大值
      if (parseInt(targetDrag.style.width) > (_offsetParent.width - _offsetParent.right + _offset.right)) {
        targetDrag.style.width = (_offsetParent.width - _offsetParent.right + _offset.right) + "px";
        targetDrag.style.left = "0px";
      } else if ((_offset.width - (_xNow - _x)) <= 0) {
        targetDrag.style.width = "0px";
        targetDrag.style.left = (_offsetParent.width - _offsetParent.right + _offset.right) + "px";
      }
      if (parseInt(targetDrag.style.height) > (_offsetNow.height + _offsetParent.bottom - _offsetNow.bottom)) {
        targetDrag.style.height = (_offsetNow.height + _offsetParent.bottom - _offsetNow.bottom) + "px";
      } else if (_offset.height - _yNow + _y <= 0) {
        targetDrag.style.height = "0px";
        targetDrag.style.top = (_offsetNow.top - _offsetParent.top) + "px";
      }
      // 移动蒙版
      lineTop.style.top = (_offsetNow.top - _offsetParent.top - 1) + "Px";
      lineBottom.style.top = (_offsetNow.bottom - _offsetParent.top) + "px";
      areaLeft.style.width = (_offsetNow.left - _offsetParent.left) + "px";
      areaRight.style.width = (_offsetParent.right - _offsetNow.right) + "px";
      areaTop.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaTop.style.width = (_offsetNow.width) + "px";
      areaTop.style.height = (_offsetNow.top - _offsetParent.top) + "px";
      areaBottom.style.left = (_offsetNow.left - _offsetParent.left) + "px";
      areaBottom.style.width = (_offsetNow.width) + "px";
      areaBottom.style.height = (_offsetParent.bottom - _offsetNow.bottom) + "px";
    }

    document.onmouseup = function () {
      document.onmousemove = null;
      document.onmousedown = null;
    }
  }
  if (window.addEventListener) {
    document.querySelector(".mbe-tailor-box").addEventListener("mousedown", mouseDown);
    // document.querySelector(".lineTop").addEventListener("mousedown", mouseDownLineT);
    // document.querySelector(".lineRight").addEventListener("mousedown", mouseDownLineR);
    // document.querySelector(".lineBottom").addEventListener("mousedown", mouseDownLineB);
    // document.querySelector(".lineLeft").addEventListener("mousedown", mouseDownLineL);
    document.querySelector(".pointTopCenter").addEventListener("mousedown", mouseDownLineT);
    document.querySelector(".pointRightCenter").addEventListener("mousedown", mouseDownLineR);
    document.querySelector(".pointBottomCenter").addEventListener("mousedown", mouseDownLineB);
    document.querySelector(".pointLeftCenter").addEventListener("mousedown", mouseDownLineL);

    document.querySelector(".pointTopRight").addEventListener("mousedown", mouseDownTR);
    document.querySelector(".pointBottomLeft").addEventListener("mousedown", mouseDownBL);
    document.querySelector(".pointBottomRight").addEventListener("mousedown", mouseDownBR);
    document.querySelector(".pointTopLeft").addEventListener("mousedown", mouseDownTL);
  }

}