var fs = require('fs');
var os = require('os');
var net = require('net');
var path = require('path');
var app = require('app');  // Module to control application life.
var ChildProcess = require('child_process');
var BrowserWindow = require('browser-window');  // Module to create native browser window.

// Report crashes to our server.
require('crash-reporter').start();

// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the javascript object is GCed.
var mainWindow = null;

// Electron 暂时还支持 NPAPI flash 插件，所以我们可以不用自带 flash 插件。但如果 Electron 去掉了 NPAPI flash 支持，
// 那么就要自带 pepflashplayer.dll，并打开下面两行：
// app.commandLine.appendSwitch('ppapi-flash-path', 'C:/Users/duanyao/AppData/Local/360Chrome/Chrome/Application/ppflash/flash/pepflashplayer.dll');
// app.commandLine.appendSwitch('ppapi-flash-version', '17.0.0.188');

// Quit when all windows are closed.
app.on('window-all-closed', function () {
  // On OSX it is common for applications and their menu bar 
  // to stay active until the user quits explicitly with Cmd + Q
  if (process.platform != 'darwin') {
    app.quit();
  }
});

function fileUrl(str) {
  if (typeof str !== 'string') {
    throw new Error('Expected a string');
  }

  var pathName = path.resolve(str).replace(/\\/g, '/');

  // Windows drive letter must be prefixed with a slash
  if (pathName[0] !== '/') {
    pathName = '/' + pathName;
  }

  return encodeURI('file://' + pathName);
};

// This method will be called when Electron has done everything
// initialization and ready for creating browser windows.
app.on('ready', function() {
  checkSingletonAndRun(runMBEditor);
});

app.on('will-quit', function() {
  deleteSingletonSocket();
});

app.on('will-exit', function() {
  deleteSingletonSocket();
});

/**
 * 用于保证单例运行的命名管道（windows）或本地套接字（linux）。
 */
var singletonSocketPath = process.platform === 'win32'?
  '\\\\.\\pipe\\mbeditor_electron-sock' : path.join(os.tmpdir(), 'mbeditor_electron-' + process.env.USER + '.sock');

/**
 * 检查单例状态后运行 runnable 函数。
 * @param runnable: (slaveOptions: Object) => any
 */
function checkSingletonAndRun(runnable) {
  console.log('checkSingletonAndRun:start:'  + process.pid);
  var client = net.connect({path: singletonSocketPath}, function() {
    console.log('checkSingletonAndRun:client connected: pid: ' + process.pid);
    client.write('' + Math.random(), function(arg) {
      console.warn('checkSingletonAndRun: there is an instance, will exit! pid: ' + process.pid + ':', arg);
      client.end();
      app.terminate();
    });
  });

  client.on('error', createServerAndRun);
  
  function createServerAndRun() {
    console.log('checkSingletonAndRun:createServerAndRun, pid: ' + process.pid);
    client.end();
    var server = net.createServer(function(connection) {
      connection.on('data', function(data) {
        console.log('checkSingletonAndRun:server:ondata:, pid: ' + process.pid + ':', data);
        runnable({}); //TODO 传递参数过来
      });
    });
    server.listen(singletonSocketPath, function() {
      console.log('checkSingletonAndRun:run your app..., pid: ' + process.pid);
      runnable();
    });
    server.on('error', function(error) {
      console.error('checkSingletonAndRun:server:failed, pid: ' + process.pid + ':', error);
    });
  }
}

function deleteSingletonSocket() {
  if(process.platform === 'win32') return;
  if(fs.existsSync(singletonSocketPath)) {
    try {
      fs.unlinkSync(singletonSocketPath);
    } catch (e) {
      if (e.code !== 'ENOENT')
        throw e;
    }
  }  
}

/**
 * @param slaveOptions 如果存在，表明是从第二个实例发来的请求，这时不考虑命令行参数 process.argv。
 */
function runMBEditor(slaveOptions) {
  console.log('runMBEditor:pid:' + process.pid + '; slaveOptions:', slaveOptions);

  var spawnUpdate = function (command, args, callback) {
    var error, spawnedProcess, stdout;
    stdout = '';
    try {
      // ChildProcess.spawn 的默认行为是父进程退出时杀死子进程，用 detached: true 避免这一行为。
      spawnedProcess = ChildProcess.spawn(command, args, { detached: true });
    } catch (_error) {
      error = _error;
      process.nextTick(function () {
        return typeof callback === "function" ? callback(error, stdout) : void 0;
      });
      return;
    }
    spawnedProcess.stdout.on('data', function (data) {
      return stdout += data;
    });
    error = null;
    spawnedProcess.on('error', function (processError) {
      return error != null ? error : error = processError;
    });
    return spawnedProcess.on('close', function (code, signal) {
      if (code !== 0) {
        if (error == null) {
          error = new Error("Command failed: " + (signal != null ? signal : code));
        }
      }
      if (error != null) {
        if (error.code == null) {
          error.code = code;
        }
        if (error.stdout == null) {
          error.stdout = stdout;
        }
      }
      return typeof callback === "function" ? callback(error, stdout) : void 0;
    });
  };
  var handleStartupEvent = function () {
    if (process.platform !== 'win32') {
      return false;
    }
    var squirrelCommand = process.argv[1];

    var error, spawnedProcess, stdout;
    stdout = '';
    switch (squirrelCommand) {
      case '--squirrel-install':
      case '--squirrel-updated':
        var processpath = process.execPath;
        var newpath = path.join(path.dirname(path.dirname(processpath)), 'update.exe');
        spawnUpdate(newpath, ['--createShortcut', 'beikedashi_electron.exe'], function (errormessage, stdoutmessage) {
          console.log('createShortcut:err:', errormessage, '; stdout:', stdoutmessage);
          app.quit();
        });
        return true;
      case '--squirrel-uninstall':
        // Undo anything you did in the --squirrel-install and 
        // --squirrel-updated handlers 
        var processpath = process.execPath;
        var newpath = path.join(path.dirname(path.dirname(processpath)), 'update.exe');
        spawnUpdate(newpath, ['--removeShortcut', 'beikedashi_electron.exe'], function (errormessage, stdoutmessage) {
          console.log('createShortcut:err:', errormessage, '; stdout:', stdoutmessage);
          app.quit();
        });        
        return true;
      case '--squirrel-obsolete':
        // This is called on the outgoing version of your app before  
        // we update to the new version - it's the opposite of 
        // --squirrel-updated 

        app.quit();
        return true;
    }
  };

  if (slaveOptions) {
    // TODO
  } else {
    if (handleStartupEvent()) {
      return;
    }
    registerProtocolHandlers();
  }

  var screen = require('screen');
  var winsize = screen.getPrimaryDisplay().workAreaSize;
  // Create the browser window.  
  mainWindow = new BrowserWindow({
    width: winsize.width,
    height: winsize.height,
    //'auto-hide-menu-bar': true,
    //'use-content-size': true,
    'web-preferences': {
      // 'plugins': true // 启用插件（flash） TODO NPAPI 插件崩溃
    }
  });
  // and load the index.html of the app.
  var dirnameurl = fileUrl(__dirname);
  mainWindow.loadUrl(dirnameurl + '/air-master-editor.xhtml');
  // mainWindow.openDevTools();
  // Emitted when the window is closed.
  mainWindow.on('closed', function () {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.
    mainWindow = null;
  });
}

function registerProtocolHandlers() {
  ['mailto', 'tencent'].forEach(function(scheme) {
    require('protocol').registerStringProtocol(scheme, function (request, callback) {
      //console.log('>>>URL: ' + request.url);
      require('shell').openExternal(request.url);
      return null;
    }, function (error) {
      if (error)
        console.error('Failed to register ' + scheme);
    });
  });
}
