var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var etb_tools;
(function (etb_tools) {
    var SVGUtils;
    (function (SVGUtils) {
        SVGUtils.NS_SVG = 'http://www.w3.org/2000/svg';
        var svg;
        function newPoint(x, y) {
            var m = svg.createSVGMatrix();
            m = m.translate(x, y);
            var p = svg.createSVGPoint();
            return p.matrixTransform(m);
        }
        SVGUtils.newPoint = newPoint;
        function newMatrix() {
            return svg.createSVGMatrix();
        }
        SVGUtils.newMatrix = newMatrix;
        function transformDelta(v, m) {
            var o1 = svg.createSVGPoint().matrixTransform(m);
            var v1 = v.matrixTransform(m);
            return newPoint(v1.x - o1.x, v1.y - o1.y);
        }
        SVGUtils.transformDelta = transformDelta;
        function matToCSS(mat) {
            return 'matrix(' + mat.a + ',' + mat.b + ',' + mat.c + ',' + mat.d + ',' + mat.e + ',' + mat.f + ')';
        }
        SVGUtils.matToCSS = matToCSS;
        function moduleInit() {
            svg = document.createElementNS(SVGUtils.NS_SVG, 'svg');
        }
        moduleInit();
    })(SVGUtils = etb_tools.SVGUtils || (etb_tools.SVGUtils = {}));
})(etb_tools || (etb_tools = {}));
///<reference path='../../html5plus.d.ts'/>
///<reference path='SVGUtils.ts'/>
var etb_tools;
(function (etb_tools) {
    var NS_SVG = etb_tools.SVGUtils.NS_SVG;
    var SVGPen = /** @class */ (function () {
        function SVGPen(canvasParent) {
            this.canvasParent = canvasParent;
            this._isDrawing = false;
            this._overlay = null;
            this._path = null;
            this._lastX = 0;
            this._lastY = 0;
            this._pointerId = -1;
            this._scale = 1;
            this.onPathDrawn = null;
        }
        Object.defineProperty(SVGPen.prototype, "isDrawing", {
            get: function () { return this._isDrawing; },
            set: function (draw) {
                if (draw === this._isDrawing)
                    return;
                this._isDrawing = draw;
                if (draw)
                    this._enableDrawing();
                else
                    this._disableDrawing();
            },
            enumerable: true,
            configurable: true
        });
        SVGPen.prototype.setTransform = function (scale, ox, oy) {
            this._scale = scale;
            if (scale === 1) {
                this._tm = this._itm = null;
                return;
            }
            this._tm = etb_tools.SVGUtils.newMatrix().translate(-ox, -oy).scale(scale).translate(ox, oy);
            this._itm = this._tm.inverse();
        };
        SVGPen.prototype.removeAll = function (el) {
            var strokes = el.querySelectorAll('svg.etb-temp-stroke');
            for (var i = 0; i < strokes.length; i++) {
                if (strokes[i].parentNode)
                    strokes[i].parentNode.removeChild(strokes[i]);
            }
        };
        SVGPen.prototype._enableDrawing = function () {
            var ol = this._overlay = document.createElementNS(NS_SVG, 'svg');
            ol.setAttribute('class', 'etb-SvgPenOverlay');
            ol.setAttribute('style', 'position:fixed; width:100%; height:100%; top:0; left:0; z-index:1000;');
            this.canvasParent.appendChild(ol);
            var handler = this._drawingPointerHandler.bind(this);
            ['pointerdown', 'pointermove', 'pointerup', 'touchstart'].forEach(function (type) {
                return ol.addEventListener(type, handler);
            });
        };
        SVGPen.prototype._disableDrawing = function () {
            this.canvasParent.removeChild(this._overlay);
            this._overlay = null;
        };
        SVGPen.prototype._startDraw = function (x, y) {
            var p = this._path = document.createElementNS(NS_SVG, 'path');
            p.style.stroke = 'red';
            p.style.strokeWidth = '2';
            p.style.fill = 'none';
            if (this._itm) {
                // svg 元素的css transform 和 transform 属性在 getBoundingClientRect 时的结果不同,
                // 前者得到变换前的结果，后者得到变换后的结果；html 元素是变换后的结果。TODO 这是 bug 还是规范？
                p.setAttribute('transform', etb_tools.SVGUtils.matToCSS(this._tm));
                var v = etb_tools.SVGUtils.newPoint(x, y).matrixTransform(this._itm);
                x = v.x;
                y = v.y;
            }
            p.pathSegList.appendItem(p.createSVGPathSegMovetoAbs(x, y));
            this._overlay.appendChild(p);
        };
        SVGPen.prototype._movePenBy = function (dx, dy) {
            var p = this._path;
            if (this._itm) {
                dx = dx / this._scale;
                dy = dy / this._scale;
            }
            // TODO make curve work
            // if (p.pathSegList.numberOfItems !== 0)
            //   p.pathSegList.appendItem(p.createSVGPathSegCurvetoQuadraticSmoothRel(dx, dy));
            // else
            //   p.pathSegList.appendItem(p.createSVGPathSegLinetoRel(dx, dy));
            p.pathSegList.appendItem(p.createSVGPathSegLinetoRel(dx, dy));
        };
        SVGPen.prototype._endDraw = function () {
            var p = this._path;
            if (this.onPathDrawn) {
                var evt = { path: p, canvas: null };
                this.onPathDrawn(evt);
                if (evt.canvas) {
                    var c = evt.canvas;
                    var pbox = p.getBoundingClientRect();
                    var cbox = c.getBoundingClientRect();
                    var start = p.pathSegList.getItem(0);
                    var s = this._scale;
                    if (c.namespaceURI !== NS_SVG) {
                        var svg = document.createElementNS(NS_SVG, 'svg');
                        svg.setAttribute('class', 'etb-temp-stroke');
                        svg.setAttribute('style', 'position:absolute; top:' + (pbox.top - cbox.top) / s
                            + 'px; left:' + (pbox.left - cbox.left) / s + 'px; width:'
                            + pbox.width / s + 'px; height:' + pbox.height / s + 'px; overflow:visible; z-index: 2;');
                        svg.appendChild(p);
                        var pbx = pbox.left, pby = pbox.top;
                        if (this._itm) {
                            var pbo = etb_tools.SVGUtils.newPoint(pbox.left, pbox.top).matrixTransform(this._itm);
                            pbx = pbo.x;
                            pby = pbo.y;
                        }
                        var nx = start.x - pbx, ny = start.y - pby;
                        start = p.createSVGPathSegMovetoAbs(nx, ny);
                        p.pathSegList.replaceItem(start, 0);
                        p.removeAttribute('transform');
                        c.appendChild(svg);
                    }
                }
            }
            this._path = null;
        };
        SVGPen.prototype._drawingPointerHandler = function (ev) {
            var x = ev.clientX, y = ev.clientY;
            switch (ev.type) {
                case 'pointerdown':
                    if (this._pointerId < 0) {
                        this._startDraw(x, y);
                        this._pointerId = ev.pointerId;
                    }
                    break;
                case 'pointermove':
                    if (ev.pointerId === this._pointerId)
                        this._movePenBy(x - this._lastX, y - this._lastY);
                    break;
                case 'pointerup':
                    if (ev.pointerId === this._pointerId) {
                        this._endDraw();
                        this._pointerId = -1; //TODO -1 是否总是非法的 id？
                    }
                    break;
                case 'touchstart':
                    ev.preventDefault(); // 防止触摸屏上绘画时滚动
                    break;
            }
            this._lastX = x;
            this._lastY = y;
        };
        return SVGPen;
    }());
    etb_tools.SVGPen = SVGPen;
})(etb_tools || (etb_tools = {}));
var etb_tools;
(function (etb_tools) {
    var UrlParams;
    (function (UrlParams) {
        /**
         * 解析 URL 中的参数部分。可以传入 hash 部分或者 query 部分，有没有开头的 # 或 ? 都可以。
         * @param separator 是主要分割字符，默认是 "&"。
         */
        function parse(parts, separator) {
            if (separator === void 0) { separator = '&'; }
            if (parts[0] === '#' || parts[0] === '?')
                parts = parts.slice(1);
            var params = Object.create(null);
            parts.split(separator).forEach(function (pair) {
                if (!pair)
                    return;
                var kv = pair.split('=');
                var key = decodeURIComponent(kv[0] || '');
                var value = decodeURIComponent(kv[1] || '');
                if (!key) {
                    console.warn('UrlParams:parse: invalid key: ' + key);
                    return;
                }
                if (!value)
                    value = true;
                params[key] = value;
            });
            return params;
        }
        UrlParams.parse = parse;
    })(UrlParams = etb_tools.UrlParams || (etb_tools.UrlParams = {}));
})(etb_tools || (etb_tools = {}));
// book.r.ts 和 book.e.ts 的共享代码
//
// module etb_config {
//
//     export declare var custom_长虹: boolean;
//
// }
var etb_book;
(function (etb_book) {
    etb_book.kDefaultPageWidth = 946;
    etb_book.kDefaultPageHeight = 714;
    // normal：原有位置弹出，center：弹出到页面中心，none：不弹出
    etb_book.popupOptions = ['none', 'normal', 'center'];
    function offSetRect(el) {
        var nc = el.getBoundingClientRect();
        //// Chrome/Edge 上 ClientRect 是不可变的，所以下面的操作无意义；Firefox 上是可变的。
        //// 用意是什么？
        // nc.left = el.offsetLeft;
        // nc.top = el.offsetTop;
        // nc.right = el.offsetLeft + el.offsetWidth;
        // nc.bottom = el.offsetTop + el.offsetHeight;
        // nc.width = el.offsetWidth;
        // nc.height = el.offsetHeight;
        return nc;
    }
    etb_book.offSetRect = offSetRect;
    function getControlById(id, doc) {
        if (!id)
            return null;
        return doc.querySelector('[data-id="' + id + '"]');
    }
    etb_book.getControlById = getControlById;
    // 对不支持的音视频，尝试下载/用本地程序打开
    function mediaClicked(ev) {
        var el = ev.target;
        if (/^(video|audio)$/.test(el.localName) && el.error) {
            if (el.error.code === MediaError.MEDIA_ERR_SRC_NOT_SUPPORTED)
                window.open(el.src);
            else if (el.error.code === MediaError.MEDIA_ERR_DECODE)
                openUrlByAnchor(el.src, el, fileNameOfUrl(el.src));
        }
    }
    etb_book.mediaClicked = mediaClicked;
    function enableControlConnection(doc, enable) {
        if (enable) {
            doc.addEventListener('click', manageDocClick);
        }
        else {
            doc.removeEventListener('click', manageDocClick);
        }
    }
    etb_book.enableControlConnection = enableControlConnection;
    function manageDocClick(ev) {
        var isf = triggerConnection(ev);
        if (isf) {
        }
        else {
            animationPlay(ev);
        }
    }
    etb_book.manageDocClick = manageDocClick;
    function animationPlay(ev) {
        var etbpage = etb_book.getAncestors(ev.target, function (el) { return el.classList.contains('etb-page'); }).pop() || etb_book.currentPage;
        if (/^(video|audio)$/.test(ev.target.localName)) {
            return false;
        }
        //var control = etb_book.getAncestors(<HTMLElement>ev.target, (el: HTMLElement) => { return el.hasAttribute('data-control') }).pop();
        //if (!!control) {
        //  return false;
        //}
        if (etbpage.hasAttribute('data-mainbo-animation')) {
            //var ctrs = (<HTMLElement>etbpage).querySelectorAll('[data-control]:not(.mainbo-no-animation)');
            var ctrs = Array.prototype.slice.call(etbpage.children).filter(function (item) {
                return item.hasAttribute('data-control') && !item.classList.contains('.mainbo-no-animation') && item.classList.contains('mainbo-hidden');
            });
            if (ctrs.length == 0) {
                return true;
            }
            else {
                ctrs[0].classList.remove('mainbo-hidden');
                return false;
            }
            //for (var i = 0, len = ctrs.length; i < len; i++) {
            //  //if ((<HTMLElement>ctrs[i]).classList.contains('mainbo-hidden')) {
            //  //ctrs[i].removeEventListener('transitionend', transition1);
            //  (<HTMLElement>ctrs[i]).classList.remove('mainbo-hidden');
            //  //break;
            //}
        }
        //if (i == ctrs.length) {   
        //} else {
        //  return false
        //}
    }
    etb_book.animationPlay = animationPlay;
    function transition1(ev) {
        var el = ev.target;
        el.classList.remove('mainbo-hidden');
    }
    function animationPlayReverse(ev) {
        var etbpage = etb_book.getAncestors(ev.target, function (el) { return el.classList.contains('etb-page'); }).pop() || etb_book.currentPage;
        if (/^(video|audio)$/.test(ev.target.localName)) {
            return false;
        }
        if (etbpage.hasAttribute('data-mainbo-animation')) {
            var ctrs = Array.prototype.slice.call(etbpage.children).reverse().filter(function (item) {
                return item.hasAttribute('data-control') && !item.classList.contains('.mainbo-no-animation') && !item.classList.contains('mainbo-hidden');
            });
            if (ctrs.length == 1) {
                return true;
            }
            else {
                ctrs[0].classList.add('mainbo-hidden');
                addMaskSimple(false, ctrs);
                // removeShowMask(ctrs[0]);
                ctrs[0].style.opacity = '';
                return false;
            }
        }
        //  for (var i = ctrs.length - 1; i >= 0; i--) {
        //    if (!ctrs[i].classList.contains('mainbo-hidden')) {
        //      ctrs[i].classList.add('mainbo-hidden');
        //      break;
        //    }
        //  }
        //  if (i == 0) {
        //    return 'endanimation';
        //  }
        //  //return true;
        //} else {
        //  return false
        //}
    }
    etb_book.animationPlayReverse = animationPlayReverse;
    /**
     * 重置所有的弹出项的弹出状态和隐藏状态。
     * @param node 父节点
     * @param hideTarget 是否隐藏弹出项。一般来说，编辑态不隐藏，放映态隐藏。
     */
    function resetPopups(node, hideTarget) {
        forEach(node.querySelectorAll('[data-mainbo-popup]'), function (el) {
            if (!isPopup(el.getAttribute('data-mainbo-popup')))
                return;
            var targ = getControlById(el.getAttribute('data-mainbo-connection-src'), node);
            targ && dismissPopup(targ, hideTarget);
        });
        dismissAllPopups(node, hideTarget); // TODO 重复？
    }
    etb_book.resetPopups = resetPopups;
    // data-mainbo-popup 的值是否是有效的弹出形式
    function isPopup(popupType) {
        return etb_book.popupOptions.indexOf(popupType) > 0;
    }
    etb_book.isPopup = isPopup;
    function forEach(array, fn) {
        Array.prototype.forEach.call(array, fn);
    }
    etb_book.forEach = forEach;
    function triggerConnection(ev) {
        var finished = false;
        var el, trigers, popups;
        if (ev.type == 'keydown') {
            el = ev.target;
            trigers = el.querySelectorAll('[data-mainbo-connection-src');
            popups = el.querySelectorAll('.mainbo-popup');
        }
        else {
            el = ev.target;
            trigers = etb_book.getAncestors(el, function (el) { return el.hasAttribute('data-mainbo-connection-src')
                || el.hasAttribute('xlink:href') || el.localName === 'a'; }); //TODO NS?
            popups = etb_book.getAncestors(el, function (el) { return el.classList.contains('mainbo-popup'); });
        }
        // 点击空白时取消弹出，但居中弹出例外
        var centerPopup = el.ownerDocument.querySelector('.mainbo-popup.mainbo-center');
        if (!trigers.some(function (el) { return el.hasAttribute('data-mainbo-popup'); }) && popups.length === 0 && !centerPopup) {
            //todo 判断页面弹出项是否是显示的,根据弹出项的hidden属性还是class mainbo-popup
            finished = dismissAllPopups(el.ownerDocument, true);
        }
        if (trigers.length) {
            trigers.forEach(function (trigger) { return playConnection(trigger, ev); });
            finished = true;
        }
        return finished;
    }
    etb_book.triggerConnection = triggerConnection;
    function triggerMapConnection(targ, ev) {
        var isfished = false;
        var trigers, popups;
        if (targ.classList.contains('mainbo-hidden')) {
            targ = targ.parentElement.querySelector('[data-mainbo-connection-src="' + targ.getAttribute('data-id') + '"]');
        }
        trigers = etb_book.getAncestors(targ, function (el) { return el.hasAttribute('data-mainbo-connection-src'); });
        popups = etb_book.getAncestors(targ, function (el) { return el.classList.contains('mainbo-popup'); });
        if (!trigers.some(function (el) { return el.hasAttribute('data-mainbo-popup'); }) && popups.length === 0) {
            //todo 判断页面弹出项是否是显示的,根据弹出项的hidden属性还是class mainbo-popup
            isfished = dismissAllPopups(targ.ownerDocument, true);
        }
        if (trigers.length) {
            trigers.forEach(function (trigger) { return playConnection(trigger, ev); });
            isfished = true;
        }
        return isfished;
    }
    etb_book.triggerMapConnection = triggerMapConnection;
    /**
     * 消除所有的弹出项的弹出状态
     * @param node 父节点
     * @param hideTarget 是否隐藏弹出项。一般来说，编辑态不隐藏，放映态隐藏。
     */
    function dismissAllPopups(node, hideTarget) {
        var popups = node.querySelectorAll('.mainbo-popup');
        forEach(popups, function (el) { return dismissPopup(el, hideTarget); });
        return popups.length > 0;
    }
    function dismissAllCenterPopups(node) {
        forEach(node.querySelectorAll('.mainbo-center.mainbo-popup'), function (el) { return dismissPopup(el, true); });
    }
    etb_book.dismissAllCenterPopups = dismissAllCenterPopups;
    function dismissPopup(pp, hideTarget) {
        pp.classList.remove('mainbo-popup');
        var isCenter;
        if (pp.classList.contains('mainbo-center')) {
            isCenter = true;
            pp.classList.remove('mainbo-center');
        }
        var oldStyle = pp.getAttribute('data-etb-saved-style');
        if (oldStyle) {
            pp.setAttribute('style', oldStyle);
            pp.removeAttribute('data-etb-saved-style');
        }
        if (hideTarget) {
            pp.classList.add('mainbo-hidden');
            if (isCenter) {
                addMaskSimple(false, [pp]);
            }
            pp.style.opacity = '';
        }
        else {
            pp.classList.remove('mainbo-hidden');
        }
        // pause media on dismiss
        pauseMedia(pp);
    }
    etb_book.dismissPopup = dismissPopup;
    function pauseMedia(target) {
        if (typeof target['pause'] === 'function') {
            target['pause']();
        }
        var medias = target.querySelectorAll('audio, video');
        forEach(medias, function (media) {
            if (typeof media['pause'] === 'function') {
                media['pause']();
                if (target.classList.contains('mainbo-voicescore') || target.classList.contains('mainbo-guwen')) {
                    var article = etb_book.getAncestors(media, function (el) { return el.localName == 'article'; }).pop();
                    if (article.querySelector('.mbe-icon-pause')) {
                        article.querySelector('.mbe-icon-pause').parentElement.setAttribute('title', '播放');
                        article.querySelector('.mbe-icon-pause').classList.remove('mbe-icon-pause');
                    }
                }
            }
        });
    }
    function doPopup(trigger, target) {
        var popup = trigger.getAttribute('data-mainbo-popup');
        if (!isPopup(popup))
            return false;
        // 关闭已经弹出的目标
        if (target.classList.contains('mainbo-popup') || !target.classList.contains('mainbo-hidden')) {
            dismissPopup(target, true);
            return false;
        }
        var oldStyle = target.getAttribute('style');
        // 先显示，再计算尺寸，否则未指定宽高的元素计算值是 auto。
        target.classList.add('mainbo-popup');
        if (popup === 'center') {
            target.classList.add('mainbo-center');
        }
        target.classList.remove('mainbo-hidden');
        target.classList.remove('mainbo-hide');
        if (popup === 'center' && !target.classList.contains('mainbo-hidden')) {
            addMaskSimple(true, [target]);
            transformTarget(target);
            addShowMask(target);
            target.style.opacity = '1';
        }
        if (popup === 'center') {
            target.style.left = '50%';
            target.style.top = '50%';
            var win = target.ownerDocument.defaultView;
            var targetRect = target.getBoundingClientRect();
            var w = Math.max(parseInt(win.getComputedStyle(target, null).width), targetRect.width);
            var h = Math.max(parseInt(win.getComputedStyle(target, null).height), targetRect.height);
            target.style.marginLeft = (-w / 2) + 'px';
            target.style.marginTop = (-h / 2) + 'px';
        }
        target.setAttribute('data-etb-saved-style', oldStyle);
        return true;
    }
    function fullscreenElement() {
        return document.fullscreenElement || document.mozFullScreenElement || document.webkitFullscreenElement;
    }
    function launchFullScreen() {
        var element = document.body;
        var requestFullscreen = element.requestFullscreen
            || element.mozRequestFullScreen
            || element.webkitRequestFullScreen;
        requestFullscreen.call(element, Element['ALLOW_KEYBOARD_INPUT']);
    }
    function cancelFullscreen() {
        var doc = document;
        var exitFullscreen = doc.exitFullscreen
            || doc.mozCancelFullScreen
            || doc.webkitCancelFullScreen;
        exitFullscreen.call(doc);
    }
    function addShowMask(target) {
        if (!target)
            return;
        var pages = document.querySelector('iframe').contentDocument.body.querySelectorAll('.etb-page');
        forEach(pages, function (page) {
            page.classList.add('showMask');
            if (page.style.backgroundImage) {
                page.setAttribute('data-backgroundImage', page.style.backgroundImage);
                page.style.background = '';
            }
        });
    }
    function removeShowMask(target) {
        if (!target)
            return;
        var pages = document.querySelector('iframe').contentDocument.body.querySelectorAll('.etb-page');
        forEach(pages, function (page) {
            page.classList.remove('showMask');
            if (page.getAttribute('data-backgroundImage')) {
                page.style.backgroundImage = page.getAttribute('data-backgroundImage');
                page.removeAttribute('data-backgroundImage');
            }
        });
    }
    function addMaskSimple(isShow, ctrs) {
        var iframe = document.querySelector('iframe');
        var _frameDocument = iframe.contentDocument;
        var frameContainer = document.querySelector('.mainbo-frame-wrapper');
        var scrollPanel = frameContainer.parentElement;
        var turnPage = document.querySelector('.etb-turnpage');
        var toggleMenu = document.querySelector('.etb-menu-toggle');
        var etbMap = document.querySelector('.etb-map');
        var etbMapNavigator = document.querySelector('.etb-map-navigator');
        var wasFullscreen; // 保存添加遮罩时的全屏状态
        var mask = document.createElement('div');
        var closeMask = document.createElement('button');
        var scale = parseFloat(getComputedStyle(iframe, null).transform.split(/,|\(/)[1]);
        wasFullscreen = fullscreenElement() == document.body;
        if (isShow) {
            if (scrollPanel.getElementsByClassName('simple-masks')[0])
                return;
            closeMask.innerHTML = '<i></i>关闭';
            closeMask.classList.add('closeMask');
            scrollPanel.scrollTop = scrollPanel.scrollLeft = 0;
            closeMask.addEventListener('click', function (ev) {
                addMaskSimple(false, ctrs);
                if (!wasFullscreen)
                    cancelFullscreen();
            });
            scrollPanel.appendChild(closeMask);
            mask.classList.add('simple-masks');
            scrollPanel.insertBefore(mask, frameContainer);
            _frameDocument.body.style.background = 'none';
            turnPage.classList.remove('show');
            toggleMenu.classList.remove('show');
            etbMap.classList.add('hide');
            etbMapNavigator && etbMapNavigator.classList.add('hide');
            transformTarget(ctrs[0]);
        }
        else {
            if (!scrollPanel.getElementsByClassName('simple-masks')[0])
                return;
            scrollPanel.removeChild(scrollPanel.getElementsByClassName('simple-masks')[0]);
            scrollPanel.removeChild(scrollPanel.querySelector('.closeMask'));
            _frameDocument.body.style.background = '';
            turnPage.classList.add('show');
            toggleMenu.classList.add('show');
            etbMap.classList.remove('hide');
            etbMapNavigator && etbMapNavigator.classList.remove('hide');
            if (ctrs[0] && ctrs[0].classList.contains('mainbo-popup')) {
                dismissPopup(ctrs[0], true);
            }
            pauseMedia(ctrs[0]);
            removeShowMask(ctrs[0]);
            clickCloseMask();
        }
    }
    etb_book.addMaskSimple = addMaskSimple;
    function clickCloseMask() {
        var iframe = document.querySelector('iframe');
        var frameContainer = document.querySelector('.mainbo-frame-wrapper');
        var scrollPanel = frameContainer.parentElement;
        if (iframe.hasAttribute('data-etb-saved-style')) {
            iframe.setAttribute('style', iframe.getAttribute('data-etb-saved-style'));
            iframe.removeAttribute('data-etb-saved-style');
        }
        if (frameContainer.hasAttribute('data-etb-saved-style')) {
            frameContainer.setAttribute('style', frameContainer.getAttribute('data-etb-saved-style'));
            frameContainer.removeAttribute('data-etb-saved-style');
        }
        scrollPanel.style.overflow = scrollPanel.style.display = scrollPanel.style.alignItems = '';
        frameContainer.style.position = frameContainer.style.left = frameContainer.style.marginLeft = '';
    }
    function transformTarget(target) {
        if (!target)
            return;
        (target.localName == 'article') && (target.style.height = target.getBoundingClientRect().height + 'px');
        var iframe = document.querySelector('iframe');
        var scrollPanel = document.querySelector('.mainbo-scroll-pane');
        var scrollPanelRect = document.querySelector('.mainbo-scroll-pane').getBoundingClientRect();
        var scale = parseFloat(getComputedStyle(document.querySelector('iframe'), null).transform.split(/,|\(/)[1]);
        var w = target.getBoundingClientRect().width;
        var h = target.getBoundingClientRect().height;
        var newscale = Math.min(scrollPanelRect.height * 0.9 / h, scrollPanelRect.width * 0.9 / w);
        var oldStyleIframe = iframe.getAttribute('style');
        var oldStyleIframeContainer = iframe.parentElement.getAttribute('style');
        var page = target.parentElement;
        var maxPageWidth = 0, maxPageHeight = 0, totalPageHeight = 0;
        var kDefaultPageMarginV = 16, kDefaultPageMarginH = 16, kDefaultScrollBarWidth = 17;
        maxPageWidth = Math.max(maxPageWidth, parseFloat(page.style.width) || etb_book.kDefaultPageWidth);
        var ph = parseFloat(page.style.height) || etb_book.kDefaultPageHeight;
        maxPageHeight = Math.max(maxPageHeight, ph);
        Array.prototype.slice.call(page.parentElement.children, 0).forEach(function (page) {
            page['etbScale'] = 1; // TODO 去掉
            var tph = parseFloat(page.style.height) || etb_book.kDefaultPageHeight;
            totalPageHeight += tph;
        });
        var singlePage = fullscreenElement() == document.body;
        if (!singlePage) {
            launchFullScreen();
            singlePage = fullscreenElement() == document.body;
        }
        // newscale = singlePage ? newscale : scale;
        var contentWidth = newscale * (singlePage ? maxPageWidth : maxPageWidth + 2 * kDefaultPageMarginH);
        var contentHeight = newscale * (singlePage ? maxPageHeight :
            totalPageHeight + (page.parentElement.children.length + 1) * kDefaultPageMarginV + 2); // 2 是 etb-pages 的 padding
        var frameWidth = (innerHeight < contentHeight || innerWidth < contentWidth) ?
            Math.max(contentWidth, innerWidth - kDefaultScrollBarWidth / devicePixelRatio) : innerWidth;
        var frameHeight = Math.max(innerHeight, contentHeight);
        iframe.parentElement.style.width = frameWidth + 'px';
        iframe.parentElement.style.height = frameHeight + 'px';
        iframe.style.width = frameWidth / newscale + 'px';
        iframe.style.height = frameHeight / newscale + 'px';
        iframe.style.transform = iframe.style.webkitTransform = 'scale(' + newscale + ')';
        if (!iframe.hasAttribute('data-etb-saved-style'))
            iframe.setAttribute('data-etb-saved-style', oldStyleIframe);
        if (!iframe.parentElement.hasAttribute('data-etb-saved-style'))
            iframe.parentElement.setAttribute('data-etb-saved-style', oldStyleIframeContainer);
        iframe.parentElement.style.position = 'relative';
        iframe.parentElement.style.left = '50%';
        iframe.parentElement.style.marginLeft = -frameWidth / 2 + 'px';
        scrollPanel.style.overflow = 'hidden';
        scrollPanel.style.display = singlePage ? 'flex' : '';
        scrollPanel.style.alignItems = 'center';
    }
    etb_book.transformTarget = transformTarget;
    function getCSSValue(el, propName) {
        var cv = el.ownerDocument.defaultView &&
            el.ownerDocument.defaultView.getComputedStyle(el).getPropertyValue(propName);
        return cv || (el.style && el.style.getPropertyValue(propName)) || '';
    }
    function doLink(el, ev) {
        var url = el.getAttribute('xlink:href') || (el.localName === 'a' && el.getAttribute('href'));
        if (!url)
            return false;
        if (etb_book.isEditing(el))
            return true; // 会阻止 xlink:href，但不会阻止 a，后者由 book.e.ts/pointerHandler() 拦截。
        // 锚点链接处理，是否会对其他相关链接造成影响？
        if (anchorHref(url, el))
            return true;
        if (tryOpenUrlByDefaultBrowser(url, ev))
            return true;
        // 这是针对 firefox android 的一个 hack, 目的是允许用外部应用打开 flash 文件，因为 firefox android 中的 flash 不支持拖拽。
        // TODO 彻底去除 flash 支持后，简单地打开链接即可：
        // window.open(toAbsolute(xl));
        var fn = fileNameOfUrl(url);
        var i = fn.lastIndexOf('.');
        var ext = i >= 0 ? fn.slice(i + 1) : '';
        var isAndroidSwf = ext === 'swf' && navigator.userAgent.indexOf('Android') > -1;
        // Android 设备下swf需要下载打开
        if (isAndroidSwf || el.localName !== 'a') {
            openUrlByAnchor(url, el, isAndroidSwf ? fn : null);
            ev.preventDefault();
        }
        return true;
    }
    function anchorHref(url, el) {
        if (/^#page-\d+$/.test(url)) {
            var a = el.ownerDocument.createElement('a');
            el.ownerDocument.body.appendChild(a);
            a.onclick = function (ev) {
                ev.stopPropagation();
                etb_book.gotoPage(parseInt(/\d+/.exec(url)[0]) - 1);
                el.ownerDocument.body.removeChild(a);
            };
            a.click();
            return true;
        }
    }
    function fileNameOfUrl(url) {
        var i = url.lastIndexOf('/');
        return i >= 0 ? url.slice(i + 1) : url;
    }
    function openUrlByAnchor(url, context, download) {
        var doc = context.ownerDocument || context;
        var a = doc.createElement('a');
        a.href = url;
        if (download)
            a['download'] = download;
        else
            a.target = '_blank'; //总是新窗口打开
        a.hidden = true;
        doc.body.appendChild(a);
        a.onclick = function (ev) {
            ev.stopPropagation(); // 避免被 triggerConnection 接收到。
            doc.body.removeChild(a);
        };
        a.click();
    }
    var schemesWithDefaultBrowser = /^http[s]?:/;
    function tryOpenUrlByDefaultBrowser(url, ev) {
        if (!self['Components'] || !Components.classes || !schemesWithDefaultBrowser.test(url))
            return false;
        try {
            // first construct an nsIURI object using the ioservice
            var ioservice = Components.classes["@mozilla.org/network/io-service;1"]
                .getService(Components.interfaces.nsIIOService);
            var uriToOpen = ioservice.newURI(url, null, null);
            var extps = Components.classes["@mozilla.org/uriloader/external-protocol-service;1"]
                .getService(Components.interfaces.nsIExternalProtocolService);
            if (!extps.externalProtocolHandlerExists(uriToOpen.scheme))
                return false;
            // now, open it!
            extps.loadURI(uriToOpen, null);
            ev.preventDefault();
            return true;
        }
        catch (e) {
            console.warn(e);
            return false;
        }
    }
    function playConnection(el, ev) {
        // TODO 合并 xlink:href and data-mainbo-connection-src?
        doLink(el, ev);
        var src = el.getAttribute('data-mainbo-connection-src');
        var target = getControlById(src, el.ownerDocument);
        if (!target)
            return;
        doPopup(el, target);
        if (typeof target['play'] !== 'function') {
            return;
        }
        var media = target;
        var begin = parseFloat(el.getAttribute('data-mainbo-media-begin'));
        // 要求显式设置 data-mainbo-media-begin 才可触发播放，避免与 popup 产生干扰
        if (!isFinite(begin))
            return;
        var end = parseFloat(el.getAttribute('data-mainbo-media-end')) || -1;
        media.currentTime = begin;
        media.addEventListener('timeupdate', onTimeupdate);
        media.addEventListener('ended', onEnded);
        media.play();
        function onTimeupdate(ev) {
            var el = ev.target;
            if (end > 0 && el.currentTime >= end) {
                el.pause();
                cleanUp(el);
            }
        }
        function onEnded(ev) {
            cleanUp(ev.target);
        }
        function cleanUp(el) {
            el.removeEventListener('timeupdate', onTimeupdate);
            el.removeEventListener('ended', onEnded);
        }
    }
})(etb_book || (etb_book = {}));
//参考：
//  Promises / A + 规范 http://promises-aplus.github.io/promises-spec/
//  Promises/A 规范 http://wiki.commonjs.org/wiki/Promises/A
//  Q https://github.com/kriskowal/q/wiki/API-Reference
//  Promise.TypeScript https://github.com/pragmatrix/Promise
var mbe_common;
(function (mbe_common) {
    var Promise = /** @class */ (function () {
        function Promise() {
        }
        /**
        * onDone/onFail 应该返回值（或抛出异常），即不应返回 undefined，忘记返回值通常是 Bug，因此会在控制台给出警告。
        * 如果确实不需要返回值，可返回 null。
        */
        Promise.prototype.then = function (onDone, onFail) { return null; };
        Object.defineProperty(Promise.prototype, "status", {
            get: function () { return 0; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Promise.prototype, "result", {
            get: function () { return undefined; },
            enumerable: true,
            configurable: true
        });
        Promise.prototype.done = function (onDone) { return this; };
        Promise.prototype.fail = function (onFail) { return this; };
        Promise.prototype.progress = function (onProgress) { return this; };
        Promise.when = function (promises) {
            var allDone = new Deferred();
            if (!promises.length) {
                allDone.resolve([]);
                return allDone;
            }
            var resolved = 0;
            for (var i = 0; i < promises.length; i++) {
                promises[i]
                    .done(function (v) {
                    ++resolved;
                    if (resolved === promises.length && allDone.status === Promise.UNFULFILLED) {
                        var results = promises.map(function (p) { return p.result; });
                        allDone.resolve(results);
                    }
                })
                    .fail(function (e) {
                    if (allDone.status === Promise.UNFULFILLED)
                        allDone.reject(e); //TODO 此处i是无用的，怎么指示是哪一个promise的信息？
                })
                    .progress(function (v) {
                    if (allDone.status === Promise.UNFULFILLED) {
                        allDone.notify(v); //TODO 此处i是无用的，怎么指示是哪一个promise的信息？
                    }
                });
            }
            return allDone;
        };
        /**
         * 将其他库的 promise 实现包装成 mbe_common.Deferred 的实例。
         */
        Promise.wrap = function (promiseLike) {
            var ret = new Deferred();
            promiseLike.then(function (res) {
                ret.resolve(res);
            }, function (err) {
                ret.reject(err);
            });
            return ret;
        };
        Promise.UNFULFILLED = 0;
        Promise.RESOLVED = 1;
        Promise.REJECTED = 2;
        return Promise;
    }());
    mbe_common.Promise = Promise;
    var Deferred = /** @class */ (function (_super) {
        __extends(Deferred, _super);
        function Deferred() {
            var _this = _super.call(this) || this;
            _this._onDones = null;
            _this._onFails = null;
            _this._onProgresses = null;
            _this._status = Promise.UNFULFILLED;
            _this._result = undefined;
            if (Deferred._DEBUG) {
                try {
                    throw new Error('Deferred constructor calling stack');
                }
                catch (e) {
                    _this._stack = e;
                }
            }
            return _this;
        }
        Object.defineProperty(Deferred.prototype, "status", {
            get: function () { return this._status; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Deferred.prototype, "result", {
            get: function () { return this._result; },
            enumerable: true,
            configurable: true
        });
        Deferred.prototype.done = function (onDone) {
            if (this._status == Promise.UNFULFILLED) {
                this._onDones = this._onDones || [];
                this._onDones.push(onDone);
            }
            else if (this._status == Promise.RESOLVED)
                this._emitEventDirectly(onDone);
            return this;
        };
        Deferred.prototype.fail = function (onFail) {
            if (this._status == Promise.UNFULFILLED) {
                this._onFails = this._onFails || [];
                this._onFails.push(onFail);
            }
            else if (this._status == Promise.REJECTED)
                this._emitEventDirectly(onFail);
            return this;
        };
        Deferred.prototype.progress = function (onProgress) {
            if (this._status == Promise.UNFULFILLED) {
                this._onProgresses = this._onProgresses || [];
                this._onProgresses.push(onProgress);
            }
            return this;
        };
        Deferred.prototype.then = function (onDone, onFail) {
            var _this = this;
            var def = new Deferred();
            var result;
            this.done(function (data) {
                if (onDone) {
                    try {
                        result = onDone(data);
                        _this._warnReturnValue(result);
                        if (result instanceof Promise) {
                            def._bindTo(result);
                            return result;
                        }
                        else
                            def.resolve(result);
                    }
                    catch (err) {
                        def.reject(err);
                    }
                }
                else
                    def.resolve(data);
            });
            this.fail(function (err) {
                if (onFail) {
                    try {
                        result = onFail(err);
                        _this._warnReturnValue(result);
                        if (result instanceof Promise) {
                            def._bindTo(result);
                            return result;
                        }
                        else {
                            def.resolve(result);
                        }
                    }
                    catch (err2) {
                        def.reject(err2);
                    }
                }
                else
                    def.reject(err);
            });
            return def;
        };
        Deferred.prototype.resolve = function (data) {
            if (Deferred._DEBUG && typeof data === 'undefined')
                console.warn('>>>> Deferred.resolve() received undefined, likely a bug');
            return this._emitEvent(data, Promise.RESOLVED);
        };
        Deferred.prototype.reject = function (err) {
            if (Deferred._DEBUG) {
                try {
                    throw new Error('Deferred.reject calling stack');
                }
                catch (e) {
                    console.warn('rejected: Defered.constructor stack:\n' + (this._stack['stack'] || this._stack)
                        + '\nrejected: Defered.rejected stack:\n' + (e['stack'] || e)
                        + '\nrejected: reason stack:\n' + (err['stack'] || err));
                }
            }
            return this._emitEvent(err, Promise.REJECTED);
        };
        Deferred.prototype.notify = function (data) {
            return this._emitEvent(data);
        };
        Deferred.prototype._emitEvent = function (data, status) {
            if (this._status != Promise.UNFULFILLED && Deferred._DEBUG) {
                // ES6 Promise 在重复完成 promise 的时候并不会出错，所以此处也只在 DEBUG 模式给出警告
                // throw Error('fulfilled');
                console.warn('Promise: try to fulfil a fulfilled.');
                return this;
            }
            var callbacks;
            if (status === Promise.RESOLVED)
                callbacks = this._onDones;
            else if (status === Promise.REJECTED)
                callbacks = this._onFails;
            else
                callbacks = this._onProgresses;
            if (status) {
                this._status = status;
                this._result = data;
                this._onDones = this._onFails = this._onProgresses = null;
            }
            if (callbacks) {
                for (var i = 0; i < callbacks.length; i++) {
                    try {
                        callbacks[i](data);
                    }
                    catch (e) {
                        this._log(e);
                    }
                }
            }
            return this;
        };
        Deferred.prototype._bindTo = function (p) {
            p.done(this.resolve.bind(this))
                .fail(this.reject.bind(this))
                .progress(this.notify.bind(this));
        };
        Deferred.prototype._emitEventDirectly = function (callback) {
            var _this = this;
            if (!callback)
                return;
            setTimeout(function () {
                try {
                    callback(_this._result);
                }
                catch (e) {
                    _this._log(e);
                }
            }, 0);
        };
        Deferred.prototype._log = function (err) {
            console.warn(err.stack || err);
        };
        Deferred.prototype._warnReturnValue = function (value) {
            if (Deferred._DEBUG) {
                if (typeof value === 'undefined')
                    console.warn('>>>> Promise.then(): onDone/onFail returns undefined, likely a bug');
                else if (value && !(value instanceof Promise) && typeof value.then === 'function')
                    console.warn('>>>> Promise.then(): onDone/onFail returns a promise-like object, likely a bug. Consider Promise.wrap().');
            }
        };
        /**
        * 将 _DEBUG 设置为 true 时，_stack.stack 将反调用映构造器时的调用栈，从而有助于调试。
        */
        Deferred._DEBUG = false;
        return Deferred;
    }(Promise));
    mbe_common.Deferred = Deferred;
})(mbe_common || (mbe_common = {}));
///<reference path="Promise.ts"/>
/// <reference path="IOUtils.ts" />
var mbe_common;
(function (mbe_common) {
    function updateCacheData() {
        var db = new indexedDB();
        db.selectAll().then(function (resultList) {
            resultList.forEach(function (item) {
                var options = item['options'];
                if (options.type === 'get')
                    mbe_common.IOUtils.getDataFromNetOrIndexedDB(item['url'], options.dataType, true);
            });
        });
    }
    // setTimeout(updateCacheData, 1000 * 5);
    function clearCacheData() {
        var db = new indexedDB();
        db.clear().then(function (okMsg) {
            console.log('clearCacheData()', okMsg);
        }, function (errMsg) { return console.log('clearCacheData()', errMsg); });
    }
    // Firefox 没有找到手动清除方法，使用此代码清除
    setTimeout(clearCacheData, 1000 * 10);
    var indexedDB = /** @class */ (function () {
        function indexedDB() {
            this.settings = {
                databaseName: 'mainbo',
                version: 1.0,
                db: null,
                tableName: 'base',
                transaction: null,
                objectStore: null
            };
            if (!indexedDB.indexedDB || !indexedDB.IDBTransaction || !indexedDB.IDBKeyRange)
                console.warn('不支持 indexedD', '无法缓存数据');
            this.openDB();
        }
        indexedDB.newInstance = function () {
            var obj = new indexedDB();
            return new mbe_common.Deferred().resolve(obj);
        };
        indexedDB.prototype.openDB = function () {
            var def = new mbe_common.Deferred();
            var st = this.settings;
            var request = indexedDB.indexedDB.open(st.databaseName, st.version);
            request.onsuccess = function (ev) {
                st.db = ev.target.result;
                st.transaction = st.db.transaction([st.tableName], 'readwrite');
                st.objectStore = st.transaction.objectStore(st.tableName);
                def.resolve(st.db);
            };
            request.onerror = function (ev) {
                def.reject('openDB(): indexedDB 打开失败');
            };
            request.onupgradeneeded = function (ev) {
                st.db = ev.target.result;
                if (!st.db.objectStoreNames.contains(st.tableName)) {
                    var objectStore = st.db.createObjectStore(st.tableName, { keyPath: 'urlMD5' });
                    objectStore.createIndex('indexUrlMD5', 'urlMD5', { unique: true });
                }
                def.resolve(st.db);
            };
            return def;
        };
        indexedDB.prototype.insert = function (st) {
            var def = new mbe_common.Deferred();
            var urlMD5 = CryptoJS.MD5(st.url).toString();
            var that = this;
            return that.openDB()
                .then(function () { return that.select({ url: st.url, type: 'item' }); }).then(function (item) {
                item.updateTime = (new Date().toLocaleString());
                item.result = st.result;
                item.options = st.options;
                var updateRequest = that.settings.objectStore.put(item);
                updateRequest.onsuccess = function (ev) {
                    def.resolve(st.result);
                };
                updateRequest.onerror = function (ev) {
                    def.reject('insert(): 更新失败');
                };
                return def;
            }, function (err) {
                var expire = Date.now() + 1000 * 60 * 60 * 24 * 30 * 12;
                var newItem = {
                    urlMD5: urlMD5,
                    keyMD5: urlMD5,
                    url: st.url,
                    result: st.result,
                    createTime: (new Date().toLocaleString()),
                    updateTime: (new Date().toLocaleString()),
                    expire: expire,
                    options: st.options
                };
                if (!that.settings.objectStore)
                    def.resolve(st.result);
                else {
                    var objectStoreRequest = that.settings.objectStore.add(newItem);
                    objectStoreRequest.onsuccess = function (ev) {
                        def.resolve(st.result);
                    };
                    objectStoreRequest.onerror = function (ev) {
                        def.reject('insert(): 新增失败');
                    };
                }
                return def;
            });
        };
        /**
         * @param err urlGet 的 Error 对象
         */
        indexedDB.prototype.select = function (st) {
            var def = new mbe_common.Deferred();
            var urlMD5 = CryptoJS.MD5(st.url).toString();
            var that = this;
            return that.openDB().then(function (db) {
                var objectStoreRequest = that.settings.objectStore.get(urlMD5);
                objectStoreRequest.onsuccess = function (ev) {
                    var item = objectStoreRequest.result;
                    if (item)
                        def.resolve(st.type === 'item' ? item : item.result);
                    else
                        def.reject(st.err);
                };
                objectStoreRequest.onerror = function (ev) {
                    def.reject(st.err);
                };
                // TODO Firefox 索引不可用？
                // var index = that.settings.objectStore.index('indexUrlMD5');
                // index.get(urlMD5).onsuccess = ev => {
                //   var item = ev.target.result;
                //   def.resolve(item);
                // }
                // index.get(urlMD5).onerror = ev => {
                //   def.reject(ev);
                // }
                return def;
            });
        };
        indexedDB.prototype.selectAll = function () {
            var def = new mbe_common.Deferred();
            var st = this.settings;
            return this.openDB().then(function (db) {
                st.transaction = st.db.transaction([st.tableName], 'readwrite');
                st.objectStore = st.transaction.objectStore(st.tableName);
                var index = st.objectStore.index('indexUrlMD5');
                var resultList = [];
                index.openCursor().onsuccess = function (ev) {
                    var cursor = ev.target.result;
                    if (cursor) {
                        resultList.push(cursor.value);
                        cursor.continue();
                    }
                    else {
                        def.resolve(resultList);
                    }
                };
                return def;
            });
        };
        indexedDB.prototype.update = function (st) { };
        indexedDB.prototype.delete = function (st) { };
        indexedDB.prototype.clear = function () {
            var _this = this;
            var def = new mbe_common.Deferred();
            return this.openDB().then(function (db) {
                var objectStoreRequest = _this.settings.objectStore.clear();
                objectStoreRequest.onsuccess = function (ev) {
                    def.resolve("数据清楚成功");
                };
                objectStoreRequest.onerror = function (ev) {
                    def.resolve("数据清楚失败");
                };
                return def;
            });
        };
        indexedDB.prototype.closeDB = function () { this.settings.db.close(); };
        indexedDB.indexedDB = window.indexedDB
            || window['webkitIndexedDB']
            || window['mozIndexedDB'];
        indexedDB.IDBTransaction = window['IDBTransaction']
            || window['webkitIDBTransaction']
            || window['msIDBTransaction'];
        indexedDB.IDBKeyRange = window['IDBKeyRange']
            || window['webkitIDBKeyRange']
            || window['msIDBKeyRange'];
        indexedDB.filter = [
            'sync_ClientMetaData',
            'getSubjectsByComType',
            'getPublishersByComType',
            'shop_getCommodityList',
            'book_ChapterInfoComId',
        ];
        return indexedDB;
    }());
    mbe_common.indexedDB = indexedDB;
})(mbe_common || (mbe_common = {}));
///<reference path="Promise.ts"/>
/// <reference path="IndexedDB.ts" />
var mbe_common;
(function (mbe_common) {
    var IOUtils;
    (function (IOUtils) {
        /**
         * @return string, 文本内容。
         * progress：ProgressEvent
         */
        function readAsText(blob, encoding) {
            return read(blob, encoding || 'UTF-8');
        }
        IOUtils.readAsText = readAsText;
        /**
         * @return ArrayBuffer, 二进制内容。
         * progress：ProgressEvent
         */
        function readAsArrayBuffer(blob) {
            return read(blob);
        }
        IOUtils.readAsArrayBuffer = readAsArrayBuffer;
        function read(blob, encoding) {
            var def = new mbe_common.Deferred();
            var fr = new FileReader();
            fr.onload = function () { return def.resolve(fr.result); };
            fr.onerror = function (err) { return def.reject(err); };
            fr.onloadend = function () {
                if (def.status === mbe_common.Promise.UNFULFILLED)
                    def.reject(new Error());
            };
            fr.onprogress = function (e) { return def.notify(e); };
            if (encoding)
                fr.readAsText(blob, encoding);
            else
                fr.readAsArrayBuffer(blob);
            return def;
        }
        // Firefox 对 file|chrome|resource|app 协议总是假定 XML 格式；
        // Chrome 对 filesystem + responseType = 'document' 总是假定 (x)html 格式，所以要自行识别 mime 类型。
        function shouldOverrideMimeType(urlScheme) {
            return /^(file|chrome|resource|app|filesystem)$/.test(urlScheme);
        }
        var db = new mbe_common.indexedDB();
        /**
         * 封装 urlGet，支持数据缓存
         * @param updateIndexedDB 是否更新缓存
         */
        function getDataFromNetOrIndexedDB(url, dataType, updateIndexedDB) {
            if (dataType === void 0) { dataType = 'text'; }
            if (updateIndexedDB === void 0) { updateIndexedDB = false; }
            var def = new mbe_common.Deferred();
            var fetchIsExist = false;
            mbe_common.indexedDB.filter.forEach(function (item) {
                if (url.indexOf(item) > 0) {
                    fetchIsExist = true;
                    return;
                }
            });
            if (fetchIsExist) {
                if (updateIndexedDB === true) {
                    return urlGet(url, dataType)
                        .then(function (result) { return db.insert({ url: url, result: result, options: { type: 'get', dataType: dataType } }); });
                }
                else {
                    // 查询缓存
                    //   成功：使用缓存，随即更新缓存
                    //   失败：使用网络，添加缓存
                    db.select({ url: url })
                        .then(function (data) {
                        def.resolve(data);
                        setTimeout(function () {
                            urlGet(url, dataType)
                                .then(function (result) { return db.insert({ url: url, result: result, options: { type: 'get', dataType: dataType } }); });
                        }, 0);
                    }, function (err) {
                        return urlGet(url, dataType)
                            .then(function (result) {
                            def.resolve(result);
                            db.insert({ url: url, result: result, options: { type: 'get', dataType: dataType } });
                        });
                    });
                }
            }
            else {
                return urlGet(url, dataType);
            }
            return def;
        }
        IOUtils.getDataFromNetOrIndexedDB = getDataFromNetOrIndexedDB;
        /**
         * 用于 fetch() 或 urlFetch() 的强制缓存验证选项。适用于GET方法。
         * cache-Control: max-age=0 和 cache: no-cache 理论上都能导致条件请求，而不是直接使用缓存。
         * 但是 Firefox 52-58 对 max-age=0 的实现有 bug
         * （ https://bugzilla.mozilla.org/show_bug.cgi?id=1433088 ），
         * 即如果 age 在 1 秒以内，就有可能直接使用缓存。
         * Firefox 52-58 的 cache: no-cache 实现没有这个问题。
         * Chrome 63 还不支持 cache: no-cache ，但对 max-age=0 的实现没有这个问题。
         * 所以解决办法是两者都用上。
         */
        IOUtils.kRenewOptions = Object.freeze({ headers: { 'cache-control': 'max-age=0' }, cache: 'no-cache' });
        /**
         * 用于 fetch() 或 urlFetch() 的强制缓存验证选项。适用于HEAD方法。详见 kRenewOptions。
         */
        IOUtils.kRenewHeadOptions = Object.freeze({ method: 'HEAD', headers: { 'cache-control': 'max-age=0' }, cache: 'no-cache' });
        /**
         * 从指定的 url 获取数据。
         * 与直接使用 fetch() 相比，优点是减少了得到响应体的步骤，缺点则是不能得到响应头以及非200状态的响应（会作为异常）。
         * Firefox 52-58 的 XHR 对 cache-control max-age=0 的实现不正确，如果要强制缓存验证，只能用 fetch/urlFetch，
         * 并加上 kRenewOptions/kRenewHeadOptions。
         * @param dataType 指定返回的响应体的数据形式。可以为 'blob|arraybuffer|text|json'，
         *  'json' 将会自动解析 json 为对象。
         * @param options 与 window.fetch() 的第二个参数含义相同
         * @return Promise<any> 根据 dataType，数据类型可以是 Blob、ArrayBuffer、string、Object 等。
         * TODO 未来可逐步取代 urlGet 和 urlPost 。
         * 注意，现在还不能取代 urlGet，因为不支持 document 类型的响应体。
         * 这是因为用 DOMParser 解析文档时，只能丢弃 base url 的信息。
         * 虽然有可能插入 base 元素来解决，但这样的文档与原文档不同了。
         */
        function urlFetch(url, dataType, options) {
            if (dataType === void 0) { dataType = 'text'; }
            var contentType;
            var pUrl = new URL(url, self.document ? document.baseURI : undefined);
            var scheme = pUrl.protocol.slice(0, -1);
            if (shouldOverrideMimeType(scheme)) {
                contentType = fileNameToMime(url);
            }
            return mbe_common.Promise.wrap(
            // 此处不能直接用 url，因为 firefox 对 chrome: 协议的相对 url 有 bug，会抛出异常。
            // https://bugzilla.mozilla.org/show_bug.cgi?id=1436017
            fetch(pUrl.href, options)
                .then(function (res) {
                if (!res.ok)
                    throw new Error('fetch ' + url + ' failed with code ' + res.status);
                if (!contentType) {
                    contentType = res.headers.get('content-type');
                }
                switch (dataType) {
                    case 'text':
                    // case 'document':
                    //   return res.text();
                    case 'json':
                        return res.json();
                    case 'blob':
                        return res.blob();
                    case 'arraybuffer':
                        return res.arrayBuffer();
                }
            })
                .then(function (body) {
                // if (dataType === 'document') {
                //   if (!/xml|html/.test(contentType)) {
                //     console.warn('urlFetch:override as xml:' + url + ' ' + contentType);
                //     contentType = "application/xml";
                //   }
                //   let doc = new DOMParser().parseFromString(body, contentType);
                //   if (doc.documentElement.localName === 'parsererror' && 
                //     doc.documentElement.namespaceURI === 'http://www.mozilla.org/newlayout/xml/parsererror.xml') {
                //     throw new Error('urlFetch:DOMParser error:\n' + doc.documentElement.outerHTML);
                //   }
                //   return doc;
                // } else 
                if (dataType === 'blob' && contentType && contentType != body.type) {
                    console.log('urlFetch:overrid as blob:' + url + ' ' + body.type);
                    return new Blob([body], { type: contentType });
                }
                else {
                    return body;
                }
            }));
        }
        IOUtils.urlFetch = urlFetch;
        /**
         * 从指定的 url 下载数据。
         * @param dataType 与 XHR2 的 responseType 类似，可以为 'blob|document|arraybuffer|text'，
         * 还可以取 'json'，将会自动解析 json 为对象。
         * @return Promise<any> 根据 dataType，数据类型可以是 Blob、Document、ArrayBuffer、string、Object 等。
         */
        function urlGet(url, dataType) {
            ////console.log('urlGet:url: ' + url + ' , ' + dataType);
            if (dataType === void 0) { dataType = 'text'; }
            var scheme = getUrlScheme(toAbsoluteUrl(url));
            /* chrome 29-31 对 filesystem: XHR blob 的读取有bug，较大的blob（十几兆到上百兆）读取时会出现错误NotFoundError，
            尤其是同时还在创建其它blob时。所以对此特殊处理。
            TODO: 测试 http, file, blob url 的 blob 类型读取有没有类似问题。
            TODO: 跟踪
            TODO: 处理相对url
            */
            if (dataType === 'blob' && scheme === 'filesystem')
                return fsUrlGet(url);
            var def = new mbe_common.Deferred();
            var xhr = new XMLHttpRequest();
            function reject(err, stage) {
                if (stage === void 0) { stage = ''; }
                console.error('urlGet:error:' + stage + ':url=' + url + ' , dataType=' + dataType, err);
                return def.reject(err);
            }
            //TODO FF 25- 和 IE 11- 要求 open() 之后才能设置 responseType，否则抛出异常，这不符合最新的规范
            //TODO FF 对于某些网络错误，open() 抛出异常 https://bugzilla.mozilla.org/show_bug.cgi?id=995298
            try {
                xhr.open('GET', url);
                if (shouldOverrideMimeType(scheme)) {
                    xhr.overrideMimeType(fileNameToMime(url));
                    console.log('urlGet:overrideMimeType:' + url + ' ' + fileNameToMime(url));
                }
            }
            catch (e) {
                return reject(e, 'open');
            }
            // if (/^(blob|document|arraybuffer|text)$/.test(dataType))
            //   xhr.responseType = dataType;
            // else if ('json' === dataType)
            //   xhr.responseType = 'text';
            // else return reject(new Error('unknown dataType: ' + dataType), 'dataType');
            if (typeof dataType === 'string' && dataType) {
                if (dataType === 'json') {
                    xhr.responseType = 'text';
                }
                else {
                    xhr.responseType = dataType;
                }
            }
            else {
                reject(new Error('unknown dataType: ' + dataType), 'dataType');
            }
            xhr.onload = function () {
                var st = xhr.status;
                if (st >= 200 && st < 300 || st === 304 || st === 0) {
                    if (dataType === 'json') {
                        try {
                            def.resolve(JSON.parse(xhr.response));
                        }
                        catch (e) {
                            e.data = xhr.response;
                            reject(e, 'JSON.parse');
                        }
                    }
                    else
                        def.resolve(xhr.response);
                }
                else {
                    reject(new Error('XHR status:' + st + ', url: ' + url), 'http-' + st);
                }
            };
            // err 不是个 Error 对象，而是个 Event 对象，意义不大。
            xhr.onerror = function (err) { return reject(new Error('XHR failed on loading ' + url), 'network'); };
            xhr.onprogress = function (ev) { return def.notify(ev); };
            xhr.onloadend = function (ev) {
                if (def.status === mbe_common.Promise.UNFULFILLED)
                    reject(new Error('XHR failed on loadend'), 'loadend');
            };
            try {
                xhr.send();
            }
            catch (e) {
                reject(e, 'send');
            }
            return def;
        }
        IOUtils.urlGet = urlGet;
        /**
         * 向指定的 url post 数据。
         * @param data 要发送的数据。
         * @param sendContentType 发送的 mime 类型，设置到 'Content-Type' 头。仅当 data 的类型是 string 时有效。默认值 'text/plain'。
         * @param returnDataType 与 XHR2 的 responseType 类似，可以为 'blob|document|arraybuffer|text'，
         * 还可以取 'json'，将会自动解析 json 为对象。
         * @return Promise<any> 根据 returnDataType，数据类型可以是 Blob、Document、ArrayBuffer、string、Object 等。
         */
        function urlPost(url, data, sendContentType, returnDataType) {
            ////console.log('urlPost:url: ' + url + ' , ' + dataType);
            if (sendContentType === void 0) { sendContentType = 'text/plain'; }
            if (returnDataType === void 0) { returnDataType = 'text'; }
            var def = new mbe_common.Deferred();
            var xhr = new XMLHttpRequest();
            function reject(err, stage) {
                if (stage === void 0) { stage = ''; }
                console.error('urlPost:error:' + stage + ':url=' + url + ' , sendContentType=' + sendContentType + ' , returnDataType=' + returnDataType, err);
                return def.reject(err);
            }
            //TODO FF 25- 和 IE 11- 要求 open() 之后才能设置 responseType，否则抛出异常，这不符合最新的规范
            //TODO FF 对于某些网络错误，open() 抛出异常 https://bugzilla.mozilla.org/show_bug.cgi?id=995298
            try {
                xhr.open('POST', url);
            }
            catch (e) {
                return reject(e, 'open');
            }
            if (typeof data === 'string')
                xhr.setRequestHeader('Content-Type', sendContentType);
            // if (/^(blob|document|arraybuffer|text)$/.test(returnDataType))
            //   xhr.responseType = returnDataType;
            // else if ('json' === returnDataType)
            //   xhr.responseType = 'text';
            // else return reject(new Error('unknown dataType: ' + returnDataType), 'dataType');
            if (typeof returnDataType === 'string' && returnDataType) {
                if (returnDataType === 'json') {
                    xhr.responseType = 'text';
                }
                else {
                    xhr.responseType = returnDataType;
                }
            }
            else {
                reject(new Error('unknown dataType: ' + returnDataType), 'dataType');
            }
            xhr.onload = function () {
                var st = xhr.status;
                if (st == 200) {
                    if (returnDataType === 'json') {
                        try {
                            def.resolve(JSON.parse(xhr.response));
                        }
                        catch (e) {
                            e.data = xhr.response;
                            reject(e, 'JSON.parse');
                        }
                    }
                    else
                        def.resolve(xhr.response);
                }
                else {
                    reject(new Error('XHR status:' + st + ', url: ' + url), 'http-' + st);
                }
            };
            // err 不是个 Error 对象，而是个 Event 对象，意义不大。
            xhr.onerror = function (err) { return reject(new Error('XHR failed on loading ' + url), 'network'); };
            xhr.onprogress = function (ev) { return def.notify(ev); };
            xhr.onloadend = function (ev) {
                if (def.status === mbe_common.Promise.UNFULFILLED)
                    reject(new Error('XHR failed on loadend'), 'loadend');
            };
            try {
                xhr.send(data);
            }
            catch (e) {
                reject(e, 'send');
            }
            return def;
        }
        IOUtils.urlPost = urlPost;
        function fsUrlGet(url) {
            var def = new mbe_common.Deferred();
            var resolve = window['resolveLocalFileSystemURL'] || window['webkitResolveLocalFileSystemURL'];
            resolve(url, function (entry) {
                if (entry.isFile)
                    entry.file(function (file) { return def.resolve(file); }, function (err) { return def.reject(err); });
                else
                    def.reject(new Error("can't getBlob of directory"));
            }, function (err) { return def.reject(err); });
            return def;
        }
        /**
         * 读操作系统中的文件，文件会被整体读出。
         * 注意，目前只有Moz平台特权代码中支持，未来 node-webkit 环境也可能支持。
         * @param path 文件的操作系统路径。
         * @return Blob 类型，文件内容。
         */
        function getFile(path) {
            var ret = new mbe_common.Deferred();
            try {
                var blob = new window['File'](path);
                ret.resolve(blob);
            }
            catch (e) {
                ret.reject(e);
            }
            return ret;
        }
        IOUtils.getFile = getFile;
        /**
         * 将路径正规化。如果可能，'..'将被消去，'.'和多个'/'被消去，末尾的'/'被消去（开头的不会消去）。
         */
        function pathNormalize(path) {
            var parts = pathSplit(path);
            if (parts[0] === '/')
                parts[0] = '';
            return parts.join('/');
        }
        IOUtils.pathNormalize = pathNormalize;
        /**
         * 将路径正规化为相对路径。如果可能，'..'将被消去，'.'和多个'/'被消去，开头和末尾的'/'被消去。
         */
        function pathNormalizeRelative(path) {
            var parts = pathSplit(path);
            if (parts[0] === '/')
                parts.shift();
            return parts.join('/');
        }
        IOUtils.pathNormalizeRelative = pathNormalizeRelative;
        /**
         * 将路径正规化，并切分成部分。如果可能，'..'将被消去，'.'和多个'/'被消去，末尾的'/'被消去。
         */
        function pathSplit(path) {
            var parts = path.split('/');
            var parts2 = [];
            if (path.charAt(0) === '/')
                parts2.push('/');
            for (var i = 0; i < parts.length; i++) {
                var part = parts[i];
                if (!part || part === '.')
                    continue;
                else if (part === '..') {
                    var p = parts2.pop();
                    if (p === '/')
                        throw new Error('malformed:' + path);
                }
                else
                    parts2.push(part);
            }
            return parts2;
        }
        IOUtils.pathSplit = pathSplit;
        /**
         * 将两个路径连接成一个路径。例如 pathJoin('a', 'b') == pathJoin('a/', '/b') == 'a/b'
         */
        function pathJoin(path1, path2) {
            path1 = path1.charAt(path1.length - 1) === '/' ? path1.slice(0, -1) : path1;
            path2 = path2.charAt(0) === '/' ? path2.slice(1) : path2;
            return path1 + '/' + path2;
        }
        IOUtils.pathJoin = pathJoin;
        function fileNameOfPath(path) {
            var i = path.lastIndexOf('/');
            return i >= 0 ? path.slice(i + 1) : path;
        }
        IOUtils.fileNameOfPath = fileNameOfPath;
        function dirOfPath(path) {
            var i = path.lastIndexOf('/');
            return i >= 0 ? path.slice(0, i + 1) : '.';
        }
        IOUtils.dirOfPath = dirOfPath;
        var REG_EXT = /^\w+$/;
        function fileExt(path) {
            var name = fileNameOfPath(path);
            var i = name.lastIndexOf('.');
            var ext = i >= 0 ? name.slice(i + 1) : null;
            return ext && REG_EXT.test(ext) ? ext : '';
        }
        IOUtils.fileExt = fileExt;
        function fileNameOfPathWithOutExt(path) {
            var name = fileNameOfPath(path), ext = fileExt(name);
            return ext ? name.slice(0, -ext.length - 1) : name;
        }
        IOUtils.fileNameOfPathWithOutExt = fileNameOfPathWithOutExt;
        /**
         * TODO 目前参数必须是正规化的绝对url，baseUrl的路径部分至少要有一个/
         */
        function toRelativeURL(url, baseUrl) {
            var i = baseUrl.lastIndexOf('/');
            var baseDir = i >= 0 ? baseUrl.slice(0, i + 1) : baseUrl + '/';
            if (url.indexOf(baseDir) === 0)
                return url.slice(baseDir.length);
            else
                return null;
        }
        IOUtils.toRelativeURL = toRelativeURL;
        var REGX_SCHEME = /^[a-zA-Z]+\:/; //TODO accurate
        function getUrlScheme(url) {
            var m = url.match(REGX_SCHEME);
            if (m)
                return m[0].slice(0, -1);
        }
        IOUtils.getUrlScheme = getUrlScheme;
        IOUtils.SCHEME_DISABLED = 'disabled'; //用于造成 object 加载失败，显示后备内容。TODO 更标准的做法？
        /**
         * 去掉 disabled: 协议，如果有的话。
         */
        function getEnabledUrl(url) {
            return getUrlScheme(url) === IOUtils.SCHEME_DISABLED ? url.slice(IOUtils.SCHEME_DISABLED.length + 1) : url;
        }
        IOUtils.getEnabledUrl = getEnabledUrl;
        /**
         * 加上 disabled: 协议，如果没有的话
         */
        function getDisabledUrl(url) {
            return getUrlScheme(url) === IOUtils.SCHEME_DISABLED ? url : IOUtils.SCHEME_DISABLED + ':' + url;
        }
        IOUtils.getDisabledUrl = getDisabledUrl;
        /**
         * 测试是否绝对url。测试时忽略掉 disabled: 协议部分（如果有）。
         */
        function isAbsoluteUrl(url) {
            var s = getUrlScheme(getEnabledUrl(url));
            return !!s;
        }
        IOUtils.isAbsoluteUrl = isAbsoluteUrl;
        function toAbsoluteUrl(url, baseUrl) {
            if (isAbsoluteUrl(url))
                return url;
            var disabled = getUrlScheme(url) === IOUtils.SCHEME_DISABLED;
            baseUrl || (baseUrl = document.baseURI);
            url = pathJoin(dirOfPath(baseUrl), getEnabledUrl(url)); //TODO baseUrl may not has path portion
            return disabled ? getDisabledUrl(url) : url;
        }
        IOUtils.toAbsoluteUrl = toAbsoluteUrl;
        /**
         * 二进制文件的mime
         */
        IOUtils.MIME_BIN = "application/octet-stream";
        /**
         * 二进制文件的扩展名
         */
        IOUtils.EXT_BIN = "bin";
        function mimeToExt(mime) {
            if (self['zip'] && zip.mimeToExt)
                return zip.mimeToExt(mime) || IOUtils.EXT_BIN;
            else {
                console.warn('zip.mimeToExt not exists, give up');
                return IOUtils.EXT_BIN;
            }
        }
        IOUtils.mimeToExt = mimeToExt;
        function fileNameToMime(name) {
            if (self['zip'] && zip.fileNameToMime) {
                return zip.fileNameToMime(name);
            }
            else {
                console.warn('zip.mimeToExt not exists, give up');
                return IOUtils.MIME_BIN;
            }
        }
        IOUtils.fileNameToMime = fileNameToMime;
        // 用前缀的 '.' 来表示关闭的 mime-type。用于强迫 <object> 显示后备内容（配合typemustmatch）。
        function isDisabledMime(mime) {
            return mime[0] === '.';
        }
        IOUtils.isDisabledMime = isDisabledMime;
        function toDisabledMime(mime) {
            return mime[0] === '.' ? mime : '.' + mime;
        }
        IOUtils.toDisabledMime = toDisabledMime;
        function toEnabledMime(mime) {
            return mime[0] === '.' ? mime.slice(1) : mime;
        }
        IOUtils.toEnabledMime = toEnabledMime;
        // TODO hasUrlSerializationIssue & encodePath are not actually used
        // to detect firefox bug https://bugzilla.mozilla.org/show_bug.cgi?id=547667
        var _url_ser_issue = null;
        function hasUrlSerializationIssue(context) {
            if (context === void 0) { context = document; }
            if (_url_ser_issue === null) {
                var el = (context.ownerDocument || context).createElement('img');
                el.setAttribute('src', 'a b');
                _url_ser_issue = el.outerHTML.indexOf('%') >= 0;
            }
            return _url_ser_issue;
        }
        IOUtils.hasUrlSerializationIssue = hasUrlSerializationIssue;
        // export function encodePath(name: string): string {
        //   var parts = pathSplit(name);
        //   if (name[name.length - 1] === '/')
        //     parts.push('');
        //   if (parts[0] === '/')
        //     parts[0] = '';
        //   parts = parts.map(part => {
        //     if (hasUrlSerializationIssue())
        //       return encodeURIComponent(part);
        //     else
        //       return encodeIRIComponent(part);
        //   });
        //   return parts.join('/');
        // }
        function encodeIRIPath(name) {
            var parts = pathSplit(name);
            if (name[name.length - 1] === '/')
                parts.push('');
            if (parts[0] === '/')
                parts[0] = '';
            parts = parts.map(function (part) {
                return encodeIRIComponent(part);
            });
            return parts.join('/');
        }
        IOUtils.encodeIRIPath = encodeIRIPath;
        function encodeIRIComponent(iric) {
            for (var i = 0; i < iric.length && isIRIComponentChar(iric.charCodeAt(i)); i++)
                ;
            if (i === iric.length)
                return iric;
            var parts = [iric.slice(0, i)];
            for (; i < iric.length; i++) {
                if (isIRIComponentChar(iric.charCodeAt(i)))
                    parts.push(iric[i]);
                else
                    parts.push(encodeURIComponent(iric[i]));
            }
            return parts.join('');
        }
        IOUtils.encodeIRIComponent = encodeIRIComponent;
        function isIRIComponentChar(ch) {
            ch = ch | 0;
            return ch >= 97 && ch <= 122 //a-z
                || ch >= 48 && ch <= 57 //0-9
                || ch >= 65 && ch <= 90 //A-Z
                || ch === 95 //_
                || ch === 45 //-
                || ch === 46 //.
                || ch === 40 //(
                || ch === 41 //)
                || ch === 33 //!
                || ch === 126 //~
                || ch > 127; // 非ASCII字符。TODO 不一定都合法
        }
        IOUtils.isIRIComponentChar = isIRIComponentChar;
        var mimeNormalizingMap = {
            'application/vnd.adobe.flash.movie': 'application/x-shockwave-flash',
            'application/wps-office.doc': 'application/msword',
            'application/wps-office.docx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'application/wps-office.ppt': 'application/vnd.ms-powerpoint',
            'application/wps-office.pptx': 'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
            'application/wps-office.xls': 'application/vnd.ms-excel',
            'application/wps-office.xlsx': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        };
        /**
         * 将 mime 正规化。有些 mime 例如 application/vnd.adobe.flash.movie 是浏览器不支持的，
         * 但是 <input type=file> 可能报告它。
         */
        function normalizeMime(mime) {
            return mimeNormalizingMap[mime] || mime;
        }
        IOUtils.normalizeMime = normalizeMime;
    })(IOUtils = mbe_common.IOUtils || (mbe_common.IOUtils = {}));
})(mbe_common || (mbe_common = {}));
/// <reference path="etb/tools/UrlParams.ts" />
var mbe_config;
(function (mbe_config) {
    mbe_config.version = '2.1';
    // 界面的变体。只对 MasterEditorApp 有效。目前的取值可以是 '' 和 'air'。
    mbe_config.uiType = '';
    mbe_config.onlineHelpUrlPrefix = 'http://oss.aliyuncs.com/public-datas/beikedashi-help/';
    mbe_config.mozUpdateUrl = 'http://beikedashi.myuclass.com/update/updates-%VERSION%.xml';
    mbe_config.mozTestUpdateUrl = 'http://192.168.0.231:8088/beikedashi-test/update/updates-%VERSION%.xml';
    mbe_config.userActionUploadUrl = 'http://ftp.myuclass.com/';
    // 用户数据上报测试服务器
    mbe_config.ftpuserActionUploadUrl = 'http://192.168.0.24/importst-web/';
    // 内部存储器（mbe_common.Storage）对应的实际文件系统目录，如果有的话。
    mbe_config.storageDir = null;
    mbe_config.storageUrl = null; //storage根目录对应的url。最好提供，否则自动生成。
    mbe_config.embed = false;
    // 目录存在表示打开，不存在表示新建
    mbe_config.docDir = null;
    // 导入这个epub档案后打开。如果同时指定了 docDir，则导入到此目录
    mbe_config.archiveFile = null;
    // archiveFile 的路径是相对于 storageDir 的。默认 false，即 archiveFile 应为文件系统绝对路径。
    mbe_config.archiveFileIsRelative = false;
    //export var createNewDoc = false;
    // 新建文档时可指定元数据
    mbe_config.docMetadata = null;
    // 操作中不要弹出对话框
    mbe_config.silent = false;
    // 启用实验特性
    mbe_config.experimental = false;
    // 是否在 Electron 环境
    mbe_config.isElectron = false;
    // 是否在 Mozilla 特权环境 （Firefox 扩展和 XULRunner）
    mbe_config.isMozPrivileged = false;
    // 是否在 XULRunner 环境
    mbe_config.isXULRunner = false;
    // 个人中心隐藏(根据是否设置cookie，目前只有通过备课大师登录才设置为true)
    mbe_config.isShowPersonCenterBtn = false;
    // 命令行参数
    mbe_config.args = [];
    // 导入控件临时目录有效期 单位以天计算 如0.5为12小时 1为一天 默认值为3 测试为1小时
    mbe_config.commonTempTime = 3;
    mbe_config.Mediatype = {
        270: '文档', 271: '图片', 272: '音频', 273: '视频', 274: '动画', 275: '其他'
    };
    mbe_config.Typecontent = {
        317: "试题", 318: "课件", 319: "教案", 320: "素材", 321: "论文", 322: "专题资源",
        323: "说课稿", 324: "挂图", 360: "学案", 361: "其他", 471: "教材解读", 1121: "教学案例",
        1967: "生字教学", 1968: "课文朗读", 1970: "课件配图", 1971: "拓展资料", 1972: "公式定理",
        1973: "写作", 1974: "音视频", 1975: "玲珑画板", 1976: "微课", 1977: "精品配套资源",
        1978: "精品课件", 1979: "备课大师课件", 1980: "拼图", 1981: "趣味匹配"
    };
    mbe_config.Format = {
        doc: "276", docx: "277", htm: "1422", html: "1421", pdf: "280", pdfx: "1352", pps: "288", ppsx: "289",
        ppt: "284", pptx: "285", rtf: "282", txt: "283", vsd: "281", xhtml: "1420", xls: "278", xlsx: "279",
        xml: "286", xpt: "287", bmp: "293", gif: "292", jpeg: "291", jpg: "290", png: "294", tif: "295", flac: "300",
        m4a: "301", mid: "297", mp3: "296", voc: "302", wav: "299", wma: "298", asf: "310", avi: "304", f4v: "308",
        flv: "303", mkv: "305", mov: "312", mp4: "307", mpg: "309", rm: "314", rmvb: "313", webm: "311", wmv: "306",
        swf: "315", dbb: "1350", exe: "316", l3d: "1351"
    };
    mbe_config.FormatMedia = {
        doc: "270", docx: "270", htm: "270", html: "270", pdf: "270", pdfx: "270", pps: "270", ppsx: "270",
        ppt: "270", pptx: "270", rtf: "270", txt: "270", vsd: "270", xhtml: "270", xls: "270", xlsx: "270",
        xml: "270", xpt: "270", upub: "270", bmp: "271", gif: "271", jpeg: "271", jpg: "271", png: "271", tif: "271",
        flac: "272", m4a: "272", mid: "272", mp3: "272", voc: "272", wav: "272", wma: "272", asf: "273",
        avi: "273", f4v: "273", flv: "273", mkv: "273", mov: "273", mp4: "273", mpg: "273", rm: "273",
        rmvb: "273", webm: "273", wmv: "273", swf: "274", dbb: "275", exe: "275", l3d: "275"
    };
    // 根据格式获取格式ID
    function getFromatId(format) {
        return mbe_config.Format[format];
    }
    mbe_config.getFromatId = getFromatId;
    // 根据格式获取mediaID
    function getMediaId(format) {
        return mbe_config.FormatMedia[format];
    }
    mbe_config.getMediaId = getMediaId;
    // 根据格式获取mediaName
    function getMediaName(format) {
        return mbe_config.Mediatype[mbe_config.FormatMedia[format]];
    }
    mbe_config.getMediaName = getMediaName;
    var commonFeedBack = {
        qqLink: 'tencent://message/?Menu=yes&amp;uin=938058459&amp;Service=58&amp;SigT=A7F6FEA02730C988EE427F812F06F8DF4471BDE66FFF0EDA1DA497C0BC68D562549F2422954CA3CEEB7E3EA3DA5C1D274DCA471C7D1A9C80BEEC1CAB60C6B81FD3FEBA20CBD6E6157C5E28F55D33BC7E9B64B3E4526B711DA2E1F3BA54D1E5991124C293615893DBC97EF3B3836A7F9A071B81D57BDE7C86&amp;SigU=30E5D5233A443AB2CAA9E13E5918B0D36A3370B97E9A737F9E0B4426B000C41CA05FAB2665263D62F38E4C3241637C1E1C6C0F234ED86CBCBBA98E44FE3903F3E226AF1C72CBE2CE',
        qqGroupLink: 'tencent://groupwpa/?subcmd=all&param=7B2267726F757055696E223A3533343633373538312C2274696D655374616D70223A313435333739343932307D0A',
        qrCode: 'image/gqqqrc.png',
        tel: '400-898-5166'
    };
    ;
    // 定制版信息表
    var customInfos = Object.freeze({
        __proto__: null,
        // 皖新
        'wanxin': {
            custom: 'wanxin',
            title: 'AI备课',
            company: '安徽新华教育图书发行有限公司',
            feedBack: {
                qqLink: 'tencent://message/?Menu=yes&amp;uin=328745735&amp;',
                qqGroupLink: 'tencent://groupwpa/?subcmd=all&param=7B2267726F757055696E223A3534393330313035392C2274696D655374616D70223A313436363637353332387D0A',
                qrCode: 'image/gqqqrc_wanxin.png',
                tel: '400-995-1080'
            },
            releaseUrl: 'http://beikedashi.myuclass.com/beikedashi-setup.exe '
        },
        // 课件制作工具（从v4授课端单点登录）
        'tool': {
            custom: 'tool',
            title: "课件制作工具",
            company: '明博教育科技股份有限公司',
            feedBack: commonFeedBack
        },
        // 独立版/班班通
        'local': {
            custom: 'local',
            title: "优课智慧教学系统",
            company: '明博教育科技股份有限公司',
            feedBack: commonFeedBack
        },
        // 教研
        'jy': {
            custom: 'jy',
            title: "备课大师",
            company: '明博教育科技股份有限公司',
            feedBack: commonFeedBack
        },
        // 格尔木
        'germu': {
            custom: 'germu',
            title: "中小学多媒体素材库",
            company: '明博教育科技股份有限公司',
            feedBack: commonFeedBack
        },
        // 默认，非定制版
        'default': {
            custom: '',
            title: "备课大师",
            company: '明博教育科技股份有限公司',
            feedBack: commonFeedBack
        }
    });
    /**
     * 获得定制版信息
     * @param custom 定制版标识。空或 'default' 表示非定制版。
     */
    function getCustomInfo(custom) {
        return customInfos[custom] || customInfos['default'];
    }
    mbe_config.getCustomInfo = getCustomInfo;
    /**
     * custom_XXX 是特殊定制版，即超出 getCustomInfo() 覆盖范围的定制版，例如可能改变服务器地址。
     * custom_XXX 也可能搭配 getCustomInfo() 使用。
     * 制作这种定制版时，一般在本地将 false 改为 true 后编译（但不要自动上传ftp服务器）：grunt mozapp zip:beikedashi
     *
     * custom_班班通 的制作方式是特殊的：grunt mozinstallerbanbantong
     *
     * custom_授课系统
     * 此版本为嵌入到授课系统的备课大师 只显示云课件不可编辑课件
     */
    mbe_config.custom_安徽时代 = false;
    mbe_config.custom_浙江考A啦 = false;
    mbe_config.custom_江西新华 = false;
    mbe_config.custom_文轩 = false;
    mbe_config.custom_格尔木 = false;
    mbe_config.custom_文轩智慧星 = false;
    mbe_config.custom_班班通 = false;
    mbe_config.custom_授课系统 = true;
    mbe_config.custom_校园区域版 = false;
    mbe_config.custom_校园精简版 = false;
    mbe_config.custom_长虹 = false;
    mbe_config.custom_淮南 = false;
    mbe_config.custom_军校 = false;
    //校园区域版为原来的资源互通  资源互通成为原来资源互通的一种标识  想具有资源互通的功能 就在下面 ||上你想要的版本
    mbe_config.custom_资源互通 = mbe_config.custom_校园区域版 || mbe_config.custom_校园精简版;
    // 备课大师非编辑版。目前取值可以为'' 和 'noedit'，由 custom_授课系统 决定。TODO 由命令行参数决定。
    mbe_config.editType = mbe_config.custom_授课系统 ? 'noedit' : '';
    /**
     * 禁止更新（包括自动和手动）
     */
    mbe_config.updateDisabled = mbe_config.custom_安徽时代 || mbe_config.custom_资源互通 || mbe_config.custom_浙江考A啦 || mbe_config.custom_江西新华 || mbe_config.custom_文轩 || mbe_config.custom_格尔木 || mbe_config.custom_文轩智慧星 || mbe_config.custom_班班通 || mbe_config.custom_授课系统 || mbe_config.custom_长虹 || mbe_config.custom_淮南 || mbe_config.custom_军校;
    mbe_config.wanxinLinkUrl = false;
    function parseUrlParms() {
        var params = etb_tools.UrlParams.parse(location.search);
        var params1 = etb_tools.UrlParams.parse(location.hash);
        for (var key in params1)
            params[key] = params1[key]; // hash 优先级高于 search
        for (var key in params) {
            var keyTarg = key, value = params[key];
            if (key === 'x')
                keyTarg = 'experimental';
            if (key === 'args') {
                value = value.split(' ').filter(function (s) { return !!s; });
                value.forEach(function (arg) {
                    if (arg === '-x')
                        mbe_config.experimental = true;
                });
            }
            if (typeof mbe_config[keyTarg] === 'function') {
                console.warn('mbe_config:parseUrlHash: invalid key: ' + key);
                continue;
            }
            mbe_config[keyTarg] = value;
        }
    }
    function addConfigClasses() {
        var rcl = document.documentElement.classList;
        if (mbe_config.embed) {
            rcl.add('mbe-embed');
        }
        if (!mbe_config.experimental) {
            rcl.add('mbe-disable-x');
        }
    }
    function uaSniff() {
        // sniff Electron
        if (self['require']) {
            try {
                var remote = require('remote');
                var BrowserWindow = remote.require('browser-window');
                mbe_config.isElectron = !!BrowserWindow;
            }
            catch (e) {
            }
        }
        else if (window['Components'] && window['Components'].utils) {
            mbe_config.isMozPrivileged = true;
            if (navigator.userAgent.indexOf('beikedashi') >= 0)
                mbe_config.isXULRunner = true;
        }
    }
    function moduleInit() {
        parseUrlParms();
        addConfigClasses();
        uaSniff();
    }
    moduleInit();
})(mbe_config || (mbe_config = {}));
/// <reference path="../mbe_config.ts" />
var uclass_services;
(function (uclass_services) {
    // 测试服务器地址
    uclass_services.kTestServerPrefix = "http://192.168.0.230/u3"; // 内网地址：http://192.168.0.230/u3  外网地址：http://123.124.21.163:1235/u3
    uclass_services.kTestServerPrefix231 = "http://192.168.0.231/uclass3.0";
    // 正式服务器地址
    uclass_services.kOfficialServerPrefix = mbe_config.custom_安徽时代 ?
        "http://sdcbv4.myuclass.com:32788/" :
        (mbe_config.custom_军校 ? "http://192.168.0.94" : "http://v3.myuclass.com");
    // 安徽时代资源服务器地址
    uclass_services.kServerPrefixWan = 'http://www.timeep.com/weike/pad';
    uclass_services.kServerPrefix = mbe_config.experimental ? uclass_services.kTestServerPrefix : uclass_services.kOfficialServerPrefix;
    //军校预览图片地址
    uclass_services.KPreviewHost = 'http://192.168.0.90/';
    //思维导图插入图片服务器
    uclass_services.KSwdtHost = 'http://192.168.0.230/';
    //校园精简版获取元数据测试服务器地址
    uclass_services.KJJServerPrefix = "http://192.168.0.245";
    // 教研服务器地址
    // 测试
    uclass_services.kJYTestServerPrefix = "http://123.124.21.163:1234/jy"; // 内网地址：http://192.168.0.38/jy 外网地址：http://123.124.21.163:1234/jy
    // 正式
    uclass_services.kJYOfficialServerPrefix = "http://jy.myuclass.com";
    uclass_services.kJYServerPrefix = mbe_config.experimental ? uclass_services.kJYTestServerPrefix : uclass_services.kJYOfficialServerPrefix;
    // 各类资源的数量，按章节统计
    uclass_services.kPublicationResourceCount = mbe_config.experimental ?
        'http://abcd3.oss.aliyuncs.com/beikedashi/resamount.txt' :
        (mbe_config.custom_安徽时代 ?
            'http://shidai-uclass.oss.aliyuncs.com/beikedashi/resamount.txt' :
            (mbe_config.custom_军校 ? uclass_services.KPreviewHost + 'beikedashi/resamount.txt' : 'http://uclass.oss.aliyuncs.com/beikedashi/resamount.txt'));
    uclass_services.kGerMuCheckUserInfo = "http://218.95.250.231:8085/jcsj/MingboWriteXml.do";
    // export const kGerMuPlatformKeyByUclass = "6bdc4554c21144e79e2b2a88819b5de0";
    uclass_services.kGerMuSecretKey = "680bb3ea4045676e6245808958d51083c7869e01e3a8c804";
    uclass_services.kGerMuPlatformKeyByUclass = "b9a9b16890104734966c415dffa831d9";
    uclass_services.kUclassAppKeyByGerMu = "a143fb1a1d8843d087ba21f6df2315a1";
    uclass_services.kEduYunTicketValidate = "http://211.153.75.8:10000/aamif/ticketValidate";
    uclass_services.kEduYunGetAccessToken = "http://api.eduyun.cn/apigateway/getaccesstoken";
    uclass_services.kEduYunGetUserInfo = "http://api.eduyun.cn/aam/rest/user/getuserinfo";
    uclass_services.kEduYunPlatformKeyByUclass = "e66597b449914094afd02cb79f142fab";
    uclass_services.kEduYunAppKeyByUclass = "2X-P-T-PC-A-YANGGUAN";
    uclass_services.kUclassAppIdByEduYun = "AP000000014144";
    uclass_services.kUclassAppKeyByEduYun = "d064e6401a0f83711c3d55aa3bcc19f8";
    // 课件上传根目录
    uclass_services.kDocUploadRootDir = "docList/";
    // 课件签名地址
    uclass_services.kDocSignatureUrl = uclass_services.kServerPrefix + "/ajaxup/commonSignature.anys?userDir=" + uclass_services.kDocUploadRootDir + "&appCode=bkds";
    // 课件上传地址
    uclass_services.kDocUploadPrefix = mbe_config.experimental ?
        "http://bkds.oss.aliyuncs.com/" :
        (mbe_config.custom_安徽时代 ? "http://shidai-bkds.oss.aliyuncs.com/" :
            "http://mainbo-bkds.oss.aliyuncs.com/");
    // 用于 loginClientById.anys，优课部落等接口
    uclass_services.kUclassDESKey = '1234!@#$';
    // 用于 loginClientById.anys，优课部落等接口
    uclass_services.kUclassMD5Salt = '1QAZ2WSX';
    // 课件发送地址发送至移动授课
    uclass_services.kClassRoomServer = 'http://localhost:7017';
    // 文轩智慧星token
    uclass_services.kWenXuanServerPrefix = mbe_config.experimental ? 'http://171.221.201.253:8088/winshare-web-api/resource/' : 'http://www.jxzyzx.com/winshare-web-api/resource/';
    uclass_services.kWenXuanAccessToken = 'f5f452a0290744b1a98bee7084ba23e5';
    function setUserCookie(data) {
        var items = ['userType=teacher', 'client_agent=window', 'viewSize=small',
            (data ? "JSESSIONID=" + data.body.content.jsessionid : '')];
        var host = new URL(uclass_services.kServerPrefix).host;
        // TODO 跨域设置 cookie 在浏览器上是似乎是没用的
        items.forEach(function (item) { return document.cookie = item + ';domain=' + host; });
    }
    uclass_services.setUserCookie = setUserCookie;
    /**
     * '155' // 江苏凤凰教育出版社
     *
     * '348' // 江苏凤凰科学技术出版社
     *
     * '371' //译林出版社
     *
     * '905' //江苏人民出版社
     *
     * '912' // 江苏凤凰少年儿童出版社
     */
    uclass_services.publishIdOfFH = ['155', '348', '371', '905', '912'];
    function resolveUrl(params) {
        var type = +params.deviceType;
        var url = null;
        switch (type) {
            case 3:
                {
                    var base = new URL(params.ftpHost);
                    base.hostname = (!!params.httpURL ? params.httpURL + '.' : '') + base.hostname;
                    if (params.ftpPort)
                        base.port = '' + params.ftpPort;
                    url = new URL(params.relativeURL || '', base.href).href;
                    break;
                }
            case 1:
                {
                    var base = new URL(params.httpURL, params.ftpHost);
                    if (params.ftpPort)
                        base.port = '' + params.ftpPort;
                    url = new URL(params.relativeURL || '', base.href).href;
                    break;
                }
            case 0:
                {
                    // 凤凰ftp服务器
                    var base = new URL(params.httpURL, 'ftp://' + params.ftpHost);
                    base.username = params['ftpUser'];
                    base.password = params['ftpPWD'];
                    if (params.ftpPort)
                        base.port = '' + params.ftpPort;
                    url = new URL(params.relativeURL || '', base.href).href;
                }
                break;
            default:
                console.error('us:resolveUrl: bad params:', params);
        }
        // console.log('us:resolveUrl:' + url);
        return url;
    }
    uclass_services.resolveUrl = resolveUrl;
    function selectUrl(paramList, sourceType) {
        var params = null;
        if (sourceType && sourceType == '101') {
            params = paramList.filter(function (params) {
                // http
                return params['deviceId'] == '1148';
                // ftp
                // return params['deviceId'] == '1015';
            })[0];
        }
        else {
            params = paramList.filter(function (params) {
                if (mbe_config.custom_安徽时代) {
                    return /shidai-/.test(params.ftpHost) || /shidai-/.test(params.httpURL);
                }
                else if (mbe_config.custom_浙江考A啦) {
                    return true;
                }
                else if (mbe_config.custom_资源互通) {
                    return true;
                }
                else {
                    return /^\w{4,}\.oss\.aliyuncs\.com\//.test(params.httpURL + '.' + params.ftpHost.substr(7));
                }
            })[0];
        }
        return params && resolveUrl(params);
    }
    uclass_services.selectUrl = selectUrl;
})(uclass_services || (uclass_services = {}));
///<reference path='../../html5plus.d.ts'/>
///<reference path='../tools/SVGPen.ts' />
///<reference path="../tools/UrlParams.ts" />
///<reference path="./book.shared.ts"/>
///<reference path="../../../third_party/classroomteacherserver/protocol.d.ts" />
///<reference path="../../../third_party/classroomteacherserver/EventSource.d.ts" />
/// <reference path="../../mbe/common/IOUtils.ts" />
/// <reference path="../../uclass/services.ts" />
/**
 * 用于reader的etb_book模块
 */
var etb_controls;
(function (etb_controls) {
    var a = 1; // TODO 空模块会被编译器认为不存在
})(etb_controls || (etb_controls = {}));
;
var etb_config;
(function (etb_config) {
    //export declare var custom_长虹: boolean;
})(etb_config || (etb_config = {}));
var etb_book;
(function (etb_book) {
    var contentFrame, frameWrapper, scrollPane;
    var pages, map;
    var kDefaultPageMarginV = 16, kDefaultPageMarginH = 16, kDefaultScrollBarWidth = 17;
    var maxPageWidth = 0, maxPageHeight = 0, totalPageHeight = 0;
    var classroomserver = 'http://localhost:7017';
    var scrollX = scrollY = 0;
    var chScrollX = 0;
    var chScrollY = 0;
    var prevFullscreened = false;
    etb_book.scale = 1;
    var iou = mbe_common.IOUtils;
    etb_book.gotoPage = function (pnOrPage) {
        var pn = -1, page = null;
        if (typeof pnOrPage === 'number') {
            pn = pnOrPage;
            page = pages[pn];
        }
        else {
            pn = pages.indexOf(pnOrPage);
            page = pnOrPage;
        }
        if (pn < 0 || !page) {
            console.error('gotoPage: bad param:', pnOrPage);
            return;
        }
        if (Fscreen.isFullScreen() && !Fscreen.isDocFullScreen()) {
            console.warn('gotoPage: have to exit fullscreen first');
            return;
        }
        var pageChanged = currentPageNumber !== pn;
        etb_book.currentPage = page;
        currentPageNumber = pn;
        if (Fscreen.isDocFullScreen()) {
            Fscreen.showSinglePage();
        }
        else {
            scrollY = scrollPane.scrollTop = etb_book.currentPage.getBoundingClientRect().top * etb_book.scale;
            onScrolled(etb_book.currentPage.ownerDocument);
        }
        var fullscreenChanged = prevFullscreened !== Fscreen.isFullScreen();
        postCurrentPage();
        updatePageSelection();
        if ((pageChanged || fullscreenChanged) &&
            etb_book.currentPage.hasAttribute('data-mainbo-animation')) {
            resetAnimation(etb_book.currentPage);
        }
        if (etb_book.currentPage.classList.contains('showMask')) {
            var target = etb_book.currentPage.querySelector('.mainbo-center');
            var targetNext = etb_book.currentPage.nextElementSibling && etb_book.currentPage.nextElementSibling.querySelector('.mainbo-center');
            var targetPrev = etb_book.currentPage.previousElementSibling && etb_book.currentPage.previousElementSibling.querySelector('.mainbo-center');
            etb_book.transformTarget(target);
            if (targetNext) {
                etb_book.gotoPage(currentPageNumber + 1);
            }
            if (targetPrev) {
                etb_book.gotoPage(currentPageNumber - 1);
            }
        }
    };
    /**
     * 隐藏空的弹出盒子
     * @param el 当前页面元素
     */
    var hideBlankLink = function (el) {
        try {
            el.querySelector('.mainbo_link_header').parentNode.style.display = 'none';
        }
        catch (e) {
            console.error(e);
        }
    };
    var extContentStyle = '.mainbo-single-page-mode { height: 100% }' +
        'body {overflow: hidden;}' +
        '.mainbo-single-page-mode body {display: flex; align-items: center; justify-content: center; height: 100%;}' +
        '.mainbo-single-page-mode .etb-pages {flex: 0 0 1; position: relative;}' +
        '.mainbo-single-page-mode .etb-page {position: absolute; margin: 0;}' +
        '.etb-page { transition-property: left, top, opacity; transition-duration: 1s;}' +
        '.cur{left:0;z-Index:0;} .pre{ left:0; z-Index:-1; opacity:0;} .next{ left:0; z-Index:-1; opacity:0;}';
    // 使用非活动的文档作为换出元素的所属文档，并适时调用
    // HTMLMediaElement.load() 是目前释放媒体内存的较好方法。
    var swapDoc;
    // 利用 MO 尽早换出页面。
    // 这对 chrome 帮助不大，因为它基本是在文档解析完以后才发送Mutation事件，但chrome似乎延迟加载其他资源。
    // 这对 firefox 帮助较大，firefox 会较早发送Mutation事件，也会较早加载其他资源。
    var observer;
    var observingEtbPages = false;
    var currentPageNumber;
    function moduleInit() {
        var params = etb_tools.UrlParams.parse(location.search);
        for (var key in params)
            etb_config[key] = params[key];
        if (!etb_config.docUrl) {
            window.addEventListener("DOMContentLoaded", init0);
            if (window.MutationObserver) {
                observer = new window.MutationObserver(mutHandler);
                observer.observe(document, { childList: true, subtree: true });
            }
        }
        else {
            window.addEventListener("load", readExternalDoc);
        }
        swapDoc = document.implementation.createDocument('http://www.w3.org/1999/xhtml', 'html', null);
        window.onresize = reLayoutFrame;
        console.log('moduleInit');
    }
    moduleInit();
    function mutHandler(muts) {
        console.log('mutHandler:' + muts.length);
        for (var i = 0; i < muts.length; i++) {
            var adds = muts[i].addedNodes;
            if (!adds)
                continue;
            var targetToChange;
            for (var j = 0; j < adds.length; j++) {
                var el = adds[j];
                //console.log(el.nodeName);
                if (!el.classList) {
                    continue;
                }
                else if (el.classList.contains('etb-page')) {
                    console.log('mutHandler:etb-page');
                    // TODO firefox 31 可能会漏掉 etb-pages，所以在这里做补偿。
                    if (!observingEtbPages) {
                        targetToChange = el.parentNode;
                        observingEtbPages = true;
                    }
                    var prev = el.previousElementSibling;
                    if (prev && prev.classList.contains('etb-page'))
                        swapOut(prev);
                }
                else if (el.classList.contains('etb-pages')) {
                    console.log('mutHandler:etb-pages');
                    targetToChange = el;
                }
                //console.log('class='+el.getAttribute('class'));
            }
        }
        if (targetToChange) {
            console.log('mutHandler:targetToChange');
            observer.disconnect();
            observer.observe(targetToChange, { childList: true });
            observingEtbPages = true;
        }
    }
    function toArray(list) {
        return Array.prototype.slice.call(list, 0);
    }
    function init0() {
        console.log('begin init0');
        observer && observer.disconnect();
        observer = null;
        createContentFrame(document);
        console.log('end init0');
    }
    function init1(content) {
        console.log('begin init1');
        if (window['StyleFix']) {
            StyleFix.process(content);
            StyleFix.process(document);
        }
        //initSignalMap(doc);
        //处理有动画时 弹出or音乐播放or视频播放，点击控件，执行动画的问题 TODO？是否会存在其他未知的问题？
        //Array.prototype.forEach.call(content.querySelectorAll('[data-control]'), (item, index) => {
        //  if (item.localName == 'audio' || item.localName == 'video') {
        //    (<HTMLElement>item).addEventListener('click', dataControlStopPropagation);
        //  }
        //});
        etb_book.enableControlConnection(content, true);
        content.addEventListener('click', etb_book.mediaClicked);
        initMenu();
        onScrolled(content);
        scrollPane.addEventListener('scroll', onScroll);
        Fscreen.launchFullScreen(); // 除了 FF 特权模式以外毫无作用，看来浏览器中只有用户操作能发起全屏。TODO
        setTimeout(checkFullScreen, 300);
        initEventSource(content);
        console.log('end init1');
    }
    function checkFullScreen() {
        if (!Fscreen.isFullScreen()) {
            tipDialog('为保证课件播放效果，请全屏播放课件！');
        }
    }
    function tipDialog(msg, type) {
        var html = '<div class="mbe-dialog-tip" id="mbe-dialog-tip1">'
            + '<div>' + msg + '</div>' +
            '<div class="footer"><button class="tip-fullScreen">确定</button><button class="tip-cancel">取消</button></div></div>';
        document.body.insertAdjacentHTML('afterbegin', html);
        var tip = document.querySelector("#mbe-dialog-tip1"), tip_fullScreen = tip.querySelector(".tip-fullScreen"), tip_cancel = tip.querySelector(".tip-cancel");
        tip.style.marginLeft = '-' + tip.getBoundingClientRect().width / 2 + 'px';
        tip_fullScreen.addEventListener('click', function () {
            Fscreen.launchFullScreen();
            document.body.removeChild(tip);
        });
        tip_cancel.addEventListener('click', function () {
            document.body.removeChild(tip);
        });
        var isHidden = false;
        if (type == 'toast')
            isHidden = true;
        if (isHidden) {
            tip_cancel.setAttribute('hidden', 'hidden');
            tip_fullScreen.setAttribute('hidden', 'hidden');
            tip.style.bottom = '50%';
            tip.style.marginTop = tip.getBoundingClientRect().height / 2 + 'px';
        }
        setTimeout(function () { if (document.querySelector("#mbe-dialog-tip1")) {
            document.body.removeChild(tip);
        } }, 5000);
    }
    function dataControlStopPropagation(ev) {
        ev.stopPropagation();
    }
    function readExternalDoc() {
        var docUrl = etb_config.docUrl;
        console.log('readExternalDoc:' + docUrl);
        var xhr = new XMLHttpRequest();
        try {
            xhr.open('GET', docUrl);
            xhr.responseType = 'document';
            xhr.send();
        }
        catch (e) {
            fallback(e, 'open/send');
        }
        xhr.onload = function () {
            var st = xhr.status;
            if (st >= 200 && st < 300 || st === 304 || st === 0) {
                createMapPages(xhr.response);
                createContentFrame(xhr.response);
            }
            else {
                fallback(new Error('XHR status:' + st), 'http-' + st);
            }
        };
        xhr.onerror = function (err) {
            fallback(err, 'network');
        };
        function fallback(err, stage) {
            if (stage === void 0) { stage = ''; }
            console.error('readExternalDoc:error:' + stage + ':url=' + docUrl, err);
            if (!etb_config.noRedirection) {
                console.warn('readExternalDoc:redirect:' + docUrl);
                location.href = docUrl;
            }
            else {
                document.body.innerHTML = "<p>加载失败：" + docUrl + "</p>";
            }
        }
    }
    function createContentFrame(content) {
        if (content != document)
            document.body.innerHTML = '';
        contentFrame = document.createElement('iframe');
        contentFrame.allowFullscreen = true;
        updateAllowFullscreenOfContentFrame();
        // 此处不使用 about:blank 的理由是：（1）FF 上 about:blank 不能继承 chrome 的特权（2）是 quirks 模式（3）是 html 而不是 xhtml
        // 用 srcdoc 可以解决2，但不能解决1和3；IE/Edge14- 也不支持；
        // 用 data: 在firefox上可以解决1-3，但在Chrome上与父文档不同源；
        // 用 blob-url 在Firefox、Chrome上可以解决1-3，但 IE/Edge14- 不支持 iframe 使用 blob-url。可能的原因：https://developer.microsoft.com/en-us/microsoft-edge/platform/issues/7754905/
        // 用 javascript: 可以解决2，但不能解决1和3；所有浏览器都支持。
        // 决定暂时用 javascript 协议，以后考虑用 blob-url 和 xhtml。
        // blob-url 的途径：
        // const frameSrc = '<html xmlns="http://www.w3.org/1999/xhtml" \
        //   xmlns:xlink=\"http://www.w3.org/1999/xlink\"><head></head><body></body></html>';
        // const frameUrl = URL.createObjectURL(new Blob([frameSrc], {type: 'application/xhtml+xml'}), {oneTimeOnly: true});
        // contentFrame.src = frameUrl;
        // FF 上 javascript-url 不能继承 chrome 的特权，但 data-url 可以。
        contentFrame.src = location.protocol === 'chrome:' ?
            'data:text/html,<!DOCTYPE%20html><body></body>' :
            "javascript:'<!DOCTYPE%20html><body></body>'";
        frameWrapper = document.createElement('div');
        frameWrapper.className = 'mainbo-frame-wrapper';
        frameWrapper.appendChild(contentFrame);
        scrollPane = document.createElement('div');
        scrollPane.className = 'mainbo-scroll-pane';
        scrollPane.appendChild(frameWrapper);
        document.body.appendChild(scrollPane);
        if (contentFrame.contentDocument && contentFrame.contentDocument.readyState === 'complete') {
            processContentDoc(content, contentFrame.contentDocument);
        }
        else {
            contentFrame.onload = function () { return processContentDoc(content, contentFrame.contentDocument); };
        }
    }
    /**
     * 基于 chromium （至少40-54）的浏览器有个与全屏相关的bug：
     * 如果 iframe 内的文档中有 video，如果 iframe 或其祖先元素进入全屏，再让 video 进入全屏，则退出全屏后，排版会乱掉；
     * 在 crosswalk android 上，video 进入全屏后将无法退出。
     *
     * bug：
     * https://bugs.chromium.org/p/chromium/issues/detail?id=643131
     * 可能相关的：
     * https://bugs.chromium.org/p/chromium/issues/detail?id=640484
     *
     * 此方法用于绕开此bug：当 iframe 或其祖先元素进入全屏时，则不允许 iframe 内的元素全屏。
     * 由于不确定此 bug 影响的版本范围，所以要求受影响的浏览器（目前主要是 crosswalk android）自行声明全局变量
     * chromium_iframe_video_fullscreen_bug 。普通浏览器可以通过刷新页面来从这个错误中退出。
     */
    function updateAllowFullscreenOfContentFrame() {
        self['chromium_iframe_video_fullscreen_bug'] = true;
        if (self['chromium_iframe_video_fullscreen_bug']) {
            if (Fscreen.isDocFullScreen()) {
                contentFrame.allowFullscreen = false;
            }
            else {
                contentFrame.allowFullscreen = true;
            }
        }
    }
    function processContentDoc(content, frameDoc) {
        contentFrame.onload = null;
        var reader = document;
        var base = frameDoc.createElement('base');
        base.href = content.URL;
        frameDoc.head.appendChild(base);
        var resQuery = 'head>*, script, link[rel=stylesheet], style';
        var resContent = toArray(content.querySelectorAll(resQuery));
        if (etb_config.stripCodes) {
            resContent = resContent.filter(function (el) { return el.localName !== 'script' &&
                !/(^|\/)controls\//.test(el['href']) && !el.hasAttribute('data-href'); }); //data-href 是 prefixfree 生成的
        }
        ;
        var resReader = reader === content ? [] : toArray(reader.querySelectorAll(resQuery));
        var res = resContent.concat(resReader);
        var resCount = 0;
        res.forEach(function (el) {
            var src = el['src'] || el['href'] || el.getAttribute('data-href');
            if (el.localName === 'script') {
                if (!src)
                    return;
                var dests = [];
                if (!reader.contains(el) && !/(^|\/)book\.js$/.test(src))
                    dests.push(reader);
                if (/(^|\/)(hand|trueclick|mfrac)\.js$/.test(src))
                    dests.push(frameDoc);
                dests.forEach(function (dest) {
                    // 直接插入来自别的文档的 script 元素似乎无法执行，只好在本文档上创建
                    var script = dest.createElement('script');
                    script.src = src;
                    dest.head.appendChild(script);
                    ++resCount;
                    script.onload = script.onerror = onResLoad;
                });
            }
            else if (el.localName === 'link' || el.localName === 'style') {
                if (/(^|\/)reader\.css$/.test(src)) {
                    if (!reader.contains(el))
                        reader.head.appendChild(el);
                }
                else {
                    if (src)
                        el['href'] = src;
                    // data-inprogress 是 prefixfree 添加的，表示正在处理的 link
                    if (el.hasAttribute('data-inprogress'))
                        el.removeAttribute('data-inprogress');
                    frameDoc.head.appendChild(el);
                }
            }
            else if (!reader.contains(el)) {
                if (el.localName === 'title') {
                    reader.querySelector('title').textContent = el.textContent;
                }
                else {
                    reader.head.appendChild(el);
                }
            }
        });
        var ste = frameDoc.createElement('style');
        ste.textContent = extContentStyle;
        frameDoc.head.appendChild(ste);
        var pgContaner = content.querySelector('.etb-pages');
        // 通常 adoptNode 并不是必需的，但在 Firefox chrome-url 的文档中，如果不调用 adoptNode，先修改某元素
        //（这里是 .etb-page）的 style，再将其转移到新文档中，则该元素的 background-image （如果采用相对url）可能不生效。
        // TODO 跟踪 bug
        frameDoc.adoptNode(pgContaner);
        pages = toArray(pgContaner.children);
        pages.forEach(function (page) {
            swapOut(page);
            page.style.margin = ''; // 清除可能意外添加的 margin。TODO 清理编辑器代码。
        });
        frameDoc.body.appendChild(pgContaner);
        calcPageSize();
        if (content !== reader) {
            var outline = content.querySelector('.etb-outline');
            if (outline)
                reader.body.appendChild(outline);
        }
        reLayoutFrame();
        if (resCount === 0) {
            finish();
            return;
        }
        var finishTimer = setTimeout(finish, 3000);
        function onResLoad() {
            this.onload = this.onerror = null;
            --resCount;
            console.log('onResLoad:' + resCount);
            if (resCount === 0)
                finish();
        }
        function finish() {
            clearTimeout(finishTimer);
            init1(frameDoc);
            var hash = location.hash;
            if (hash.length > 1) {
                var page = frameDoc.querySelector(hash);
                if (page)
                    etb_book.gotoPage(page);
            }
        }
    }
    function calcPageSize() {
        pages.forEach(function (page) {
            page['etbScale'] = 1; // TODO 去掉
            maxPageWidth = Math.max(maxPageWidth, parseFloat(page.style.width) || etb_book.kDefaultPageWidth);
            var ph = parseFloat(page.style.height) || etb_book.kDefaultPageHeight;
            maxPageHeight = Math.max(maxPageHeight, ph);
            totalPageHeight += ph;
        });
    }
    function reloadMedias(node) {
        var medias = node.querySelectorAll('video, audio');
        for (var i = 0; i < medias.length; i++)
            medias[i].load();
    }
    function swapOut(p) {
        if (p.etbrSwap)
            return false;
        console.log('do swapOut');
        var swap = swapDoc.createDocumentFragment();
        while (p.firstChild)
            swap.appendChild(p.firstChild);
        reloadMedias(swap); //故意引发错误，导致释放内存。
        p.etbrSwap = swap;
        return true;
    }
    function swapIn(p) {
        if (!p.etbrSwap)
            return false;
        p.appendChild(p.etbrSwap);
        delete p.etbrSwap;
        initPage(p);
        reloadMedias(p); //不可缺少，因为已经出错的媒体不一定会自动重新加载，甚至可能变得不可见。
        return true;
    }
    function initPage(page) {
        if (page.etbrInit)
            return false;
        etb_book.resetPopups(page, true);
        initControls(page);
        page.etbrInit = true;
        return false;
    }
    function reLayoutFrame() {
        if (!pages)
            return;
        var singlePage = Fscreen.isDocFullScreen();
        var contentWidth = etb_book.scale * (singlePage ? maxPageWidth : maxPageWidth + 2 * kDefaultPageMarginH);
        var contentHeight = etb_book.scale * (singlePage ? maxPageHeight :
            totalPageHeight + (pages.length + 1) * kDefaultPageMarginV + 2); // 2 是 etb-pages 的 padding
        var frameWidth = (innerHeight < contentHeight || innerWidth < contentWidth) ?
            Math.max(contentWidth, innerWidth - kDefaultScrollBarWidth / devicePixelRatio) : innerWidth;
        var frameHeight = Math.max(innerHeight, contentHeight);
        frameWrapper.style.width = frameWidth + 'px';
        frameWrapper.style.height = frameHeight + 'px';
        contentFrame.style.width = frameWidth / etb_book.scale + 'px';
        contentFrame.style.height = frameHeight / etb_book.scale + 'px';
        contentFrame.style.transform = contentFrame.style.webkitTransform = 'scale(' + etb_book.scale + ')';
        scrollX = scrollPane.scrollLeft;
        scrollY = scrollPane.scrollTop;
    }
    function clockFrame(sX, sY) {
        scrollPane.scrollLeft = sX * (scrollPane.scrollWidth - scrollPane.offsetWidth);
        scrollPane.scrollTop = sY * (scrollPane.scrollHeight - scrollPane.offsetHeight);
    }
    function onScrolled(doc) {
        //console.log('onScrolled');
        if (Fscreen.isFullScreen()) {
            console.warn('onScrolled called when fullscreened, abort.');
            return;
        }
        var curr = null, cpn = -1;
        for (var i = 0; i < pages.length; i++) {
            var p = pages[i];
            if (elemCenterInViewport(p)) {
                swapIn(p);
                if (!curr) {
                    curr = p;
                    cpn = i;
                }
            }
            else {
                swapOut(p);
            }
        }
        etb_book.currentPage = curr;
        currentPageNumber = cpn;
        console.log('onScrolled:currentPageNumber:' + currentPageNumber);
        postCurrentPage();
        updatePageSelection();
        hideBlankLink(curr);
    }
    var scrollTimer = null;
    function onScroll(ev) {
        // TODO 防止触摸屏上绘画时滚动。目前 Firefox windows (45) 还不支持 Touch，所以需要这样处理。
        // 支持 Touch 事件的 UA 其实不需要这样做，只要在 touchstart 时 preventDefault() 即可，SVGPen 已经处理。
        if (svgPen.isDrawing) {
            scrollPane.scrollLeft = scrollX;
            scrollPane.scrollTop = scrollY;
            return;
        }
        //console.log('onScroll');
        if (scrollTimer !== null)
            clearTimeout(scrollTimer);
        scrollTimer = setTimeout(onScrolled, 300, ev.target);
    }
    // 从 contentFrame 内的坐标 xi 转换到主文档的坐标。frameX0 是 contentFrame 的左上角在主文档内的坐标。
    function toOuterX(xi, frameX0) {
        return xi * etb_book.scale + frameX0;
    }
    function elemCenterInViewport(el) {
        var fRect = contentFrame.getBoundingClientRect();
        var rect = el.getBoundingClientRect();
        var left = toOuterX(rect.left, fRect.left), right = toOuterX(rect.right, fRect.left), top = toOuterX(rect.top, fRect.top), bottom = toOuterX(rect.bottom, fRect.top);
        var ecx = (left + right) / 2;
        var ecy = (top + bottom) / 2;
        var vcx = innerWidth / 2;
        var vcy = innerHeight / 2;
        return ecx > 0 && ecy > 0 && ecx < innerWidth && ecy < innerHeight ||
            vcx > left && vcx < right && vcy > top && vcy < bottom;
    }
    function getControlOf(el) {
        var ctrName = el.getAttribute('data-control');
        if (ctrName === '')
            return etb_controls[el.localName];
        else
            return etb_controls[ctrName];
    }
    function initControls(elemsOrDoc) {
        var nodes = elemsOrDoc.nodeType ? elemsOrDoc.querySelectorAll('[data-control]') : elemsOrDoc;
        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            var ctr = getControlOf(node);
            if (ctr) {
                try {
                    ctr.init(node);
                }
                catch (e) {
                    console.warn(e);
                }
            }
            //addBuildInSignal(node); //TODO: rewirte
        }
    }
    // getAncestors 和 isEditing 是供 book.shared.ts 调用
    function getAncestors(node, filter) {
        var ret = [];
        var docType = Node.DOCUMENT_NODE;
        for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
            try {
                if (filter && filter(cur))
                    ret.push(cur);
            }
            catch (e) {
                console.warn(e.stack || e);
            }
        }
        return ret;
    }
    etb_book.getAncestors = getAncestors;
    function isEditing(contenxt) { return false; }
    etb_book.isEditing = isEditing;
    var Fscreen;
    (function (Fscreen) {
        function fullscreenElement() {
            return document.fullscreenElement || document.mozFullScreenElement || document.webkitFullscreenElement;
        }
        Fscreen.fullscreenElement = fullscreenElement;
        function isFullScreen() {
            return !!fullscreenElement();
        }
        Fscreen.isFullScreen = isFullScreen;
        function isDocFullScreen() {
            return fullscreenElement() === document.body;
        }
        Fscreen.isDocFullScreen = isDocFullScreen;
        function launchFullScreen() {
            var element = document.body;
            var requestFullscreen = element.requestFullscreen
                || element.mozRequestFullScreen
                || element.webkitRequestFullScreen;
            requestFullscreen.call(element, Element['ALLOW_KEYBOARD_INPUT']);
        }
        Fscreen.launchFullScreen = launchFullScreen;
        function cancelFullscreen() {
            var doc = document;
            var exitFullscreen = doc.exitFullscreen
                || doc.mozCancelFullScreen
                || doc.webkitCancelFullScreen;
            exitFullscreen.call(doc);
        }
        Fscreen.cancelFullscreen = cancelFullscreen;
        function updateFullscreenButton() {
            var btn = document.getElementsByClassName('etb-full')[0];
            var fclass = 'etb-full-attr';
            if (isFullScreen()) {
                btn.classList.add(fclass);
                btn['title'] = btn.dataset['normal'];
            }
            else {
                btn.classList.remove(fclass);
                btn['title'] = btn.dataset['full'];
            }
        }
        Fscreen.updateFullscreenButton = updateFullscreenButton;
        // 单页模式下显示当前 etb-page
        function showSinglePage() {
            pages.forEach(function (e, i) {
                if (i < currentPageNumber) {
                    e.addEventListener('webkitTransitionEnd '
                        + 'transitionend '
                        + 'msTransitionEnd '
                        + 'oTransitionEnd ', function () {
                        swapOut(e);
                    });
                    e.classList.remove("cur");
                    e.classList.remove("next");
                    e.classList.add("pre");
                }
                else if (i > currentPageNumber) {
                    e.addEventListener('webkitTransitionEnd '
                        + 'transitionend '
                        + 'msTransitionEnd '
                        + 'oTransitionEnd ', function () {
                        swapOut(e);
                    });
                    e.classList.remove("cur");
                    e.classList.remove("pre");
                    e.classList.add("next");
                }
                else {
                    swapIn(e);
                    e.classList.remove("next");
                    e.classList.remove("pre");
                    e.classList.add("cur");
                }
            });
            // 让 etb-pages 和 currentPage 水平和垂直居中
            var pst = etb_book.currentPage.parentElement.style;
            pst.width = etb_book.currentPage.offsetWidth + 'px';
            pst.height = etb_book.currentPage.offsetHeight + 'px';
        }
        Fscreen.showSinglePage = showSinglePage;
        function scaleToScreen() {
            contentFrame.contentDocument.documentElement.classList.add('mainbo-single-page-mode');
            etb_book.scale = Math.min(innerWidth / maxPageWidth, innerHeight / maxPageHeight);
            reLayoutFrame();
        }
        Fscreen.scaleToScreen = scaleToScreen;
        function restoreScale() {
            contentFrame.contentDocument.documentElement.classList.remove('mainbo-single-page-mode');
            etb_book.scale = 1;
            if (pages[0]) {
                pages[0].parentElement.style.width = '';
                pages[0].parentElement.style.height = '';
            }
            pages.forEach(function (e) { return e.classList.remove("cur", "pre", "next"); });
            reLayoutFrame();
        }
        Fscreen.restoreScale = restoreScale;
    })(Fscreen || (Fscreen = {}));
    var svgPen;
    function postCurrentPage() {
        if (window.opener) {
            try {
                window.opener.postMessage(pages.indexOf(etb_book.currentPage), '/');
            }
            catch (e) {
                console.log('postmessage >>>> ', e);
            }
        }
    }
    function updatePageSelection() {
        //更新当前幻灯片的值到 select 元素的值
        document.getElementsByClassName("etb-page-select")[0]
            .selectedIndex = currentPageNumber;
    }
    function resetAnimation(page) {
        var ctrs = toArray(page.children).filter(function (item) {
            return item.hasAttribute('data-control');
        });
        for (var i = 1; i < ctrs.length; i++) {
            if (Fscreen.isFullScreen()) {
                ctrs[i].classList.add('mainbo-hidden');
            }
            else {
                ctrs[i].classList.remove('mainbo-hidden');
            }
        }
    }
    etb_book.resetAnimation = resetAnimation;
    function showMenu(show, x) {
        //console.log('showMenu', show);
        var menu = document.getElementsByClassName("etb-menu")[0];
        var turnpage = document.getElementsByClassName("etb-turnpage")[0];
        if (show === menu.classList.contains('show'))
            return;
        menu.classList.toggle('show');
        if (menu.classList.contains('show')) {
            turnpage.classList.remove('show');
        }
        else {
            turnpage.classList.add('show');
        }
        if (show) {
            var curX = menu.offsetLeft, width = menu.offsetWidth;
            // 尽量保持在上一次显示的位置
            if (x >= curX && x < curX + width)
                return;
            var left = x - width / 2;
            left = Math.min(left, document.documentElement.clientWidth - width);
            left = Math.max(left, 0);
            menu.style.left = left + 'px';
        }
    }
    function toggleMenu(ev) {
        console.log('toggleMenu');
        showMenu(!document.getElementsByClassName("etb-menu")[0].classList.contains('show'), ev.clientX);
    }
    function getOutline() { return document.getElementsByClassName("etb-outline")[0]; }
    function showOutline(show) {
        var ol = getOutline();
        if (!ol)
            return;
        if (show) {
            ol.classList.remove('hidden');
            ol.classList.add('shown');
        }
        else {
            ol.classList.remove('shown');
            ol.classList.add('hidden');
        }
    }
    function toggleOutline() {
        var ol = getOutline();
        if (!ol)
            return;
        showOutline(!ol.classList.contains('shown'));
    }
    function triggerOutline(a) {
        var href = a.getAttribute('href') || '';
        var pos = href.lastIndexOf('#');
        if (pos < 0)
            return;
        var id = href.slice(pos + 1);
        var targ = contentFrame.contentDocument.getElementById(id);
        etb_book.gotoPage(targ);
    }
    function eventInThirdParty(evTarget, widget) {
        var ans = getAncestors(evTarget, function (e) {
            return e.hasAttribute('data-control') || e === widget;
        });
        return !ans.length;
    }
    function createMapPages(content) {
        if (!content.querySelector('.etb-pages > [data-mapname]') && !content.querySelector('.etb-pages > * > [data-mapname]')) {
            return map = null;
        }
        var mapPages = toArray(content.querySelector('.etb-pages').children);
        var etbMapNavigator = document.createElement('div');
        var etbMapPages = document.createElement('div');
        var mapLineLeft = document.createElement('div');
        var mapTitle = document.createElement('div');
        var mapMask = document.createElement('div');
        etbMapNavigator.classList.add('etb-map-navigator');
        etbMapPages.classList.add('etb-map-pages');
        mapLineLeft.classList.add('map-lineLeft');
        mapTitle.classList.add('map-title');
        mapMask.classList.add('map-mask');
        mapTitle.textContent = content.querySelector('title').textContent;
        etbMapPages.appendChild(mapLineLeft);
        etbMapNavigator.appendChild(mapTitle);
        etbMapNavigator.appendChild(etbMapPages);
        etbMapNavigator.appendChild(mapMask);
        mapPages.forEach(function (page, i) {
            var etbMapPage = document.createElement('div');
            var etbPageTitle = document.createElement('div');
            var etbPageContent = document.createElement('ul');
            var ctls = Array.prototype.slice.call(page.children, 0).filter(function (child) {
                child.setAttribute('title', child.getAttribute('data-mapname') || '');
                if (child.getAttribute('data-control') == 'simpleicon') {
                    child.setAttribute('title', child.nextElementSibling.getAttribute('data-mapname') || '');
                    child.removeAttribute('data-mapname');
                }
                return (child.getAttribute('data-control') != 'mainbo_textcomment') && child.hasAttribute('data-mapname');
            });
            etbMapPage.classList.add('etb-map-page');
            etbPageTitle.classList.add('etb-map-title');
            etbPageContent.classList.add('etb-map-content');
            etbMapPage.addEventListener('click', function (ev) {
                etb_book.gotoPage(i);
                toArray(document.querySelectorAll('.etb-map-title')).forEach(function (title, i) {
                    title.style.color = '';
                    if (pages.indexOf(page) == i) {
                        title.style.color = '#ef8f13';
                    }
                });
            });
            etbPageTitle.textContent = page.getAttribute('data-mapname') || '第' + (i + 1) + '页';
            toArray(ctls).forEach(function (ctl, j) {
                var li = document.createElement('li');
                var timer, timerOut;
                ctl.getAttribute('data-mainbo-connection-src') && ctl.setAttribute('data-mapname', ctl.nextElementSibling.getAttribute('data-mapname'));
                li.textContent = j + 1 + '.' + (ctl.getAttribute('data-mapname') || '未命名');
                li.addEventListener('click', function (ev) {
                    ev.stopPropagation();
                    etb_book.gotoPage(i);
                    toArray(document.querySelectorAll('.etb-map-title')).forEach(function (title, i) {
                        title.style.color = '';
                        if (pages.indexOf(page) == i) {
                            title.style.color = '#ef8f13';
                        }
                    });
                    var ctls = Array.prototype.slice.call(page.children, 0).filter(function (child) {
                        return (child.getAttribute('data-control') != 'mainbo_textcomment') && child.hasAttribute('data-mapname');
                    });
                    var targ = ev.target;
                    var ctl = ctls[j];
                    var ctlPreve = ctls[j].previousElementSibling;
                    // etb_book.triggerMapConnection(ctls[j], ev); // 弹出项
                    if (page.querySelector('[data-control="maptipebg"]') && targ.style.color)
                        return;
                    clearTimeout(timerOut);
                    timerOut = setTimeout(function () {
                        var ctlbg = document.createElement('div');
                        var leftTop = document.createElement('div');
                        var leftBottom = document.createElement('div');
                        var rightTop = document.createElement('div');
                        var rightBottom = document.createElement('div');
                        leftTop.classList.add('left-top');
                        leftBottom.classList.add('left-bottom');
                        rightTop.classList.add('right-top');
                        rightBottom.classList.add('right-bottom');
                        ctlbg.appendChild(leftTop);
                        ctlbg.appendChild(leftBottom);
                        ctlbg.appendChild(rightTop);
                        ctlbg.appendChild(rightBottom);
                        clearTimeout(timer);
                        ctlbg.style.backgroundColor = 'transparent';
                        ctlbg.style.border = '2px dashed #ef8f13';
                        ctlbg.style.pointerEvents = 'none';
                        ctlbg.setAttribute('data-control', 'maptipebg');
                        toArray(etbMapPages.querySelectorAll('li')).forEach(function (li) {
                            li.style.color = '';
                        });
                        if (ctlPreve && ctlPreve.getAttribute('data-control') == 'simpleicon') {
                            ctl = ctlPreve;
                        }
                        targ.style.color = '#ef8f13';
                        var ctlRect = ctl.getBoundingClientRect();
                        ctlbg.style.width = (ctlRect.width + 10) + 'px';
                        ctlbg.style.height = (ctlRect.height + 10) + 'px';
                        ctlbg.style.left = parseFloat(ctl.style.left) - 7 + 'px';
                        ctlbg.style.top = parseFloat(ctl.style.top) - 7 + 'px';
                        if (page.querySelector('[data-control="maptipebg"]')) {
                            page.removeChild(page.querySelector('[data-control="maptipebg"]'));
                        }
                        page.insertBefore(ctlbg, ctls[j]);
                        timer = setTimeout(function () {
                            targ.style.color = '';
                            if (page.querySelector('[data-control="maptipebg"]')) {
                                page.removeChild(page.querySelector('[data-control="maptipebg"]'));
                            }
                        }, 5000);
                    }, 100);
                });
                etbPageContent.appendChild(li);
            });
            etbMapPage.appendChild(etbPageTitle);
            etbMapPage.appendChild(etbPageContent);
            etbMapPages.appendChild(etbMapPage);
        });
        map = etbMapNavigator;
    }
    function initMenu() {
        insertMenutHtml();
        // 鼠标位于底部此区域时调出菜单
        var kMenuSensitiveHeight = 30;
        var etbFull = document.getElementsByClassName("etb-full")[0], etbMenu = document.getElementsByClassName("etb-menu")[0], eSelect = document.getElementsByClassName("etb-page-select")[0], etbPage = document.getElementsByClassName("etb-page"), etbSendPage = document.getElementsByClassName('etb-sendPage')[0], etbOutline = getOutline(), fullscreenchange = "onwebkitfullscreenchange" in document ? "webkitfullscreenchange" :
            "onmozfullscreenchange" in document ? "mozfullscreenchange" : "fullscreenchange";
        Fscreen.updateFullscreenButton();
        var isNotEdit = etb_config.editType == 'noedit';
        etbSendPage.style.display = isNotEdit && window.opener ? '' : 'none';
        document.getElementsByClassName('etb-SvgPenDraw')[0].style.display = isNotEdit ? 'none' : '';
        document.getElementsByClassName('etb-SvgPenRemoveAll')[0].style.display = isNotEdit ? 'none' : '';
        if (mbe_config.custom_长虹) {
            document.getElementsByClassName('etb-SvgPenDraw')[0].style.display = 'none';
            document.getElementsByClassName('etb-SvgPenRemoveAll')[0].style.display = 'none';
            etbSendPage.style.display = 'none';
        }
        if (etbOutline)
            etbOutline.classList.add('hidden');
        etbMenu.querySelector('.etb-page-count').textContent = ' / ' + pages.length;
        //添加select下的option;
        addOptions();
        function addOptions() {
            for (var i = 0; i < pages.length; i++) {
                eSelect.add(new Option((i + 1) + '', i + ''));
            }
        }
        function prev() {
            endMediaOfPage(currentPageNumber);
            etb_book.gotoPage(currentPageNumber - 1 < 0 ? 0 : currentPageNumber - 1);
            var data = {
                type: 'Presenter',
                changed: 'page',
                currentPage: (currentPageNumber + 1) <= 1 ? 1 : currentPageNumber + 1
            };
            var pp = mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(data), 'text/plain');
            pp.then(function (data) {
                console.log(data);
            }, function (err) {
                console.warn(err);
            });
        }
        function next() {
            endMediaOfPage(currentPageNumber);
            etb_book.gotoPage((currentPageNumber + 1) > pages.length - 1 ? pages.length - 1 : currentPageNumber + 1);
            var data = {
                type: 'Presenter',
                changed: 'page',
                currentPage: (currentPageNumber + 1) >= pages.length ? pages.length : currentPageNumber + 1
            };
            var pp = mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(data), 'text/plain');
            pp.then(function (data) {
                console.log(data);
            }, function (err) {
                console.warn(err);
            });
        }
        function zoomMinus() {
            etb_book.scale = etb_book.scale - 0.2 < 0.3 ? 0.3 : etb_book.scale - 0.2;
            var sX = scrollPane.scrollLeft / (scrollPane.scrollWidth - scrollPane.offsetWidth);
            var sY = scrollPane.scrollTop / (scrollPane.scrollHeight - scrollPane.offsetHeight);
            reLayoutFrame();
            clockFrame(sX, sY);
        }
        function zoomPlus() {
            etb_book.scale = etb_book.scale + 0.2 > 3 ? 3 : etb_book.scale + 0.2;
            var sX = scrollPane.scrollLeft / (scrollPane.scrollWidth - scrollPane.offsetWidth);
            var sY = scrollPane.scrollTop / (scrollPane.scrollHeight - scrollPane.offsetHeight);
            reLayoutFrame();
            clockFrame(sX, sY);
        }
        function toggleMap() {
            var etbMap = document.querySelector('.etb-map');
            var etbMapNavigator = document.querySelector('.etb-map-navigator');
            if (!etbMapNavigator) {
                etbMap.parentElement.insertBefore(map, etbMap);
                return;
            }
            if (etbMapNavigator.hasAttribute('hidden')) {
                etbMapNavigator.removeAttribute('hidden');
            }
            else {
                etbMapNavigator.setAttribute('hidden', '');
            }
        }
        function sendDocYun(containerDir, isNet, userAccount, uid, currentPage) {
            var sendTime = new Date().getTime();
            var userInfo = CryptoJS.MD5(uid + userAccount).toString();
            var url = uclass_services.kDocUploadPrefix + uclass_services.kDocUploadRootDir + "mbe_users/uclass/"
                + userInfo
                + '/manual/editing/'
                + containerDir.substr(-13)
                + '/OEBPS/';
            var localUrl = 'mbe_users/uclass/' + uid + '/editing/' + containerDir.substr(-13) + '/OEBPS/';
            var localContent = sendTime + '-fromclass-content.xhtml';
            if (typeof currentPage == 'number') {
                var curl = '';
                if (isNet || !/chrome:\/\//.test(etb_config.docUrl)) {
                    curl = url + (etb_config.docUrl || 'content.xhtml');
                }
                else {
                    // curl = etb_config.docUrl;
                    curl = url + 'content.xhtml';
                }
                mbe_common.IOUtils.urlGet(curl, 'text').then(function (data) {
                    var domparser = new DOMParser();
                    var result = domparser.parseFromString(data, 'text/html');
                    var docRoot = result.querySelector('html');
                    var etbPages = toArray(docRoot.querySelectorAll('.etb-page'));
                    etbPages.forEach(function (page, i) {
                        if (currentPage != i) {
                            page.parentElement.removeChild(page);
                        }
                    });
                    var blob = htmlToBlob(docRoot);
                    var hs = new HttpStorage(uclass_services.kDocUploadPrefix);
                    return hs.putBlob(localUrl + localContent, blob);
                }).then(function () {
                    url += 'reader.xhtml?closeOnEsc&editType=noedit&uid=' + uid + '&userAccount=' + userAccount + '&isNet=' + isNet + '&docUrl=' + localContent;
                    var urlJSON = { type: 'SendUrls', items: [{ name: (document.title + '(第' + (currentPage + 1) + '页)') || sendTime || containerDir.substr(-13), url: url, tags: ['#webpage'] }] };
                    iou.urlPost(uclass_services.kClassRoomServer + '/classroomControl', JSON.stringify(urlJSON)).then(function (ok) {
                        tipDialog("发送成功", 'toast');
                    }, function (err) {
                        console.log('授课系统发送完成：' + err);
                        throw tipDialog('发送完成', 'toast');
                    });
                }).fail(function (err) {
                    alert('发送失败,请重新上传当前页！');
                    // tipDialog("发送失败！");
                    throw err;
                });
            }
            else {
                url += 'reader.xhtml?closeOnEsc&editType=noedit&uid=' + uid + '&userAccount=' + userAccount + '&isNet=' + isNet;
                var urlJSON = { type: 'SendUrls', items: [{ name: document.title || sendTime || containerDir.substr(-13), url: url, tags: ['#webpage'] }] };
                iou.urlPost(uclass_services.kClassRoomServer + '/classroomControl', JSON.stringify(urlJSON));
            }
        }
        function htmlToBlob(doc) {
            var root = (doc.nodeType === Node.DOCUMENT_NODE ? doc.documentElement : doc);
            var rtn = root.tagName;
            var rtnl = rtn.toLowerCase();
            var type = rtn === rtnl ? 'application/xhtml+xml' : 'text/html';
            var docType = rtnl === 'html' ? '<!DOCTYPE html>\n' : '';
            return new Blob([docType, root.outerHTML], { type: type });
        }
        var HttpStorage = /** @class */ (function () {
            function HttpStorage(_baseUrl) {
                this._baseUrl = _baseUrl;
                this._userInfo = { uid: etb_config.uid, org_account: etb_config.userAccount };
                this._encryptUID = CryptoJS.MD5(this._userInfo.uid + this._userInfo.org_account).toString();
                /**
                 * 课件列表
                 */
                this._docCollection = { url: "", docObj: {} };
                /**
                 * 课件对象，要上传的对象
                 * deleteFlag 1 已删除
                 */
                this._docObj = {
                    creationTime: 0, lastModifiedDate: 0, title: "",
                    mbeMode: '', syncType: 'auto', deleteFlag: 0, fileList: []
                };
                this._docRecordUrl = uclass_services.kDocUploadRootDir + 'mbe_users/uclass/' + this._encryptUID + '/manual/editing/docRecord.record';
                this.fail = this.fail.bind(this);
                this.getSignature();
                if (this._baseUrl)
                    this.downloadDocRecord();
            }
            Object.defineProperty(HttpStorage.prototype, "docRecordUrl", {
                get: function () { return this._docRecordUrl; },
                enumerable: true,
                configurable: true
            });
            HttpStorage.newInstance = function (options) {
                var st = new HttpStorage(options && options.baseUrl || ''); //TODO configurable default?
                //TODO configurable size
                return new mbe_common.Deferred().resolve(st);
            };
            /**
             * 获取签名
             */
            HttpStorage.prototype.getSignature = function (url) {
                var _this = this;
                var def = new mbe_common.Deferred();
                var now = Date.now();
                // 3s 缓冲时间
                if (!this._signature || now + 3000 > +this._signature.expire) {
                    iou.urlGet(url || uclass_services.kDocSignatureUrl, "json").then(function (data) {
                        // this._signature.accessid = data.accessid;
                        // this._signature.policy = data.policy;
                        // this._signature.signature = data.signature;
                        // this._signature.dir = data.dir;
                        // this._signature.host = data.host;
                        // this._signature.expire = data.expire;
                        _this._signature = data;
                        def.resolve(data);
                    }, function (err) {
                        _this.fail(">>>getSignature:获取签名", err);
                        def.reject(err);
                    });
                }
                else {
                    def.resolve(this._signature);
                }
                return def;
            };
            /**
             * 加载课件记录
             */
            HttpStorage.prototype.downloadDocRecord = function () {
                var _this = this;
                var def = new mbe_common.Deferred();
                // 资源互通 不网络同步 课件列表
                if (mbe_config.custom_资源互通)
                    return def;
                if (Object.keys(this._docCollection.docObj).length) {
                    def.resolve("加载课件记录已完成");
                }
                else {
                    iou.urlFetch(uclass_services.kDocUploadPrefix + this.docRecordUrl, "json", iou.kRenewOptions).then(function (data) {
                        if (data)
                            _this._docCollection = data;
                        def.resolve("赋值成功");
                    }, function (err) {
                        _this.fail(">>>downloadDocRecord:请求课件记录", err);
                        def.resolve(true);
                    });
                }
                return def;
            };
            HttpStorage.prototype.putBlob = function (path, data) {
                var _this = this;
                var def = new mbe_common.Deferred();
                var file = data;
                var encryptPath = path.replace(this._userInfo.uid, this._encryptUID + "/manual");
                var url = uclass_services.kDocUploadPrefix + uclass_services.kDocUploadRootDir + encryptPath, options = iou.kRenewHeadOptions;
                return mbe_common.Promise.wrap(fetch(url, options).catch(function (e) {
                    // fetch 的出错信息过于简略，所以在此处提供全面的信息。
                    throw new Error(e + ': url=' + url + ' , opions=' + JSON.stringify(options));
                }))
                    .then(function (response) {
                    if (response.ok && file.lastModifiedDate) {
                        var remoteModificationDate = (new Date(response.headers.get('Last-Modified'))).getTime(), localModificationDate = (new Date(file.lastModifiedDate)).getTime();
                        if (remoteModificationDate >= localModificationDate)
                            return recordFileInfo.bind(_this)();
                        else
                            return upFile.bind(_this)();
                    }
                    else {
                        return upFile.bind(_this)();
                    }
                });
                // return def;
                function upFile() {
                    var _this = this;
                    return this.getSignature()
                        .then(function () { return iou.urlPost(uclass_services.kDocUploadPrefix, _this.createFromData(uclass_services.kDocUploadRootDir + encryptPath, data)); })
                        .then(function () { return recordFileInfo.bind(_this)(); })
                        .fail(function (err) {
                        _this.fail(">>>putBlob: ", err);
                        return def.reject(err);
                    });
                }
                function upFileRecord() {
                    var _this = this;
                    var fileInfo = {};
                    fileInfo['url'] = uclass_services.kDocUploadPrefix + uclass_services.kDocUploadRootDir + encryptPath;
                    fileInfo['userAccount'] = this._userInfo.account;
                    fileInfo['userId'] = this._userInfo.uid;
                    fileInfo['lastModifiedDate'] = Date.parse(file.lastModifiedDate);
                    var jblob = new Blob([JSON.stringify(fileInfo)], { type: "text/plain" });
                    var fileRecordData = this.createFromData(uclass_services.kDocUploadRootDir + encryptPath + ".record", jblob);
                    return iou.urlPost(uclass_services.kDocUploadPrefix, fileRecordData).then(function () { return recordFileInfo.bind(_this)(); });
                }
                function recordFileInfo() {
                    var fileObj = {
                        url: uclass_services.kDocUploadPrefix + uclass_services.kDocUploadRootDir + encryptPath,
                        localUrl: path,
                        size: file.size + "B",
                        lastModifiedDate: Date.parse(file.lastModifiedDate)
                    };
                    this._docObj.fileList.push(fileObj);
                    return def.resolve(true);
                }
            };
            /**
             * 创建FromData
             * key 文件目录
             * data 文件
             */
            HttpStorage.prototype.createFromData = function (key, data) {
                var formData = new FormData();
                formData.append("key", key); // 文件目录
                formData.append("policy", this._signature.policy);
                formData.append("OSSAccessKeyId", this._signature.accessid);
                formData.append("success_action_status", "200");
                formData.append("signature", this._signature.signature);
                data && formData.append("file", data);
                return formData;
            };
            HttpStorage.prototype.fail = function (method, msg) {
                method = method || "";
                msg = msg || "";
                console.error(method + '失败：' + msg);
            };
            return HttpStorage;
        }());
        function endMediaOfPage(pnOrPage) {
            var pn = -1, page = null;
            if (typeof pnOrPage === 'number') {
                pn = pnOrPage;
                page = pages[pn];
            }
            else {
                pn = pages.indexOf(pnOrPage);
                page = pnOrPage;
            }
            Array.prototype.slice.call(page.querySelectorAll('audio, video'), 0).forEach(function (media) {
                media['pause']();
                media.currentTime = 0;
            });
        }
        function TabPageUp(event) {
            if (etb_book.currentPage.querySelector('.mainbo-center'))
                return;
            if (Fscreen.isFullScreen()) {
                var endmark;
                if (etb_book.currentPage.hasAttribute('data-mainbo-animation')) {
                    endmark = etb_book.animationPlayReverse(event);
                    if (endmark) {
                        prev();
                    }
                }
                else {
                    prev();
                }
            }
            else {
                //todo 是否需要屏蔽在非全屏下的pagedown事件
                //(<Event>event).preventDefault();  
            }
        }
        function TabPageDown(event) {
            if (etb_book.currentPage.querySelector('.mainbo-center'))
                return;
            if (Fscreen.isFullScreen()) {
                var endmark;
                if (etb_book.currentPage.hasAttribute('data-mainbo-animation')) {
                    endmark = etb_book.animationPlay(event);
                    if (endmark) {
                        next();
                    }
                }
                else {
                    next();
                }
            }
            else {
                //todo 是否需要屏蔽在非全屏下的pagedown事件
                //(<Event>event).preventDefault();            
            }
        }
        function keyFn(event) {
            console.log('keycode:' + event.keyCode);
            if (event.ctrlKey && !event.altKey && !event.shiftKey) {
                switch (event.keyCode) {
                    case 69:
                        break;
                    //ctrl+e
                    case 88:
                        break;
                    //ctrl+x
                    case 80:
                        //event.preventDefault();
                        //Fscreen.launchFullScreen();
                        //gotoPage(currentPageNumber);
                        break;
                    //ctrl+p
                    case 68:
                    //ctrl+d
                    case 74:
                    //ctrl+j
                    case 83:
                }
                return;
            }
            if (event.altKey && !event.shiftKey && !event.ctrlKey) {
                //alt+F5全屏 快捷鍵
                switch (event.keyCode) {
                    case 116:
                        event.preventDefault();
                        Fscreen.launchFullScreen();
                        break;
                }
                return;
            }
            switch (event.keyCode) {
                case 27:// esc
                    if (etb_config.closeOnEsc) {
                        window.close();
                    }
                    break;
                case 33:
                case 37:
                case 38:
                    TabPageUp(event);
                    break;
                case 34:
                case 39:
                case 40:
                    TabPageDown(event);
                    break;
                default:
                    break;
            }
        }
        var lastX = 0, lastY = 0;
        var isMousedown = false;
        function mouseFn(event) {
            //console.log(event.type);
            var target = event.target;
            var turnpage = getAncestors(target, function (el) { return el.classList.contains('etb-turnpage-right') || el.classList.contains('etb-turnpage-left'); }).pop();
            switch (event.type) {
                case 'pointerdown':
                    if (turnpage) {
                        isMousedown = true;
                        lastY = event.clientY;
                    }
                    break;
                case 'pointerup':
                    isMousedown = false;
                case "pointermove":
                    // if (event.pointerType !== 'mouse') break;
                    var mx = event.clientX, my = event.clientY;
                    if (!document.contains(target) && (event.pointerType == 'mouse')) {
                        var fRect = contentFrame.getBoundingClientRect();
                        mx = toOuterX(mx, fRect.left);
                        my = toOuterX(my, fRect.left);
                    }
                    // if (mx - lastX !== 0 || my - lastY !== 0) { // chrome 上可能发送假的移动事件，造成菜单意外消失。
                    //   showMenu(my > document.documentElement.clientHeight - kMenuSensitiveHeight ||
                    //     etbMenu.contains(target), mx);
                    // } 改为点击出发菜单显示/隐藏
                    if (turnpage && isMousedown) {
                        var minTop = Math.min(document.documentElement.clientHeight / 2 - turnpage.getBoundingClientRect().height / 2, (parseFloat(turnpage.style.marginTop) || 0) - lastY + my);
                        var maxTop = Math.max(-document.documentElement.clientHeight / 2 + turnpage.getBoundingClientRect().height / 2, (parseFloat(turnpage.style.marginTop) || 0) - lastY + my);
                        turnpage.style.marginTop = (maxTop > 0 ? minTop : maxTop) + 'px';
                    }
                    lastX = mx;
                    lastY = my;
                    break;
                case "pointerover":
                    if (event.relatedTarget)
                        break;
                    // if (eventInThirdParty(target, etbMenu)) toggleMenu(event);
                    break;
                case "click":
                    if (eventInThirdParty(target, etbMenu)) {
                        toggleOutline();
                    }
                    else {
                        showOutline(false);
                    }
                    if (target['href'] && mbe_config.custom_长虹) {
                        var index = target['href'].lastIndexOf(".");
                        var ext = target['href'].substr(index + 1);
                        //长虹项目屏蔽exe msi apk upub html打开 如想增加 在后面||就行
                        if (ext == 'exe' || ext == 'msi' || ext == 'apk' || ext == 'upub' || ext == 'html') {
                            alert('出于安全性考虑，该文件格式不支持打开');
                            event.preventDefault();
                        }
                    }
                    if (target.localName === 'a' && etbOutline && etbOutline.contains(target)) {
                        event.preventDefault();
                        triggerOutline(target);
                    }
                default:
                    break;
            }
        }
        if (!window.opener)
            etbMenu.querySelector('.etb-exit').style.display = 'none';
        etbMenu.querySelector('.etb-exit').onclick = function () { return window.close(); };
        /*事件*/
        etbFull.addEventListener("click", function () {
            if (!Fscreen.isFullScreen()) {
                Fscreen.launchFullScreen();
            }
            else
                Fscreen.cancelFullscreen();
        });
        eSelect.addEventListener("change", function (ev) {
            etb_book.gotoPage(this.selectedIndex);
        }, false);
        etbSendPage.addEventListener('click', function () {
            var containerDir = location.href.split('/OEBPS')[0];
            sendDocYun(containerDir, etb_config.isNet, etb_config.userAccount, etb_config.uid, currentPageNumber);
        }, false);
        // window.addEventListener("scroll", function () {
        //   timeOut.scroll(function () {
        //     Fscreen.now = Array.prototype.indexOf.call(etbPages.children, jugeNowPage());
        //     eSelect.selectedIndex = Fscreen.now;
        //   })
        // }, false);
        document.querySelector(".etb-prev").addEventListener("click", prev, false);
        document.querySelector(".etb-next").addEventListener("click", next, false);
        document.querySelector(".etb-prev-left").addEventListener("click", prev, false);
        document.querySelector(".etb-next-left").addEventListener("click", next, false);
        document.querySelector(".etb-prev-right").addEventListener("click", prev, false);
        document.querySelector(".etb-next-right").addEventListener("click", next, false);
        document.querySelector(".etb-minusProp").addEventListener("click", zoomMinus, false);
        document.querySelector(".etb-plusProp").addEventListener("click", zoomPlus, false);
        document.querySelector(".etb-map").addEventListener("click", toggleMap, false);
        document.addEventListener(fullscreenchange, function (ev) {
            if (Fscreen.isFullScreen()) {
                //console.log('fullscreenchange:true');
                if (Fscreen.isDocFullScreen()) {
                    Fscreen.scaleToScreen();
                    etb_book.gotoPage(currentPageNumber);
                }
            }
            else {
                //console.log('fullscreenchange:false');
                // 退出全屏时，消除所有居中弹出
                etb_book.dismissAllCenterPopups(contentFrame.contentDocument);
                Fscreen.restoreScale();
                etb_book.gotoPage(currentPageNumber);
            }
            ;
            Fscreen.updateFullscreenButton();
            prevFullscreened = Fscreen.isFullScreen();
            updateAllowFullscreenOfContentFrame();
        }, false);
        ['pointerdown', 'pointerup', 'pointermove', 'pointerover', 'click'].forEach(function (ev) {
            window.addEventListener(ev, mouseFn);
            contentFrame.contentWindow.addEventListener(ev, mouseFn);
        });
        window.addEventListener("message", function (event) { etb_book.gotoPage(event.data); });
        window.addEventListener("keydown", keyFn);
        contentFrame.contentWindow.addEventListener("keydown", keyFn);
        svgPen = new etb_tools.SVGPen(contentFrame.contentDocument.body);
        svgPen.onPathDrawn = onPathDrawn;
        initSVGPenBar();
        etbMenuToggle();
    }
    function etbMenuToggle() {
        var etbMenuToggle = document.getElementsByClassName('etb-menu-toggle')[0];
        var etbMenu = document.getElementsByClassName('etb-menu')[0];
        var timer = null;
        etbMenuToggle.addEventListener('pointerdown', function (ev) {
            etbMenu.classList.add('show');
            if (etbMenu.classList.contains('show')) {
                etbMenuToggle.classList.remove('show');
                clearTimeout(timer);
                timer = setTimeout(function () {
                    etbMenu.classList.remove('show');
                    etbMenuToggle.classList.add('show');
                }, 5000);
            }
        });
        etbMenu.addEventListener('pointermove', function (ev) {
            clearTimeout(timer);
            timer = setTimeout(function () {
                etbMenu.classList.remove('show');
                etbMenuToggle.classList.add('show');
            }, 5000);
        });
        etbMenu.addEventListener('pointerleave', function (ev) {
            if (ev.pointerType !== 'touch') {
                etbMenu.classList.remove('show');
                etbMenuToggle.classList.add('show');
            }
        });
    }
    function initSVGPenBar() {
        var draw = document.querySelector('.etb-SvgPenDraw');
        draw.addEventListener('pointerdown', function (ev) {
            svgPen.isDrawing = !svgPen.isDrawing;
            if (svgPen.isDrawing) {
                scrollX = scrollPane.scrollLeft;
                scrollY = scrollPane.scrollTop;
                draw.classList.add('etb-down');
            }
            else
                draw.classList.remove('etb-down');
        });
        var removeAll = document.querySelector('.etb-SvgPenRemoveAll');
        removeAll.addEventListener('pointerdown', function (ev) { return etb_book.currentPage && svgPen.removeAll(etb_book.currentPage); });
    }
    function onPathDrawn(event) {
        event.canvas = etb_book.currentPage;
    }
    function insertMenutHtml() {
        var html = [
            '<div class="etb-turnpage show">',
            '<div class="etb-turnpage-left">',
            '<button class="etb-prev-left" title="上一页"></button>',
            '<button class="etb-next-left" title="下一页"></button>',
            '</div>',
            '<div class="etb-divider"></div>',
            '<div class="etb-turnpage-right">',
            '<button class="etb-prev-right" title="上一页"></button>',
            '<button class="etb-next-right" title="下一页"></button>',
            '</div>',
            '</div> ',
            '<div class="etb-menu-toggle show"><button></button></div>',
            '<div class="etb-menu">',
            '<button class="etb-plusProp" title="放大">',
            '<i class="etb-icon-mono-plus-pages"></i>',
            '</button>',
            '<button class="etb-minusProp" title="缩小">',
            '<i class="etb-icon-mono-minus-pages"></i>',
            '</button>',
            '<div class="etb-page-tools" style="display: none;">',
            '<select class="etb-page-select"></select>',
            '<label class="etb-page-count">/1</label>',
            '</div>',
            '<button class="etb-prev" title="上一页" style="display: none;"></button>',
            '<button class="etb-next" title="下一页" style="display: none;"></button>',
            '<button class="etb-SvgPenDraw" title="笔画"></button>',
            '<button class="etb-SvgPenRemoveAll" title="橡皮"></button>',
            '<div class="etb-fullScreen">',
            '<button class="etb-full" data-full="全屏播放" data-normal="退出全屏" title="全屏播放"> </button>',
            '</div>',
            '<button class="etb-sendPage" title="发送"></button>',
            '<button class="etb-exit" title="退出"></button>',
            '</div> ',
            '<div class="etb-map" style="display:' + (!map ? 'none' : '') + '">',
            '<span class="map-circlebg"></span>',
            // '<button>教学地图</button>',
            '</div>',
        ].join('\n');
        if (mbe_config.custom_长虹) {
            html = [
                '<div class="etb-turnpage show">',
                '<div class="etb-turnpage-left">',
                '<button class="etb-prev-left" style="display: none;" title="上一页"></button>',
                '<button class="etb-next-left" style="display: none;" title="下一页"></button>',
                '</div>',
                '<div class="etb-divider"></div>',
                '<div class="etb-turnpage-right">',
                '<button class="etb-prev-right" style="display: none;" title="上一页"></button>',
                '<button class="etb-next-right" style="display: none;" title="下一页"></button>',
                '</div>',
                '</div> ',
                '<div class="etb-menu-toggle show" style="display: none;"><button></button></div>',
                '<div class="etb-menu">',
                '<button class="etb-plusProp" style="display: none;" title="放大">',
                '<i class="etb-icon-mono-plus-pages"></i>',
                '</button>',
                '<button class="etb-minusProp" style="display: none;" title="缩小">',
                '<i class="etb-icon-mono-minus-pages"></i>',
                '</button>',
                '<div class="etb-page-tools" style="display: none;">',
                '<select class="etb-page-select"></select>',
                '<label class="etb-page-count">/1</label>',
                '</div>',
                '<button class="etb-prev" title="上一页" style="display: none;"></button>',
                '<button class="etb-next" title="下一页" style="display: none;"></button>',
                '<button class="etb-SvgPenDraw" style="display: none;" title="笔画"></button>',
                '<button class="etb-SvgPenRemoveAll" style="display: none;" title="橡皮"></button>',
                '<div class="etb-fullScreen">',
                '<button class="etb-full" style="" data-full="全屏播放" data-normal="退出全屏" title="全屏播放"> </button>',
                '</div>',
                '<button class="etb-sendPage" style="display: none;" title="发送"></button>',
                '<button class="etb-exit" style="display: none;" title="退出"></button>',
                '</div> ',
                '<div class="etb-map" style="display:' + (!map ? 'none' : '') + '">',
                '<span class="map-circlebg"></span>',
                // '<button>教学地图</button>',
                '</div>',
            ].join('\n');
        }
        document.body.insertAdjacentHTML('afterbegin', html);
    }
    function initEventSource(doc) {
        var id = 'device-beikedashi-' + Date.now();
        var url = "http://localhost:7017/messages/" + id;
        var sse = new EventSource(url);
        function endMediaOfPage(pnOrPage) {
            var pn = -1, page = null;
            if (typeof pnOrPage === 'number') {
                pn = pnOrPage;
                page = pages[pn];
            }
            else {
                pn = pages.indexOf(pnOrPage);
                page = pnOrPage;
            }
            Array.prototype.slice.call(page.querySelectorAll('audio, video'), 0).forEach(function (media) {
                media['pause']();
                media.currentTime = 0;
            });
        }
        // 本地sse服务器没开，会无限重连接7017端口 会导致控制台出现请求拒绝的错误
        sse.onopen = function (e) {
            console.log(url + '-----sse连接已建立');
        };
        sse.onmessage = function (dd) {
            console.log(dd.data);
            var msg = JSON.parse(dd.data);
            if (msg.type == 'Presenter' && msg.id != '' && Object.keys(msg).length == 2 && mbe_config.custom_长虹) {
                window.close();
            }
            if (msg.type == 'Presenter' && msg.changed == "pageZoom" && msg.pageZoomMode == 'zoomIn' && mbe_config.custom_长虹) {
                etb_book.scale = etb_book.scale + 0.2 > 3 ? 3 : etb_book.scale + 0.2;
                var sX = scrollPane.scrollLeft / (scrollPane.scrollWidth - scrollPane.offsetWidth);
                var sY = scrollPane.scrollTop / (scrollPane.scrollHeight - scrollPane.offsetHeight);
                reLayoutFrame();
                clockFrame(sX, sY);
            }
            if (msg.type == 'Presenter' && msg.changed == "pageZoom" && msg.pageZoomMode == 'zoomOut' && mbe_config.custom_长虹) {
                etb_book.scale = etb_book.scale - 0.2 < 0.3 ? 0.3 : etb_book.scale - 0.2;
                var sX = scrollPane.scrollLeft / (scrollPane.scrollWidth - scrollPane.offsetWidth);
                var sY = scrollPane.scrollTop / (scrollPane.scrollHeight - scrollPane.offsetHeight);
                reLayoutFrame();
                clockFrame(sX, sY);
            }
            if (msg.type == 'Presenter' && msg.changed == "pageScrollBar" && mbe_config.custom_长虹) {
                if (!msg.horizontal) {
                    msg.horizontal = 0;
                }
                if (!msg.vertical) {
                    msg.vertical = 0;
                }
                var chScrollPaneWidth = scrollPane.clientWidth;
                var chScrollPaneHeight = scrollPane.clientHeight;
                var chIframeWidth = document.getElementsByClassName('mainbo-frame-wrapper')[0].clientWidth;
                var chIframeHeight = document.getElementsByClassName('mainbo-frame-wrapper')[0].clientHeight;
                chScrollX = chScrollX + msg.horizontal;
                chScrollY = chScrollY + msg.vertical;
                if (chScrollX + chScrollPaneWidth > chIframeWidth) {
                    chScrollX = chIframeWidth - chScrollPaneWidth;
                }
                if (chScrollY + chScrollPaneHeight > chIframeHeight) {
                    chScrollY = chIframeHeight - chScrollPaneHeight;
                }
                if (chScrollX < 0) {
                    chScrollX = 0;
                }
                if (chScrollY < 0) {
                    chScrollY = 0;
                }
                scrollPane.scrollLeft = chScrollX;
                scrollPane.scrollTop = chScrollY;
            }
            if (msg.type !== 'NavigatePresenter' || msg.id !== id)
                return;
            if (typeof msg.targetPage === 'number') {
                etb_book.gotoPage(msg.targetPage - 1);
                var data = {
                    type: 'Presenter',
                    changed: 'page',
                    currentPage: msg.targetPage,
                };
                var pp = mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(data), 'text/plain');
                pp.then(function (data) {
                    console.log(data);
                }, function (err) {
                    console.warn(err);
                });
            }
            else if (msg.direction === 'forward') {
                endMediaOfPage(currentPageNumber);
                if (etb_book.currentPage.getAttribute('data-mainbo-animation') == "progress") {
                    // 有动画的页面，先播放动画
                    if (etb_book.animationPlay(dd)) {
                        // 再翻页
                        etb_book.gotoPage(currentPageNumber + 1);
                    }
                }
                else {
                    etb_book.gotoPage(currentPageNumber + 1);
                }
                var data = {
                    type: 'Presenter',
                    changed: 'page',
                    currentPage: (currentPageNumber + 1) >= pages.length ? pages.length : currentPageNumber + 1
                };
                var pp = mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(data), 'text/plain');
                pp.then(function (data) {
                    console.log(data);
                }, function (err) {
                    console.warn(err);
                });
            }
            else if (msg.direction === 'backward') {
                endMediaOfPage(currentPageNumber);
                etb_book.gotoPage(currentPageNumber - 1);
                var data = {
                    type: 'Presenter',
                    changed: 'page',
                    currentPage: (currentPageNumber + 1) <= 1 ? 1 : currentPageNumber + 1
                };
                var pp = mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(data), 'text/plain');
                pp.then(function (data) {
                    console.log(data);
                }, function (err) {
                    console.warn(err);
                });
            }
        };
        sse.onerror = function (ev) {
            for (var p in ev) {
                console.log(ev[p]);
            }
        };
        var curp = null;
        if (currentPageNumber < 1) {
            curp = 1;
        }
        else if (currentPageNumber >= pages.length - 1) {
            curp = pages.length;
        }
        else {
            curp = currentPageNumber + 1;
        }
        var data = {
            type: 'Presenter',
            currentPage: curp,
            pageCount: pages.length,
            id: id,
            title: 'beikedashiDoc' + id
        };
        var datacur = {
            type: 'Presenter',
            changed: 'page',
            currentPage: curp,
            pageCount: pages.length
        };
        // 发起sse连接请求
        mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(data), 'text/plain').then(function (data) {
            // 发起当前页请求
            mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(datacur), 'text/plain');
        });
        // 窗打开时监听窗口 beforeunload事件，
        window.onbeforeunload = function (e) {
            // 如果sse存在发送id为空字符串
            if (sse) {
                var data = {
                    type: 'Presenter',
                    id: ''
                };
                mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(data), 'text/plain');
            }
        };
        // 外层window对象
        window.addEventListener('focus', function (e) {
            console.log('outer document focus!');
            var curp = null;
            if (currentPageNumber < 1) {
                curp = 1;
            }
            else if (currentPageNumber >= pages.length - 1) {
                curp = pages.length;
            }
            else {
                curp = currentPageNumber + 1;
            }
            var data = {
                type: 'Presenter',
                currentPage: curp,
                pageCount: pages.length,
                id: id,
                title: 'beikedashiDoc' + id
            };
            var datacur = {
                type: 'Presenter',
                changed: 'page',
                currentPage: curp,
                pageCount: pages.length
            };
            // 发起sse连接请求
            mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(data), 'text/plain').then(function (data) {
                // 发起当前页请求
                mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(datacur), 'text/plain');
            });
        }, true);
        window.addEventListener('blur', function (e) {
            console.log('outer document blur!');
        }, true);
        // 内层window对象
        var wrapiframe = window.document.querySelector('.mainbo-frame-wrapper > iframe');
        var innerWindow = wrapiframe.contentWindow;
        innerWindow.addEventListener('focus', function (e) {
            console.log('inner document focus!');
            var curp = null;
            if (currentPageNumber < 1) {
                curp = 1;
            }
            else if (currentPageNumber >= pages.length - 1) {
                curp = pages.length;
            }
            else {
                curp = currentPageNumber + 1;
            }
            var data = {
                type: 'Presenter',
                currentPage: curp,
                pageCount: pages.length,
                id: id,
                title: 'beikedashiDoc' + id
            };
            var datacur = {
                type: 'Presenter',
                changed: 'page',
                currentPage: curp,
                pageCount: pages.length
            };
            // 发起sse连接请求
            mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(data), 'text/plain').then(function (data) {
                // 发起当前页请求
                mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(datacur), 'text/plain');
            });
        }, true);
        innerWindow.addEventListener('blur', function (e) {
            console.log('inner document blur');
        }, true);
        /* 浏览器bug？ 监听方式不能接受到事件
        document.body.addEventListener('focus', function (e) {
          console.log('document body focus');
          mbe_common.IOUtils.urlPost(classroomserver + '/presenter', JSON.stringify(data), 'text/plain');
        }, true);
        document.body.addEventListener('blur', function (e) {
          console.log('document body blur');
        }, true);
        */
    }
})(etb_book || (etb_book = {}));
//# sourceMappingURL=book.js.map