function testDynamicH5() 
{
    console.log("use h5");
      
    var refText = "I want to know the past and present of Hong Kong.";

    $("#content .currentWord").html(refText);

    window.aiPanel = new chivox.AiPanel({
        appKey: Config.appKey,
        mode: chivox.MODE.HTML5,
        sigurl: "php/sig.php",       
        data: {
            
            duration: 20000,
            serverParams: {
                coreType: "en.pred.exam",
                rank:100,
                precision: 1,
                coreTimeout: 10000,
                refText: "I want to know the past and present of Hong Kong.",
                //refText: {                         // 必需, 参考文本
					 //lm: refText
				 //}, 
                 client_params: {          
                     ext_subitem_rank4: 0, // 可选，句子与单词评分是否启用4分制，1为启用，0为分制跟随rank
                },	
                userId: "guest",
				attachAudioUrl: 1
            }
        },
        onBeforeRecord: function () {
            $("#scoreResult .pron").empty();
            $("#scoreResult .fluency").empty();
            $("#scoreResult .details").empty();
        },
        onScore: function (data) 
		{
			$('#audio').attr('src', "http://"+data.audioUrl+".mp3");
			console.log("audio url:"+"http://"+data.audioUrl+".mp3");
			
            var resultObj = new chivox.EnSentScore(data);
            $("#scoreResult .pron").html(resultObj.getOverall());
            $("#scoreResult .fluency").html(resultObj.getFluency());

            var html = htmlA = htmlB = '';
            html += '<table border="0" cellpadding="0" cellspacing="0">';
            for (var i = 0; i < resultObj.getWordSize() ; i++) {
                htmlA += '<td align="center" style="padding:0 10px;">' + resultObj.getWord(i).getChar() + '</td>';
                htmlB += '<td align="center">' + resultObj.getWord(i).getScore() + '</td>';
            }
            html += '<tr>' + htmlA + '</tr>';
            html += '<tr>' + htmlB + '</tr>';
            html += '</table>';
            $("#scoreResult .details").html(html);
        },
        onScoreError: function (errorType) 
        {
            console.log("h5 error");
            var errorObj = chivox.AiStatusCode.get(errorType, "cn");
            alert(errorObj.feedback);
        }
    });   
    
    aiPanel.Dialog.close();
    
    if (window.location.search == "?debug") {
            $(".debug").show();
        }


    window.changeWord = function () 
	{
        refText = "The food price is high at present.";
        $("#content .currentWord").html(refText);
        $("#scoreResult .pron").empty();
        $("#scoreResult .fluency").empty();
        $("#scoreResult .details").empty();
        aiPanel.setData({
            audioUrl: "static/mp3/en/The-food-price-is-high-at-present.mp3",
            serverParams: {
                coreType: "en.sent.score",
                refText: refText,
                userId: "guest",
				attachAudioUrl: 1
            }
        });
    }
}

function testDynamicFlash() 
{	
    console.log("use flash");
    
    //var refText = "My name is Li Ming from China Medical University";
    
    var refText = "I want to know the past and present of Hong Kong.";
    
    $("#content .currentWord").html(refText);

    window.aiPanel = new chivox.AiPanel({
        appKey: Config.appKey,
        mode: chivox.MODE.FLASH,
        sigurl: "php/sig.php",
        data: {
            audioUrl: "static/mp3/en/I-want-to-know-the-past-and-present-of-Hong-Kong.mp3",
            duration: 20000,
            serverParams: {
                coreType: "en.sent.score",
                refText: refText,
                coreTimeout: 10000,
                userId: "guest",
				attachAudioUrl: 1
            }
        },
        onBeforeRecord: function () {
            $("#scoreResult .pron").empty();
            $("#scoreResult .fluency").empty();
            $("#scoreResult .details").empty();
        },
        onScore: function (data) {
            var resultObj = new chivox.EnSentScore(data);
            $("#scoreResult .pron").html(resultObj.getOverall());
            $("#scoreResult .fluency").html(resultObj.getFluency());

            var html = htmlA = htmlB = '';
            html += '<table border="0" cellpadding="0" cellspacing="0">';
            for (var i = 0; i < resultObj.getWordSize() ; i++) {
                htmlA += '<td align="center" style="padding:0 10px;">' + resultObj.getWord(i).getChar() + '</td>';
                htmlB += '<td align="center">' + resultObj.getWord(i).getScore() + '</td>';
            }
            html += '<tr>' + htmlA + '</tr>';
            html += '<tr>' + htmlB + '</tr>';
            html += '</table>';
            $("#scoreResult .details").html(html);
        },
        onScoreError: function (errorType) 
        {
            console.log("use flash error");
            var errorObj = chivox.AiStatusCode.get(errorType, "cn");
            alert(errorObj.feedback);
        },
        onError: function( error )
        {
            console.log("1");
            console.error(error);
            console.log("2");
        }
    });
    aiPanel.Dialog.close();

    window.changeWord = function () {
        refText = "The food price is high at present.";
        $("#content .currentWord").html(refText);
        $("#scoreResult .pron").empty();
        $("#scoreResult .fluency").empty();
        $("#scoreResult .details").empty();
        aiPanel.setData({
            audioUrl: "static/mp3/en/The-food-price-is-high-at-present.mp3",
            serverParams: {
                coreType: "en.sent.score",
                refText: refText,
                userId: "guest"
            }
        });
    }
}