// 要远程调试 xulrunner 应用，请加上命令行参数：
// Windows: beikedashi_xulrunner.exe -start-debugger-server 6101
// Linux/Mac: beikedashi_xulrunner --start-debugger-server 6101

let Ci = Components.interfaces;
let Cu = Components.utils;
let Cc = Components.classes;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");
const kMainUrl = "chrome://mbeditor/content/air-master-editor.xhtml";

function _onload() {
  var browser = document.getElementById("browser");

  window.addEventListener('close', _onclose);
  document.title = '加载中...';
  browser.addEventListener('DOMTitleChanged', function() {
    document.title = browser.contentTitle;
  });
  browser.addProgressListener(_progressListener, Ci.nsIWebProgress.NOTIFY_ALL);

  // browser.focus() 确保 browser 中的 HTML 文档能自动获得焦点。
  // 但这样做的副作用是让窗口退出了最大化，所以之后调用 window.maximize() 重新最大化（注意，不异步执行则无效）。
  window.focus();
  browser.focus();
  setTimeout(function() { window.maximize(); }, 0);

  // 没有 window.arguments，说明不是通过执行 exe ，而是通过window.open/a[target='_blank']等创建的窗口，不应加载 kMainUrl。
  if (!window.arguments) {
    return;
  }
  
  browser.loadURI(kMainUrl + _getArgs(), null, null);
}

function _getArgs() {
  var cmdLine = window.arguments[0];
  cmdLine = cmdLine.QueryInterface(Ci.nsICommandLine);
  if (!cmdLine.length) return '';
  var args = [];
  for(var i = 0; i < cmdLine.length; i++) {
    args.push(cmdLine.getArgument(i));
  }
  dump('>>>>>>_getArgs:' + args.join(' ') + '\n');
  return '?args=' + encodeURIComponent(args.join(' '));
}

// 实现 beforeunload 提示，参考 firefox 源码（44-的版本） chrome://browser/content/browser.js:WindowIsClosing()，
// 或 browser\base\content\browser.js
// 注意 FF 45+ 没有 resetCloseWindow()，简单去掉即可，适用于 45-47。详见
// https://bugzilla.mozilla.org/show_bug.cgi?id=967873
function _onclose(ev) {
  var browser = document.getElementById("browser");
  let ds = browser.docShell;
  // Passing true to permitUnload indicates we plan on closing the window.
  // This means that once unload is permitted, all further calls to
  // permitUnload will be ignored. This avoids getting multiple prompts
  // to unload the page.
  if (ds.contentViewer && !ds.contentViewer.permitUnload(true)) {
    // ... however, if the user aborts closing, we need to undo that,
    // to ensure they get prompted again when we next try to close the window.
    // We do this on the window's toplevel docshell instead of on the tab, so
    // that all tabs we iterated before will get this reset.

    // window.getInterface(Ci.nsIDocShell).contentViewer.resetCloseWindow();
    ev.preventDefault();
    return false;
  }
}

var _progressListener = {
  _closeTimer: -1,
  // We need to advertize that we support weak references.  This is done simply
  // by saying that we QI to nsISupportsWeakReference.  XPConnect will take
  // care of actually implementing that interface on our behalf.
  QueryInterface: function (iid) {
    if (iid.equals(Ci.nsIWebProgressListener) ||
      iid.equals(Ci.nsISupportsWeakReference) ||
      iid.equals(Ci.nsISupports))
      return this;
    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  // This method is called to indicate state changes.
  onStateChange: function (webProgress, request, stateFlags, status) {
    const WPL = Ci.nsIWebProgressListener;
	   // dump("onStateChange:doc url:" + webProgress.DOMWindow.document.URL/*browser.contentDocument.URL*/ + 
    // ', stateFlags:0x' + stateFlags.toString(16) + ',status:' + status.toString(16) + ', request.name:' +
    // request.name + '\n');

    // 通过新窗口打开（window.open(), <a target="_blank">）不支持的文件类型/协议时，会产生空白窗口，用下面的代码可关闭空白窗口。
    var _this = this;
    if (stateFlags & WPL.STATE_IS_REQUEST) {
      if (
        webProgress.DOMWindow.top === webProgress.DOMWindow && // 不要让非顶层窗口误触发
        _this._closeTimer < 0 &&
        (stateFlags & WPL.STATE_STOP) &&
        status === 0x804b0002 &&   // NS_BINDING_ABORTED
        webProgress.DOMWindow.document.URL === 'about:blank' &&
        request.name === 'about:document-onload-blocker'
        ) {
          _this._closeTimer = setTimeout(function() {
            window.close();
            dump("mbe_browser.js:onStateChange: closing blank window.\n");
          }, 100);
      } else if (_this._closeTimer > 0 && status === 0) {
        clearTimeout(_this._closeTimer);
        _this._closeTimer = 0;
      }
    }
  },

  // This method is called to indicate progress changes for the currently
  // loading page.
  onProgressChange: function (webProgress, request, curSelf, maxSelf,
    curTotal, maxTotal) { },

  // This method is called to indicate a change to the current location.
  onLocationChange: function (webProgress, request, location) { },

  // This method is called to indicate a status changes for the currently
  // loading page.  The message is already formatted for display.
  onStatusChange: function (webProgress, request, status, message) { },

  // This method is called when the security state of the browser changes.
  onSecurityChange: function (webProgress, request, state) { }
};

addEventListener("load", _onload, false);
