#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp

if [ $# -ne 3 ];then
	e_json updateCustomer "fail"
	exit 0
fi

maintainer="$1"
telephone="$2"
name="$3"

mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi

str_sql="update customer_info set maintainer='${maintainer}', telephone='${telephone}', name='${name}';"

su - postgres<<EOF
    psql -d rcd -p $port -c "${str_sql}" > $tmpf
EOF

e_json updateCustomer "success"