#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

v_f=/usr/rcd/version_web.ini
dos2unix $v_f > /dev/null 2>&1
v1=`cat $v_f | grep mainVersion|awk -F'=' '{print $2}'`
v2=`cat $v_f | grep mainVersion|awk -F'=' '{print $2}'`

if [ "$v1" -le 2 ] && [ "$v2" -lt 1 ]; then
#2.1以前版本
	exit 0;
else
#2.1及2.1以后版本
	installPackageName=`rpm -qa | grep rcd_cmproxywinstu`
	if [ -z "$installPackageName" ]; then
		e_json fix_cm_missing -21
		exit 0;
	fi
	
	rpmPath=`find / -name "$installPackageName"*.rpm 2> /dev/null | head -1`
	if [ -z "$rpmPath" ]; then
		e_json fix_cm_missing -22
		exit 0;
	fi
	
	sudo rpm -e "$installPackageName"
	sudo rpm -ivh "$rpmPath" > /dev/null 2>&1
	
	e_json fix_cm_missing 0
fi