#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi

su - postgres<<EOF
  psql -d rcd -p $port -c "select id from lb_seat_info order by id;" > $tmpf
EOF

RE=`cat $tmpf|sed '1,2d;N;$d;P;D'`
index=10
if [ -n "$RE" ]; then
while read item
do
  ((index++))
  item_id=`echo $item|awk '{print $1}'`
  item_ip="192.168.123.""$index" 
  str_sql="update lb_seat_info set (vm_ip, vm_mask, vm_gateway) = ('${item_ip}', '255.255.255.0', '192.168.123.1') where id=${item_id};"
su - postgres<<EOF
  psql -d rcd -p $port -c "${str_sql}" > $tmpf
EOF
done<<<"${RE}"

fi





e_json natVmIpRepair "ok"





