#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin

cd $C_DIR

#include files
. ./common.json

function checkIPAddr() {
	echo $1|grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" > /dev/null; 
	#IP地址必须为全数字 
	if [ $? -ne 0 ] 
	then 
			return 1 
	fi 
	
	ipaddr=$1 
	echo $ipaddr
	#以"."分隔，取出每个列的值 
	a=`echo $ipaddr | awk -F'.' '{print $1}'`
	b=`echo $ipaddr | awk -F'.' '{print $2}'`
	c=`echo $ipaddr | awk -F'.' '{print $3}'`
	d=`echo $ipaddr | awk -F'.' '{print $4}'` 
	for num in $a $b $c $d 
	do 
		#每个数值必须在0-255之间 
		if [ $num -gt 255 ] || [ $num -lt 0 ]; then 
		    return 1 
		fi 
	done 
	
	return 0 
} 


tmpf=/tmp/_sqlout.tmp
user_path=/home/user

#获取非共享口ip
ipaddr=`sudo ipmitool lan print 1 | grep '^IP Address  :*' | awk -F '[:]' '{print $2}'|awk -F '[ ]' '{print $2}' 2> /dev/null`
#获取共享口ip
shareipaddr=`sudo ipmitool lan print 8 | grep '^IP Address  :*' | awk -F '[:]' '{print $2}'|awk -F '[ ]' '{print $2}' 2> /dev/null`
checkIPAddr $ipaddr
if [ $? != 0 ]; then
	ipaddr=''
fi

checkIPAddr $shareipaddr
if [ $? != 0 ]; then
	shareipaddr=''
fi
	

e_json ipaddr "$ipaddr" shareipaddr "$shareipaddr"
