#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp

mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi

su - postgres<<EOF
  psql -d rcd -p $port -c "select base_name, is_default from lb_vm_base_image where is_default='Y';" > $tmpf
EOF

exe_s="e_json "

RE=`cat $tmpf|sed '1,2d;N;$d;P;D'`

if [ -n "$RE" ]; then
while read item
do
  i_use=`echo $item|awk -F'|' '{print $2}'`
  i_name=`echo $item|awk -F'|' '{print $1}'`

  exe_s=${exe_s}${i_name}" "${i_use}" "
done<<<"${RE}"
fi

$exe_s


