#!/bin/bash

#0、检查OTA包是否确实丢失：文件夹/opt/ftpshare/upgrade/OTA/packages/，且有2个或以上
#1、查找rcd_androidota安装版本
#2、查找该版本的rpm包，如不存在，查找Patch包，比如（rcd_androidota^2.1.0.14-rj_R1P1^2.1.0.13-rj_R1.patch）  find / -name rcd_androidota*2.1.0.14*.patch
#3、Patch包合并出安装包
#4、卸载原rcd_androidota包，安装新包

S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp
resultKey="otaPackageFix"
newPackageName="otaFix.rpm"

otpPackageNum=`find  /opt/ftpshare/upgrade/OTA/packages/ -name *.zip 2> /dev/null | wc -l `
if [ -n "$otpPackageNum" ] && [ "$otpPackageNum" -ge 2 ]; then
	e_json $resultKey 0
	exit 0
fi

#是否安装了rpm包
installPackageName=`rpm -qa | grep rcd_androidota`
if [ -z "$installPackageName" ]; then
	e_json $resultKey -1
	exit -5
fi

#截取安装的版本号
pathVersion=${installPackageName#rcd_androidota-}
pathVersion=${pathVersion%%-rj_*}

#是否存在安装包
isExistRpmPackage=`find / -name "${installPackageName}"*.rpm 2> /dev/null | head -1 `
if [ -z "$isExistRpmPackage" ]; then
	#path文件是否存在
	isExistRpmPath=`find / -name rcd_androidota*"${pathVersion}"*.patch 2> /dev/null`
	if [ -z "$isExistRpmPath" ]; then
		e_json $resultKey -1
		exit -1
	else
	    #获取基线版本号
		basePathVersion=${isExistRpmPath##*^}
		basePathVersion=${basePathVersion%%-rj*}
		if [ -z "$basePathVersion" ]; then
			e_json $resultKey -2
			exit -1
		else 
			#获取基线patch包
			basePathPackage=`find /tmp/rcdosinstall/Patch -name rcd_androidota-"${basePathVersion}"*.rpm 2> /dev/null | head -1 `
			if [ -z "$basePathPackage" ]; then
				e_json $resultKey -3
				exit -1
			else
				#合并组成新的rpm包
				applydeltarpm -r $basePathPackage $isExistRpmPath $C_DIR/$newPackageName > /dev/null 2>&1
				if [ $? != 0 ]; then
					e_json $resultKey -4
					exit -1
				fi
				isExistRpmPackage=$newPackageName
				
				sudo rpm -e rcd_androidota
				sudo rpm -ivh $C_DIR/$isExistRpmPackage > /dev/null 2>&1
				rm -rf $C_DIR/$isExistRpmPackage
				e_json $resultKey 0
			fi
		fi
	fi
else
	sudo rpm -e rcd_androidota
	sudo rpm -ivh $isExistRpmPackage > /dev/null 2>&1
	e_json $resultKey 0
fi
