#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp

sudo service rcd_ha status > /dev/null 2>&1

if [ ! $? = 0 ];then
  status=off
else
  status=on
fi


info=`rcd_ha_cli get_conf`

virtualIp=`echo "$info"|grep virtual_ip|awk -F'=' '{print $2}'`
vipNetmask=`echo "$info"|grep vip_netmask|awk -F'=' '{print $2}'`
referenceIp=`echo "$info"|grep reference_ip|awk -F'=' '{print $2}'`
routerId=`echo "$info"|grep router_id|awk -F'=' '{print $2}'`
defaultMaster=`echo "$info"|grep default_master|awk -F'=' '{print $2}'`



e_json status "$status" virtualIp "$virtualIp" vipNetmask "$vipNetmask" referenceIp "$referenceIp" routerId "$routerId" defaultMaster "$defaultMaster"




