#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi

su - postgres<<EOF
    psql -d rcd -p $port -c "select count(*) from lb_seat_info;" > $tmpf
EOF

vmAmount=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`

su - postgres<<EOF
    psql -d rcd -p $port -c "select * from rcd_license where license_type!='TEMP';" > $tmpf
EOF

RE=`cat $tmpf|grep feature_id|awk -F'|' '{print $10}'|awk '{print $1}'|awk -F'>' '{print $2}'|awk -F'<' '{print $1}'`

licAmount=0

while read item
do
  if [ "$item" = "LIC-RCC-CM2" ]; then
    ((licAmount+=210))
  elif [ "$item" = "LIC-RCC-CM-DOG" ]; then
    ((licAmount+=210))
  elif [ "$item" = "RCC-CM-NUM-35" ]; then
    ((licAmount+=35))
  elif [ "$item" = "RCC-CM-NUM-70" ]; then
    ((licAmount+=70))
  elif [ "$item" = "LIC-RCC-CM" ]; then
    ((licAmount+=210))
  fi

done<<<"${RE}"

if [ $licAmount -ge $vmAmount ]; then
  e_json licEnough "yes" licAmount "$licAmount" vmAmount "$vmAmount"
else
  e_json licEnough "no" licAmount "$licAmount" vmAmount "$vmAmount"
fi




