#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi

su - postgres<<EOF
    psql -d rcd -p $port -c "select * from lb_user_schedule;" > $tmpf
EOF
RE=`cat $tmpf | sed '1,2d;N;$d;P;D'`

size=0
while read item
do
  t_cron=`echo $item|awk -F'|' '{print $3}'|awk '{print $1}'`
  if [ "$t_cron" = "0" ]; then
    hour=`echo $item|awk -F'|' '{print $7}'|awk '{printf("%02d", $1)}'`
    minute=`echo $item|awk -F'|' '{print $8}'|awk '{printf("%02d", $1)}'`
    second=`echo $item|awk -F'|' '{print $9}'|awk '{printf("%02d", $1)}'`
    ((size++))
    break
  fi
done<<<"${RE}"

if [ $size -gt 0 ]; then
  time_cron="$hour":"$minute":"$second"
  e_json rebootSchedule "yes" time "$time_cron"
else 
  e_json rebootSchedule "no"
fi



