#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi

su - postgres<<EOF
    psql -d rcd -p $port -c "select ip from lb_server_host where is_master='N';" > $tmpf
EOF

exe_s="e_json "

master_size=`du -s /opt/ftpshare/share/|awk '{print $1}'`

index=0

for item in $(cat $tmpf |grep -E -o "([0-9]{1,3}[\.]){3}[0-9]{1,3}")
do
  slave_size=`ssh $item "du -s /opt/ftpshare/share" | awk '{print $1}'`
  if [ $master_size -eq $slave_size ]; then
    exe_s=${exe_s}"${item}"" yes "
  else
    exe_s=${exe_s}"${item}"" no "
  fi
  ((index++))
done
if [ $index -gt 0 ]; then
  $exe_s
else
  e_json ""
fi


