#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi

su - postgres<<EOF
    psql -d rcd -p $port -c "select ip,wan_ip,wan_mask from lb_server_host where is_master='N';" > $tmpf
EOF
f_wan="/etc/sysconfig/network-scripts/ifcfg-wan0"
host_arr="["
index=0
RE=`cat $tmpf | grep -E "([0-9]{1,3}[\.]){3}[0-9]{1,3}"`
if [ -n "$RE" ]; then
while read item
do
  item_ip=`echo $item|awk -F'|' '{print $1}'|awk '{print $1}'`
  ip_array[$index]=$item_ip
  ((index++))
done<<<"${RE}"
index=0
for item_ip in ${ip_array[*]}
do
  if [ $index -gt 0 ]; then
    host_arr=${host_arr}", "
  fi 
  
  if [ -f $f_wan ]; then
    item_wan_ip=`ssh $item_ip "[ -f $f_wan ] && cat $f_wan|grep -i IPADDR" | awk -F'=' '{print $2}'`
  fi
  host_arr=${host_arr}"{\"ip\" : ""\""${item_ip}"\""
  host_arr=${host_arr}", \"wanIp\" : \"""${item_wan_ip}""\"}"
  ((index++))
done
fi

host_arr=${host_arr}"]"
e_arr_json slaveHost "${host_arr}" 
