#!/usr/bin/python
# -*- coding: utf-8 -*-
'''
洢IPǷpingͨ
'''
from subprocess import Popen, PIPE, STDOUT
from ConfigParser import ConfigParser, NoOptionError
import json

#haļ
HA_CONF = "/etc/rcd_ha/rcd_ha.conf"

ha_conf = None

def shell_cmd(cmd, timeout = None, need_out = False):
    if need_out:
        child = Popen(cmd, shell = True, close_fds = True, 
                      stdout = PIPE, stderr = STDOUT)
        out = child.communicate()[0]
        return child.returncode, out
    else:
        child = Popen(cmd, shell = True, close_fds = True, 
                      stdout = open("/dev/null", "w"), stderr = STDOUT)
        child.wait()
        return child.returncode
        
def ping(ip):
    cmd = "ping -c 1 %s" % ip
    for i in range(3):
        if 0 == shell_cmd(cmd):
            return True
    return False
    
def main():
    global ha_conf
    ha_conf = ConfigParser()
    ha_conf.read(HA_CONF)
    
    result = {}
    
    try:
        ip = ha_conf.get("keepalived_storage", "reference_ip")
    except NoOptionError:
        result["status"] = False
        return result
        
    result["status"] = ping(ip)
    
    return json.dumps(result)

if __name__ == "__main__":
    print main()