#!/usr/bin/python
# -*- coding: utf-8 -*-
'''
IPͷIPǷͬһ
'''
from subprocess import Popen, PIPE, STDOUT
from ConfigParser import ConfigParser, NoOptionError
from IPy import IP
import json

#haļ
HA_CONF = "/etc/rcd_ha/rcd_ha.conf"

ha_conf = None

mgt_net = "br0"

storage_net = "bond1"

def shell_cmd(cmd, timeout = None, need_out = False):
    if need_out:
        child = Popen(cmd, shell = True, close_fds = True, 
                      stdout = PIPE, stderr = STDOUT)
        out = child.communicate()[0]
        return child.returncode, out
    else:
        child = Popen(cmd, shell = True, close_fds = True, 
                      stdout = open("/dev/null", "w"), stderr = STDOUT)
        child.wait()
        return child.returncode
		
def get_ip(net):
    cmd = "ip addr show %s 2>>/dev/null|\
           grep 'scope global %s'|\
           awk -F 'inet' '{print $2}'|\
           awk -F 'brd' '{print $1}'" % (net, net)
    ip_addr = shell_cmd(cmd, need_out = True)[1].strip()
    return ip_addr
    
def get_mgt_ip_net_segement():
    global mgt_net
    ip_addr = get_ip(mgt_net)
    if 0 == len(ip_addr):
        return
    
    ip, mask = ip_addr.split("/")
    return IP(ip).make_net(mask)
    
def get_storage_ip_net_segement():
    global storage_net
    ip_addr = get_ip(storage_net)
    if 0 == len(ip_addr):
        return
    
    ip, mask = ip_addr.split("/")
    return IP(ip).make_net(mask)
    
def get_mgt_vip_net_segement():
    global ha_conf
    try:
        ip = ha_conf.get("keepalived_management", "virtual_ip")
        mask = ha_conf.get("keepalived_management", "vip_netmask")
    except NoOptionError:
        return
        
    return IP(ip).make_net(mask)
    
def get_storage_vip_net_segement():
    global ha_conf
    try:
        ip = ha_conf.get("keepalived_storage", "virtual_ip")
        mask = ha_conf.get("keepalived_storage", "vip_netmask")
    except NoOptionError:
        return
        
    return IP(ip).make_net(mask)
    
def main():
    '''
    0:
    1:IPIPͬһ
    2:ҵIPҵIPͬһ
    3:洢IPʹ洢IPͬһ
    '''
    global ha_conf
    ha_conf = ConfigParser()
    ha_conf.read(HA_CONF)
    
    result = {}
    
    mgt_ip_net_segement = get_mgt_ip_net_segement()
    storage_ip_net_segement = get_storage_ip_net_segement()
    
    mgt_vip_net_segement = get_mgt_vip_net_segement()
    storage_vip_net_segement = get_storage_vip_net_segement()
    
    if (mgt_ip_net_segement == mgt_vip_net_segement and 
        storage_ip_net_segement == storage_vip_net_segement):
        result["status"] = 0
    elif (mgt_ip_net_segement != mgt_vip_net_segement and 
          storage_ip_net_segement != storage_vip_net_segement):
        result["status"] = 1
    elif mgt_ip_net_segement != mgt_vip_net_segement:
        result["status"] = 2
    else:
        result["status"] = 3
        
    return json.dumps(result)
    
if __name__ == "__main__":
    print main()