#!/bin/bash

DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
cd $C_DIR
#include files
. ./common.json

total=0
used=0

for disk in $(df -l | grep user_disk | awk '{print $6}')
do
	echo $disk | grep space &> /dev/null && continue

	tmp_total=$(df  -hm $disk | tail -n 1 | awk '{print $2}')
	tmp_used=$(df  -hm $disk | tail -n 1 | awk '{print $3}')
	((total += tmp_total))
	((used += tmp_used))
done

e_json total "$total" used "$used"
