#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi
str_sql="
select b.name, b.teacher_ip,b.vlan_id,b.lesson_id, c.os_type, c.rcc_os_version,c.product_model, a.*
	from lb_seat_info a left join lb_classroom b on a.classroom_id=b.id left join rcd_seat c on a.terminal_mac=c.mac_address  order by a.id;
"
su - postgres<<EOF
    psql -d rcd -p $port -c "$str_sql" > $tmpf
EOF

index=0
RE=`cat $tmpf|sed '1,2d;N;$d;P;D'`
line=`cat $tmpf|wc -l`
((line=line-4))
echo "["
if [ -n "$RE" ]; then
while read item
do
  ((index++))
  vmHostName=`echo $item|awk -F'|' '{print $11}'`
  vmIp=`echo $item|awk -F'|' '{print $18}'`
  vmMac=`echo $item|awk -F'|' '{print $17}'`
  vmMask=`echo $item|awk -F'|' '{print $27}'`
  vmGateway=`echo $item|awk -F'|' '{print $28}'`
  vmDns=`echo $item|awk -F'|' '{print $29}'`
  vmUsername=`echo $item|awk -F'|' '{print $31}'`
  vmPassword=`echo $item|awk -F'|' '{print $32}'`
  
  tmHostName=`echo $item|awk -F'|' '{print $21}'`
  tmNetType=`echo $item|awk -F'|' '{print $22}'`
  tmIp=`echo $item|awk -F'|' '{print $12}'`
  tmMac=`echo $item|awk -F'|' '{print $13}'`
  tmMask=`echo $item|awk -F'|' '{print $23}'`
  tmGateway=`echo $item|awk -F'|' '{print $24}'`
  tmDns=`echo $item|awk -F'|' '{print $25}'`
  tmResolutionRadio=`echo $item|awk -F'|' '{print $26}'`
  crName=`echo $item|awk -F'|' '{print $1}'`
  teaIp=`echo $item|awk -F'|' '{print $2}'`
  vlanId=`echo $item|awk -F'|' '{print $3}'`

  tmOsVersion=`echo $item|awk -F'|' '{print $6}'`
  tmOsType=`echo $item|awk -F'|' '{print $5}'`
  tmProductModel=`echo $item|awk -F'|' '{print $7}'`

  e_json vmHostName "$vmHostName" vmIp "$vmIp" vmMac "$vmMac" vmMask "$vmMask" vmGateway "$vmGateway" vmDns "$vmDns" vmUsername "$vmUsername" vmPassword "$vmPassword" tmHostName "$tmHostName" tmNetType "$tmNetType" tmIp "$tmIp" tmMac "$tmMac" tmMask "$tmMask" tmGateway "$tmGateway" tmDns "$tmDns" tmResolutionRadio "$tmResolutionRadio" crName "$crName" teaIp "$teaIp" vlanId "$vlanId" tmOsVersion "$tmOsVersion" tmOsType "$tmOsType" tmProductModel "$tmProductModel"
  if [ $index -lt $line ]; then
    echo -n ","
  fi
done<<<"${RE}"

fi
echo "]"

