#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi

su - postgres<<EOF
    psql -d rcd -p $port -c "select * from customer_info;" > $tmpf
EOF

name=`cat $tmpf|awk 'NR==3'|awk -F"|" '{print $2}'|awk '{print $1}'`
c_type=`cat $tmpf|awk 'NR==3'|awk -F"|" '{print $6}'|awk '{print $1}'`
channel=`cat $tmpf|awk 'NR==3'|awk -F"|" '{print $3}'|awk '{print $1}'`
channel_tel=`cat $tmpf|awk 'NR==3'|awk -F"|" '{print $8}'|awk '{print $1}'`
maintainer=`cat $tmpf|awk 'NR==3'|awk -F"|" '{print $4}'|awk '{print $1}'`
telephone=`cat $tmpf|awk 'NR==3'|awk -F"|" '{print $8}'|awk '{print $1}'`

su - postgres<<EOF
    psql -d rcd -p $port -c "select classroom from rcd_info;" > $tmpf
EOF
classroom=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`


e_json name "$name" customer_type "$c_type" classroom "$classroom" channel "$channel" channelTele "$channel_tel" maintainer "$maintainer" telephone "$telephone"
