#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi
if [ -f /etc/sysconfig/network-scripts/ifcfg-bond0 ]; then
  netcardMode="bond"
else
 netcardMode="normal"
fi
su - postgres<<EOF
    psql -d rcd -p $port -c "select para_value from lb_sys_parameter where para_name='SYS_PARA_SCENE';" > $tmpf
EOF
  tmType=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
su - postgres<<EOF
	psql -d rcd -p $port -c "select para_value from lb_sys_parameter where para_name='SYS_PARA_DESKTOPTYPE';" > $tmpf
EOF
  desktopType=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
su - postgres<<EOF
	psql -d rcd -p $port -c "select para_value from lb_sys_parameter where para_name='SYS_PARA_MODE_CONFIG_IP';" > $tmpf
EOF
  modeFromDb=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
su - postgres<<EOF
	psql -d rcd -p $port -c "select para_value from lb_sys_parameter where para_name='SYS_PARA_HA_ROLE';" > $tmpf
EOF
  roleFromDb=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
su - postgres<<EOF
	psql -d rcd -p $port -c "select count(*) from lb_seat_info;" > $tmpf
EOF
  seatNumFromDb=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
su - postgres<<EOF
	psql -d rcd -p $port -c "select count(*) from lb_seat_info where vm_ip='' or vm_ip is null;" > $tmpf
EOF
  vmIpNumFromDb=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
su - postgres<<EOF
	psql -d rcd -p $port -c "select count(*) from lb_seat_info where disk_location='' or disk_location is null;" > $tmpf
EOF
  diskNumFromDb=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
su - postgres<<EOF
	psql -d rcd -p $port -c "select count(*) from lb_seat_info where vm_image_id is null;" > $tmpf
EOF
  vmNumFromDb=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
  if [ $tmType = "0" ]; then
    e_json deployMode "00"
  elif [ $tmType = "1" ]; then
    e_json deployMode "01"
  elif [ $tmType = "2" ] && [ "$mode" = "Cluster" ] && [ $modeFromDb = "0" ]; then
	e_json deployMode "11"
  elif [ $tmType = "2" ] && [ "$mode" = "Cluster" ] && [ ! $roleFromDb = $role ]; then
	e_json deployMode "12"
  elif [ $tmType = "2" ] && [ ! "$mode" = "Cluster" ] && [ $modeFromDb = "1" ]; then
	e_json deployMode "21"
  elif [ $tmType = "2" ] && [ ! "$mode" = "Cluster" ] && [ ! $roleFromDb = $role ]; then
	e_json deployMode "22"
  else
    e_json deployMode "0"
  fi
  #if [ $tmType = "2" ] && [ ! $seatNumFromDb = 0 ] && [ ! $vmIpNumFromDb = 0 ]; then
  #  e_json deployMode "2"
  #fi
  #if [ $tmType = "2" ] && [ ! $seatNumFromDb = 0 ] && [ ! $diskNumFromDb = 0 ]; then
  #  e_json deployMode "3"
  #fi
  #if [ $tmType = "2" ] && [ ! $seatNumFromDb = 0 ] && [ $desktopType = "1" ] && [ ! $vmNumFromDb = 0 ]; then
  #  e_json deployMode "4"
  #fi



