#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/licence_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi

#返回临时证书数量
su - postgres<<EOF
    psql -d rcd -p $port -c "select license_name from rcd_license where license_type='TEMP' and is_valid='Y' ;" > $tmpf
EOF

tmp_sun_num=`cat $tmpf|grep RCC-CM | wc -l`
tmp_ccr_num=`cat $tmpf|grep RCC-CCR | wc -l` 

#返回正式证书数量
su - postgres<<EOF
    psql -d rcd -p $port -c "select license_name from rcd_license where license_type!='TEMP'  and is_valid='Y' ;" > $tmpf
EOF

sun_num=`cat $tmpf|grep RCC-CM | wc -l`
ccr_num=`cat $tmpf|grep RCC-CCR | wc -l`
   e_json sun_license "$sun_num" ccr_license "${ccr_num}" tmp_sun_license "$tmp_sun_num"  tmp_ccr_license "$tmp_ccr_num"
