#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp
if [ ! -d /tmp/_sqlout_2.tmp ];then
  touch /tmp/_sqlout_2.tmp
fi
if [ ! -d /tmp/_sqlout_3.tmp ];then
  touch /tmp/_sqlout_3.tmp
fi
tmpf2=/tmp/_sqlout_2.tmp
tmpf3=/tmp/_sqlout_3.tmp
chmod 777 /tmp/_sqlout_2.tmp
chmod 777 /tmp/_sqlout_3.tmp

mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi

su - postgres<<EOF
    psql -d rcd -p $port -c "select count(*) from lb_seat_info;" > $tmpf
    psql -d rcd -p $port -c "select count(*) from lb_server_host;" > $tmpf2
    psql -d rcd -p $port -c "select count(*) from rcd_license where license_type!='TEMP'" > $tmpf3
EOF

vmAmount=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
hostAmount=`cat $tmpf2|awk 'NR==3'|awk '{print $1}'`
licAmount=`cat $tmpf3|awk 'NR==3'|awk '{print $1}'`
#su - postgres<<EOF
#    psql -d rcd -p $port -c "select * from rcd_license where license_type!='TEMP';" > $tmpf
#EOF

#RE=`cat $tmpf|grep feature_id|awk -F'|' '{print $10}'|awk '{print $1}'|awk -F'>' '{print $2}'|awk -F'<' '{print $1}'`

#licAmount=0

#while read item
#do
#  if [ "$item" = "LIC-RCC-CM2" ]; then
#    ((licAmount+=210))
#  elif [ "$item" = "LIC-RCC-CM-DOG" ]; then
#    ((licAmount+=70))
#  elif [ "$item" = "RCC-CM-NUM-35" ]; then
#    ((licAmount+=35))
#  elif [ "$item" = "RCC-CM-NUM-70" ]; then
#    ((licAmount+=70))
#  fi

#done<<<"${RE}"
#echo $licAmount
#echo $hostAmount
if [ $licAmount -ge $hostAmount ]; then
  e_json licExist "yes" licEnough "yes" licAmount "$licAmount" hostAmount "$hostAmount" vmAmount "$vmAmount"
elif [ $licAmount != 0 ]; then
  e_json licExist "yes" licEnough "no" licAmount "$licAmount" hostAmount "$hostAmount" vmAmount "$vmAmount"
else
  e_json licExist "no" licEnough "no" licAmount "$licAmount" hostAmount "$hostAmount" vmAmount "$vmAmount"
fi
