#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi


str_sql="
select b.vm_count, b.tm_count, a.* from lb_usergroup a left join (
select a.usergroup_id as id, a.count as vm_count,b.count as tm_count from 
   ( select usergroup_id,count(id) from lb_seat_info group by usergroup_id )a left join
   ( select usergroup_id,count(id) from lb_seat_info where terminal_mac is not null group by usergroup_id) b
on a.usergroup_id=b.usergroup_id
) b on a.id=b.id order by a.id;
"

#su - postgres<<EOF
#    psql -d rcd -p $port -c "select * from lb_classroom  order by id;" > $tmpf
#EOF

su - postgres<<EOF
    psql -d rcd -p $port -c "$str_sql" > $tmpf
EOF



index=0
RE=`cat $tmpf|sed '1,2d;N;$d;P;D'`
line=`cat $tmpf|wc -l`
((line=line-4))
echo "["

while read item
do
  ((index++))
  crName=`echo $item|awk -F'|' '{print $4}'`
  teaIp=`echo $item|awk -F'|' '{print $5}'`
  vlanId=`echo $item|awk -F'|' '{print $8}'`
  tmStartIp=`echo $item|awk -F'|' '{print $12}'`
  tmEndIp=`echo $item|awk -F'|' '{print $13}'`
  vmCount=`echo $item|awk -F'|' '{print $1}'`
  tmCount=`echo $item|awk -F'|' '{print $2}'`
  if [ -z $vmCount ]; then
     vmCount=0
  fi
  if [ -z $tmCount ]; then
     tmCount=0
  fi

  e_json crName "$crName" teaIp "$teaIp" vlanId "$vlanId" tmStartIp "$tmStartIp" tmEndIp "$tmEndIp" vmCount "$vmCount" tmCount "$tmCount"
  if [ $index -lt $line ]; then
    echo -n ","
  fi
done<<<"${RE}"


echo "]"



